-- Create a new schema, to make it easier to cleanup afterwards.
CREATE USER Item39Example
IDENTIFIED BY example
DEFAULT TABLESPACE USERS
TEMPORARY TABLESPACE TEMP
QUOTA 20M on USERS;

ALTER SESSION SET CURRENT_SCHEMA = ITEM39EXAMPLE;

CREATE TABLE Purchases (
	PurchaseID int PRIMARY KEY,
	CustomerID int NOT NULL,
	PurchaseDate date NOT NULL,
	PurchaseAmount decimal(19,4) NOT NULL
);

CREATE SEQUENCE Purchases_Sequence;

CREATE TRIGGER Purchases_Sequence_Trigger
BEFORE INSERT ON Purchases
FOR EACH ROW
WHEN (new.PurchaseID IS NULL)
BEGIN
  SELECT Purchases_Sequence.NEXTVAL
  INTO   :new.PurchaseID
  FROM   dual;
END;
/

INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1, 1, DATE '2013-10-05', 74.6495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2, 9, DATE '2011-11-04', 461.5677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3, 1, DATE '2014-09-28', 447.2001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4, 2, DATE '2012-11-21', 591.8555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5, 6, DATE '2011-03-10', 488.8755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6, 7, DATE '2013-09-03', 408.7025);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7, 3, DATE '2014-04-24', 110.5471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8, 3, DATE '2014-12-21', 296.2020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (9, 3, DATE '2012-09-13', 464.1072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (10, 3, DATE '2014-02-02', 986.7017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (11, 6, DATE '2012-03-10', 974.4616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (12, 10, DATE '2014-09-10', 519.0092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (13, 1, DATE '2014-07-14', 394.3178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (14, 5, DATE '2015-10-17', 478.6520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (15, 4, DATE '2011-01-17', 709.2099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (16, 8, DATE '2012-09-05', 960.3166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (17, 10, DATE '2012-12-11', 809.5744);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (18, 9, DATE '2013-07-22', 131.2104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (19, 1, DATE '2011-04-05', 78.8460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (20, 7, DATE '2011-05-19', 463.0039);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (21, 4, DATE '2013-03-13', 572.1064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (22, 5, DATE '2014-06-09', 932.7317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (23, 6, DATE '2014-06-26', 865.7009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (24, 8, DATE '2011-07-25', 461.7454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (25, 10, DATE '2011-03-20', 141.0627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (26, 9, DATE '2013-08-24', 172.2494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (27, 2, DATE '2011-04-01', 909.2511);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (28, 2, DATE '2014-12-28', 417.7485);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (29, 9, DATE '2011-10-05', 428.1018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (30, 1, DATE '2015-02-08', 626.5140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (31, 8, DATE '2011-10-08', 522.7024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (32, 1, DATE '2012-10-04', 615.0627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (33, 4, DATE '2014-10-03', 153.1935);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (34, 1, DATE '2011-05-13', 97.6664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (35, 4, DATE '2014-06-22', 43.6965);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (36, 1, DATE '2011-08-05', 161.7518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (37, 3, DATE '2011-04-30', 893.5793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (38, 2, DATE '2015-05-13', 554.2385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (39, 7, DATE '2015-04-15', 28.6261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (40, 2, DATE '2014-05-17', 242.9793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (41, 10, DATE '2014-10-27', 532.1067);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (42, 10, DATE '2012-02-09', 499.1023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (43, 10, DATE '2013-08-30', 104.7142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (44, 7, DATE '2014-11-24', 892.5640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (45, 8, DATE '2012-06-30', 826.6523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (46, 4, DATE '2012-01-15', 88.4537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (47, 10, DATE '2012-09-08', 677.7030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (48, 8, DATE '2014-09-12', 755.4644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (49, 5, DATE '2013-11-11', 670.0557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (50, 5, DATE '2013-09-02', 666.4387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (51, 4, DATE '2013-03-29', 564.6401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (52, 3, DATE '2014-08-14', 174.4185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (53, 6, DATE '2012-05-10', 998.3586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (54, 4, DATE '2013-12-19', 797.2962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (55, 7, DATE '2015-01-12', 6.6520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (56, 6, DATE '2015-04-29', 141.9179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (57, 4, DATE '2013-05-10', 595.8669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (58, 3, DATE '2014-03-06', 985.4548);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (59, 3, DATE '2012-09-04', 450.7928);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (60, 8, DATE '2013-07-17', 316.6260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (61, 5, DATE '2013-06-05', 499.4514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (62, 1, DATE '2015-04-28', 692.7986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (63, 5, DATE '2014-03-19', 868.1002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (64, 3, DATE '2013-08-06', 837.5932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (65, 5, DATE '2013-04-28', 463.9992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (66, 5, DATE '2015-06-06', 359.3988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (67, 7, DATE '2015-12-08', 365.8156);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (68, 10, DATE '2014-03-04', 296.6514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (69, 1, DATE '2012-04-26', 434.9554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (70, 3, DATE '2015-06-15', 547.4581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (71, 5, DATE '2012-05-09', 66.7372);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (72, 8, DATE '2013-08-01', 255.3358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (73, 3, DATE '2014-04-08', 102.5842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (74, 10, DATE '2012-11-18', 835.8668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (75, 7, DATE '2012-07-22', 930.8973);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (76, 4, DATE '2012-02-02', 73.0041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (77, 5, DATE '2011-10-10', 828.0174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (78, 9, DATE '2015-08-02', 973.1369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (79, 10, DATE '2015-01-24', 635.0932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (80, 7, DATE '2015-03-06', 52.6089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (81, 9, DATE '2011-12-16', 494.5465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (82, 5, DATE '2012-07-19', 153.7866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (83, 8, DATE '2012-02-17', 747.6928);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (84, 5, DATE '2014-02-01', 761.6632);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (85, 7, DATE '2012-11-11', 61.8739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (86, 6, DATE '2013-02-23', 348.2839);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (87, 6, DATE '2011-05-27', 616.7042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (88, 10, DATE '2011-10-15', 355.8974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (89, 5, DATE '2012-05-01', 91.0144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (90, 8, DATE '2015-02-24', 901.7786);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (91, 8, DATE '2014-03-27', 565.8849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (92, 10, DATE '2013-02-23', 908.1246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (93, 10, DATE '2013-09-08', 103.4456);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (94, 10, DATE '2012-09-29', 712.0002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (95, 7, DATE '2011-12-13', 743.5279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (96, 10, DATE '2015-07-02', 839.3081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (97, 6, DATE '2013-11-22', 631.0021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (98, 8, DATE '2011-01-25', 267.1210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (99, 3, DATE '2012-07-29', 428.5647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (100, 4, DATE '2013-01-24', 467.2534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (101, 8, DATE '2012-02-07', 722.6381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (102, 1, DATE '2014-07-08', 381.0516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (103, 7, DATE '2013-05-19', 320.5089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (104, 3, DATE '2014-05-29', 122.5976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (105, 10, DATE '2012-04-26', 599.7015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (106, 6, DATE '2015-08-29', 309.3042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (107, 1, DATE '2011-05-08', 71.8342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (108, 7, DATE '2015-06-23', 162.4918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (109, 7, DATE '2012-05-30', 866.3990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (110, 3, DATE '2013-12-10', 933.6480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (111, 2, DATE '2014-07-20', 313.9005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (112, 5, DATE '2013-10-08', 622.7300);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (113, 3, DATE '2015-02-11', 350.3615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (114, 7, DATE '2013-07-02', 398.1838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (115, 9, DATE '2012-08-01', 822.0795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (116, 1, DATE '2011-11-17', 345.6647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (117, 4, DATE '2014-03-12', 945.1058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (118, 10, DATE '2011-02-15', 106.4369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (119, 6, DATE '2011-09-25', 775.7192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (120, 10, DATE '2011-03-05', 115.7153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (121, 9, DATE '2015-01-11', 742.6947);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (122, 7, DATE '2015-02-24', 9.9182);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (123, 6, DATE '2012-11-03', 205.6369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (124, 4, DATE '2013-03-03', 533.1769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (125, 6, DATE '2012-03-21', 981.5732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (126, 6, DATE '2015-03-16', 158.6126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (127, 9, DATE '2015-11-23', 151.8902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (128, 3, DATE '2012-07-10', 390.5841);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (129, 3, DATE '2011-12-07', 92.3388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (130, 8, DATE '2013-01-21', 91.5891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (131, 9, DATE '2014-03-13', 442.0020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (132, 8, DATE '2011-09-16', 560.8963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (133, 7, DATE '2014-01-04', 544.5721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (134, 7, DATE '2012-12-30', 167.8397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (135, 9, DATE '2014-01-27', 329.9708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (136, 9, DATE '2013-06-10', 113.4949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (137, 9, DATE '2015-03-03', 833.2777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (138, 5, DATE '2013-09-20', 625.0952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (139, 6, DATE '2012-10-08', 161.9616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (140, 2, DATE '2013-03-15', 752.5698);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (141, 5, DATE '2012-10-19', 276.4496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (142, 10, DATE '2011-12-04', 454.2123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (143, 3, DATE '2015-05-18', 489.4984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (144, 2, DATE '2014-05-22', 157.3664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (145, 7, DATE '2011-08-07', 587.8781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (146, 3, DATE '2011-06-19', 943.1550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (147, 7, DATE '2014-01-12', 557.7630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (148, 4, DATE '2011-03-10', 705.2619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (149, 2, DATE '2011-03-01', 889.9207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (150, 7, DATE '2011-01-26', 397.8631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (151, 7, DATE '2012-04-22', 894.2023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (152, 6, DATE '2013-10-07', 524.5652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (153, 3, DATE '2015-05-02', 491.4018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (154, 3, DATE '2012-05-26', 312.8493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (155, 5, DATE '2014-01-13', 724.5588);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (156, 1, DATE '2012-12-14', 712.7199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (157, 5, DATE '2012-09-03', 175.4146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (158, 3, DATE '2011-03-18', 787.3321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (159, 8, DATE '2013-03-10', 141.0245);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (160, 5, DATE '2013-02-10', 441.0889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (161, 8, DATE '2015-10-06', 157.4140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (162, 9, DATE '2014-10-29', 681.2502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (163, 4, DATE '2014-07-17', 70.1530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (164, 10, DATE '2015-05-10', 774.8098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (165, 5, DATE '2015-09-30', 491.6460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (166, 4, DATE '2013-11-04', 753.0042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (167, 9, DATE '2015-10-05', 78.1578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (168, 7, DATE '2013-02-11', 182.5218);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (169, 8, DATE '2015-06-05', 68.2129);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (170, 10, DATE '2015-02-21', 708.5846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (171, 2, DATE '2012-09-16', 512.3871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (172, 9, DATE '2011-06-22', 320.0106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (173, 4, DATE '2014-05-10', 944.4753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (174, 4, DATE '2014-07-12', 23.1494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (175, 6, DATE '2014-05-16', 839.2658);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (176, 10, DATE '2014-02-07', 288.4823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (177, 4, DATE '2015-10-09', 520.4198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (178, 4, DATE '2014-06-14', 48.2705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (179, 7, DATE '2012-07-28', 945.2989);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (180, 3, DATE '2011-10-03', 38.4181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (181, 9, DATE '2012-03-04', 600.8496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (182, 5, DATE '2015-09-16', 446.6283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (183, 1, DATE '2012-05-12', 500.6635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (184, 7, DATE '2011-11-12', 694.4757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (185, 2, DATE '2011-10-01', 197.3868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (186, 3, DATE '2011-06-06', 917.4368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (187, 5, DATE '2012-05-16', 69.4944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (188, 5, DATE '2012-08-10', 231.7228);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (189, 2, DATE '2014-12-17', 443.2810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (190, 9, DATE '2012-02-13', 617.2510);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (191, 4, DATE '2011-10-07', 938.0804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (192, 6, DATE '2014-12-17', 45.9455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (193, 8, DATE '2011-07-14', 484.0706);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (194, 2, DATE '2015-08-28', 720.8728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (195, 4, DATE '2013-06-09', 595.1557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (196, 6, DATE '2013-12-22', 595.1995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (197, 6, DATE '2013-05-20', 384.0593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (198, 3, DATE '2011-01-09', 714.6887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (199, 8, DATE '2014-08-23', 665.7204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (200, 3, DATE '2013-10-03', 834.8739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (201, 5, DATE '2011-09-15', 864.9971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (202, 10, DATE '2011-12-01', 375.2412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (203, 7, DATE '2011-10-05', 637.0489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (204, 3, DATE '2012-01-08', 181.3361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (205, 5, DATE '2014-05-12', 885.4761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (206, 8, DATE '2011-11-02', 574.1917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (207, 2, DATE '2015-05-31', 580.0899);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (208, 9, DATE '2011-10-21', 468.2524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (209, 8, DATE '2014-01-10', 473.5836);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (210, 6, DATE '2015-12-07', 436.0764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (211, 7, DATE '2013-03-07', 192.3000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (212, 2, DATE '2014-03-23', 127.1440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (213, 7, DATE '2014-08-20', 842.0333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (214, 5, DATE '2012-06-07', 102.6063);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (215, 6, DATE '2011-12-10', 840.2393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (216, 4, DATE '2011-01-21', 710.7857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (217, 9, DATE '2013-06-18', 180.5867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (218, 7, DATE '2013-09-05', 375.6773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (219, 9, DATE '2014-08-09', 577.4230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (220, 2, DATE '2015-04-26', 574.2092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (221, 10, DATE '2012-06-20', 683.5097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (222, 5, DATE '2014-02-24', 846.4351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (223, 6, DATE '2014-02-25', 739.2408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (224, 9, DATE '2014-04-23', 450.9620);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (225, 6, DATE '2014-05-17', 770.5042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (226, 7, DATE '2013-09-30', 466.4415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (227, 2, DATE '2015-12-09', 835.9400);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (228, 3, DATE '2014-09-12', 223.6024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (229, 1, DATE '2012-02-03', 427.9937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (230, 10, DATE '2011-05-26', 244.0663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (231, 4, DATE '2011-09-21', 904.4231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (232, 1, DATE '2015-10-01', 805.7312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (233, 6, DATE '2015-10-23', 382.5501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (234, 5, DATE '2014-10-25', 110.4249);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (235, 9, DATE '2011-01-19', 173.4211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (236, 9, DATE '2011-04-04', 225.6084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (237, 8, DATE '2014-12-13', 809.5795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (238, 9, DATE '2011-05-06', 319.3273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (239, 2, DATE '2013-07-02', 808.9997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (240, 4, DATE '2015-11-30', 623.1952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (241, 1, DATE '2012-01-06', 337.3469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (242, 7, DATE '2011-07-27', 601.2421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (243, 7, DATE '2014-07-31', 758.1392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (244, 7, DATE '2015-01-11', 7.2046);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (245, 2, DATE '2014-12-08', 424.9509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (246, 3, DATE '2013-07-17', 810.9364);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (247, 10, DATE '2011-04-29', 203.9123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (248, 3, DATE '2015-02-06', 381.4642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (249, 7, DATE '2014-09-19', 880.6336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (250, 1, DATE '2013-05-20', 884.3701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (251, 8, DATE '2011-07-06', 414.6128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (252, 9, DATE '2015-09-15', 8.3820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (253, 5, DATE '2012-06-01', 137.2656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (254, 7, DATE '2015-04-29', 91.5111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (255, 4, DATE '2012-04-14', 151.3641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (256, 1, DATE '2013-07-22', 18.5619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (257, 5, DATE '2013-10-05', 636.0004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (258, 8, DATE '2013-06-14', 186.0869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (259, 7, DATE '2013-08-23', 410.8319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (260, 9, DATE '2011-08-12', 419.0346);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (261, 7, DATE '2011-11-24', 738.2517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (262, 10, DATE '2011-09-18', 356.4874);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (263, 9, DATE '2015-09-18', 40.2586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (264, 9, DATE '2013-08-18', 229.5173);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (265, 2, DATE '2015-03-18', 531.6533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (266, 6, DATE '2013-06-07', 386.5689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (267, 7, DATE '2014-05-31', 744.5939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (268, 2, DATE '2015-10-27', 731.6083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (269, 7, DATE '2012-05-19', 929.1853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (270, 7, DATE '2011-09-07', 614.6308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (271, 6, DATE '2012-02-08', 901.2062);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (272, 10, DATE '2013-02-13', 861.2594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (273, 6, DATE '2011-03-06', 566.6777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (274, 6, DATE '2014-09-10', 954.2278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (275, 1, DATE '2014-04-20', 236.8623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (276, 3, DATE '2011-11-25', 82.2676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (277, 8, DATE '2015-07-27', 88.2958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (278, 10, DATE '2015-02-15', 732.0362);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (279, 8, DATE '2015-05-16', 26.0110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (280, 4, DATE '2011-11-01', 959.5679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (281, 8, DATE '2013-06-04', 262.5292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (282, 9, DATE '2011-11-03', 454.4757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (283, 7, DATE '2015-12-25', 342.9689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (284, 10, DATE '2014-09-15', 543.6236);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (285, 2, DATE '2015-11-21', 829.4535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (286, 6, DATE '2012-01-06', 896.0411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (287, 7, DATE '2014-05-02', 668.4655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (288, 10, DATE '2011-06-26', 291.0390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (289, 1, DATE '2013-07-12', 959.0609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (290, 9, DATE '2013-06-30', 154.8591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (291, 5, DATE '2013-06-29', 589.6080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (292, 10, DATE '2012-07-01', 623.4925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (293, 2, DATE '2013-09-12', 908.4954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (294, 4, DATE '2012-11-20', 389.9650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (295, 8, DATE '2015-01-06', 884.9435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (296, 2, DATE '2011-04-21', 980.8596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (297, 8, DATE '2011-11-08', 560.9835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (298, 9, DATE '2011-12-14', 528.6219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (299, 5, DATE '2015-10-26', 475.5513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (300, 6, DATE '2012-07-03', 38.3820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (301, 6, DATE '2015-02-16', 66.3424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (302, 8, DATE '2011-07-04', 472.3040);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (303, 7, DATE '2013-09-19', 452.2790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (304, 10, DATE '2014-01-12', 266.0027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (305, 6, DATE '2012-04-11', 983.1639);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (306, 9, DATE '2014-05-23', 553.3534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (307, 4, DATE '2015-07-12', 441.7044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (308, 10, DATE '2013-09-22', 183.0378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (309, 6, DATE '2012-01-09', 854.6489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (310, 1, DATE '2011-05-22', 69.0964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (311, 3, DATE '2013-12-27', 930.2661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (312, 6, DATE '2014-08-21', 903.9642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (313, 1, DATE '2014-01-29', 160.0759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (314, 3, DATE '2012-10-23', 451.2641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (315, 2, DATE '2014-03-10', 156.5054);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (316, 8, DATE '2011-01-22', 283.7759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (317, 3, DATE '2011-09-25', 13.5184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (318, 10, DATE '2012-01-04', 496.6350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (319, 7, DATE '2013-09-27', 400.0638);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (320, 7, DATE '2014-03-12', 635.6123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (321, 10, DATE '2015-02-06', 718.1034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (322, 8, DATE '2013-12-06', 453.5549);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (323, 2, DATE '2013-04-16', 772.5474);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (324, 8, DATE '2014-11-20', 774.3261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (325, 3, DATE '2014-03-11', 25.0228);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (326, 6, DATE '2015-08-10', 277.7137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (327, 9, DATE '2015-06-03', 952.7640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (328, 2, DATE '2014-04-16', 176.7126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (329, 9, DATE '2015-09-04', 69.2843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (330, 10, DATE '2013-12-31', 256.0028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (331, 5, DATE '2011-01-17', 521.2842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (332, 9, DATE '2014-08-13', 559.6740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (333, 5, DATE '2015-04-22', 256.4849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (334, 2, DATE '2013-11-13', 987.6290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (335, 8, DATE '2012-09-14', 893.2254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (336, 10, DATE '2012-12-02', 790.2252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (337, 3, DATE '2014-02-14', 2.1967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (338, 8, DATE '2012-12-12', 76.9661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (339, 5, DATE '2013-06-05', 560.4598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (340, 4, DATE '2012-06-30', 276.1000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (341, 2, DATE '2012-06-27', 454.3367);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (342, 8, DATE '2011-08-10', 485.4276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (343, 4, DATE '2015-06-17', 436.3901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (344, 10, DATE '2013-02-21', 889.9644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (345, 6, DATE '2015-07-05', 224.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (346, 9, DATE '2014-11-08', 685.6439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (347, 10, DATE '2014-06-03', 463.4166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (348, 9, DATE '2011-11-20', 457.2313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (349, 3, DATE '2014-09-13', 233.4595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (350, 10, DATE '2014-12-16', 601.1675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (351, 9, DATE '2015-07-27', 967.3411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (352, 9, DATE '2015-11-05', 64.3484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (353, 2, DATE '2014-03-18', 128.5581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (354, 9, DATE '2012-08-15', 839.9390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (355, 7, DATE '2013-05-27', 320.2787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (356, 9, DATE '2012-03-13', 612.7876);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (357, 6, DATE '2014-03-20', 699.7566);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (358, 9, DATE '2014-10-30', 677.9529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (359, 7, DATE '2015-11-04', 240.9799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (360, 10, DATE '2012-09-02', 705.4502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (361, 10, DATE '2014-12-20', 600.5895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (362, 3, DATE '2012-03-27', 264.9917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (363, 2, DATE '2014-01-18', 113.7535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (364, 7, DATE '2014-01-09', 598.6461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (365, 6, DATE '2011-05-05', 547.8123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (366, 4, DATE '2015-05-16', 370.5921);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (367, 1, DATE '2015-05-02', 647.4793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (368, 10, DATE '2011-03-19', 172.4470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (369, 5, DATE '2011-02-09', 558.0387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (370, 2, DATE '2012-04-07', 366.2802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (371, 5, DATE '2012-12-08', 281.5792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (372, 6, DATE '2014-10-13', 936.5524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (373, 5, DATE '2014-07-31', 936.1753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (374, 4, DATE '2012-03-29', 123.9637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (375, 6, DATE '2012-09-15', 181.2756);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (376, 2, DATE '2014-06-29', 232.6757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (377, 4, DATE '2014-06-21', 17.1648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (378, 2, DATE '2011-02-23', 882.5831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (379, 3, DATE '2015-05-19', 549.7330);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (380, 4, DATE '2015-05-03', 339.3790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (381, 7, DATE '2012-03-09', 814.2971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (382, 10, DATE '2014-07-15', 495.5327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (383, 9, DATE '2015-08-04', 943.2531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (384, 9, DATE '2011-09-19', 468.1168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (385, 1, DATE '2014-06-07', 288.6617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (386, 7, DATE '2011-03-15', 456.9357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (387, 8, DATE '2011-05-28', 431.1158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (388, 7, DATE '2013-09-06', 416.5459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (389, 6, DATE '2011-06-19', 667.3502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (390, 10, DATE '2011-07-05', 280.4378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (391, 4, DATE '2014-09-15', 90.4686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (392, 4, DATE '2015-04-17', 324.2438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (393, 1, DATE '2013-02-08', 835.9863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (394, 5, DATE '2011-10-03', 855.0096);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (395, 4, DATE '2013-07-12', 675.5106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (396, 10, DATE '2011-04-02', 189.3449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (397, 7, DATE '2013-07-22', 371.6741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (398, 8, DATE '2012-06-08', 837.7440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (399, 4, DATE '2012-10-20', 342.1521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (400, 2, DATE '2011-02-19', 854.0010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (401, 8, DATE '2015-07-10', 38.1645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (402, 10, DATE '2014-03-17', 290.9696);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (403, 5, DATE '2011-10-12', 899.1927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (404, 2, DATE '2013-06-07', 867.1793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (405, 5, DATE '2013-01-08', 319.5883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (406, 3, DATE '2011-10-15', 30.7886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (407, 4, DATE '2012-04-07', 128.1732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (408, 8, DATE '2012-12-20', 4.5944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (409, 4, DATE '2015-12-01', 658.6634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (410, 5, DATE '2014-11-29', 87.6029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (411, 5, DATE '2013-09-23', 595.6227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (412, 5, DATE '2014-01-25', 817.1736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (413, 7, DATE '2015-06-13', 128.2198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (414, 4, DATE '2011-07-04', 901.6010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (415, 4, DATE '2011-06-27', 891.1532);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (416, 1, DATE '2011-06-08', 105.0568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (417, 4, DATE '2012-08-24', 321.7386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (418, 3, DATE '2013-05-02', 645.6368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (419, 6, DATE '2015-08-05', 309.9843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (420, 10, DATE '2011-02-21', 90.8766);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (421, 7, DATE '2014-12-20', 939.4764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (422, 5, DATE '2012-08-25', 230.9333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (423, 4, DATE '2015-09-30', 505.0968);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (424, 6, DATE '2015-08-07', 277.6008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (425, 8, DATE '2013-07-24', 275.8116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (426, 2, DATE '2013-08-23', 957.3354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (427, 6, DATE '2012-09-03', 100.5661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (428, 1, DATE '2013-10-28', 81.1657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (429, 1, DATE '2014-09-18', 448.4531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (430, 6, DATE '2012-06-15', 991.9307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (431, 6, DATE '2011-12-09', 861.0017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (432, 7, DATE '2013-01-12', 179.4208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (433, 8, DATE '2014-05-06', 540.4309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (434, 1, DATE '2015-03-31', 695.7321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (435, 7, DATE '2015-10-24', 301.2144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (436, 7, DATE '2013-12-23', 523.3275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (437, 6, DATE '2013-10-03', 596.3401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (438, 8, DATE '2013-02-26', 76.0738);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (439, 4, DATE '2014-09-11', 148.5284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (440, 9, DATE '2013-08-23', 257.8730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (441, 3, DATE '2014-12-08', 328.7625);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (442, 10, DATE '2014-06-08', 426.5214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (443, 4, DATE '2013-10-06', 757.8826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (444, 1, DATE '2012-07-21', 579.7473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (445, 5, DATE '2013-10-11', 684.8151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (446, 10, DATE '2011-08-21', 273.2951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (447, 8, DATE '2015-11-04', 196.0240);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (448, 8, DATE '2012-08-08', 934.3853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (449, 2, DATE '2011-04-09', 963.8564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (450, 3, DATE '2013-02-04', 570.4538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (451, 6, DATE '2014-08-08', 867.6064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (452, 4, DATE '2011-03-23', 726.0373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (453, 3, DATE '2012-11-04', 527.7596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (454, 5, DATE '2012-08-30', 251.2754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (455, 6, DATE '2012-03-01', 914.5247);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (456, 4, DATE '2013-11-14', 807.2312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (457, 6, DATE '2014-06-17', 785.8728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (458, 9, DATE '2012-03-07', 621.5918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (459, 4, DATE '2015-11-15', 591.3677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (460, 4, DATE '2015-05-19', 362.2530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (461, 8, DATE '2015-02-10', 930.2226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (462, 4, DATE '2014-06-10', 47.0074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (463, 8, DATE '2014-04-03', 556.1413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (464, 8, DATE '2014-06-17', 666.7327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (465, 10, DATE '2013-12-22', 226.6012);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (466, 9, DATE '2011-09-11', 416.2019);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (467, 7, DATE '2015-09-22', 276.7426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (468, 7, DATE '2011-03-16', 432.4877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (469, 7, DATE '2011-09-10', 600.3866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (470, 7, DATE '2013-07-05', 367.8256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (471, 6, DATE '2013-09-05', 508.7168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (472, 6, DATE '2015-06-29', 245.6648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (473, 10, DATE '2014-08-22', 497.1083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (474, 8, DATE '2012-12-12', 52.1112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (475, 8, DATE '2012-03-16', 762.1141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (476, 8, DATE '2011-07-15', 512.9549);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (477, 1, DATE '2014-11-20', 473.0508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (478, 4, DATE '2014-03-12', 925.3495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (479, 2, DATE '2012-10-26', 592.7857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (480, 8, DATE '2012-12-03', 2.5165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (481, 4, DATE '2013-10-19', 761.3114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (482, 9, DATE '2011-01-27', 166.1808);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (483, 10, DATE '2013-07-22', 117.3093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (484, 8, DATE '2012-08-13', 877.9994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (485, 1, DATE '2013-11-07', 124.3243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (486, 2, DATE '2011-09-18', 134.9643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (487, 5, DATE '2011-03-10', 651.6613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (488, 4, DATE '2012-09-06', 289.1554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (489, 5, DATE '2014-01-29', 781.2075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (490, 3, DATE '2012-12-10', 493.9832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (491, 1, DATE '2015-07-08', 737.4547);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (492, 7, DATE '2012-07-29', 974.7483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (493, 5, DATE '2013-04-14', 484.7061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (494, 10, DATE '2015-04-26', 786.2755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (495, 1, DATE '2014-07-14', 327.6504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (496, 10, DATE '2011-06-30', 281.7550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (497, 3, DATE '2011-03-07', 870.3801);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (498, 7, DATE '2015-04-21', 91.1498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (499, 1, DATE '2014-07-31', 353.1460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (500, 6, DATE '2013-01-31', 268.6132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (501, 4, DATE '2011-11-30', 996.5525);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (502, 1, DATE '2015-08-22', 763.5363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (503, 1, DATE '2011-11-29', 333.9987);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (504, 6, DATE '2013-10-04', 596.0308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (505, 8, DATE '2015-06-02', 61.7370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (506, 1, DATE '2015-02-10', 621.9416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (507, 5, DATE '2012-08-01', 228.9290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (508, 5, DATE '2015-11-24', 475.6483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (509, 7, DATE '2011-06-16', 489.1614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (510, 9, DATE '2011-08-19', 401.5697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (511, 3, DATE '2014-12-26', 334.1804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (512, 3, DATE '2011-04-08', 860.5233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (513, 8, DATE '2015-05-12', 28.8060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (514, 6, DATE '2013-12-12', 588.8512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (515, 1, DATE '2012-07-30', 600.9417);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (516, 9, DATE '2015-01-14', 764.0418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (517, 5, DATE '2011-11-20', 929.6982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (518, 10, DATE '2012-08-20', 678.1420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (519, 8, DATE '2011-08-11', 542.4084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (520, 9, DATE '2013-04-05', 91.6368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (521, 5, DATE '2011-07-05', 764.5407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (522, 3, DATE '2014-01-15', 987.5872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (523, 2, DATE '2013-02-14', 651.2803);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (524, 4, DATE '2014-10-01', 106.4033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (525, 6, DATE '2013-12-29', 630.3709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (526, 10, DATE '2012-02-08', 533.9685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (527, 2, DATE '2013-03-17', 760.9587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (528, 1, DATE '2015-04-29', 710.8328);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (529, 7, DATE '2014-05-31', 724.4609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (530, 9, DATE '2011-09-17', 480.3590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (531, 5, DATE '2011-05-10', 642.5748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (532, 5, DATE '2015-08-01', 381.9009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (533, 3, DATE '2015-08-13', 572.2035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (534, 6, DATE '2015-09-26', 324.1725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (535, 4, DATE '2012-01-04', 5.9640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (536, 3, DATE '2014-02-28', 997.7751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (537, 9, DATE '2015-03-01', 832.1822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (538, 4, DATE '2015-10-18', 521.2786);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (539, 1, DATE '2013-03-14', 816.2623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (540, 10, DATE '2014-09-28', 502.3828);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (541, 8, DATE '2015-02-17', 906.0354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (542, 10, DATE '2011-04-16', 176.0129);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (543, 7, DATE '2012-03-23', 799.9941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (544, 6, DATE '2013-06-13', 379.6377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (545, 1, DATE '2013-12-15', 159.8028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (546, 9, DATE '2015-04-02', 876.9314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (547, 10, DATE '2013-03-19', 945.9423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (548, 9, DATE '2015-05-03', 895.8550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (549, 10, DATE '2013-09-26', 185.3338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (550, 3, DATE '2015-07-01', 563.6087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (551, 5, DATE '2015-08-11', 352.0569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (552, 3, DATE '2014-07-17', 192.2381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (553, 10, DATE '2014-09-11', 548.7415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (554, 3, DATE '2012-04-26', 261.5091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (555, 2, DATE '2012-07-30', 504.0726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (556, 2, DATE '2013-11-14', 8.9653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (557, 9, DATE '2013-07-07', 112.2559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (558, 7, DATE '2013-02-28', 227.5953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (559, 10, DATE '2015-10-07', 965.6599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (560, 8, DATE '2014-04-25', 527.7686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (561, 10, DATE '2012-11-26', 860.9829);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (562, 4, DATE '2013-04-05', 518.0962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (563, 9, DATE '2012-06-26', 751.1875);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (564, 9, DATE '2015-09-30', 8.8023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (565, 4, DATE '2011-04-11', 758.9950);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (566, 9, DATE '2015-05-28', 952.2796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (567, 10, DATE '2011-08-26', 288.3198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (568, 2, DATE '2015-08-16', 704.6336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (569, 2, DATE '2012-12-09', 582.8871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (570, 8, DATE '2014-06-01', 603.1666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (571, 1, DATE '2015-11-16', 931.8597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (572, 1, DATE '2012-02-02', 408.4196);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (573, 10, DATE '2015-06-09', 861.8797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (574, 8, DATE '2012-11-12', 40.0256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (575, 1, DATE '2014-02-17', 185.6015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (576, 5, DATE '2011-03-21', 588.5277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (577, 6, DATE '2012-10-25', 187.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (578, 6, DATE '2015-09-04', 271.6425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (579, 4, DATE '2011-10-17', 946.6006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (580, 8, DATE '2014-09-29', 753.4396);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (581, 10, DATE '2014-11-21', 588.0262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (582, 3, DATE '2013-11-14', 865.1037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (583, 2, DATE '2012-08-02', 525.4990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (584, 5, DATE '2014-12-01', 160.8521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (585, 4, DATE '2012-02-07', 128.3021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (586, 3, DATE '2012-10-24', 450.3366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (587, 6, DATE '2011-11-20', 833.1594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (588, 1, DATE '2014-04-19', 310.6943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (589, 5, DATE '2014-02-27', 820.0999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (590, 3, DATE '2014-02-19', 996.9988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (591, 4, DATE '2011-08-24', 885.5191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (592, 2, DATE '2013-01-01', 604.5868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (593, 5, DATE '2011-01-11', 555.6187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (594, 3, DATE '2014-11-20', 288.4937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (595, 1, DATE '2012-11-02', 641.3999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (596, 4, DATE '2012-11-13', 387.9391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (597, 1, DATE '2014-10-21', 424.8254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (598, 9, DATE '2012-06-23', 791.1918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (599, 3, DATE '2013-03-04', 620.6428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (600, 3, DATE '2014-07-20', 207.5233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (601, 9, DATE '2014-08-07', 588.6116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (602, 8, DATE '2013-08-04', 241.3087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (603, 7, DATE '2013-05-25', 312.9679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (604, 2, DATE '2015-04-27', 582.1672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (605, 3, DATE '2015-08-15', 631.7491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (606, 5, DATE '2014-07-09', 943.6374);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (607, 4, DATE '2015-02-08', 330.3585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (608, 3, DATE '2012-10-30', 508.7159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (609, 2, DATE '2014-03-10', 75.9076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (610, 7, DATE '2012-05-11', 915.5449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (611, 7, DATE '2012-01-21', 821.3723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (612, 3, DATE '2013-11-02', 840.6135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (613, 3, DATE '2012-05-14', 280.9948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (614, 2, DATE '2012-01-09', 212.2203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (615, 9, DATE '2015-06-04', 939.7424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (616, 7, DATE '2015-01-12', 995.8792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (617, 3, DATE '2011-09-04', 992.5973);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (618, 5, DATE '2013-07-26', 590.3354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (619, 6, DATE '2014-08-23', 880.5003);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (620, 1, DATE '2014-06-18', 308.6583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (621, 3, DATE '2014-07-09', 119.1201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (622, 10, DATE '2013-05-09', 977.6255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (623, 8, DATE '2012-06-18', 884.5337);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (624, 10, DATE '2014-10-20', 585.8883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (625, 4, DATE '2013-10-09', 717.6475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (626, 9, DATE '2013-11-15', 327.2728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (627, 6, DATE '2012-01-23', 852.8009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (628, 7, DATE '2011-07-20', 573.3859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (629, 7, DATE '2011-01-11', 398.6257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (630, 8, DATE '2012-04-05', 797.6624);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (631, 5, DATE '2012-05-30', 163.7022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (632, 8, DATE '2011-05-04', 396.4013);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (633, 4, DATE '2013-07-03', 650.9997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (634, 2, DATE '2013-03-29', 739.0773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (635, 9, DATE '2011-02-22', 164.8279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (636, 2, DATE '2012-04-18', 346.7175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (637, 7, DATE '2011-06-23', 552.1358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (638, 10, DATE '2013-04-07', 943.3318);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (639, 2, DATE '2015-04-18', 529.1030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (640, 9, DATE '2013-08-01', 184.6647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (641, 10, DATE '2013-09-15', 119.9781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (642, 3, DATE '2015-01-20', 324.4435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (643, 9, DATE '2011-02-09', 234.7867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (644, 9, DATE '2012-10-18', 904.5550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (645, 7, DATE '2013-01-30', 175.6264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (646, 1, DATE '2013-10-21', 44.9056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (647, 10, DATE '2011-08-20', 323.5920);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (648, 3, DATE '2015-01-03', 343.3984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (649, 5, DATE '2015-06-18', 348.7514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (650, 5, DATE '2013-10-21', 645.5208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (651, 1, DATE '2012-03-12', 395.3419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (652, 7, DATE '2012-03-28', 834.4901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (653, 3, DATE '2013-11-01', 910.6916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (654, 2, DATE '2014-09-16', 311.9845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (655, 10, DATE '2011-01-12', 88.4031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (656, 9, DATE '2012-03-30', 610.9861);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (657, 1, DATE '2012-02-16', 356.7750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (658, 8, DATE '2014-08-05', 727.0796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (659, 8, DATE '2012-07-19', 864.5198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (660, 4, DATE '2012-09-30', 304.4762);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (661, 9, DATE '2013-06-16', 90.8365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (662, 7, DATE '2014-07-22', 756.9727);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (663, 7, DATE '2012-10-19', 110.0902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (664, 5, DATE '2012-12-04', 278.2452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (665, 3, DATE '2015-12-12', 751.8426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (666, 9, DATE '2011-09-19', 424.9710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (667, 10, DATE '2011-05-03', 189.6137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (668, 2, DATE '2015-02-15', 541.9175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (669, 4, DATE '2011-11-17', 47.3923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (670, 7, DATE '2014-02-16', 593.0248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (671, 10, DATE '2014-07-23', 443.7433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (672, 4, DATE '2014-05-29', 49.2654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (673, 3, DATE '2014-04-10', 61.2323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (674, 8, DATE '2012-01-22', 695.8355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (675, 2, DATE '2011-10-04', 188.6802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (676, 10, DATE '2015-06-19', 794.6766);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (677, 2, DATE '2013-03-30', 742.8388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (678, 9, DATE '2015-08-31', 979.9787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (679, 3, DATE '2012-09-19', 410.2618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (680, 4, DATE '2015-12-19', 672.7419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (681, 9, DATE '2013-03-28', 3.6808);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (682, 4, DATE '2013-01-19', 509.4024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (683, 3, DATE '2012-02-02', 224.6344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (684, 2, DATE '2013-03-22', 753.1050);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (685, 7, DATE '2011-01-24', 402.3205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (686, 8, DATE '2011-03-05', 329.2122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (687, 6, DATE '2013-07-03', 485.7097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (688, 2, DATE '2014-10-18', 339.0152);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (689, 3, DATE '2013-03-18', 650.6741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (690, 1, DATE '2014-11-24', 553.8419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (691, 1, DATE '2011-03-04', 989.9425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (692, 10, DATE '2012-11-17', 825.0563);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (693, 3, DATE '2011-09-20', 78.8120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (694, 8, DATE '2013-07-18', 224.6267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (695, 10, DATE '2011-02-15', 93.8282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (696, 3, DATE '2015-02-25', 363.0055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (697, 7, DATE '2013-04-02', 214.3533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (698, 4, DATE '2014-03-07', 956.5415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (699, 6, DATE '2012-11-06', 152.7124);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (700, 8, DATE '2012-05-14', 750.6555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (701, 2, DATE '2013-06-21', 855.2919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (702, 9, DATE '2012-07-04', 781.6745);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (703, 10, DATE '2014-02-16', 296.0060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (704, 8, DATE '2012-05-02', 755.7267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (705, 5, DATE '2015-04-01', 201.7774);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (706, 8, DATE '2013-10-15', 346.0764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (707, 5, DATE '2013-12-19', 773.2578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (708, 5, DATE '2012-10-10', 214.8561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (709, 1, DATE '2013-12-14', 123.3043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (710, 10, DATE '2011-07-26', 293.7266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (711, 8, DATE '2015-01-01', 868.1473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (712, 3, DATE '2012-06-17', 376.7964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (713, 5, DATE '2012-11-16', 316.8177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (714, 5, DATE '2012-08-01', 191.7778);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (715, 6, DATE '2015-07-06', 300.7954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (716, 6, DATE '2011-05-29', 581.4341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (717, 5, DATE '2013-06-20', 532.3382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (718, 5, DATE '2015-07-31', 356.9853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (719, 9, DATE '2012-11-11', 875.9247);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (720, 5, DATE '2015-10-10', 422.6304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (721, 4, DATE '2014-03-19', 939.2613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (722, 8, DATE '2012-07-15', 850.5986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (723, 9, DATE '2012-11-30', 891.2435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (724, 3, DATE '2012-12-23', 493.5505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (725, 6, DATE '2013-12-16', 603.0823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (726, 1, DATE '2012-09-04', 618.6871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (727, 2, DATE '2013-09-09', 970.4535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (728, 5, DATE '2011-09-23', 836.6056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (729, 8, DATE '2011-12-08', 602.0072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (730, 9, DATE '2012-08-08', 825.6748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (731, 4, DATE '2013-03-19', 580.3233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (732, 9, DATE '2015-01-23', 786.2974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (733, 3, DATE '2013-10-24', 827.2663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (734, 5, DATE '2011-05-09', 659.6064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (735, 2, DATE '2013-06-29', 817.4500);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (736, 1, DATE '2011-09-24', 222.0064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (737, 4, DATE '2014-12-03', 213.3963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (738, 5, DATE '2015-10-02', 468.9078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (739, 7, DATE '2013-12-22', 551.3275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (740, 9, DATE '2013-04-11', 56.2441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (741, 4, DATE '2013-03-17', 555.9545);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (742, 1, DATE '2011-09-23', 270.8536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (743, 2, DATE '2011-11-05', 215.7108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (744, 4, DATE '2012-08-23', 356.9475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (745, 3, DATE '2015-11-24', 685.6946);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (746, 9, DATE '2014-09-16', 613.1461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (747, 5, DATE '2011-01-02', 508.2385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (748, 8, DATE '2015-02-18', 887.0342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (749, 3, DATE '2014-01-13', 923.8314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (750, 4, DATE '2015-09-20', 512.3941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (751, 9, DATE '2012-09-06', 830.6673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (752, 3, DATE '2013-09-03', 857.3681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (753, 5, DATE '2012-04-26', 80.6167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (754, 2, DATE '2013-01-28', 730.0820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (755, 5, DATE '2014-02-25', 811.3943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (756, 4, DATE '2011-12-07', 4.6933);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (757, 10, DATE '2015-08-05', 890.4310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (758, 7, DATE '2012-02-25', 802.4556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (759, 2, DATE '2014-05-18', 152.6443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (760, 5, DATE '2013-07-28', 583.0903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (761, 7, DATE '2011-02-06', 375.6229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (762, 10, DATE '2013-03-28', 936.6522);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (763, 8, DATE '2011-11-04', 612.8489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (764, 3, DATE '2012-05-07', 297.6296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (765, 7, DATE '2014-05-09', 713.4033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (766, 9, DATE '2015-12-09', 81.8499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (767, 10, DATE '2014-08-24', 549.5302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (768, 10, DATE '2012-07-10', 657.2114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (769, 3, DATE '2015-02-02', 374.3279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (770, 5, DATE '2014-10-12', 78.7890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (771, 3, DATE '2012-06-25', 368.0378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (772, 1, DATE '2013-09-18', 63.4303);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (773, 9, DATE '2012-08-09', 805.6578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (774, 1, DATE '2015-08-02', 819.6806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (775, 2, DATE '2013-07-25', 866.6760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (776, 4, DATE '2013-06-26', 668.4076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (777, 7, DATE '2011-09-11', 634.8877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (778, 6, DATE '2011-04-09', 534.2960);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (779, 1, DATE '2013-01-30', 807.8559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (780, 8, DATE '2015-04-01', 989.9363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (781, 6, DATE '2012-09-03', 110.4485);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (782, 4, DATE '2014-07-22', 83.4193);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (783, 2, DATE '2013-09-09', 912.7743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (784, 4, DATE '2012-03-19', 89.6131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (785, 10, DATE '2015-12-03', 995.0075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (786, 1, DATE '2015-07-16', 722.9553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (787, 4, DATE '2013-09-29', 705.6806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (788, 2, DATE '2011-09-27', 97.1842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (789, 1, DATE '2013-03-13', 848.2121);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (790, 9, DATE '2012-07-24', 812.7566);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (791, 2, DATE '2012-02-19', 331.5754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (792, 7, DATE '2013-10-09', 410.9407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (793, 3, DATE '2012-05-17', 316.2635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (794, 2, DATE '2011-05-28', 968.2372);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (795, 2, DATE '2013-03-05', 680.6212);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (796, 4, DATE '2015-12-20', 619.3023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (797, 3, DATE '2015-11-20', 658.0048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (798, 9, DATE '2015-07-01', 918.0813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (799, 7, DATE '2014-04-17', 643.5442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (800, 4, DATE '2015-12-17', 603.8447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (801, 10, DATE '2011-01-23', 63.6159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (802, 6, DATE '2014-06-24', 851.0272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (803, 6, DATE '2011-01-17', 512.7063);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (804, 9, DATE '2015-04-03', 845.0423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (805, 2, DATE '2014-03-28', 144.3562);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (806, 9, DATE '2014-12-20', 767.2370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (807, 4, DATE '2012-01-26', 51.7102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (808, 5, DATE '2012-09-24', 260.9361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (809, 10, DATE '2015-07-06', 863.4061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (810, 2, DATE '2011-09-02', 142.9866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (811, 8, DATE '2011-03-29', 369.8057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (812, 4, DATE '2015-04-29', 356.1350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (813, 7, DATE '2015-01-26', 994.5997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (814, 5, DATE '2015-02-16', 162.7081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (815, 9, DATE '2011-11-24', 472.6418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (816, 4, DATE '2012-07-18', 292.2036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (817, 8, DATE '2015-07-20', 23.8779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (818, 4, DATE '2015-08-17', 523.2357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (819, 3, DATE '2012-06-04', 302.6222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (820, 6, DATE '2014-10-24', 990.4481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (821, 6, DATE '2013-03-12', 376.1693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (822, 8, DATE '2013-11-28', 452.3459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (823, 10, DATE '2015-04-29', 808.9993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (824, 5, DATE '2013-07-12', 561.5713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (825, 4, DATE '2013-08-23', 747.2137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (826, 6, DATE '2014-09-16', 957.0971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (827, 8, DATE '2012-05-04', 747.1669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (828, 7, DATE '2012-03-14', 837.4206);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (829, 9, DATE '2013-05-30', 139.0593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (830, 8, DATE '2013-08-06', 247.3736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (831, 1, DATE '2013-08-06', 10.4028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (832, 8, DATE '2012-03-13', 716.8064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (833, 9, DATE '2012-12-22', 890.7519);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (834, 7, DATE '2013-02-13', 204.0112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (835, 8, DATE '2015-03-10', 926.3204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (836, 1, DATE '2014-03-12', 259.4213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (837, 9, DATE '2014-07-05', 570.7131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (838, 4, DATE '2014-06-08', 67.7319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (839, 3, DATE '2013-12-23', 945.2569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (840, 2, DATE '2011-12-15', 227.7705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (841, 8, DATE '2014-06-20', 671.2450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (842, 10, DATE '2012-01-05', 444.7444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (843, 3, DATE '2012-03-23', 233.7782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (844, 10, DATE '2012-07-12', 705.2255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (845, 1, DATE '2012-04-27', 442.9509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (846, 8, DATE '2012-10-23', 975.4404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (847, 1, DATE '2014-09-14', 416.3411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (848, 8, DATE '2013-03-31', 153.5553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (849, 4, DATE '2015-07-04', 495.5954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (850, 9, DATE '2011-08-19', 388.4176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (851, 6, DATE '2011-06-03', 595.4243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (852, 10, DATE '2011-04-05', 134.7690);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (853, 7, DATE '2014-01-26', 615.4591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (854, 2, DATE '2015-06-24', 653.0961);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (855, 9, DATE '2013-10-07', 227.6753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (856, 3, DATE '2013-02-25', 611.2700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (857, 7, DATE '2015-02-25', 42.0279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (858, 1, DATE '2013-07-07', 951.1350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (859, 6, DATE '2012-08-11', 97.8286);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (860, 7, DATE '2015-07-13', 187.2592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (861, 1, DATE '2013-08-17', 20.0700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (862, 8, DATE '2015-11-13', 214.2897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (863, 7, DATE '2015-04-28', 121.8768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (864, 2, DATE '2012-11-30', 616.0324);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (865, 1, DATE '2014-01-26', 132.5838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (866, 10, DATE '2015-01-15', 652.9993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (867, 5, DATE '2013-05-07', 465.3832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (868, 10, DATE '2012-12-12', 790.5884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (869, 8, DATE '2015-12-10', 236.3878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (870, 9, DATE '2013-09-14', 213.2204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (871, 5, DATE '2014-01-13', 721.4905);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (872, 5, DATE '2012-02-11', 956.1461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (873, 1, DATE '2012-08-25', 577.9788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (874, 2, DATE '2011-06-22', 74.8517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (875, 9, DATE '2011-05-06', 319.2031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (876, 6, DATE '2012-03-08', 931.4250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (877, 5, DATE '2012-09-06', 218.5677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (878, 1, DATE '2013-10-18', 103.7738);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (879, 4, DATE '2012-03-16', 118.6204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (880, 6, DATE '2011-11-01', 771.7733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (881, 5, DATE '2011-01-02', 540.7560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (882, 1, DATE '2015-02-03', 593.6115);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (883, 4, DATE '2012-09-11', 341.8252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (884, 10, DATE '2012-10-11', 750.6418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (885, 3, DATE '2013-03-06', 651.9494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (886, 1, DATE '2013-05-04', 875.6338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (887, 2, DATE '2014-02-15', 101.3472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (888, 8, DATE '2013-07-01', 237.6557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (889, 8, DATE '2015-05-10', 976.3360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (890, 5, DATE '2013-01-12', 315.0503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (891, 4, DATE '2015-01-15', 217.3934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (892, 8, DATE '2011-12-29', 619.5781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (893, 8, DATE '2012-10-28', 969.9033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (894, 7, DATE '2014-06-12', 757.9977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (895, 2, DATE '2014-04-29', 207.7004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (896, 10, DATE '2014-08-08', 456.9552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (897, 4, DATE '2012-09-08', 322.8676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (898, 2, DATE '2015-04-24', 617.7458);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (899, 9, DATE '2014-06-16', 572.6416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (900, 2, DATE '2013-04-13', 789.9516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (901, 3, DATE '2015-06-18', 510.0571);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (902, 1, DATE '2012-10-03', 625.7527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (903, 1, DATE '2013-04-22', 917.1676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (904, 5, DATE '2012-10-20', 282.3749);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (905, 4, DATE '2013-08-05', 666.9272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (906, 1, DATE '2015-04-22', 639.2783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (907, 9, DATE '2014-08-10', 556.7902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (908, 5, DATE '2013-08-06', 540.6074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (909, 4, DATE '2015-02-18', 333.8929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (910, 4, DATE '2012-07-31', 296.2503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (911, 8, DATE '2011-06-21', 392.7022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (912, 7, DATE '2012-05-09', 938.2541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (913, 7, DATE '2012-04-23', 832.5146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (914, 10, DATE '2011-10-11', 326.0553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (915, 2, DATE '2015-07-11', 646.5033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (916, 10, DATE '2014-07-14', 426.4585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (917, 4, DATE '2014-03-03', 872.4645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (918, 7, DATE '2013-07-17', 371.2350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (919, 10, DATE '2015-09-27', 964.0831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (920, 1, DATE '2011-09-25', 256.9500);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (921, 9, DATE '2011-12-01', 551.6521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (922, 8, DATE '2015-11-07', 227.7274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (923, 3, DATE '2013-08-04', 814.2524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (924, 3, DATE '2013-11-27', 921.3375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (925, 5, DATE '2014-08-30', 995.8271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (926, 8, DATE '2013-01-15', 101.9123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (927, 8, DATE '2015-04-16', 986.2429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (928, 5, DATE '2014-03-16', 819.9812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (929, 10, DATE '2013-02-23', 867.1513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (930, 9, DATE '2012-09-28', 862.2479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (931, 2, DATE '2015-06-30', 608.5573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (932, 4, DATE '2013-05-16', 600.8219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (933, 3, DATE '2015-05-05', 531.1322);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (934, 3, DATE '2014-12-04', 328.6688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (935, 3, DATE '2012-05-15', 261.7162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (936, 4, DATE '2014-03-31', 915.0033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (937, 1, DATE '2012-10-14', 676.4440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (938, 9, DATE '2015-11-23', 59.4502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (939, 6, DATE '2015-03-09', 83.7146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (940, 2, DATE '2013-11-14', 12.6710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (941, 2, DATE '2014-09-24', 318.8435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (942, 7, DATE '2011-07-12', 560.7399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (943, 5, DATE '2014-05-13', 903.7629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (944, 5, DATE '2013-10-09', 680.0857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (945, 8, DATE '2012-07-25', 922.3482);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (946, 8, DATE '2013-09-08', 279.1393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (947, 1, DATE '2015-09-07', 787.0636);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (948, 8, DATE '2012-01-18', 643.8479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (949, 5, DATE '2014-12-02', 111.4943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (950, 2, DATE '2015-10-16', 781.2419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (951, 6, DATE '2011-06-07', 584.4907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (952, 8, DATE '2015-02-22', 951.6326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (953, 2, DATE '2015-07-28', 653.6628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (954, 8, DATE '2013-09-22', 315.6916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (955, 4, DATE '2012-05-13', 238.2995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (956, 6, DATE '2015-08-12', 282.3296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (957, 9, DATE '2015-03-01', 811.5004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (958, 8, DATE '2015-05-26', 995.8302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (959, 10, DATE '2014-02-21', 286.5479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (960, 7, DATE '2011-07-21', 565.0148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (961, 4, DATE '2011-01-06', 653.0355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (962, 5, DATE '2011-05-28', 736.8091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (963, 6, DATE '2011-06-14', 673.4561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (964, 5, DATE '2013-05-22', 471.6450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (965, 2, DATE '2013-02-01', 687.6930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (966, 5, DATE '2014-02-05', 791.8804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (967, 4, DATE '2013-01-05', 407.1219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (968, 5, DATE '2013-05-20', 503.8458);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (969, 7, DATE '2015-05-29', 64.3391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (970, 8, DATE '2012-04-12', 731.5001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (971, 10, DATE '2012-09-30', 750.0146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (972, 5, DATE '2014-04-11', 813.0143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (973, 1, DATE '2014-05-11', 287.5204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (974, 8, DATE '2012-11-12', 951.4120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (975, 9, DATE '2012-12-31', 938.1065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (976, 2, DATE '2011-05-22', 990.9122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (977, 3, DATE '2012-06-26', 323.9646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (978, 8, DATE '2015-10-26', 134.1667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (979, 6, DATE '2012-05-05', 998.9894);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (980, 7, DATE '2011-12-23', 716.6877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (981, 7, DATE '2013-05-11', 314.8488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (982, 10, DATE '2014-03-30', 342.3949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (983, 1, DATE '2015-04-14', 708.4868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (984, 9, DATE '2013-05-10', 85.9094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (985, 3, DATE '2012-04-24', 277.7572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (986, 5, DATE '2011-05-08', 656.9248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (987, 2, DATE '2013-10-19', 947.1592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (988, 5, DATE '2012-08-13', 215.4406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (989, 10, DATE '2013-07-23', 90.3693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (990, 8, DATE '2012-10-03', 979.3866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (991, 6, DATE '2015-01-31', 103.5029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (992, 3, DATE '2013-05-21', 680.6139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (993, 10, DATE '2012-10-02', 772.9023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (994, 10, DATE '2014-08-19', 518.6999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (995, 8, DATE '2013-11-09', 359.6356);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (996, 8, DATE '2014-04-30', 582.0345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (997, 2, DATE '2011-01-29', 887.2838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (998, 10, DATE '2011-12-22', 432.1179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (999, 3, DATE '2011-09-08', 992.3927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1000, 3, DATE '2014-06-19', 130.4677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1001, 1, DATE '2013-10-05', 74.6495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1002, 9, DATE '2011-11-04', 461.5677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1003, 1, DATE '2014-09-28', 447.2001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1004, 2, DATE '2012-11-21', 591.8555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1005, 6, DATE '2011-03-10', 488.8755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1006, 7, DATE '2013-09-03', 408.7025);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1007, 3, DATE '2014-04-24', 110.5471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1008, 3, DATE '2014-12-21', 296.2020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1009, 3, DATE '2012-09-13', 464.1072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1010, 3, DATE '2014-02-02', 986.7017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1011, 6, DATE '2012-03-10', 974.4616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1012, 10, DATE '2014-09-10', 519.0092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1013, 1, DATE '2014-07-14', 394.3178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1014, 5, DATE '2015-10-17', 478.6520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1015, 4, DATE '2011-01-17', 709.2099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1016, 8, DATE '2012-09-05', 960.3166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1017, 10, DATE '2012-12-11', 809.5744);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1018, 9, DATE '2013-07-22', 131.2104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1019, 1, DATE '2011-04-05', 78.8460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1020, 7, DATE '2011-05-19', 463.0039);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1021, 4, DATE '2013-03-13', 572.1064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1022, 5, DATE '2014-06-09', 932.7317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1023, 6, DATE '2014-06-26', 865.7009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1024, 8, DATE '2011-07-25', 461.7454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1025, 10, DATE '2011-03-20', 141.0627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1026, 9, DATE '2013-08-24', 172.2494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1027, 2, DATE '2011-04-01', 909.2511);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1028, 2, DATE '2014-12-28', 417.7485);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1029, 9, DATE '2011-10-05', 428.1018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1030, 1, DATE '2015-02-08', 626.5140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1031, 8, DATE '2011-10-08', 522.7024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1032, 1, DATE '2012-10-04', 615.0627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1033, 4, DATE '2014-10-03', 153.1935);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1034, 1, DATE '2011-05-13', 97.6664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1035, 4, DATE '2014-06-22', 43.6965);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1036, 1, DATE '2011-08-05', 161.7518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1037, 3, DATE '2011-04-30', 893.5793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1038, 2, DATE '2015-05-13', 554.2385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1039, 7, DATE '2015-04-15', 28.6261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1040, 2, DATE '2014-05-17', 242.9793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1041, 10, DATE '2014-10-27', 532.1067);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1042, 10, DATE '2012-02-09', 499.1023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1043, 10, DATE '2013-08-30', 104.7142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1044, 7, DATE '2014-11-24', 892.5640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1045, 8, DATE '2012-06-30', 826.6523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1046, 4, DATE '2012-01-15', 88.4537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1047, 10, DATE '2012-09-08', 677.7030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1048, 8, DATE '2014-09-12', 755.4644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1049, 5, DATE '2013-11-11', 670.0557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1050, 5, DATE '2013-09-02', 666.4387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1051, 4, DATE '2013-03-29', 564.6401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1052, 3, DATE '2014-08-14', 174.4185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1053, 6, DATE '2012-05-10', 998.3586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1054, 4, DATE '2013-12-19', 797.2962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1055, 7, DATE '2015-01-12', 6.6520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1056, 6, DATE '2015-04-29', 141.9179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1057, 4, DATE '2013-05-10', 595.8669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1058, 3, DATE '2014-03-06', 985.4548);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1059, 3, DATE '2012-09-04', 450.7928);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1060, 8, DATE '2013-07-17', 316.6260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1061, 5, DATE '2013-06-05', 499.4514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1062, 1, DATE '2015-04-28', 692.7986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1063, 5, DATE '2014-03-19', 868.1002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1064, 3, DATE '2013-08-06', 837.5932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1065, 5, DATE '2013-04-28', 463.9992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1066, 5, DATE '2015-06-06', 359.3988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1067, 7, DATE '2015-12-08', 365.8156);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1068, 10, DATE '2014-03-04', 296.6514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1069, 1, DATE '2012-04-26', 434.9554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1070, 3, DATE '2015-06-15', 547.4581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1071, 5, DATE '2012-05-09', 66.7372);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1072, 8, DATE '2013-08-01', 255.3358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1073, 3, DATE '2014-04-08', 102.5842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1074, 10, DATE '2012-11-18', 835.8668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1075, 7, DATE '2012-07-22', 930.8973);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1076, 4, DATE '2012-02-02', 73.0041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1077, 5, DATE '2011-10-10', 828.0174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1078, 9, DATE '2015-08-02', 973.1369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1079, 10, DATE '2015-01-24', 635.0932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1080, 7, DATE '2015-03-06', 52.6089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1081, 9, DATE '2011-12-16', 494.5465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1082, 5, DATE '2012-07-19', 153.7866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1083, 8, DATE '2012-02-17', 747.6928);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1084, 5, DATE '2014-02-01', 761.6632);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1085, 7, DATE '2012-11-11', 61.8739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1086, 6, DATE '2013-02-23', 348.2839);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1087, 6, DATE '2011-05-27', 616.7042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1088, 10, DATE '2011-10-15', 355.8974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1089, 5, DATE '2012-05-01', 91.0144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1090, 8, DATE '2015-02-24', 901.7786);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1091, 8, DATE '2014-03-27', 565.8849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1092, 10, DATE '2013-02-23', 908.1246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1093, 10, DATE '2013-09-08', 103.4456);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1094, 10, DATE '2012-09-29', 712.0002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1095, 7, DATE '2011-12-13', 743.5279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1096, 10, DATE '2015-07-02', 839.3081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1097, 6, DATE '2013-11-22', 631.0021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1098, 8, DATE '2011-01-25', 267.1210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1099, 3, DATE '2012-07-29', 428.5647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1100, 4, DATE '2013-01-24', 467.2534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1101, 8, DATE '2012-02-07', 722.6381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1102, 1, DATE '2014-07-08', 381.0516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1103, 7, DATE '2013-05-19', 320.5089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1104, 3, DATE '2014-05-29', 122.5976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1105, 10, DATE '2012-04-26', 599.7015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1106, 6, DATE '2015-08-29', 309.3042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1107, 1, DATE '2011-05-08', 71.8342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1108, 7, DATE '2015-06-23', 162.4918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1109, 7, DATE '2012-05-30', 866.3990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1110, 3, DATE '2013-12-10', 933.6480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1111, 2, DATE '2014-07-20', 313.9005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1112, 5, DATE '2013-10-08', 622.7300);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1113, 3, DATE '2015-02-11', 350.3615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1114, 7, DATE '2013-07-02', 398.1838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1115, 9, DATE '2012-08-01', 822.0795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1116, 1, DATE '2011-11-17', 345.6647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1117, 4, DATE '2014-03-12', 945.1058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1118, 10, DATE '2011-02-15', 106.4369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1119, 6, DATE '2011-09-25', 775.7192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1120, 10, DATE '2011-03-05', 115.7153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1121, 9, DATE '2015-01-11', 742.6947);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1122, 7, DATE '2015-02-24', 9.9182);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1123, 6, DATE '2012-11-03', 205.6369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1124, 4, DATE '2013-03-03', 533.1769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1125, 6, DATE '2012-03-21', 981.5732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1126, 6, DATE '2015-03-16', 158.6126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1127, 9, DATE '2015-11-23', 151.8902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1128, 3, DATE '2012-07-10', 390.5841);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1129, 3, DATE '2011-12-07', 92.3388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1130, 8, DATE '2013-01-21', 91.5891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1131, 9, DATE '2014-03-13', 442.0020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1132, 8, DATE '2011-09-16', 560.8963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1133, 7, DATE '2014-01-04', 544.5721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1134, 7, DATE '2012-12-30', 167.8397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1135, 9, DATE '2014-01-27', 329.9708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1136, 9, DATE '2013-06-10', 113.4949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1137, 9, DATE '2015-03-03', 833.2777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1138, 5, DATE '2013-09-20', 625.0952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1139, 6, DATE '2012-10-08', 161.9616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1140, 2, DATE '2013-03-15', 752.5698);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1141, 5, DATE '2012-10-19', 276.4496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1142, 10, DATE '2011-12-04', 454.2123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1143, 3, DATE '2015-05-18', 489.4984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1144, 2, DATE '2014-05-22', 157.3664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1145, 7, DATE '2011-08-07', 587.8781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1146, 3, DATE '2011-06-19', 943.1550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1147, 7, DATE '2014-01-12', 557.7630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1148, 4, DATE '2011-03-10', 705.2619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1149, 2, DATE '2011-03-01', 889.9207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1150, 7, DATE '2011-01-26', 397.8631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1151, 7, DATE '2012-04-22', 894.2023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1152, 6, DATE '2013-10-07', 524.5652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1153, 3, DATE '2015-05-02', 491.4018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1154, 3, DATE '2012-05-26', 312.8493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1155, 5, DATE '2014-01-13', 724.5588);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1156, 1, DATE '2012-12-14', 712.7199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1157, 5, DATE '2012-09-03', 175.4146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1158, 3, DATE '2011-03-18', 787.3321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1159, 8, DATE '2013-03-10', 141.0245);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1160, 5, DATE '2013-02-10', 441.0889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1161, 8, DATE '2015-10-06', 157.4140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1162, 9, DATE '2014-10-29', 681.2502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1163, 4, DATE '2014-07-17', 70.1530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1164, 10, DATE '2015-05-10', 774.8098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1165, 5, DATE '2015-09-30', 491.6460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1166, 4, DATE '2013-11-04', 753.0042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1167, 9, DATE '2015-10-05', 78.1578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1168, 7, DATE '2013-02-11', 182.5218);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1169, 8, DATE '2015-06-05', 68.2129);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1170, 10, DATE '2015-02-21', 708.5846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1171, 2, DATE '2012-09-16', 512.3871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1172, 9, DATE '2011-06-22', 320.0106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1173, 4, DATE '2014-05-10', 944.4753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1174, 4, DATE '2014-07-12', 23.1494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1175, 6, DATE '2014-05-16', 839.2658);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1176, 10, DATE '2014-02-07', 288.4823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1177, 4, DATE '2015-10-09', 520.4198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1178, 4, DATE '2014-06-14', 48.2705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1179, 7, DATE '2012-07-28', 945.2989);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1180, 3, DATE '2011-10-03', 38.4181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1181, 9, DATE '2012-03-04', 600.8496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1182, 5, DATE '2015-09-16', 446.6283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1183, 1, DATE '2012-05-12', 500.6635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1184, 7, DATE '2011-11-12', 694.4757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1185, 2, DATE '2011-10-01', 197.3868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1186, 3, DATE '2011-06-06', 917.4368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1187, 5, DATE '2012-05-16', 69.4944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1188, 5, DATE '2012-08-10', 231.7228);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1189, 2, DATE '2014-12-17', 443.2810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1190, 9, DATE '2012-02-13', 617.2510);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1191, 4, DATE '2011-10-07', 938.0804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1192, 6, DATE '2014-12-17', 45.9455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1193, 8, DATE '2011-07-14', 484.0706);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1194, 2, DATE '2015-08-28', 720.8728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1195, 4, DATE '2013-06-09', 595.1557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1196, 6, DATE '2013-12-22', 595.1995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1197, 6, DATE '2013-05-20', 384.0593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1198, 3, DATE '2011-01-09', 714.6887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1199, 8, DATE '2014-08-23', 665.7204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1200, 3, DATE '2013-10-03', 834.8739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1201, 5, DATE '2011-09-15', 864.9971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1202, 10, DATE '2011-12-01', 375.2412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1203, 7, DATE '2011-10-05', 637.0489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1204, 3, DATE '2012-01-08', 181.3361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1205, 5, DATE '2014-05-12', 885.4761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1206, 8, DATE '2011-11-02', 574.1917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1207, 2, DATE '2015-05-31', 580.0899);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1208, 9, DATE '2011-10-21', 468.2524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1209, 8, DATE '2014-01-10', 473.5836);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1210, 6, DATE '2015-12-07', 436.0764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1211, 7, DATE '2013-03-07', 192.3000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1212, 2, DATE '2014-03-23', 127.1440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1213, 7, DATE '2014-08-20', 842.0333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1214, 5, DATE '2012-06-07', 102.6063);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1215, 6, DATE '2011-12-10', 840.2393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1216, 4, DATE '2011-01-21', 710.7857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1217, 9, DATE '2013-06-18', 180.5867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1218, 7, DATE '2013-09-05', 375.6773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1219, 9, DATE '2014-08-09', 577.4230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1220, 2, DATE '2015-04-26', 574.2092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1221, 10, DATE '2012-06-20', 683.5097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1222, 5, DATE '2014-02-24', 846.4351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1223, 6, DATE '2014-02-25', 739.2408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1224, 9, DATE '2014-04-23', 450.9620);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1225, 6, DATE '2014-05-17', 770.5042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1226, 7, DATE '2013-09-30', 466.4415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1227, 2, DATE '2015-12-09', 835.9400);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1228, 3, DATE '2014-09-12', 223.6024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1229, 1, DATE '2012-02-03', 427.9937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1230, 10, DATE '2011-05-26', 244.0663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1231, 4, DATE '2011-09-21', 904.4231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1232, 1, DATE '2015-10-01', 805.7312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1233, 6, DATE '2015-10-23', 382.5501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1234, 5, DATE '2014-10-25', 110.4249);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1235, 9, DATE '2011-01-19', 173.4211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1236, 9, DATE '2011-04-04', 225.6084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1237, 8, DATE '2014-12-13', 809.5795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1238, 9, DATE '2011-05-06', 319.3273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1239, 2, DATE '2013-07-02', 808.9997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1240, 4, DATE '2015-11-30', 623.1952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1241, 1, DATE '2012-01-06', 337.3469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1242, 7, DATE '2011-07-27', 601.2421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1243, 7, DATE '2014-07-31', 758.1392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1244, 7, DATE '2015-01-11', 7.2046);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1245, 2, DATE '2014-12-08', 424.9509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1246, 3, DATE '2013-07-17', 810.9364);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1247, 10, DATE '2011-04-29', 203.9123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1248, 3, DATE '2015-02-06', 381.4642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1249, 7, DATE '2014-09-19', 880.6336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1250, 1, DATE '2013-05-20', 884.3701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1251, 8, DATE '2011-07-06', 414.6128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1252, 9, DATE '2015-09-15', 8.3820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1253, 5, DATE '2012-06-01', 137.2656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1254, 7, DATE '2015-04-29', 91.5111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1255, 4, DATE '2012-04-14', 151.3641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1256, 1, DATE '2013-07-22', 18.5619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1257, 5, DATE '2013-10-05', 636.0004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1258, 8, DATE '2013-06-14', 186.0869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1259, 7, DATE '2013-08-23', 410.8319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1260, 9, DATE '2011-08-12', 419.0346);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1261, 7, DATE '2011-11-24', 738.2517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1262, 10, DATE '2011-09-18', 356.4874);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1263, 9, DATE '2015-09-18', 40.2586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1264, 9, DATE '2013-08-18', 229.5173);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1265, 2, DATE '2015-03-18', 531.6533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1266, 6, DATE '2013-06-07', 386.5689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1267, 7, DATE '2014-05-31', 744.5939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1268, 2, DATE '2015-10-27', 731.6083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1269, 7, DATE '2012-05-19', 929.1853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1270, 7, DATE '2011-09-07', 614.6308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1271, 6, DATE '2012-02-08', 901.2062);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1272, 10, DATE '2013-02-13', 861.2594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1273, 6, DATE '2011-03-06', 566.6777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1274, 6, DATE '2014-09-10', 954.2278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1275, 1, DATE '2014-04-20', 236.8623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1276, 3, DATE '2011-11-25', 82.2676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1277, 8, DATE '2015-07-27', 88.2958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1278, 10, DATE '2015-02-15', 732.0362);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1279, 8, DATE '2015-05-16', 26.0110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1280, 4, DATE '2011-11-01', 959.5679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1281, 8, DATE '2013-06-04', 262.5292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1282, 9, DATE '2011-11-03', 454.4757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1283, 7, DATE '2015-12-25', 342.9689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1284, 10, DATE '2014-09-15', 543.6236);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1285, 2, DATE '2015-11-21', 829.4535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1286, 6, DATE '2012-01-06', 896.0411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1287, 7, DATE '2014-05-02', 668.4655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1288, 10, DATE '2011-06-26', 291.0390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1289, 1, DATE '2013-07-12', 959.0609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1290, 9, DATE '2013-06-30', 154.8591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1291, 5, DATE '2013-06-29', 589.6080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1292, 10, DATE '2012-07-01', 623.4925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1293, 2, DATE '2013-09-12', 908.4954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1294, 4, DATE '2012-11-20', 389.9650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1295, 8, DATE '2015-01-06', 884.9435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1296, 2, DATE '2011-04-21', 980.8596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1297, 8, DATE '2011-11-08', 560.9835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1298, 9, DATE '2011-12-14', 528.6219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1299, 5, DATE '2015-10-26', 475.5513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1300, 6, DATE '2012-07-03', 38.3820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1301, 6, DATE '2015-02-16', 66.3424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1302, 8, DATE '2011-07-04', 472.3040);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1303, 7, DATE '2013-09-19', 452.2790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1304, 10, DATE '2014-01-12', 266.0027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1305, 6, DATE '2012-04-11', 983.1639);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1306, 9, DATE '2014-05-23', 553.3534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1307, 4, DATE '2015-07-12', 441.7044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1308, 10, DATE '2013-09-22', 183.0378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1309, 6, DATE '2012-01-09', 854.6489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1310, 1, DATE '2011-05-22', 69.0964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1311, 3, DATE '2013-12-27', 930.2661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1312, 6, DATE '2014-08-21', 903.9642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1313, 1, DATE '2014-01-29', 160.0759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1314, 3, DATE '2012-10-23', 451.2641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1315, 2, DATE '2014-03-10', 156.5054);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1316, 8, DATE '2011-01-22', 283.7759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1317, 3, DATE '2011-09-25', 13.5184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1318, 10, DATE '2012-01-04', 496.6350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1319, 7, DATE '2013-09-27', 400.0638);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1320, 7, DATE '2014-03-12', 635.6123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1321, 10, DATE '2015-02-06', 718.1034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1322, 8, DATE '2013-12-06', 453.5549);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1323, 2, DATE '2013-04-16', 772.5474);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1324, 8, DATE '2014-11-20', 774.3261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1325, 3, DATE '2014-03-11', 25.0228);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1326, 6, DATE '2015-08-10', 277.7137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1327, 9, DATE '2015-06-03', 952.7640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1328, 2, DATE '2014-04-16', 176.7126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1329, 9, DATE '2015-09-04', 69.2843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1330, 10, DATE '2013-12-31', 256.0028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1331, 5, DATE '2011-01-17', 521.2842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1332, 9, DATE '2014-08-13', 559.6740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1333, 5, DATE '2015-04-22', 256.4849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1334, 2, DATE '2013-11-13', 987.6290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1335, 8, DATE '2012-09-14', 893.2254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1336, 10, DATE '2012-12-02', 790.2252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1337, 3, DATE '2014-02-14', 2.1967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1338, 8, DATE '2012-12-12', 76.9661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1339, 5, DATE '2013-06-05', 560.4598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1340, 4, DATE '2012-06-30', 276.1000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1341, 2, DATE '2012-06-27', 454.3367);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1342, 8, DATE '2011-08-10', 485.4276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1343, 4, DATE '2015-06-17', 436.3901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1344, 10, DATE '2013-02-21', 889.9644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1345, 6, DATE '2015-07-05', 224.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1346, 9, DATE '2014-11-08', 685.6439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1347, 10, DATE '2014-06-03', 463.4166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1348, 9, DATE '2011-11-20', 457.2313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1349, 3, DATE '2014-09-13', 233.4595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1350, 10, DATE '2014-12-16', 601.1675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1351, 9, DATE '2015-07-27', 967.3411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1352, 9, DATE '2015-11-05', 64.3484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1353, 2, DATE '2014-03-18', 128.5581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1354, 9, DATE '2012-08-15', 839.9390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1355, 7, DATE '2013-05-27', 320.2787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1356, 9, DATE '2012-03-13', 612.7876);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1357, 6, DATE '2014-03-20', 699.7566);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1358, 9, DATE '2014-10-30', 677.9529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1359, 7, DATE '2015-11-04', 240.9799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1360, 10, DATE '2012-09-02', 705.4502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1361, 10, DATE '2014-12-20', 600.5895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1362, 3, DATE '2012-03-27', 264.9917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1363, 2, DATE '2014-01-18', 113.7535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1364, 7, DATE '2014-01-09', 598.6461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1365, 6, DATE '2011-05-05', 547.8123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1366, 4, DATE '2015-05-16', 370.5921);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1367, 1, DATE '2015-05-02', 647.4793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1368, 10, DATE '2011-03-19', 172.4470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1369, 5, DATE '2011-02-09', 558.0387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1370, 2, DATE '2012-04-07', 366.2802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1371, 5, DATE '2012-12-08', 281.5792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1372, 6, DATE '2014-10-13', 936.5524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1373, 5, DATE '2014-07-31', 936.1753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1374, 4, DATE '2012-03-29', 123.9637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1375, 6, DATE '2012-09-15', 181.2756);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1376, 2, DATE '2014-06-29', 232.6757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1377, 4, DATE '2014-06-21', 17.1648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1378, 2, DATE '2011-02-23', 882.5831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1379, 3, DATE '2015-05-19', 549.7330);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1380, 4, DATE '2015-05-03', 339.3790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1381, 7, DATE '2012-03-09', 814.2971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1382, 10, DATE '2014-07-15', 495.5327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1383, 9, DATE '2015-08-04', 943.2531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1384, 9, DATE '2011-09-19', 468.1168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1385, 1, DATE '2014-06-07', 288.6617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1386, 7, DATE '2011-03-15', 456.9357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1387, 8, DATE '2011-05-28', 431.1158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1388, 7, DATE '2013-09-06', 416.5459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1389, 6, DATE '2011-06-19', 667.3502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1390, 10, DATE '2011-07-05', 280.4378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1391, 4, DATE '2014-09-15', 90.4686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1392, 4, DATE '2015-04-17', 324.2438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1393, 1, DATE '2013-02-08', 835.9863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1394, 5, DATE '2011-10-03', 855.0096);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1395, 4, DATE '2013-07-12', 675.5106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1396, 10, DATE '2011-04-02', 189.3449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1397, 7, DATE '2013-07-22', 371.6741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1398, 8, DATE '2012-06-08', 837.7440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1399, 4, DATE '2012-10-20', 342.1521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1400, 2, DATE '2011-02-19', 854.0010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1401, 8, DATE '2015-07-10', 38.1645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1402, 10, DATE '2014-03-17', 290.9696);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1403, 5, DATE '2011-10-12', 899.1927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1404, 2, DATE '2013-06-07', 867.1793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1405, 5, DATE '2013-01-08', 319.5883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1406, 3, DATE '2011-10-15', 30.7886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1407, 4, DATE '2012-04-07', 128.1732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1408, 8, DATE '2012-12-20', 4.5944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1409, 4, DATE '2015-12-01', 658.6634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1410, 5, DATE '2014-11-29', 87.6029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1411, 5, DATE '2013-09-23', 595.6227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1412, 5, DATE '2014-01-25', 817.1736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1413, 7, DATE '2015-06-13', 128.2198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1414, 4, DATE '2011-07-04', 901.6010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1415, 4, DATE '2011-06-27', 891.1532);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1416, 1, DATE '2011-06-08', 105.0568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1417, 4, DATE '2012-08-24', 321.7386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1418, 3, DATE '2013-05-02', 645.6368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1419, 6, DATE '2015-08-05', 309.9843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1420, 10, DATE '2011-02-21', 90.8766);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1421, 7, DATE '2014-12-20', 939.4764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1422, 5, DATE '2012-08-25', 230.9333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1423, 4, DATE '2015-09-30', 505.0968);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1424, 6, DATE '2015-08-07', 277.6008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1425, 8, DATE '2013-07-24', 275.8116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1426, 2, DATE '2013-08-23', 957.3354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1427, 6, DATE '2012-09-03', 100.5661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1428, 1, DATE '2013-10-28', 81.1657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1429, 1, DATE '2014-09-18', 448.4531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1430, 6, DATE '2012-06-15', 991.9307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1431, 6, DATE '2011-12-09', 861.0017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1432, 7, DATE '2013-01-12', 179.4208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1433, 8, DATE '2014-05-06', 540.4309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1434, 1, DATE '2015-03-31', 695.7321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1435, 7, DATE '2015-10-24', 301.2144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1436, 7, DATE '2013-12-23', 523.3275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1437, 6, DATE '2013-10-03', 596.3401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1438, 8, DATE '2013-02-26', 76.0738);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1439, 4, DATE '2014-09-11', 148.5284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1440, 9, DATE '2013-08-23', 257.8730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1441, 3, DATE '2014-12-08', 328.7625);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1442, 10, DATE '2014-06-08', 426.5214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1443, 4, DATE '2013-10-06', 757.8826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1444, 1, DATE '2012-07-21', 579.7473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1445, 5, DATE '2013-10-11', 684.8151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1446, 10, DATE '2011-08-21', 273.2951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1447, 8, DATE '2015-11-04', 196.0240);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1448, 8, DATE '2012-08-08', 934.3853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1449, 2, DATE '2011-04-09', 963.8564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1450, 3, DATE '2013-02-04', 570.4538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1451, 6, DATE '2014-08-08', 867.6064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1452, 4, DATE '2011-03-23', 726.0373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1453, 3, DATE '2012-11-04', 527.7596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1454, 5, DATE '2012-08-30', 251.2754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1455, 6, DATE '2012-03-01', 914.5247);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1456, 4, DATE '2013-11-14', 807.2312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1457, 6, DATE '2014-06-17', 785.8728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1458, 9, DATE '2012-03-07', 621.5918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1459, 4, DATE '2015-11-15', 591.3677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1460, 4, DATE '2015-05-19', 362.2530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1461, 8, DATE '2015-02-10', 930.2226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1462, 4, DATE '2014-06-10', 47.0074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1463, 8, DATE '2014-04-03', 556.1413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1464, 8, DATE '2014-06-17', 666.7327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1465, 10, DATE '2013-12-22', 226.6012);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1466, 9, DATE '2011-09-11', 416.2019);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1467, 7, DATE '2015-09-22', 276.7426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1468, 7, DATE '2011-03-16', 432.4877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1469, 7, DATE '2011-09-10', 600.3866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1470, 7, DATE '2013-07-05', 367.8256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1471, 6, DATE '2013-09-05', 508.7168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1472, 6, DATE '2015-06-29', 245.6648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1473, 10, DATE '2014-08-22', 497.1083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1474, 8, DATE '2012-12-12', 52.1112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1475, 8, DATE '2012-03-16', 762.1141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1476, 8, DATE '2011-07-15', 512.9549);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1477, 1, DATE '2014-11-20', 473.0508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1478, 4, DATE '2014-03-12', 925.3495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1479, 2, DATE '2012-10-26', 592.7857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1480, 8, DATE '2012-12-03', 2.5165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1481, 4, DATE '2013-10-19', 761.3114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1482, 9, DATE '2011-01-27', 166.1808);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1483, 10, DATE '2013-07-22', 117.3093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1484, 8, DATE '2012-08-13', 877.9994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1485, 1, DATE '2013-11-07', 124.3243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1486, 2, DATE '2011-09-18', 134.9643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1487, 5, DATE '2011-03-10', 651.6613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1488, 4, DATE '2012-09-06', 289.1554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1489, 5, DATE '2014-01-29', 781.2075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1490, 3, DATE '2012-12-10', 493.9832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1491, 1, DATE '2015-07-08', 737.4547);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1492, 7, DATE '2012-07-29', 974.7483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1493, 5, DATE '2013-04-14', 484.7061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1494, 10, DATE '2015-04-26', 786.2755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1495, 1, DATE '2014-07-14', 327.6504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1496, 10, DATE '2011-06-30', 281.7550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1497, 3, DATE '2011-03-07', 870.3801);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1498, 7, DATE '2015-04-21', 91.1498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1499, 1, DATE '2014-07-31', 353.1460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1500, 6, DATE '2013-01-31', 268.6132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1501, 4, DATE '2011-11-30', 996.5525);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1502, 1, DATE '2015-08-22', 763.5363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1503, 1, DATE '2011-11-29', 333.9987);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1504, 6, DATE '2013-10-04', 596.0308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1505, 8, DATE '2015-06-02', 61.7370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1506, 1, DATE '2015-02-10', 621.9416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1507, 5, DATE '2012-08-01', 228.9290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1508, 5, DATE '2015-11-24', 475.6483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1509, 7, DATE '2011-06-16', 489.1614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1510, 9, DATE '2011-08-19', 401.5697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1511, 3, DATE '2014-12-26', 334.1804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1512, 3, DATE '2011-04-08', 860.5233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1513, 8, DATE '2015-05-12', 28.8060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1514, 6, DATE '2013-12-12', 588.8512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1515, 1, DATE '2012-07-30', 600.9417);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1516, 9, DATE '2015-01-14', 764.0418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1517, 5, DATE '2011-11-20', 929.6982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1518, 10, DATE '2012-08-20', 678.1420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1519, 8, DATE '2011-08-11', 542.4084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1520, 9, DATE '2013-04-05', 91.6368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1521, 5, DATE '2011-07-05', 764.5407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1522, 3, DATE '2014-01-15', 987.5872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1523, 2, DATE '2013-02-14', 651.2803);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1524, 4, DATE '2014-10-01', 106.4033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1525, 6, DATE '2013-12-29', 630.3709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1526, 10, DATE '2012-02-08', 533.9685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1527, 2, DATE '2013-03-17', 760.9587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1528, 1, DATE '2015-04-29', 710.8328);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1529, 7, DATE '2014-05-31', 724.4609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1530, 9, DATE '2011-09-17', 480.3590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1531, 5, DATE '2011-05-10', 642.5748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1532, 5, DATE '2015-08-01', 381.9009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1533, 3, DATE '2015-08-13', 572.2035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1534, 6, DATE '2015-09-26', 324.1725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1535, 4, DATE '2012-01-04', 5.9640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1536, 3, DATE '2014-02-28', 997.7751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1537, 9, DATE '2015-03-01', 832.1822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1538, 4, DATE '2015-10-18', 521.2786);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1539, 1, DATE '2013-03-14', 816.2623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1540, 10, DATE '2014-09-28', 502.3828);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1541, 8, DATE '2015-02-17', 906.0354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1542, 10, DATE '2011-04-16', 176.0129);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1543, 7, DATE '2012-03-23', 799.9941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1544, 6, DATE '2013-06-13', 379.6377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1545, 1, DATE '2013-12-15', 159.8028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1546, 9, DATE '2015-04-02', 876.9314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1547, 10, DATE '2013-03-19', 945.9423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1548, 9, DATE '2015-05-03', 895.8550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1549, 10, DATE '2013-09-26', 185.3338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1550, 3, DATE '2015-07-01', 563.6087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1551, 5, DATE '2015-08-11', 352.0569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1552, 3, DATE '2014-07-17', 192.2381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1553, 10, DATE '2014-09-11', 548.7415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1554, 3, DATE '2012-04-26', 261.5091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1555, 2, DATE '2012-07-30', 504.0726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1556, 2, DATE '2013-11-14', 8.9653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1557, 9, DATE '2013-07-07', 112.2559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1558, 7, DATE '2013-02-28', 227.5953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1559, 10, DATE '2015-10-07', 965.6599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1560, 8, DATE '2014-04-25', 527.7686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1561, 10, DATE '2012-11-26', 860.9829);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1562, 4, DATE '2013-04-05', 518.0962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1563, 9, DATE '2012-06-26', 751.1875);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1564, 9, DATE '2015-09-30', 8.8023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1565, 4, DATE '2011-04-11', 758.9950);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1566, 9, DATE '2015-05-28', 952.2796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1567, 10, DATE '2011-08-26', 288.3198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1568, 2, DATE '2015-08-16', 704.6336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1569, 2, DATE '2012-12-09', 582.8871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1570, 8, DATE '2014-06-01', 603.1666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1571, 1, DATE '2015-11-16', 931.8597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1572, 1, DATE '2012-02-02', 408.4196);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1573, 10, DATE '2015-06-09', 861.8797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1574, 8, DATE '2012-11-12', 40.0256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1575, 1, DATE '2014-02-17', 185.6015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1576, 5, DATE '2011-03-21', 588.5277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1577, 6, DATE '2012-10-25', 187.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1578, 6, DATE '2015-09-04', 271.6425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1579, 4, DATE '2011-10-17', 946.6006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1580, 8, DATE '2014-09-29', 753.4396);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1581, 10, DATE '2014-11-21', 588.0262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1582, 3, DATE '2013-11-14', 865.1037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1583, 2, DATE '2012-08-02', 525.4990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1584, 5, DATE '2014-12-01', 160.8521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1585, 4, DATE '2012-02-07', 128.3021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1586, 3, DATE '2012-10-24', 450.3366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1587, 6, DATE '2011-11-20', 833.1594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1588, 1, DATE '2014-04-19', 310.6943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1589, 5, DATE '2014-02-27', 820.0999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1590, 3, DATE '2014-02-19', 996.9988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1591, 4, DATE '2011-08-24', 885.5191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1592, 2, DATE '2013-01-01', 604.5868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1593, 5, DATE '2011-01-11', 555.6187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1594, 3, DATE '2014-11-20', 288.4937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1595, 1, DATE '2012-11-02', 641.3999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1596, 4, DATE '2012-11-13', 387.9391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1597, 1, DATE '2014-10-21', 424.8254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1598, 9, DATE '2012-06-23', 791.1918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1599, 3, DATE '2013-03-04', 620.6428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1600, 3, DATE '2014-07-20', 207.5233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1601, 9, DATE '2014-08-07', 588.6116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1602, 8, DATE '2013-08-04', 241.3087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1603, 7, DATE '2013-05-25', 312.9679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1604, 2, DATE '2015-04-27', 582.1672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1605, 3, DATE '2015-08-15', 631.7491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1606, 5, DATE '2014-07-09', 943.6374);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1607, 4, DATE '2015-02-08', 330.3585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1608, 3, DATE '2012-10-30', 508.7159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1609, 2, DATE '2014-03-10', 75.9076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1610, 7, DATE '2012-05-11', 915.5449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1611, 7, DATE '2012-01-21', 821.3723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1612, 3, DATE '2013-11-02', 840.6135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1613, 3, DATE '2012-05-14', 280.9948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1614, 2, DATE '2012-01-09', 212.2203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1615, 9, DATE '2015-06-04', 939.7424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1616, 7, DATE '2015-01-12', 995.8792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1617, 3, DATE '2011-09-04', 992.5973);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1618, 5, DATE '2013-07-26', 590.3354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1619, 6, DATE '2014-08-23', 880.5003);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1620, 1, DATE '2014-06-18', 308.6583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1621, 3, DATE '2014-07-09', 119.1201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1622, 10, DATE '2013-05-09', 977.6255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1623, 8, DATE '2012-06-18', 884.5337);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1624, 10, DATE '2014-10-20', 585.8883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1625, 4, DATE '2013-10-09', 717.6475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1626, 9, DATE '2013-11-15', 327.2728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1627, 6, DATE '2012-01-23', 852.8009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1628, 7, DATE '2011-07-20', 573.3859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1629, 7, DATE '2011-01-11', 398.6257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1630, 8, DATE '2012-04-05', 797.6624);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1631, 5, DATE '2012-05-30', 163.7022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1632, 8, DATE '2011-05-04', 396.4013);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1633, 4, DATE '2013-07-03', 650.9997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1634, 2, DATE '2013-03-29', 739.0773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1635, 9, DATE '2011-02-22', 164.8279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1636, 2, DATE '2012-04-18', 346.7175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1637, 7, DATE '2011-06-23', 552.1358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1638, 10, DATE '2013-04-07', 943.3318);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1639, 2, DATE '2015-04-18', 529.1030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1640, 9, DATE '2013-08-01', 184.6647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1641, 10, DATE '2013-09-15', 119.9781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1642, 3, DATE '2015-01-20', 324.4435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1643, 9, DATE '2011-02-09', 234.7867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1644, 9, DATE '2012-10-18', 904.5550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1645, 7, DATE '2013-01-30', 175.6264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1646, 1, DATE '2013-10-21', 44.9056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1647, 10, DATE '2011-08-20', 323.5920);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1648, 3, DATE '2015-01-03', 343.3984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1649, 5, DATE '2015-06-18', 348.7514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1650, 5, DATE '2013-10-21', 645.5208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1651, 1, DATE '2012-03-12', 395.3419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1652, 7, DATE '2012-03-28', 834.4901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1653, 3, DATE '2013-11-01', 910.6916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1654, 2, DATE '2014-09-16', 311.9845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1655, 10, DATE '2011-01-12', 88.4031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1656, 9, DATE '2012-03-30', 610.9861);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1657, 1, DATE '2012-02-16', 356.7750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1658, 8, DATE '2014-08-05', 727.0796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1659, 8, DATE '2012-07-19', 864.5198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1660, 4, DATE '2012-09-30', 304.4762);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1661, 9, DATE '2013-06-16', 90.8365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1662, 7, DATE '2014-07-22', 756.9727);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1663, 7, DATE '2012-10-19', 110.0902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1664, 5, DATE '2012-12-04', 278.2452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1665, 3, DATE '2015-12-12', 751.8426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1666, 9, DATE '2011-09-19', 424.9710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1667, 10, DATE '2011-05-03', 189.6137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1668, 2, DATE '2015-02-15', 541.9175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1669, 4, DATE '2011-11-17', 47.3923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1670, 7, DATE '2014-02-16', 593.0248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1671, 10, DATE '2014-07-23', 443.7433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1672, 4, DATE '2014-05-29', 49.2654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1673, 3, DATE '2014-04-10', 61.2323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1674, 8, DATE '2012-01-22', 695.8355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1675, 2, DATE '2011-10-04', 188.6802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1676, 10, DATE '2015-06-19', 794.6766);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1677, 2, DATE '2013-03-30', 742.8388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1678, 9, DATE '2015-08-31', 979.9787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1679, 3, DATE '2012-09-19', 410.2618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1680, 4, DATE '2015-12-19', 672.7419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1681, 9, DATE '2013-03-28', 3.6808);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1682, 4, DATE '2013-01-19', 509.4024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1683, 3, DATE '2012-02-02', 224.6344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1684, 2, DATE '2013-03-22', 753.1050);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1685, 7, DATE '2011-01-24', 402.3205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1686, 8, DATE '2011-03-05', 329.2122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1687, 6, DATE '2013-07-03', 485.7097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1688, 2, DATE '2014-10-18', 339.0152);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1689, 3, DATE '2013-03-18', 650.6741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1690, 1, DATE '2014-11-24', 553.8419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1691, 1, DATE '2011-03-04', 989.9425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1692, 10, DATE '2012-11-17', 825.0563);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1693, 3, DATE '2011-09-20', 78.8120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1694, 8, DATE '2013-07-18', 224.6267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1695, 10, DATE '2011-02-15', 93.8282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1696, 3, DATE '2015-02-25', 363.0055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1697, 7, DATE '2013-04-02', 214.3533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1698, 4, DATE '2014-03-07', 956.5415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1699, 6, DATE '2012-11-06', 152.7124);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1700, 8, DATE '2012-05-14', 750.6555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1701, 2, DATE '2013-06-21', 855.2919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1702, 9, DATE '2012-07-04', 781.6745);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1703, 10, DATE '2014-02-16', 296.0060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1704, 8, DATE '2012-05-02', 755.7267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1705, 5, DATE '2015-04-01', 201.7774);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1706, 8, DATE '2013-10-15', 346.0764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1707, 5, DATE '2013-12-19', 773.2578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1708, 5, DATE '2012-10-10', 214.8561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1709, 1, DATE '2013-12-14', 123.3043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1710, 10, DATE '2011-07-26', 293.7266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1711, 8, DATE '2015-01-01', 868.1473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1712, 3, DATE '2012-06-17', 376.7964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1713, 5, DATE '2012-11-16', 316.8177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1714, 5, DATE '2012-08-01', 191.7778);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1715, 6, DATE '2015-07-06', 300.7954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1716, 6, DATE '2011-05-29', 581.4341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1717, 5, DATE '2013-06-20', 532.3382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1718, 5, DATE '2015-07-31', 356.9853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1719, 9, DATE '2012-11-11', 875.9247);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1720, 5, DATE '2015-10-10', 422.6304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1721, 4, DATE '2014-03-19', 939.2613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1722, 8, DATE '2012-07-15', 850.5986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1723, 9, DATE '2012-11-30', 891.2435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1724, 3, DATE '2012-12-23', 493.5505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1725, 6, DATE '2013-12-16', 603.0823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1726, 1, DATE '2012-09-04', 618.6871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1727, 2, DATE '2013-09-09', 970.4535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1728, 5, DATE '2011-09-23', 836.6056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1729, 8, DATE '2011-12-08', 602.0072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1730, 9, DATE '2012-08-08', 825.6748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1731, 4, DATE '2013-03-19', 580.3233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1732, 9, DATE '2015-01-23', 786.2974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1733, 3, DATE '2013-10-24', 827.2663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1734, 5, DATE '2011-05-09', 659.6064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1735, 2, DATE '2013-06-29', 817.4500);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1736, 1, DATE '2011-09-24', 222.0064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1737, 4, DATE '2014-12-03', 213.3963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1738, 5, DATE '2015-10-02', 468.9078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1739, 7, DATE '2013-12-22', 551.3275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1740, 9, DATE '2013-04-11', 56.2441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1741, 4, DATE '2013-03-17', 555.9545);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1742, 1, DATE '2011-09-23', 270.8536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1743, 2, DATE '2011-11-05', 215.7108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1744, 4, DATE '2012-08-23', 356.9475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1745, 3, DATE '2015-11-24', 685.6946);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1746, 9, DATE '2014-09-16', 613.1461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1747, 5, DATE '2011-01-02', 508.2385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1748, 8, DATE '2015-02-18', 887.0342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1749, 3, DATE '2014-01-13', 923.8314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1750, 4, DATE '2015-09-20', 512.3941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1751, 9, DATE '2012-09-06', 830.6673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1752, 3, DATE '2013-09-03', 857.3681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1753, 5, DATE '2012-04-26', 80.6167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1754, 2, DATE '2013-01-28', 730.0820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1755, 5, DATE '2014-02-25', 811.3943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1756, 4, DATE '2011-12-07', 4.6933);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1757, 10, DATE '2015-08-05', 890.4310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1758, 7, DATE '2012-02-25', 802.4556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1759, 2, DATE '2014-05-18', 152.6443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1760, 5, DATE '2013-07-28', 583.0903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1761, 7, DATE '2011-02-06', 375.6229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1762, 10, DATE '2013-03-28', 936.6522);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1763, 8, DATE '2011-11-04', 612.8489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1764, 3, DATE '2012-05-07', 297.6296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1765, 7, DATE '2014-05-09', 713.4033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1766, 9, DATE '2015-12-09', 81.8499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1767, 10, DATE '2014-08-24', 549.5302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1768, 10, DATE '2012-07-10', 657.2114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1769, 3, DATE '2015-02-02', 374.3279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1770, 5, DATE '2014-10-12', 78.7890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1771, 3, DATE '2012-06-25', 368.0378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1772, 1, DATE '2013-09-18', 63.4303);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1773, 9, DATE '2012-08-09', 805.6578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1774, 1, DATE '2015-08-02', 819.6806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1775, 2, DATE '2013-07-25', 866.6760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1776, 4, DATE '2013-06-26', 668.4076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1777, 7, DATE '2011-09-11', 634.8877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1778, 6, DATE '2011-04-09', 534.2960);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1779, 1, DATE '2013-01-30', 807.8559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1780, 8, DATE '2015-04-01', 989.9363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1781, 6, DATE '2012-09-03', 110.4485);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1782, 4, DATE '2014-07-22', 83.4193);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1783, 2, DATE '2013-09-09', 912.7743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1784, 4, DATE '2012-03-19', 89.6131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1785, 10, DATE '2015-12-03', 995.0075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1786, 1, DATE '2015-07-16', 722.9553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1787, 4, DATE '2013-09-29', 705.6806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1788, 2, DATE '2011-09-27', 97.1842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1789, 1, DATE '2013-03-13', 848.2121);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1790, 9, DATE '2012-07-24', 812.7566);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1791, 2, DATE '2012-02-19', 331.5754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1792, 7, DATE '2013-10-09', 410.9407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1793, 3, DATE '2012-05-17', 316.2635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1794, 2, DATE '2011-05-28', 968.2372);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1795, 2, DATE '2013-03-05', 680.6212);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1796, 4, DATE '2015-12-20', 619.3023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1797, 3, DATE '2015-11-20', 658.0048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1798, 9, DATE '2015-07-01', 918.0813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1799, 7, DATE '2014-04-17', 643.5442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1800, 4, DATE '2015-12-17', 603.8447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1801, 10, DATE '2011-01-23', 63.6159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1802, 6, DATE '2014-06-24', 851.0272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1803, 6, DATE '2011-01-17', 512.7063);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1804, 9, DATE '2015-04-03', 845.0423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1805, 2, DATE '2014-03-28', 144.3562);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1806, 9, DATE '2014-12-20', 767.2370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1807, 4, DATE '2012-01-26', 51.7102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1808, 5, DATE '2012-09-24', 260.9361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1809, 10, DATE '2015-07-06', 863.4061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1810, 2, DATE '2011-09-02', 142.9866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1811, 8, DATE '2011-03-29', 369.8057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1812, 4, DATE '2015-04-29', 356.1350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1813, 7, DATE '2015-01-26', 994.5997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1814, 5, DATE '2015-02-16', 162.7081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1815, 9, DATE '2011-11-24', 472.6418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1816, 4, DATE '2012-07-18', 292.2036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1817, 8, DATE '2015-07-20', 23.8779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1818, 4, DATE '2015-08-17', 523.2357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1819, 3, DATE '2012-06-04', 302.6222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1820, 6, DATE '2014-10-24', 990.4481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1821, 6, DATE '2013-03-12', 376.1693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1822, 8, DATE '2013-11-28', 452.3459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1823, 10, DATE '2015-04-29', 808.9993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1824, 5, DATE '2013-07-12', 561.5713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1825, 4, DATE '2013-08-23', 747.2137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1826, 6, DATE '2014-09-16', 957.0971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1827, 8, DATE '2012-05-04', 747.1669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1828, 7, DATE '2012-03-14', 837.4206);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1829, 9, DATE '2013-05-30', 139.0593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1830, 8, DATE '2013-08-06', 247.3736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1831, 1, DATE '2013-08-06', 10.4028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1832, 8, DATE '2012-03-13', 716.8064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1833, 9, DATE '2012-12-22', 890.7519);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1834, 7, DATE '2013-02-13', 204.0112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1835, 8, DATE '2015-03-10', 926.3204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1836, 1, DATE '2014-03-12', 259.4213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1837, 9, DATE '2014-07-05', 570.7131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1838, 4, DATE '2014-06-08', 67.7319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1839, 3, DATE '2013-12-23', 945.2569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1840, 2, DATE '2011-12-15', 227.7705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1841, 8, DATE '2014-06-20', 671.2450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1842, 10, DATE '2012-01-05', 444.7444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1843, 3, DATE '2012-03-23', 233.7782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1844, 10, DATE '2012-07-12', 705.2255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1845, 1, DATE '2012-04-27', 442.9509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1846, 8, DATE '2012-10-23', 975.4404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1847, 1, DATE '2014-09-14', 416.3411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1848, 8, DATE '2013-03-31', 153.5553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1849, 4, DATE '2015-07-04', 495.5954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1850, 9, DATE '2011-08-19', 388.4176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1851, 6, DATE '2011-06-03', 595.4243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1852, 10, DATE '2011-04-05', 134.7690);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1853, 7, DATE '2014-01-26', 615.4591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1854, 2, DATE '2015-06-24', 653.0961);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1855, 9, DATE '2013-10-07', 227.6753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1856, 3, DATE '2013-02-25', 611.2700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1857, 7, DATE '2015-02-25', 42.0279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1858, 1, DATE '2013-07-07', 951.1350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1859, 6, DATE '2012-08-11', 97.8286);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1860, 7, DATE '2015-07-13', 187.2592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1861, 1, DATE '2013-08-17', 20.0700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1862, 8, DATE '2015-11-13', 214.2897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1863, 7, DATE '2015-04-28', 121.8768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1864, 2, DATE '2012-11-30', 616.0324);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1865, 1, DATE '2014-01-26', 132.5838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1866, 10, DATE '2015-01-15', 652.9993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1867, 5, DATE '2013-05-07', 465.3832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1868, 10, DATE '2012-12-12', 790.5884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1869, 8, DATE '2015-12-10', 236.3878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1870, 9, DATE '2013-09-14', 213.2204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1871, 5, DATE '2014-01-13', 721.4905);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1872, 5, DATE '2012-02-11', 956.1461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1873, 1, DATE '2012-08-25', 577.9788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1874, 2, DATE '2011-06-22', 74.8517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1875, 9, DATE '2011-05-06', 319.2031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1876, 6, DATE '2012-03-08', 931.4250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1877, 5, DATE '2012-09-06', 218.5677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1878, 1, DATE '2013-10-18', 103.7738);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1879, 4, DATE '2012-03-16', 118.6204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1880, 6, DATE '2011-11-01', 771.7733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1881, 5, DATE '2011-01-02', 540.7560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1882, 1, DATE '2015-02-03', 593.6115);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1883, 4, DATE '2012-09-11', 341.8252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1884, 10, DATE '2012-10-11', 750.6418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1885, 3, DATE '2013-03-06', 651.9494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1886, 1, DATE '2013-05-04', 875.6338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1887, 2, DATE '2014-02-15', 101.3472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1888, 8, DATE '2013-07-01', 237.6557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1889, 8, DATE '2015-05-10', 976.3360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1890, 5, DATE '2013-01-12', 315.0503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1891, 4, DATE '2015-01-15', 217.3934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1892, 8, DATE '2011-12-29', 619.5781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1893, 8, DATE '2012-10-28', 969.9033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1894, 7, DATE '2014-06-12', 757.9977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1895, 2, DATE '2014-04-29', 207.7004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1896, 10, DATE '2014-08-08', 456.9552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1897, 4, DATE '2012-09-08', 322.8676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1898, 2, DATE '2015-04-24', 617.7458);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1899, 9, DATE '2014-06-16', 572.6416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1900, 2, DATE '2013-04-13', 789.9516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1901, 3, DATE '2015-06-18', 510.0571);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1902, 1, DATE '2012-10-03', 625.7527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1903, 1, DATE '2013-04-22', 917.1676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1904, 5, DATE '2012-10-20', 282.3749);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1905, 4, DATE '2013-08-05', 666.9272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1906, 1, DATE '2015-04-22', 639.2783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1907, 9, DATE '2014-08-10', 556.7902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1908, 5, DATE '2013-08-06', 540.6074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1909, 4, DATE '2015-02-18', 333.8929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1910, 4, DATE '2012-07-31', 296.2503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1911, 8, DATE '2011-06-21', 392.7022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1912, 7, DATE '2012-05-09', 938.2541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1913, 7, DATE '2012-04-23', 832.5146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1914, 10, DATE '2011-10-11', 326.0553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1915, 2, DATE '2015-07-11', 646.5033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1916, 10, DATE '2014-07-14', 426.4585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1917, 4, DATE '2014-03-03', 872.4645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1918, 7, DATE '2013-07-17', 371.2350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1919, 10, DATE '2015-09-27', 964.0831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1920, 1, DATE '2011-09-25', 256.9500);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1921, 9, DATE '2011-12-01', 551.6521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1922, 8, DATE '2015-11-07', 227.7274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1923, 3, DATE '2013-08-04', 814.2524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1924, 3, DATE '2013-11-27', 921.3375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1925, 5, DATE '2014-08-30', 995.8271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1926, 8, DATE '2013-01-15', 101.9123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1927, 8, DATE '2015-04-16', 986.2429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1928, 5, DATE '2014-03-16', 819.9812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1929, 10, DATE '2013-02-23', 867.1513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1930, 9, DATE '2012-09-28', 862.2479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1931, 2, DATE '2015-06-30', 608.5573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1932, 4, DATE '2013-05-16', 600.8219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1933, 3, DATE '2015-05-05', 531.1322);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1934, 3, DATE '2014-12-04', 328.6688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1935, 3, DATE '2012-05-15', 261.7162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1936, 4, DATE '2014-03-31', 915.0033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1937, 1, DATE '2012-10-14', 676.4440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1938, 9, DATE '2015-11-23', 59.4502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1939, 6, DATE '2015-03-09', 83.7146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1940, 2, DATE '2013-11-14', 12.6710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1941, 2, DATE '2014-09-24', 318.8435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1942, 7, DATE '2011-07-12', 560.7399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1943, 5, DATE '2014-05-13', 903.7629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1944, 5, DATE '2013-10-09', 680.0857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1945, 8, DATE '2012-07-25', 922.3482);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1946, 8, DATE '2013-09-08', 279.1393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1947, 1, DATE '2015-09-07', 787.0636);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1948, 8, DATE '2012-01-18', 643.8479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1949, 5, DATE '2014-12-02', 111.4943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1950, 2, DATE '2015-10-16', 781.2419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1951, 6, DATE '2011-06-07', 584.4907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1952, 8, DATE '2015-02-22', 951.6326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1953, 2, DATE '2015-07-28', 653.6628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1954, 8, DATE '2013-09-22', 315.6916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1955, 4, DATE '2012-05-13', 238.2995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1956, 6, DATE '2015-08-12', 282.3296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1957, 9, DATE '2015-03-01', 811.5004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1958, 8, DATE '2015-05-26', 995.8302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1959, 10, DATE '2014-02-21', 286.5479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1960, 7, DATE '2011-07-21', 565.0148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1961, 4, DATE '2011-01-06', 653.0355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1962, 5, DATE '2011-05-28', 736.8091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1963, 6, DATE '2011-06-14', 673.4561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1964, 5, DATE '2013-05-22', 471.6450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1965, 2, DATE '2013-02-01', 687.6930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1966, 5, DATE '2014-02-05', 791.8804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1967, 4, DATE '2013-01-05', 407.1219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1968, 5, DATE '2013-05-20', 503.8458);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1969, 7, DATE '2015-05-29', 64.3391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1970, 8, DATE '2012-04-12', 731.5001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1971, 10, DATE '2012-09-30', 750.0146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1972, 5, DATE '2014-04-11', 813.0143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1973, 1, DATE '2014-05-11', 287.5204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1974, 8, DATE '2012-11-12', 951.4120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1975, 9, DATE '2012-12-31', 938.1065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1976, 2, DATE '2011-05-22', 990.9122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1977, 3, DATE '2012-06-26', 323.9646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1978, 8, DATE '2015-10-26', 134.1667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1979, 6, DATE '2012-05-05', 998.9894);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1980, 7, DATE '2011-12-23', 716.6877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1981, 7, DATE '2013-05-11', 314.8488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1982, 10, DATE '2014-03-30', 342.3949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1983, 1, DATE '2015-04-14', 708.4868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1984, 9, DATE '2013-05-10', 85.9094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1985, 3, DATE '2012-04-24', 277.7572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1986, 5, DATE '2011-05-08', 656.9248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1987, 2, DATE '2013-10-19', 947.1592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1988, 5, DATE '2012-08-13', 215.4406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1989, 10, DATE '2013-07-23', 90.3693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1990, 8, DATE '2012-10-03', 979.3866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1991, 6, DATE '2015-01-31', 103.5029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1992, 3, DATE '2013-05-21', 680.6139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1993, 10, DATE '2012-10-02', 772.9023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1994, 10, DATE '2014-08-19', 518.6999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1995, 8, DATE '2013-11-09', 359.6356);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1996, 8, DATE '2014-04-30', 582.0345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1997, 2, DATE '2011-01-29', 887.2838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1998, 10, DATE '2011-12-22', 432.1179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (1999, 3, DATE '2011-09-08', 992.3927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2000, 3, DATE '2014-06-19', 130.4677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2001, 4, DATE '2011-09-03', 872.0175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2002, 7, DATE '2013-04-19', 283.2178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2003, 1, DATE '2012-08-21', 579.5087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2004, 7, DATE '2013-08-22', 379.9943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2005, 2, DATE '2014-01-16', 31.2272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2006, 1, DATE '2013-02-26', 771.4765);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2007, 7, DATE '2011-10-15', 664.1121);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2008, 4, DATE '2013-09-15', 702.2509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2009, 10, DATE '2011-09-22', 377.5851);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2010, 2, DATE '2011-12-24', 247.3873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2011, 3, DATE '2014-02-15', 958.3651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2012, 1, DATE '2015-05-06', 677.3336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2013, 3, DATE '2014-01-21', 996.8409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2014, 3, DATE '2013-03-01', 569.8603);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2015, 1, DATE '2014-03-12', 250.1659);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2016, 4, DATE '2012-10-09', 310.6405);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2017, 5, DATE '2012-02-14', 28.3222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2018, 7, DATE '2014-02-04', 587.5467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2019, 3, DATE '2012-01-29', 193.8878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2020, 7, DATE '2012-09-26', 30.7682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2021, 3, DATE '2011-04-19', 844.7213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2022, 10, DATE '2011-05-26', 191.6813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2023, 6, DATE '2015-10-29', 413.4764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2024, 10, DATE '2013-08-26', 84.9526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2025, 3, DATE '2013-03-12', 627.9972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2026, 7, DATE '2015-05-12', 69.4007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2027, 6, DATE '2012-07-09', 40.1119);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2028, 2, DATE '2015-09-22', 768.8206);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2029, 1, DATE '2015-01-04', 591.7763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2030, 2, DATE '2014-09-03', 356.0720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2031, 1, DATE '2011-04-23', 103.6284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2032, 4, DATE '2011-07-07', 891.8468);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2033, 6, DATE '2015-02-18', 141.7740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2034, 3, DATE '2013-11-16', 868.5216);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2035, 3, DATE '2011-04-21', 844.6703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2036, 10, DATE '2011-01-22', 31.6310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2037, 9, DATE '2012-08-08', 762.8862);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2038, 4, DATE '2012-08-22', 328.4924);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2039, 7, DATE '2015-04-24', 54.6821);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2040, 2, DATE '2015-02-27', 506.2807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2041, 9, DATE '2015-07-25', 992.8127);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2042, 8, DATE '2011-02-03', 244.9082);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2043, 6, DATE '2011-11-22', 837.8555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2044, 8, DATE '2012-07-30', 842.9820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2045, 5, DATE '2014-08-18', 21.0214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2046, 5, DATE '2015-09-27', 426.1693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2047, 1, DATE '2015-05-01', 683.7730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2048, 7, DATE '2015-08-03', 203.0420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2049, 10, DATE '2011-06-10', 268.5339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2050, 4, DATE '2012-02-01', 48.9951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2051, 4, DATE '2013-03-17', 553.7123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2052, 5, DATE '2012-12-24', 299.7370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2053, 8, DATE '2015-11-23', 238.2300);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2054, 7, DATE '2014-12-13', 961.6244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2055, 10, DATE '2014-03-02', 285.7465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2056, 5, DATE '2011-04-11', 680.3361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2057, 2, DATE '2013-06-22', 869.7414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2058, 2, DATE '2014-12-27', 494.5561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2059, 5, DATE '2011-06-12', 751.9972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2060, 6, DATE '2014-09-06', 961.8266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2061, 6, DATE '2011-08-20', 731.3646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2062, 6, DATE '2012-01-24', 895.2916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2063, 4, DATE '2014-09-12', 110.4745);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2064, 8, DATE '2013-01-19', 21.5131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2065, 2, DATE '2011-09-02', 143.7589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2066, 10, DATE '2013-08-12', 66.5183);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2067, 6, DATE '2011-03-19', 535.5595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2068, 10, DATE '2011-03-07', 128.3192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2069, 1, DATE '2012-11-11', 725.1900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2070, 1, DATE '2014-02-18', 218.5348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2071, 6, DATE '2011-03-03', 547.7543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2072, 1, DATE '2015-06-24', 699.8298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2073, 10, DATE '2014-10-13', 532.8646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2074, 1, DATE '2012-12-02', 687.6071);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2075, 9, DATE '2013-03-05', 37.9556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2076, 5, DATE '2011-03-17', 599.8130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2077, 5, DATE '2015-07-04', 353.8258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2078, 8, DATE '2014-03-31', 570.4945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2079, 6, DATE '2015-01-08', 63.9311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2080, 8, DATE '2013-06-16', 201.8278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2081, 7, DATE '2011-01-11', 385.6277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2082, 10, DATE '2012-12-07', 837.0699);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2083, 3, DATE '2015-04-15', 500.2867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2084, 7, DATE '2013-12-04', 542.7811);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2085, 8, DATE '2012-06-19', 802.3598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2086, 6, DATE '2014-04-30', 803.8914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2087, 6, DATE '2011-08-14', 653.6167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2088, 9, DATE '2011-03-09', 180.1497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2089, 4, DATE '2015-09-16', 582.7750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2090, 9, DATE '2011-01-10', 164.3341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2091, 9, DATE '2013-08-02', 161.8897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2092, 8, DATE '2013-08-12', 268.3301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2093, 10, DATE '2012-03-12', 576.4953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2094, 2, DATE '2011-08-18', 92.8555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2095, 7, DATE '2014-07-10', 774.9162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2096, 4, DATE '2014-07-02', 97.5210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2097, 5, DATE '2012-05-24', 134.4336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2098, 8, DATE '2014-11-02', 816.3424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2099, 7, DATE '2011-11-29', 699.2230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2100, 5, DATE '2012-01-06', 954.5032);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2101, 10, DATE '2015-07-11', 890.6098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2102, 2, DATE '2015-02-25', 555.4538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2103, 7, DATE '2013-09-21', 477.8520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2104, 9, DATE '2013-04-22', 49.9990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2105, 9, DATE '2011-12-01', 501.2408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2106, 3, DATE '2013-09-23', 853.8825);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2107, 6, DATE '2014-03-14', 766.8724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2108, 7, DATE '2013-12-22', 550.6229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2109, 8, DATE '2012-10-09', 923.6688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2110, 5, DATE '2013-12-17', 685.9336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2111, 10, DATE '2011-10-09', 326.5103);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2112, 4, DATE '2015-03-24', 299.2468);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2113, 6, DATE '2015-12-20', 430.6250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2114, 7, DATE '2013-12-27', 550.1693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2115, 9, DATE '2014-08-27', 576.1988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2116, 6, DATE '2014-09-13', 894.2947);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2117, 4, DATE '2012-10-10', 395.0049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2118, 8, DATE '2011-10-10', 567.6935);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2119, 1, DATE '2011-08-03', 219.1534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2120, 6, DATE '2013-05-05', 339.8676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2121, 4, DATE '2012-12-30', 412.9016);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2122, 7, DATE '2011-01-11', 355.4098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2123, 7, DATE '2011-06-22', 545.5443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2124, 2, DATE '2012-11-02', 560.8559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2125, 2, DATE '2011-07-19', 56.6451);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2126, 8, DATE '2013-07-21', 279.4242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2127, 2, DATE '2014-04-13', 123.3345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2128, 9, DATE '2014-02-25', 440.0091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2129, 5, DATE '2014-05-26', 912.6910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2130, 6, DATE '2014-09-04', 940.4346);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2131, 1, DATE '2014-10-23', 465.3793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2132, 8, DATE '2011-09-01', 537.4834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2133, 1, DATE '2013-05-03', 871.2715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2134, 1, DATE '2014-01-02', 109.4279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2135, 9, DATE '2013-12-06', 311.2181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2136, 6, DATE '2011-11-17', 830.1740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2137, 4, DATE '2015-03-18', 359.2179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2138, 4, DATE '2012-12-23', 450.2876);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2139, 8, DATE '2013-01-03', 41.5403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2140, 6, DATE '2014-09-26', 948.4773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2141, 1, DATE '2011-02-16', 37.0189);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2142, 10, DATE '2013-08-23', 102.9938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2143, 2, DATE '2014-05-30', 256.4809);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2144, 9, DATE '2012-09-29', 896.8415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2145, 9, DATE '2015-04-04', 837.8239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2146, 5, DATE '2014-05-12', 862.6429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2147, 3, DATE '2013-08-24', 837.7052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2148, 3, DATE '2014-03-17', 26.3259);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2149, 3, DATE '2012-12-22', 516.6567);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2150, 1, DATE '2015-10-28', 880.6216);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2151, 10, DATE '2012-09-21', 702.5162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2152, 7, DATE '2011-08-15', 566.7402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2153, 8, DATE '2014-04-02', 597.1890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2154, 1, DATE '2014-07-26', 359.3554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2155, 1, DATE '2015-01-07', 541.6016);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2156, 3, DATE '2015-07-01', 535.1999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2157, 5, DATE '2014-09-06', 9.9094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2158, 5, DATE '2011-11-20', 916.9962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2159, 8, DATE '2012-10-04', 993.3540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2160, 2, DATE '2014-05-12', 221.8166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2161, 1, DATE '2015-06-12', 730.5480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2162, 7, DATE '2011-01-17', 326.8633);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2163, 2, DATE '2015-07-29', 637.9319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2164, 3, DATE '2014-02-05', 983.2342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2165, 5, DATE '2015-02-24', 220.5542);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2166, 3, DATE '2011-02-07', 789.0269);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2167, 4, DATE '2012-11-21', 427.9753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2168, 5, DATE '2012-12-17', 321.1970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2169, 8, DATE '2011-01-21', 238.9512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2170, 4, DATE '2013-10-10', 746.0249);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2171, 3, DATE '2015-06-28', 535.0768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2172, 10, DATE '2015-10-19', 944.7174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2173, 10, DATE '2014-10-06', 526.1532);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2174, 5, DATE '2012-11-06', 270.6761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2175, 6, DATE '2013-03-19', 302.8486);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2176, 5, DATE '2015-05-10', 309.9077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2177, 6, DATE '2012-08-13', 98.9288);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2178, 9, DATE '2014-09-22', 648.7029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2179, 4, DATE '2013-08-01', 723.0320);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2180, 7, DATE '2013-03-09', 194.0022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2181, 6, DATE '2015-11-27', 441.7191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2182, 10, DATE '2011-01-28', 97.0085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2183, 6, DATE '2012-03-05', 923.3524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2184, 4, DATE '2014-07-29', 32.0694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2185, 6, DATE '2012-12-14', 237.9183);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2186, 4, DATE '2014-03-11', 898.6391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2187, 1, DATE '2013-06-01', 940.2945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2188, 10, DATE '2014-10-09', 511.9161);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2189, 1, DATE '2014-12-27', 567.8264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2190, 6, DATE '2014-06-07', 776.0182);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2191, 1, DATE '2013-03-13', 820.2645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2192, 9, DATE '2014-04-28', 442.2217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2193, 7, DATE '2011-03-21', 456.9336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2194, 7, DATE '2014-08-25', 819.7237);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2195, 5, DATE '2015-04-17', 217.9292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2196, 4, DATE '2011-01-31', 710.1556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2197, 8, DATE '2014-01-25', 465.0619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2198, 9, DATE '2011-04-25', 273.2468);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2199, 4, DATE '2013-08-06', 676.2872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2200, 7, DATE '2015-02-25', 48.7970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2201, 2, DATE '2012-06-20', 434.6676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2202, 8, DATE '2011-09-08', 516.5081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2203, 5, DATE '2014-02-24', 787.3747);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2204, 10, DATE '2015-03-15', 770.6319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2205, 8, DATE '2011-05-02', 345.5447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2206, 1, DATE '2012-12-03', 757.7989);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2207, 8, DATE '2012-11-09', 40.5870);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2208, 3, DATE '2012-05-26', 326.5128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2209, 5, DATE '2012-05-08', 56.5067);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2210, 7, DATE '2015-08-30', 231.6938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2211, 8, DATE '2013-11-18', 436.2710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2212, 7, DATE '2015-12-16', 361.2066);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2213, 2, DATE '2014-04-21', 193.9642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2214, 1, DATE '2015-07-29', 799.3518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2215, 7, DATE '2014-06-15', 780.0975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2216, 2, DATE '2015-05-16', 633.5394);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2217, 2, DATE '2014-11-13', 403.5110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2218, 8, DATE '2012-01-01', 605.8625);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2219, 8, DATE '2012-02-22', 745.3159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2220, 1, DATE '2011-12-17', 321.9151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2221, 3, DATE '2013-09-08', 848.7325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2222, 4, DATE '2014-02-13', 916.0593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2223, 5, DATE '2013-12-21', 753.3707);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2224, 2, DATE '2012-08-16', 462.9331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2225, 4, DATE '2011-07-31', 925.7604);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2226, 4, DATE '2012-03-02', 92.8550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2227, 4, DATE '2015-07-31', 487.7837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2228, 4, DATE '2011-02-12', 706.4295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2229, 10, DATE '2013-07-23', 52.7469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2230, 3, DATE '2013-02-17', 592.6930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2231, 7, DATE '2012-04-14', 844.8459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2232, 7, DATE '2012-04-20', 825.6821);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2233, 5, DATE '2012-02-16', 972.4158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2234, 7, DATE '2014-06-06', 674.2349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2235, 6, DATE '2011-09-19', 759.3347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2236, 8, DATE '2015-03-22', 925.2110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2237, 5, DATE '2012-12-04', 309.6339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2238, 7, DATE '2012-12-22', 152.7204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2239, 7, DATE '2014-03-29', 686.5247);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2240, 6, DATE '2011-01-11', 480.1195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2241, 7, DATE '2012-05-01', 858.0521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2242, 8, DATE '2012-01-06', 613.7816);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2243, 6, DATE '2013-06-02', 455.4094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2244, 4, DATE '2015-04-29', 336.1325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2245, 9, DATE '2011-07-21', 339.7471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2246, 5, DATE '2013-03-29', 459.0578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2247, 8, DATE '2011-01-07', 248.2575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2248, 7, DATE '2011-08-24', 657.5819);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2249, 1, DATE '2011-03-12', 39.6262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2250, 4, DATE '2015-12-03', 584.3898);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2251, 2, DATE '2012-03-19', 306.6446);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2252, 10, DATE '2013-01-25', 859.1995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2253, 2, DATE '2015-03-03', 527.9310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2254, 4, DATE '2012-08-20', 354.3720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2255, 4, DATE '2012-06-18', 200.0646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2256, 9, DATE '2014-05-08', 518.6084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2257, 4, DATE '2013-09-17', 763.1375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2258, 3, DATE '2012-07-11', 324.4416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2259, 7, DATE '2014-08-16', 844.8715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2260, 5, DATE '2015-03-02', 252.6897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2261, 7, DATE '2013-05-06', 270.0151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2262, 4, DATE '2012-09-28', 334.1576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2263, 3, DATE '2014-11-03', 273.7659);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2264, 3, DATE '2015-03-22', 463.8137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2265, 10, DATE '2014-05-17', 386.8479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2266, 1, DATE '2012-07-30', 610.5890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2267, 2, DATE '2014-10-30', 388.7909);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2268, 5, DATE '2015-11-15', 519.7293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2269, 6, DATE '2014-11-10', 40.0170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2270, 9, DATE '2015-03-27', 854.8865);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2271, 7, DATE '2013-06-11', 323.9055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2272, 6, DATE '2012-11-21', 250.7906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2273, 2, DATE '2013-10-04', 919.3378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2274, 2, DATE '2012-02-12', 265.1963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2275, 4, DATE '2015-08-17', 463.8631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2276, 5, DATE '2012-09-03', 234.9508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2277, 9, DATE '2011-09-13', 460.6498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2278, 1, DATE '2014-08-24', 417.2381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2279, 4, DATE '2012-01-28', 123.1859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2280, 9, DATE '2014-05-03', 466.7026);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2281, 7, DATE '2012-02-24', 844.5976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2282, 8, DATE '2014-12-07', 830.2019);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2283, 4, DATE '2015-12-03', 666.8033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2284, 6, DATE '2013-08-21', 468.3571);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2285, 1, DATE '2011-12-02', 286.0484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2286, 8, DATE '2015-03-21', 985.6465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2287, 6, DATE '2013-02-18', 297.7511);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2288, 2, DATE '2015-06-29', 618.0437);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2289, 4, DATE '2012-12-19', 474.1703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2290, 8, DATE '2013-05-13', 240.7263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2291, 5, DATE '2012-07-04', 162.0735);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2292, 2, DATE '2011-05-27', 985.1923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2293, 1, DATE '2014-05-09', 307.8490);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2294, 2, DATE '2015-01-28', 433.8350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2295, 9, DATE '2013-09-07', 210.1043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2296, 4, DATE '2015-08-04', 523.8945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2297, 6, DATE '2013-03-04', 340.0156);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2298, 3, DATE '2014-03-14', 991.5957);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2299, 5, DATE '2011-12-14', 949.2846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2300, 9, DATE '2014-12-21', 729.1582);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2301, 3, DATE '2014-05-31', 70.2669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2302, 4, DATE '2011-02-23', 728.5282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2303, 1, DATE '2012-10-14', 617.5648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2304, 2, DATE '2011-12-17', 184.7397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2305, 8, DATE '2013-06-23', 260.4843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2306, 7, DATE '2015-04-28', 55.8540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2307, 8, DATE '2015-04-23', 939.8617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2308, 10, DATE '2014-01-20', 262.7346);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2309, 10, DATE '2013-01-03', 890.5089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2310, 10, DATE '2015-10-16', 965.1138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2311, 1, DATE '2013-08-26', 57.9585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2312, 3, DATE '2015-01-24', 345.8994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2313, 10, DATE '2011-06-14', 201.2557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2314, 8, DATE '2011-04-15', 378.1689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2315, 8, DATE '2014-01-07', 408.0921);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2316, 10, DATE '2014-05-30', 439.8133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2317, 1, DATE '2012-10-26', 667.3543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2318, 7, DATE '2012-03-15', 805.4089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2319, 2, DATE '2014-04-20', 177.7652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2320, 3, DATE '2015-02-26', 401.2015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2321, 5, DATE '2015-06-12', 312.8378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2322, 10, DATE '2015-05-04', 770.7472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2323, 2, DATE '2013-11-27', 45.5589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2324, 8, DATE '2012-06-29', 799.2907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2325, 4, DATE '2013-09-22', 692.8130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2326, 5, DATE '2013-01-16', 338.7133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2327, 5, DATE '2014-07-15', 942.9416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2328, 10, DATE '2014-09-06', 485.5028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2329, 4, DATE '2014-06-06', 55.0920);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2330, 1, DATE '2011-01-14', 939.9686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2331, 10, DATE '2015-07-03', 894.9352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2332, 6, DATE '2013-07-02', 469.0542);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2333, 7, DATE '2013-09-11', 467.9535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2334, 5, DATE '2013-02-06', 394.0278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2335, 6, DATE '2015-12-04', 396.4356);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2336, 3, DATE '2012-01-02', 116.0694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2337, 7, DATE '2013-02-23', 212.6370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2338, 2, DATE '2014-12-18', 482.0635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2339, 9, DATE '2011-03-01', 207.8728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2340, 5, DATE '2012-08-05', 230.1944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2341, 10, DATE '2015-11-28', 45.7848);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2342, 6, DATE '2015-01-29', 35.0165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2343, 3, DATE '2013-06-25', 727.5349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2344, 4, DATE '2013-03-06', 509.0565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2345, 8, DATE '2015-09-18', 182.7678);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2346, 2, DATE '2013-06-11', 816.1741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2347, 2, DATE '2015-12-13', 783.9366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2348, 3, DATE '2014-01-25', 929.6801);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2349, 4, DATE '2012-01-22', 25.7428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2350, 10, DATE '2015-04-10', 770.2910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2351, 3, DATE '2013-10-09', 856.5402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2352, 9, DATE '2011-12-21', 534.6068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2353, 2, DATE '2015-11-24', 813.8304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2354, 2, DATE '2012-10-17', 548.0831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2355, 4, DATE '2015-07-12', 416.3203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2356, 4, DATE '2015-01-27', 299.5197);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2357, 3, DATE '2013-03-28', 682.9692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2358, 3, DATE '2011-04-17', 818.2742);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2359, 9, DATE '2014-03-27', 491.9267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2360, 3, DATE '2011-06-07', 921.7711);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2361, 3, DATE '2011-10-14', 112.9124);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2362, 8, DATE '2011-08-18', 454.3589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2363, 7, DATE '2015-08-16', 207.6425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2364, 9, DATE '2012-12-21', 950.5403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2365, 1, DATE '2011-04-16', 70.1785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2366, 5, DATE '2011-02-24', 588.9043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2367, 7, DATE '2012-05-14', 877.9459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2368, 6, DATE '2014-05-08', 807.2280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2369, 2, DATE '2011-05-13', 981.7333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2370, 6, DATE '2013-01-06', 292.0227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2371, 3, DATE '2012-04-06', 227.1763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2372, 10, DATE '2013-11-09', 185.2908);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2373, 9, DATE '2012-01-15', 597.5360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2374, 8, DATE '2012-09-14', 947.5708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2375, 4, DATE '2015-04-01', 355.4166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2376, 9, DATE '2011-05-15', 277.8213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2377, 7, DATE '2012-11-09', 43.2123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2378, 8, DATE '2011-09-24', 536.5024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2379, 1, DATE '2012-10-12', 616.5229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2380, 3, DATE '2011-04-14', 876.6390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2381, 3, DATE '2013-02-04', 554.7767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2382, 2, DATE '2011-06-21', 13.2615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2383, 6, DATE '2013-08-16', 459.7599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2384, 4, DATE '2015-02-27', 284.8010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2385, 9, DATE '2013-04-06', 83.4284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2386, 1, DATE '2014-07-14', 360.3284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2387, 4, DATE '2013-08-09', 655.2238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2388, 5, DATE '2011-11-26', 919.8705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2389, 1, DATE '2013-07-28', 977.7075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2390, 3, DATE '2011-11-07', 96.9159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2391, 1, DATE '2014-10-06', 433.1002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2392, 4, DATE '2012-11-08', 394.3629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2393, 4, DATE '2011-09-23', 990.1369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2394, 7, DATE '2015-09-24', 286.1018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2395, 3, DATE '2011-10-24', 117.2820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2396, 2, DATE '2015-04-13', 591.4260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2397, 10, DATE '2015-06-15', 827.3740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2398, 5, DATE '2011-07-05', 776.9946);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2399, 4, DATE '2012-11-21', 438.8780);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2400, 3, DATE '2015-07-25', 593.8636);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2401, 5, DATE '2012-01-28', 938.2283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2402, 7, DATE '2012-08-06', 976.7087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2403, 2, DATE '2013-09-15', 947.9468);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2404, 9, DATE '2015-01-15', 733.7202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2405, 7, DATE '2014-01-04', 543.1147);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2406, 3, DATE '2015-12-01', 671.2494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2407, 1, DATE '2015-12-06', 937.0708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2408, 5, DATE '2014-03-11', 866.2596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2409, 9, DATE '2013-07-19', 192.6664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2410, 6, DATE '2015-02-28', 138.4990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2411, 7, DATE '2013-03-20', 256.3074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2412, 5, DATE '2012-07-04', 146.4667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2413, 3, DATE '2014-07-06', 201.7512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2414, 6, DATE '2013-12-14', 615.2878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2415, 10, DATE '2014-05-03', 366.9943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2416, 1, DATE '2011-04-25', 99.6508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2417, 3, DATE '2014-01-01', 994.5990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2418, 3, DATE '2011-06-20', 922.8415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2419, 1, DATE '2015-09-16', 867.1119);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2420, 10, DATE '2012-10-02', 709.8502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2421, 1, DATE '2013-07-18', 933.6805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2422, 3, DATE '2011-06-20', 958.0754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2423, 5, DATE '2011-10-12', 829.5205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2424, 10, DATE '2015-07-06', 884.8174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2425, 5, DATE '2014-04-02', 858.9226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2426, 10, DATE '2015-05-29', 832.8134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2427, 7, DATE '2013-02-16', 195.1539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2428, 3, DATE '2012-04-23', 311.4342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2429, 6, DATE '2011-11-23', 830.2887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2430, 3, DATE '2015-12-19', 763.9907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2431, 10, DATE '2011-11-30', 450.4473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2432, 3, DATE '2012-05-07', 266.2178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2433, 5, DATE '2014-11-03', 97.6244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2434, 9, DATE '2013-03-20', 22.6593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2435, 8, DATE '2015-03-17', 938.4107);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2436, 7, DATE '2011-07-02', 578.0681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2437, 1, DATE '2013-10-06', 65.3147);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2438, 8, DATE '2014-08-02', 726.0397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2439, 8, DATE '2012-02-24', 741.6864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2440, 6, DATE '2013-05-07', 412.1791);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2441, 1, DATE '2014-08-08', 423.2576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2442, 10, DATE '2015-05-31', 788.9643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2443, 7, DATE '2014-05-10', 727.2041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2444, 6, DATE '2014-05-31', 839.2085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2445, 7, DATE '2014-08-19', 840.6086);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2446, 7, DATE '2013-04-04', 286.6334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2447, 2, DATE '2014-05-05', 192.6116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2448, 8, DATE '2013-10-10', 374.8490);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2449, 7, DATE '2012-05-24', 919.1075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2450, 2, DATE '2011-07-01', 17.6312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2451, 10, DATE '2012-04-12', 596.8270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2452, 7, DATE '2014-12-27', 904.5325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2453, 5, DATE '2011-10-20', 909.8827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2454, 4, DATE '2011-02-19', 729.0278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2455, 2, DATE '2013-01-07', 660.1831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2456, 3, DATE '2011-08-10', 980.1530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2457, 2, DATE '2011-10-27', 147.1881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2458, 3, DATE '2014-03-12', 63.1294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2459, 5, DATE '2011-10-16', 874.7977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2460, 8, DATE '2014-08-08', 710.3013);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2461, 7, DATE '2013-10-14', 476.0954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2462, 9, DATE '2014-08-15', 625.6365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2463, 9, DATE '2013-04-19', 35.9708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2464, 7, DATE '2013-08-01', 428.6757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2465, 7, DATE '2014-03-31', 688.0517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2466, 4, DATE '2011-11-14', 990.0896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2467, 1, DATE '2013-09-01', 48.8423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2468, 4, DATE '2012-04-18', 179.0919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2469, 9, DATE '2014-09-29', 676.8772);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2470, 4, DATE '2013-11-01', 788.9262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2471, 10, DATE '2013-07-20', 34.3360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2472, 5, DATE '2015-06-02', 268.5593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2473, 6, DATE '2015-04-26', 181.1551);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2474, 5, DATE '2013-05-11', 454.9328);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2475, 10, DATE '2014-02-25', 286.5926);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2476, 2, DATE '2014-02-18', 144.7162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2477, 7, DATE '2013-02-10', 230.8713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2478, 10, DATE '2013-05-13', 990.3120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2479, 4, DATE '2011-11-18', 44.2088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2480, 9, DATE '2011-12-30', 572.2892);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2481, 8, DATE '2012-01-24', 640.2017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2482, 10, DATE '2015-05-09', 820.3049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2483, 6, DATE '2015-11-30', 392.3268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2484, 4, DATE '2011-05-25', 812.6575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2485, 4, DATE '2014-09-07', 167.1637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2486, 3, DATE '2012-12-04', 545.9148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2487, 9, DATE '2011-07-20', 356.3351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2488, 2, DATE '2014-09-15', 368.5967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2489, 8, DATE '2011-03-14', 362.4762);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2490, 5, DATE '2014-08-07', 958.2578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2491, 5, DATE '2015-09-05', 430.8800);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2492, 9, DATE '2015-07-28', 2.1853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2493, 3, DATE '2013-10-17', 851.2421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2494, 10, DATE '2013-07-18', 31.3850);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2495, 9, DATE '2015-07-25', 936.0837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2496, 2, DATE '2015-12-25', 797.6211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2497, 1, DATE '2013-02-10', 752.9934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2498, 1, DATE '2011-10-10', 298.5283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2499, 10, DATE '2011-03-02', 151.1568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2500, 3, DATE '2013-10-06', 850.5190);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2501, 6, DATE '2015-08-04', 237.7910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2502, 9, DATE '2013-01-17', 13.5197);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2503, 10, DATE '2015-01-12', 697.9719);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2504, 3, DATE '2014-07-23', 130.1813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2505, 2, DATE '2013-12-11', 983.2952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2506, 5, DATE '2012-11-11', 328.2676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2507, 2, DATE '2015-09-02', 723.3774);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2508, 10, DATE '2014-06-10', 454.9499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2509, 4, DATE '2012-12-25', 442.4352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2510, 1, DATE '2014-11-20', 515.4669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2511, 7, DATE '2014-06-30', 749.2816);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2512, 3, DATE '2014-06-15', 156.8761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2513, 10, DATE '2013-04-25', 18.9205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2514, 7, DATE '2015-10-18', 302.5085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2515, 10, DATE '2013-07-15', 70.0995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2516, 8, DATE '2014-06-08', 655.7905);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2517, 3, DATE '2014-09-15', 233.3097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2518, 6, DATE '2012-11-25', 223.3134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2519, 3, DATE '2014-11-24', 261.5119);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2520, 4, DATE '2012-04-27', 142.1368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2521, 5, DATE '2011-04-28', 633.7545);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2522, 10, DATE '2014-12-17', 680.2457);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2523, 7, DATE '2012-02-06', 816.6158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2524, 4, DATE '2011-02-22', 718.6194);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2525, 10, DATE '2014-02-27', 358.0462);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2526, 2, DATE '2013-12-24', 32.1506);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2527, 3, DATE '2012-08-15', 417.3172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2528, 6, DATE '2012-10-08', 149.7701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2529, 7, DATE '2013-10-18', 518.8491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2530, 8, DATE '2014-03-03', 488.9715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2531, 1, DATE '2012-01-08', 391.7229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2532, 7, DATE '2012-05-04', 932.3431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2533, 1, DATE '2013-03-13', 839.1552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2534, 1, DATE '2014-02-12', 193.6898);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2535, 3, DATE '2012-05-28', 334.4981);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2536, 10, DATE '2015-01-07', 626.6820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2537, 1, DATE '2011-04-28', 122.3329);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2538, 3, DATE '2012-05-09', 262.1454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2539, 2, DATE '2013-06-13', 829.3623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2540, 9, DATE '2012-10-27', 838.8961);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2541, 1, DATE '2013-04-04', 822.5375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2542, 10, DATE '2013-02-08', 901.3853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2543, 8, DATE '2012-09-21', 926.1615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2544, 7, DATE '2012-04-24', 847.0093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2545, 9, DATE '2011-02-08', 208.9761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2546, 3, DATE '2012-03-23', 274.0038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2547, 10, DATE '2013-04-03', 983.2649);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2548, 7, DATE '2013-12-31', 548.7336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2549, 1, DATE '2011-01-04', 961.2855);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2550, 2, DATE '2012-02-16', 280.2932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2551, 10, DATE '2012-04-11', 564.3113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2552, 6, DATE '2011-03-19', 529.6799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2553, 8, DATE '2012-11-15', 37.0163);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2554, 6, DATE '2014-11-05', 9.0200);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2555, 8, DATE '2013-06-11', 216.7645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2556, 7, DATE '2011-08-18', 557.5454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2557, 2, DATE '2011-12-13', 196.9040);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2558, 6, DATE '2014-11-20', 979.3526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2559, 4, DATE '2011-05-27', 772.1351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2560, 1, DATE '2015-12-19', 951.1446);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2561, 2, DATE '2011-03-29', 910.9505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2562, 6, DATE '2013-11-24', 573.6073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2563, 4, DATE '2011-08-23', 936.1008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2564, 6, DATE '2014-10-24', 953.4637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2565, 1, DATE '2013-11-12', 123.7440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2566, 1, DATE '2013-02-26', 816.9386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2567, 2, DATE '2012-04-03', 317.7210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2568, 9, DATE '2015-03-14', 825.2308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2569, 4, DATE '2014-05-23', 968.0104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2570, 10, DATE '2014-07-09', 443.4176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2571, 8, DATE '2014-02-11', 533.4575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2572, 10, DATE '2013-05-09', 971.1643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2573, 4, DATE '2015-06-14', 393.9511);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2574, 5, DATE '2013-01-28', 422.6159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2575, 4, DATE '2015-01-23', 319.5993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2576, 6, DATE '2014-03-19', 732.3692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2577, 2, DATE '2013-03-28', 754.0842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2578, 10, DATE '2015-10-15', 969.6065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2579, 6, DATE '2011-01-14', 509.6433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2580, 7, DATE '2012-12-06', 84.0423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2581, 3, DATE '2011-09-22', 48.8858);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2582, 6, DATE '2014-08-16', 868.5836);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2583, 6, DATE '2012-10-05', 188.4846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2584, 5, DATE '2012-09-01', 238.5559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2585, 9, DATE '2012-11-22', 924.6603);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2586, 5, DATE '2011-10-22', 862.0430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2587, 9, DATE '2015-06-19', 895.3267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2588, 6, DATE '2014-05-09', 830.1352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2589, 3, DATE '2011-09-04', 976.9254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2590, 6, DATE '2011-10-11', 776.9527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2591, 8, DATE '2014-01-25', 429.7780);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2592, 5, DATE '2012-06-07', 142.9804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2593, 9, DATE '2011-12-14', 490.0104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2594, 2, DATE '2013-06-26', 878.2178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2595, 8, DATE '2012-07-31', 927.9457);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2596, 5, DATE '2015-05-11', 248.9302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2597, 7, DATE '2012-06-19', 965.2845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2598, 2, DATE '2013-11-28', 972.6979);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2599, 7, DATE '2014-06-12', 723.2653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2600, 8, DATE '2013-12-13', 392.0376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2601, 1, DATE '2015-12-20', 956.2828);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2602, 1, DATE '2014-01-21', 158.0340);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2603, 3, DATE '2015-08-11', 580.7232);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2604, 1, DATE '2012-06-27', 517.8679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2605, 5, DATE '2014-01-05', 746.8357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2606, 10, DATE '2014-12-03', 593.1470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2607, 2, DATE '2011-10-05', 135.7288);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2608, 4, DATE '2015-10-19', 614.4005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2609, 3, DATE '2015-10-13', 689.4207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2610, 3, DATE '2015-03-25', 484.3953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2611, 6, DATE '2014-05-23', 803.4613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2612, 3, DATE '2012-02-29', 227.2975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2613, 1, DATE '2014-11-06', 469.7092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2614, 7, DATE '2014-06-20', 688.0927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2615, 8, DATE '2015-03-29', 902.2587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2616, 7, DATE '2012-08-13', 42.3668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2617, 1, DATE '2012-02-20', 385.1226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2618, 9, DATE '2014-12-21', 697.5448);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2619, 8, DATE '2012-12-02', 28.8034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2620, 6, DATE '2013-01-21', 261.7011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2621, 2, DATE '2013-09-09', 921.6119);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2622, 7, DATE '2013-11-26', 487.5859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2623, 6, DATE '2014-07-10', 848.3054);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2624, 9, DATE '2013-08-12', 191.0577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2625, 2, DATE '2011-06-14', 13.6395);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2626, 3, DATE '2012-09-06', 390.4770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2627, 1, DATE '2012-05-26', 481.1539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2628, 3, DATE '2012-12-19', 515.7334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2629, 8, DATE '2011-07-01', 494.6702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2630, 9, DATE '2015-09-15', 70.6691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2631, 10, DATE '2012-09-30', 767.0847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2632, 10, DATE '2015-04-30', 781.3864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2633, 3, DATE '2012-05-04', 246.3411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2634, 8, DATE '2013-02-01', 117.6056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2635, 7, DATE '2012-12-18', 127.7596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2636, 2, DATE '2013-08-31', 890.8518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2637, 4, DATE '2015-01-06', 287.8603);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2638, 5, DATE '2011-04-10', 670.6168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2639, 10, DATE '2014-08-28', 491.7203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2640, 9, DATE '2013-12-20', 331.5132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2641, 3, DATE '2011-01-18', 726.3142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2642, 6, DATE '2015-09-01', 280.9262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2643, 3, DATE '2014-07-27', 140.7145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2644, 1, DATE '2012-06-11', 492.5300);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2645, 10, DATE '2013-05-20', 973.4915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2646, 6, DATE '2012-11-27', 202.4804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2647, 4, DATE '2013-08-01', 673.2713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2648, 2, DATE '2013-06-26', 801.9177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2649, 4, DATE '2014-03-30', 975.9592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2650, 1, DATE '2015-12-18', 885.5788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2651, 5, DATE '2014-03-22', 863.8077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2652, 8, DATE '2013-06-29', 267.7397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2653, 5, DATE '2011-12-28', 943.8945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2654, 1, DATE '2012-05-21', 461.5642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2655, 7, DATE '2011-04-05', 470.4257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2656, 4, DATE '2013-01-23', 468.6969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2657, 6, DATE '2015-07-14', 309.7287);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2658, 5, DATE '2012-12-29', 389.6655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2659, 10, DATE '2012-01-14', 504.2283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2660, 2, DATE '2012-05-01', 356.3587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2661, 9, DATE '2013-07-10', 111.9931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2662, 9, DATE '2014-10-17', 619.9955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2663, 7, DATE '2015-04-20', 119.7302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2664, 5, DATE '2011-01-29', 618.7515);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2665, 3, DATE '2013-06-25', 717.3106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2666, 7, DATE '2015-01-24', 22.0749);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2667, 10, DATE '2015-10-27', 980.9565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2668, 4, DATE '2012-10-05', 352.1036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2669, 1, DATE '2012-07-03', 560.3331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2670, 7, DATE '2012-07-28', 11.4068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2671, 3, DATE '2013-08-08', 754.5065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2672, 7, DATE '2011-11-12', 714.5058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2673, 10, DATE '2011-04-26', 205.8245);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2674, 9, DATE '2014-12-14', 697.2902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2675, 3, DATE '2013-01-04', 535.3870);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2676, 6, DATE '2014-01-08', 640.6857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2677, 4, DATE '2015-05-03', 346.8713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2678, 5, DATE '2013-01-29', 355.7753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2679, 9, DATE '2011-03-26', 217.5663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2680, 7, DATE '2014-07-18', 811.1591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2681, 10, DATE '2015-02-05', 717.2058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2682, 9, DATE '2014-12-01', 679.2363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2683, 10, DATE '2014-09-21', 539.7743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2684, 7, DATE '2011-07-14', 609.0915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2685, 4, DATE '2012-06-26', 206.8615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2686, 3, DATE '2015-04-03', 499.3450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2687, 5, DATE '2014-05-04', 837.4919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2688, 2, DATE '2015-12-15', 784.7769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2689, 1, DATE '2012-10-29', 647.1800);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2690, 4, DATE '2015-11-25', 659.0627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2691, 7, DATE '2014-02-17', 581.1231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2692, 10, DATE '2013-01-07', 898.1949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2693, 6, DATE '2015-03-27', 166.3884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2694, 8, DATE '2013-04-29', 135.3616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2695, 10, DATE '2011-06-12', 219.5201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2696, 4, DATE '2012-04-02', 106.3186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2697, 10, DATE '2011-05-14', 161.1959);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2698, 9, DATE '2014-06-29', 521.9630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2699, 9, DATE '2014-12-17', 775.2195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2700, 4, DATE '2014-04-27', 951.4165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2701, 7, DATE '2013-02-01', 221.5240);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2702, 1, DATE '2011-10-27', 321.1677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2703, 2, DATE '2011-12-25', 241.5845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2704, 8, DATE '2012-09-01', 964.5523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2705, 9, DATE '2013-05-12', 131.0722);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2706, 8, DATE '2013-05-11', 149.3018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2707, 9, DATE '2013-03-05', 61.9151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2708, 6, DATE '2013-01-13', 246.6042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2709, 9, DATE '2015-05-17', 926.1773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2710, 1, DATE '2013-03-27', 829.7401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2711, 10, DATE '2013-09-23', 121.8255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2712, 1, DATE '2013-06-15', 953.9534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2713, 6, DATE '2012-10-06', 172.0991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2714, 4, DATE '2013-06-29', 693.0693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2715, 3, DATE '2013-03-26', 639.1529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2716, 1, DATE '2014-08-10', 432.7568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2717, 10, DATE '2011-01-27', 80.2212);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2718, 10, DATE '2014-10-08', 510.6388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2719, 1, DATE '2014-08-05', 411.8900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2720, 1, DATE '2014-03-24', 217.9656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2721, 2, DATE '2011-09-22', 184.5830);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2722, 8, DATE '2015-11-13', 196.1795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2723, 3, DATE '2015-12-07', 704.9236);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2724, 8, DATE '2012-08-08', 901.2705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2725, 10, DATE '2014-06-11', 430.2838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2726, 4, DATE '2011-08-01', 856.3116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2727, 2, DATE '2012-08-17', 548.1173);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2728, 2, DATE '2013-12-28', 70.4629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2729, 10, DATE '2014-07-04', 477.7701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2730, 9, DATE '2011-10-05', 429.0683);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2731, 6, DATE '2013-08-28', 479.4897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2732, 6, DATE '2011-11-05', 824.9084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2733, 7, DATE '2014-02-13', 580.5559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2734, 5, DATE '2012-11-28', 266.1498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2735, 10, DATE '2012-06-16', 589.6351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2736, 10, DATE '2014-04-12', 396.0381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2737, 8, DATE '2013-12-08', 437.6518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2738, 3, DATE '2013-01-19', 575.2220);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2739, 8, DATE '2014-03-04', 478.0192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2740, 6, DATE '2015-02-15', 57.5597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2741, 4, DATE '2013-01-29', 437.4298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2742, 10, DATE '2012-04-20', 590.8877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2743, 4, DATE '2011-07-31', 858.5997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2744, 1, DATE '2015-08-04', 817.4399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2745, 4, DATE '2013-03-03', 537.2371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2746, 7, DATE '2011-09-05', 627.1697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2747, 4, DATE '2011-04-04', 726.0958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2748, 3, DATE '2012-09-28', 473.3192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2749, 6, DATE '2011-02-03', 496.2087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2750, 10, DATE '2012-11-02', 786.7633);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2751, 5, DATE '2012-03-07', 26.0974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2752, 10, DATE '2012-08-06', 650.5572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2753, 9, DATE '2015-11-24', 110.0729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2754, 8, DATE '2011-09-25', 557.2539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2755, 3, DATE '2013-08-05', 766.8335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2756, 9, DATE '2013-03-22', 25.3444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2757, 8, DATE '2011-11-20', 616.2441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2758, 5, DATE '2015-05-18', 340.3140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2759, 8, DATE '2014-03-24', 534.2684);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2760, 5, DATE '2012-10-11', 274.7606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2761, 7, DATE '2011-09-24', 601.1845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2762, 7, DATE '2015-03-09', 991.4523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2763, 7, DATE '2014-07-13', 768.8341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2764, 10, DATE '2014-08-13', 497.1090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2765, 5, DATE '2015-07-31', 350.2503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2766, 5, DATE '2012-11-19', 296.9172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2767, 4, DATE '2015-05-03', 373.3975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2768, 1, DATE '2015-11-08', 905.9494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2769, 4, DATE '2012-01-14', 103.4341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2770, 4, DATE '2014-12-15', 243.1148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2771, 3, DATE '2011-09-03', 995.1051);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2772, 8, DATE '2014-01-07', 504.9992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2773, 3, DATE '2011-08-06', 32.6195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2774, 5, DATE '2015-06-20', 354.3303);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2775, 7, DATE '2012-02-24', 780.5358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2776, 2, DATE '2015-06-04', 593.6954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2777, 4, DATE '2015-04-15', 337.5799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2778, 3, DATE '2011-05-05', 887.4837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2779, 5, DATE '2015-06-07', 364.0334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2780, 4, DATE '2013-10-06', 803.1141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2781, 1, DATE '2011-04-30', 130.2158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2782, 9, DATE '2015-11-19', 74.7980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2783, 6, DATE '2013-11-24', 574.2543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2784, 10, DATE '2012-08-31', 691.0069);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2785, 5, DATE '2015-07-30', 402.9708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2786, 6, DATE '2012-01-22', 828.9325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2787, 7, DATE '2011-12-12', 714.8354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2788, 10, DATE '2013-05-21', 23.3020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2789, 3, DATE '2015-04-25', 499.3164);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2790, 2, DATE '2015-03-28', 564.2906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2791, 2, DATE '2013-05-23', 779.7941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2792, 4, DATE '2014-07-23', 97.3377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2793, 5, DATE '2014-10-28', 40.9535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2794, 4, DATE '2012-05-24', 203.2585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2795, 10, DATE '2014-05-25', 456.3752);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2796, 8, DATE '2013-11-22', 445.9776);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2797, 3, DATE '2013-10-09', 822.0536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2798, 5, DATE '2012-12-17', 361.4906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2799, 6, DATE '2011-01-05', 467.1896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2800, 9, DATE '2011-04-15', 240.3199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2801, 3, DATE '2012-05-05', 253.7722);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2802, 4, DATE '2011-05-27', 820.1464);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2803, 10, DATE '2011-09-16', 369.8851);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2804, 3, DATE '2012-02-20', 253.0939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2805, 7, DATE '2012-03-02', 791.6582);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2806, 8, DATE '2014-02-28', 521.0983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2807, 8, DATE '2012-01-01', 617.9377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2808, 5, DATE '2011-06-07', 755.7427);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2809, 1, DATE '2015-08-02', 776.7181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2810, 1, DATE '2014-03-04', 173.1380);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2811, 5, DATE '2013-12-07', 687.7646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2812, 5, DATE '2011-07-19', 728.7604);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2813, 1, DATE '2015-12-11', 976.2807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2814, 5, DATE '2011-06-19', 731.1544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2815, 5, DATE '2012-06-13', 144.5447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2816, 9, DATE '2011-11-05', 526.3864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2817, 1, DATE '2012-04-15', 417.1980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2818, 7, DATE '2012-11-11', 77.8272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2819, 6, DATE '2015-01-14', 94.1382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2820, 9, DATE '2014-07-09', 521.3178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2821, 8, DATE '2011-12-10', 582.0818);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2822, 5, DATE '2012-12-13', 350.0954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2823, 9, DATE '2011-07-17', 406.6329);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2824, 2, DATE '2012-10-18', 539.1435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2825, 2, DATE '2012-07-25', 463.3207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2826, 10, DATE '2013-02-10', 897.7674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2827, 3, DATE '2015-03-13', 464.0456);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2828, 9, DATE '2015-03-14', 829.3610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2829, 6, DATE '2012-01-27', 897.9551);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2830, 10, DATE '2014-04-04', 334.5581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2831, 9, DATE '2012-08-26', 771.6419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2832, 10, DATE '2013-04-28', 976.0893);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2833, 8, DATE '2011-05-01', 420.2941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2834, 6, DATE '2015-02-23', 123.7135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2835, 1, DATE '2012-06-03', 549.3418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2836, 7, DATE '2015-12-05', 310.0694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2837, 10, DATE '2015-03-06', 704.9130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2838, 4, DATE '2012-10-04', 321.1603);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2839, 4, DATE '2011-07-02', 899.3487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2840, 7, DATE '2012-06-01', 881.8725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2841, 9, DATE '2011-01-21', 210.9948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2842, 3, DATE '2011-07-07', 959.0927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2843, 9, DATE '2013-10-19', 246.5839);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2844, 2, DATE '2012-02-22', 326.1783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2845, 7, DATE '2012-04-20', 876.5261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2846, 7, DATE '2012-11-05', 51.0337);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2847, 4, DATE '2014-08-12', 121.0571);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2848, 1, DATE '2014-05-12', 309.7992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2849, 10, DATE '2015-12-12', 58.7138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2850, 1, DATE '2013-07-20', 929.9888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2851, 7, DATE '2012-08-09', 28.7796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2852, 7, DATE '2011-11-28', 744.2263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2853, 10, DATE '2013-12-03', 267.3524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2854, 7, DATE '2012-06-28', 945.8718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2855, 1, DATE '2015-05-06', 658.2381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2856, 9, DATE '2015-05-24', 903.6769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2857, 6, DATE '2015-11-11', 413.5135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2858, 8, DATE '2014-11-28', 830.7416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2859, 1, DATE '2015-07-29', 789.7732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2860, 8, DATE '2015-01-20', 893.8909);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2861, 6, DATE '2014-12-19', 57.0527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2862, 10, DATE '2012-10-19', 788.5767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2863, 9, DATE '2015-05-12', 857.7877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2864, 1, DATE '2012-04-30', 442.1599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2865, 3, DATE '2012-07-09', 401.4962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2866, 6, DATE '2011-08-11', 711.6754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2867, 8, DATE '2011-03-20', 308.4662);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2868, 5, DATE '2011-10-19', 852.5671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2869, 5, DATE '2015-01-16', 181.8125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2870, 8, DATE '2012-07-10', 834.4753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2871, 9, DATE '2012-09-01', 821.4734);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2872, 8, DATE '2015-07-12', 96.0376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2873, 4, DATE '2012-05-13', 178.4785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2874, 9, DATE '2013-08-15', 212.2657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2875, 1, DATE '2014-06-19', 310.3230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2876, 6, DATE '2011-06-05', 622.9891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2877, 6, DATE '2015-02-24', 103.5114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2878, 7, DATE '2015-05-25', 80.4546);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2879, 6, DATE '2011-07-01', 662.6174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2880, 5, DATE '2015-09-20', 412.2870);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2881, 7, DATE '2014-07-02', 776.7102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2882, 2, DATE '2011-11-01', 154.2463);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2883, 10, DATE '2015-04-03', 770.6472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2884, 5, DATE '2014-07-10', 967.9663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2885, 4, DATE '2012-08-25', 305.7785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2886, 3, DATE '2011-09-30', 27.4155);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2887, 1, DATE '2015-05-26', 708.7368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2888, 1, DATE '2014-11-03', 474.4224);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2889, 5, DATE '2015-10-20', 465.4754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2890, 2, DATE '2013-01-10', 645.6650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2891, 2, DATE '2011-01-24', 896.5560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2892, 3, DATE '2011-04-09', 874.1714);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2893, 4, DATE '2013-03-09', 531.3871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2894, 6, DATE '2012-06-11', 5.4578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2895, 2, DATE '2013-06-14', 824.8198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2896, 9, DATE '2014-04-03', 422.4181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2897, 4, DATE '2012-02-26', 101.3050);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2898, 8, DATE '2012-06-21', 804.4241);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2899, 10, DATE '2015-08-16', 924.6822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2900, 2, DATE '2011-09-10', 164.8507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2901, 10, DATE '2012-08-18', 742.5675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2902, 9, DATE '2013-10-25', 268.4900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2903, 6, DATE '2015-04-27', 127.9867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2904, 2, DATE '2014-06-04', 224.2385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2905, 3, DATE '2011-11-18', 108.5153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2906, 9, DATE '2013-01-28', 932.7420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2907, 3, DATE '2015-07-17', 565.7477);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2908, 1, DATE '2011-04-21', 55.0867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2909, 6, DATE '2014-01-10', 635.5487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2910, 6, DATE '2014-12-01', 35.2489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2911, 3, DATE '2011-03-31', 800.1654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2912, 9, DATE '2011-06-19', 333.0588);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2913, 2, DATE '2014-05-30', 168.1242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2914, 6, DATE '2015-11-09', 377.4861);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2915, 2, DATE '2011-07-22', 117.1806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2916, 4, DATE '2014-02-17', 902.8064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2917, 1, DATE '2013-07-19', 17.9295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2918, 5, DATE '2011-11-02', 889.8214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2919, 8, DATE '2015-09-05', 136.3814);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2920, 10, DATE '2011-10-11', 374.0806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2921, 5, DATE '2012-03-17', 2.9385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2922, 8, DATE '2012-05-17', 834.0438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2923, 1, DATE '2011-12-30', 387.0917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2924, 3, DATE '2013-01-05', 536.1475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2925, 7, DATE '2012-06-16', 937.9194);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2926, 7, DATE '2012-05-25', 947.3021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2927, 4, DATE '2013-05-05', 564.6505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2928, 8, DATE '2015-12-02', 173.0207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2929, 7, DATE '2011-03-04', 387.4459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2930, 2, DATE '2011-03-18', 887.9049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2931, 2, DATE '2015-04-09', 521.6840);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2932, 8, DATE '2013-09-04', 299.0874);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2933, 8, DATE '2015-10-10', 155.7725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2934, 5, DATE '2015-10-21', 497.7667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2935, 6, DATE '2014-02-01', 669.7195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2936, 8, DATE '2011-09-08', 508.2202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2937, 6, DATE '2012-07-07', 26.2596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2938, 8, DATE '2011-10-31', 546.4087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2939, 2, DATE '2013-08-22', 859.4509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2940, 5, DATE '2015-07-29', 373.0365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2941, 1, DATE '2012-03-15', 461.6679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2942, 10, DATE '2015-02-05', 653.6501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2943, 5, DATE '2011-10-25', 838.8737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2944, 10, DATE '2011-11-20', 430.2264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2945, 9, DATE '2012-10-13', 845.4997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2946, 3, DATE '2015-08-07', 563.4972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2947, 1, DATE '2012-11-09', 706.0472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2948, 8, DATE '2013-04-30', 153.9009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2949, 5, DATE '2011-11-22', 888.2772);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2950, 9, DATE '2015-04-27', 922.0135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2951, 9, DATE '2011-09-16', 404.4886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2952, 10, DATE '2011-04-26', 211.4837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2953, 1, DATE '2012-10-17', 668.0426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2954, 10, DATE '2014-11-06', 550.6015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2955, 7, DATE '2015-06-26', 161.9122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2956, 2, DATE '2011-04-04', 908.5238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2957, 9, DATE '2012-10-26', 881.3984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2958, 4, DATE '2013-04-21', 591.8392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2959, 5, DATE '2012-12-18', 286.3192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2960, 7, DATE '2015-06-26', 161.2133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2961, 6, DATE '2015-09-26', 368.0915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2962, 5, DATE '2015-08-15', 392.7270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2963, 4, DATE '2011-02-18', 667.6408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2964, 4, DATE '2013-10-26', 747.6439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2965, 4, DATE '2015-08-24', 513.5650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2966, 6, DATE '2013-07-27', 501.0779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2967, 1, DATE '2011-09-10', 177.2863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2968, 8, DATE '2014-08-10', 670.3575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2969, 10, DATE '2012-10-08', 707.7666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2970, 4, DATE '2015-11-14', 608.9605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2971, 8, DATE '2012-08-13', 876.5467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2972, 3, DATE '2012-09-18', 471.5208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2973, 3, DATE '2014-03-13', 30.3704);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2974, 3, DATE '2011-02-07', 763.3450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2975, 10, DATE '2015-07-28', 912.4128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2976, 5, DATE '2013-02-10', 349.2884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2977, 3, DATE '2011-07-25', 995.1701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2978, 1, DATE '2011-02-10', 956.8653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2979, 5, DATE '2011-03-26', 690.6479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2980, 4, DATE '2012-11-09', 374.4221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2981, 6, DATE '2015-07-17', 241.2548);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2982, 6, DATE '2011-01-05', 410.7495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2983, 4, DATE '2015-01-11', 284.7436);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2984, 9, DATE '2011-11-07', 465.4325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2985, 4, DATE '2015-07-02', 483.4162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2986, 3, DATE '2014-12-14', 310.2002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2987, 8, DATE '2011-11-18', 631.0449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2988, 8, DATE '2011-12-05', 605.1710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2989, 8, DATE '2011-04-28', 335.8544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2990, 4, DATE '2013-10-30', 761.1958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2991, 10, DATE '2014-11-12', 626.8219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2992, 3, DATE '2015-03-18', 434.4205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2993, 3, DATE '2014-11-12', 260.0895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2994, 6, DATE '2014-02-27', 698.2376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2995, 10, DATE '2015-11-03', 4.9449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2996, 6, DATE '2012-08-01', 68.9409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2997, 6, DATE '2014-12-18', 986.0094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2998, 2, DATE '2013-12-30', 91.2298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (2999, 6, DATE '2012-03-28', 916.6615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3000, 4, DATE '2015-03-20', 344.4217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3001, 2, DATE '2014-11-28', 386.2108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3002, 3, DATE '2014-04-01', 35.6896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3003, 8, DATE '2011-07-24', 446.1343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3004, 2, DATE '2012-01-09', 279.3167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3005, 1, DATE '2013-09-14', 45.4668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3006, 7, DATE '2014-12-29', 932.9679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3007, 7, DATE '2013-02-13', 181.1133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3008, 8, DATE '2012-09-10', 904.6977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3009, 1, DATE '2015-04-11', 638.1888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3010, 2, DATE '2013-05-15', 812.6238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3011, 10, DATE '2015-09-11', 913.3537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3012, 8, DATE '2012-09-16', 924.5331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3013, 10, DATE '2013-01-27', 901.1913);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3014, 2, DATE '2011-02-09', 911.8971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3015, 1, DATE '2015-12-10', 919.9586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3016, 10, DATE '2015-09-21', 957.3420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3017, 2, DATE '2011-08-04', 107.9833);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3018, 6, DATE '2015-04-13', 202.2082);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3019, 1, DATE '2014-04-26', 264.2276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3020, 1, DATE '2011-09-11', 203.3647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3021, 9, DATE '2012-09-08', 870.0331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3022, 4, DATE '2015-10-07', 572.1153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3023, 10, DATE '2014-04-15', 334.5030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3024, 7, DATE '2014-12-09', 946.5709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3025, 5, DATE '2012-01-02', 982.1386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3026, 6, DATE '2013-05-28', 442.1261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3027, 10, DATE '2013-11-06', 211.4313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3028, 7, DATE '2011-01-15', 332.1329);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3029, 4, DATE '2011-04-07', 758.4000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3030, 4, DATE '2013-12-27', 843.4718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3031, 9, DATE '2014-02-23', 363.2791);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3032, 2, DATE '2013-07-25', 903.9403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3033, 6, DATE '2014-11-15', 40.2037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3034, 1, DATE '2012-01-06', 346.2261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3035, 2, DATE '2013-12-12', 988.2113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3036, 4, DATE '2012-04-16', 205.5651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3037, 9, DATE '2015-06-14', 964.6152);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3038, 2, DATE '2014-01-03', 5.4268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3039, 9, DATE '2014-02-23', 419.9657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3040, 7, DATE '2011-07-05', 550.4484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3041, 7, DATE '2012-10-31', 129.0869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3042, 10, DATE '2015-03-10', 726.3473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3043, 7, DATE '2012-08-25', 966.9822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3044, 7, DATE '2013-12-13', 523.2307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3045, 5, DATE '2014-02-18', 847.8422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3046, 2, DATE '2013-02-25', 702.2889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3047, 4, DATE '2013-02-19', 533.2292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3048, 2, DATE '2014-10-04', 348.1925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3049, 6, DATE '2014-03-20', 778.2790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3050, 10, DATE '2011-02-12', 47.6030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3051, 5, DATE '2011-12-29', 960.9576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3052, 1, DATE '2015-09-07', 783.8011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3053, 1, DATE '2015-09-05', 827.0023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3054, 6, DATE '2011-07-19', 713.2968);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3055, 6, DATE '2013-07-11', 474.3887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3056, 9, DATE '2015-02-22', 814.0955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3057, 3, DATE '2015-12-18', 701.1867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3058, 2, DATE '2012-08-15', 499.5635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3059, 8, DATE '2011-01-07', 297.1782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3060, 6, DATE '2011-04-19', 603.3407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3061, 8, DATE '2012-02-22', 721.5365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3062, 10, DATE '2013-01-30', 848.9805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3063, 5, DATE '2012-06-05', 146.2976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3064, 8, DATE '2012-04-15', 794.7170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3065, 3, DATE '2015-03-23', 449.3447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3066, 9, DATE '2013-02-16', 9.4134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3067, 3, DATE '2013-11-02', 884.3293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3068, 9, DATE '2012-01-22', 554.9652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3069, 10, DATE '2013-02-27', 923.6858);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3070, 8, DATE '2014-08-25', 714.3934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3071, 2, DATE '2011-04-09', 992.7268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3072, 10, DATE '2013-08-01', 102.5565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3073, 7, DATE '2012-02-18', 782.2426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3074, 5, DATE '2013-10-22', 713.7792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3075, 5, DATE '2014-11-10', 74.2777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3076, 9, DATE '2013-07-01', 143.6857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3077, 7, DATE '2014-02-11', 605.1332);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3078, 4, DATE '2011-05-03', 811.2724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3079, 3, DATE '2011-10-21', 98.7286);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3080, 3, DATE '2014-11-06', 279.8497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3081, 2, DATE '2011-04-09', 908.8970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3082, 8, DATE '2015-02-03', 863.2389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3083, 2, DATE '2012-10-27', 553.8539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3084, 4, DATE '2011-02-23', 710.7970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3085, 10, DATE '2012-12-30', 882.5143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3086, 9, DATE '2014-06-19', 579.4780);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3087, 1, DATE '2013-11-20', 76.9379);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3088, 1, DATE '2014-04-30', 326.9070);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3089, 6, DATE '2014-06-27', 871.8375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3090, 4, DATE '2014-10-21', 174.1158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3091, 1, DATE '2012-04-30', 504.3785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3092, 7, DATE '2013-10-30', 465.0516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3093, 5, DATE '2013-12-27', 708.2487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3094, 4, DATE '2013-11-06', 816.6251);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3095, 10, DATE '2015-05-14', 828.9120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3096, 7, DATE '2015-10-02', 280.1065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3097, 6, DATE '2013-10-04', 580.0496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3098, 10, DATE '2011-05-13', 172.2651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3099, 5, DATE '2014-09-23', 73.8859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3100, 6, DATE '2012-01-03', 838.4288);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3101, 10, DATE '2015-04-26', 817.9596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3102, 5, DATE '2012-01-29', 978.2641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3103, 3, DATE '2012-08-06', 424.5067);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3104, 8, DATE '2015-07-26', 63.8856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3105, 9, DATE '2015-11-06', 54.8762);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3106, 6, DATE '2014-05-29', 858.4011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3107, 5, DATE '2014-07-20', 1.5585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3108, 7, DATE '2012-11-13', 113.2231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3109, 1, DATE '2012-09-07', 639.0190);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3110, 7, DATE '2011-01-10', 330.7029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3111, 3, DATE '2012-01-11', 208.9623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3112, 10, DATE '2015-08-17', 889.9143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3113, 10, DATE '2011-10-26', 400.8349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3114, 5, DATE '2012-03-02', 17.3284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3115, 4, DATE '2011-01-11', 694.4438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3116, 10, DATE '2013-01-18', 858.2977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3117, 9, DATE '2011-04-05', 295.1265);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3118, 1, DATE '2012-04-13', 435.5007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3119, 9, DATE '2015-04-17', 912.2028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3120, 5, DATE '2011-10-04', 869.8668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3121, 8, DATE '2015-03-30', 932.4755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3122, 3, DATE '2015-07-06', 557.4222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3123, 4, DATE '2013-07-28', 683.1277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3124, 6, DATE '2014-05-10', 749.5700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3125, 8, DATE '2013-04-27', 210.0149);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3126, 5, DATE '2013-06-09', 527.6752);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3127, 5, DATE '2015-08-05', 394.3078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3128, 4, DATE '2014-04-13', 965.6176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3129, 5, DATE '2014-06-11', 884.8673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3130, 9, DATE '2015-02-09', 794.1713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3131, 4, DATE '2015-09-28', 563.6362);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3132, 7, DATE '2013-10-02', 432.8680);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3133, 10, DATE '2012-08-10', 737.3865);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3134, 7, DATE '2015-10-19', 260.2998);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3135, 4, DATE '2015-07-14', 461.8901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3136, 8, DATE '2015-03-11', 930.6329);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3137, 6, DATE '2013-06-29', 438.7321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3138, 5, DATE '2013-04-03', 489.9683);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3139, 5, DATE '2011-04-20', 655.9208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3140, 5, DATE '2014-08-03', 24.1132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3141, 4, DATE '2015-11-30', 577.9195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3142, 5, DATE '2012-01-07', 963.7149);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3143, 10, DATE '2012-08-22', 687.8881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3144, 9, DATE '2014-06-17', 541.1345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3145, 2, DATE '2013-10-10', 965.1535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3146, 1, DATE '2012-09-14', 614.4643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3147, 8, DATE '2013-01-05', 64.2167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3148, 1, DATE '2012-10-27', 690.9202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3149, 1, DATE '2013-10-27', 122.1812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3150, 10, DATE '2013-04-25', 970.6143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3151, 9, DATE '2015-06-29', 984.9800);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3152, 5, DATE '2012-06-23', 144.5489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3153, 2, DATE '2012-01-26', 260.0624);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3154, 10, DATE '2013-12-20', 204.0192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3155, 8, DATE '2012-10-05', 905.9534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3156, 7, DATE '2015-10-22', 260.5373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3157, 2, DATE '2014-07-04', 295.1363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3158, 7, DATE '2014-03-30', 674.9368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3159, 1, DATE '2013-03-31', 853.8707);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3160, 5, DATE '2013-05-29', 527.2011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3161, 1, DATE '2014-10-25', 464.0932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3162, 1, DATE '2011-04-08', 35.9409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3163, 2, DATE '2014-06-05', 228.3558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3164, 2, DATE '2013-07-30', 844.8478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3165, 4, DATE '2011-04-15', 767.0668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3166, 6, DATE '2014-04-11', 776.0944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3167, 1, DATE '2014-01-06', 152.5277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3168, 3, DATE '2012-01-07', 140.5351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3169, 1, DATE '2012-08-20', 555.4383);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3170, 6, DATE '2011-11-03', 763.8109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3171, 5, DATE '2015-07-23', 419.5656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3172, 4, DATE '2014-01-01', 805.1583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3173, 7, DATE '2011-12-26', 779.5800);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3174, 4, DATE '2011-09-15', 888.0896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3175, 1, DATE '2011-11-05', 291.9473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3176, 4, DATE '2014-03-23', 968.7606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3177, 3, DATE '2013-11-13', 869.5342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3178, 6, DATE '2015-02-10', 141.9932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3179, 5, DATE '2011-07-31', 784.4165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3180, 7, DATE '2011-08-14', 595.5507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3181, 8, DATE '2011-06-05', 463.4584);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3182, 5, DATE '2013-10-09', 703.3876);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3183, 4, DATE '2011-06-18', 843.4363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3184, 6, DATE '2012-02-17', 914.2531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3185, 1, DATE '2015-08-13', 809.1913);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3186, 9, DATE '2014-04-06', 419.0872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3187, 6, DATE '2012-09-06', 172.8056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3188, 10, DATE '2014-08-21', 533.3673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3189, 9, DATE '2014-01-13', 354.3465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3190, 7, DATE '2015-09-22', 201.3528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3191, 7, DATE '2011-09-08', 635.4966);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3192, 10, DATE '2015-04-01', 763.7953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3193, 4, DATE '2011-01-04', 636.0976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3194, 1, DATE '2013-11-21', 128.7196);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3195, 4, DATE '2015-10-10', 560.0200);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3196, 4, DATE '2015-08-25', 541.9785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3197, 4, DATE '2013-08-04', 735.3590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3198, 8, DATE '2015-01-24', 843.0404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3199, 5, DATE '2014-03-05', 774.0677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3200, 7, DATE '2015-07-02', 189.0591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3201, 1, DATE '2014-09-08', 461.9365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3202, 5, DATE '2011-12-30', 923.6817);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3203, 10, DATE '2011-03-09', 135.4819);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3204, 5, DATE '2012-12-24', 358.3704);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3205, 6, DATE '2013-10-03', 551.0487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3206, 5, DATE '2012-06-27', 179.8217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3207, 9, DATE '2011-06-29', 364.9690);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3208, 8, DATE '2011-05-14', 371.9728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3209, 10, DATE '2013-02-15', 912.0720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3210, 5, DATE '2014-07-16', 937.1928);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3211, 4, DATE '2012-12-08', 391.0031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3212, 7, DATE '2015-05-25', 153.1431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3213, 2, DATE '2013-08-31', 890.5203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3214, 4, DATE '2012-08-17', 258.3200);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3215, 8, DATE '2012-12-25', 63.7426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3216, 7, DATE '2012-01-16', 760.7056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3217, 8, DATE '2015-10-21', 192.5047);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3218, 7, DATE '2013-04-18', 314.1028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3219, 2, DATE '2013-12-17', 35.6564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3220, 5, DATE '2013-01-08', 347.9796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3221, 1, DATE '2012-08-04', 603.2888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3222, 2, DATE '2015-05-19', 619.1605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3223, 5, DATE '2013-12-25', 786.1886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3224, 5, DATE '2012-11-28', 354.0855);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3225, 10, DATE '2011-02-26', 128.3143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3226, 5, DATE '2011-04-23', 655.7703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3227, 1, DATE '2013-12-28', 169.0606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3228, 6, DATE '2014-02-03', 650.8603);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3229, 1, DATE '2011-12-06', 328.0696);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3230, 8, DATE '2012-03-13', 749.9688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3231, 1, DATE '2011-08-20', 233.4015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3232, 5, DATE '2014-10-21', 26.4938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3233, 1, DATE '2011-12-08', 367.9255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3234, 9, DATE '2012-01-30', 595.3574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3235, 7, DATE '2012-12-06', 133.6141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3236, 3, DATE '2015-06-06', 539.7768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3237, 5, DATE '2013-08-03', 567.9057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3238, 10, DATE '2014-06-24', 485.0659);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3239, 10, DATE '2014-05-16', 363.2043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3240, 7, DATE '2014-02-15', 629.3696);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3241, 1, DATE '2013-10-09', 54.1181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3242, 8, DATE '2012-04-25', 800.8328);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3243, 10, DATE '2012-07-06', 621.2953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3244, 4, DATE '2015-07-01', 417.1537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3245, 4, DATE '2013-10-15', 810.3497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3246, 1, DATE '2012-04-15', 482.3534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3247, 8, DATE '2012-08-01', 873.2751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3248, 10, DATE '2014-05-20', 377.7775);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3249, 3, DATE '2011-11-28', 64.9770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3250, 7, DATE '2014-09-24', 799.3144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3251, 6, DATE '2015-11-04', 349.4738);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3252, 7, DATE '2011-04-18', 421.2562);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3253, 7, DATE '2012-02-07', 807.3839);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3254, 1, DATE '2012-02-25', 426.0881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3255, 6, DATE '2013-11-27', 585.7703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3256, 9, DATE '2015-04-23', 842.7760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3257, 1, DATE '2014-01-05', 137.4930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3258, 6, DATE '2014-04-10', 781.3964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3259, 6, DATE '2012-10-29', 230.0560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3260, 1, DATE '2013-06-12', 895.2784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3261, 4, DATE '2014-07-01', 10.7610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3262, 3, DATE '2013-05-25', 714.1088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3263, 8, DATE '2015-06-09', 43.9032);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3264, 3, DATE '2011-12-06', 162.1031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3265, 5, DATE '2013-11-26', 703.7912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3266, 9, DATE '2014-02-18', 364.5093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3267, 6, DATE '2014-06-17', 785.2176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3268, 4, DATE '2012-08-02', 295.1628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3269, 8, DATE '2015-09-12', 124.7058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3270, 5, DATE '2013-07-21', 523.9658);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3271, 2, DATE '2014-06-15', 192.7999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3272, 9, DATE '2012-04-29', 707.4389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3273, 7, DATE '2014-12-03', 950.8985);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3274, 6, DATE '2015-11-01', 406.2869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3275, 5, DATE '2015-04-02', 293.8614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3276, 4, DATE '2011-04-12', 802.4560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3277, 2, DATE '2013-11-12', 997.8653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3278, 1, DATE '2014-06-26', 369.0348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3279, 2, DATE '2015-02-14', 543.7358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3280, 9, DATE '2014-11-12', 645.9609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3281, 8, DATE '2014-09-22', 782.4953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3282, 1, DATE '2015-08-11', 791.2831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3283, 3, DATE '2013-03-09', 585.8832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3284, 4, DATE '2013-03-13', 528.7552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3285, 2, DATE '2012-05-09', 400.4950);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3286, 4, DATE '2011-05-04', 812.1454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3287, 9, DATE '2013-09-13', 219.1100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3288, 10, DATE '2015-10-14', 941.8374);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3289, 3, DATE '2014-03-04', 9.5871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3290, 8, DATE '2013-08-16', 290.8382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3291, 2, DATE '2012-05-31', 402.2838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3292, 10, DATE '2015-04-25', 786.5093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3293, 5, DATE '2012-08-25', 255.0098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3294, 10, DATE '2011-12-04', 467.9260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3295, 3, DATE '2015-08-18', 618.6085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3296, 9, DATE '2011-05-17', 340.0094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3297, 10, DATE '2012-11-17', 756.9295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3298, 8, DATE '2011-08-01', 459.1922);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3299, 10, DATE '2012-08-04', 713.3625);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3300, 5, DATE '2015-08-27', 445.8404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3301, 5, DATE '2013-10-30', 697.1359);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3302, 5, DATE '2015-12-30', 578.1122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3303, 3, DATE '2014-09-07', 253.0717);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3304, 9, DATE '2014-05-09', 541.0113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3305, 6, DATE '2011-04-12', 606.5145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3306, 8, DATE '2014-07-07', 642.0349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3307, 1, DATE '2012-05-15', 470.3577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3308, 2, DATE '2012-04-08', 401.0969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3309, 7, DATE '2012-11-25', 132.2267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3310, 3, DATE '2013-08-17', 783.3144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3311, 8, DATE '2012-06-10', 844.9108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3312, 1, DATE '2015-07-13', 768.4582);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3313, 5, DATE '2015-02-24', 237.6605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3314, 7, DATE '2013-12-18', 584.0952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3315, 4, DATE '2014-09-21', 112.7831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3316, 4, DATE '2014-11-20', 219.4779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3317, 10, DATE '2011-03-19', 128.2255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3318, 4, DATE '2013-03-28', 515.1481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3319, 1, DATE '2015-07-29', 761.6081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3320, 2, DATE '2013-07-26', 891.6459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3321, 1, DATE '2011-06-07', 145.3993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3322, 7, DATE '2014-09-04', 843.3802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3323, 1, DATE '2014-05-31', 285.5757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3324, 10, DATE '2013-01-27', 833.8677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3325, 4, DATE '2012-02-20', 121.6820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3326, 3, DATE '2015-02-20', 406.2906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3327, 5, DATE '2015-09-04', 452.4291);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3328, 8, DATE '2013-12-31', 482.9725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3329, 3, DATE '2011-03-16', 787.6784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3330, 6, DATE '2014-11-16', 953.8520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3331, 4, DATE '2014-05-25', 45.5264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3332, 4, DATE '2013-04-14', 538.6730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3333, 2, DATE '2012-11-21', 655.6724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3334, 7, DATE '2015-06-21', 97.8954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3335, 5, DATE '2012-01-14', 948.8251);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3336, 3, DATE '2014-09-23', 204.3830);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3337, 9, DATE '2011-12-04', 538.2114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3338, 5, DATE '2014-10-31', 44.8719);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3339, 9, DATE '2012-12-02', 922.2408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3340, 4, DATE '2013-11-03', 758.4601);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3341, 3, DATE '2014-12-19', 341.7876);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3342, 8, DATE '2012-06-07', 818.0131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3343, 4, DATE '2013-11-19', 809.6107);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3344, 10, DATE '2011-07-18', 226.2727);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3345, 1, DATE '2012-03-07', 445.9275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3346, 2, DATE '2012-11-19', 633.8256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3347, 6, DATE '2011-03-01', 548.8488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3348, 9, DATE '2014-09-08', 670.9146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3349, 6, DATE '2013-03-15', 355.1428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3350, 9, DATE '2011-09-29', 399.1306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3351, 9, DATE '2011-03-01', 211.7838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3352, 7, DATE '2015-08-23', 241.7814);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3353, 8, DATE '2012-01-04', 697.5841);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3354, 8, DATE '2015-01-10', 821.7167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3355, 4, DATE '2015-03-23', 300.4410);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3356, 9, DATE '2015-02-26', 853.7557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3357, 4, DATE '2012-08-01', 292.5364);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3358, 3, DATE '2012-08-11', 419.2041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3359, 5, DATE '2013-03-20', 419.3292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3360, 3, DATE '2012-02-20', 200.2238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3361, 4, DATE '2014-11-03', 189.6058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3362, 4, DATE '2014-05-16', 987.3852);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3363, 9, DATE '2012-01-24', 613.4186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3364, 1, DATE '2014-01-09', 178.3747);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3365, 10, DATE '2015-03-26', 737.7879);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3366, 4, DATE '2015-02-26', 306.2377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3367, 10, DATE '2013-08-21', 112.7858);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3368, 8, DATE '2015-09-06', 139.7650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3369, 2, DATE '2012-12-05', 635.2702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3370, 1, DATE '2015-12-29', 908.4001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3371, 6, DATE '2013-12-18', 681.2665);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3372, 5, DATE '2012-05-18', 83.3536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3373, 6, DATE '2011-04-26', 592.9073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3374, 7, DATE '2012-09-25', 3.1480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3375, 9, DATE '2014-08-07', 549.8582);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3376, 3, DATE '2014-12-31', 327.3862);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3377, 3, DATE '2011-10-16', 33.7695);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3378, 1, DATE '2013-11-13', 59.3029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3379, 10, DATE '2011-11-22', 387.9401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3380, 3, DATE '2015-04-03', 487.8564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3381, 8, DATE '2014-12-23', 857.4419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3382, 7, DATE '2011-12-27', 781.5145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3383, 2, DATE '2011-10-18', 127.8296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3384, 4, DATE '2015-06-18', 388.5478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3385, 8, DATE '2014-09-18', 742.0682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3386, 7, DATE '2014-10-03', 803.7451);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3387, 7, DATE '2012-04-11', 841.0890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3388, 4, DATE '2013-11-11', 833.9557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3389, 4, DATE '2011-03-31', 797.4544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3390, 7, DATE '2012-11-18', 95.0693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3391, 10, DATE '2013-02-22', 911.8467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3392, 7, DATE '2015-04-24', 119.0073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3393, 1, DATE '2012-08-13', 625.5427);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3394, 6, DATE '2011-10-13', 722.0169);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3395, 1, DATE '2014-12-31', 568.8543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3396, 9, DATE '2011-08-06', 354.4025);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3397, 10, DATE '2011-05-15', 204.5945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3398, 4, DATE '2015-11-11', 631.2360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3399, 1, DATE '2012-04-24', 488.4849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3400, 7, DATE '2013-01-09', 139.6897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3401, 2, DATE '2015-03-31', 521.0398);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3402, 8, DATE '2011-06-25', 409.0837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3403, 7, DATE '2012-10-04', 35.6444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3404, 5, DATE '2013-03-17', 446.7428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3405, 4, DATE '2013-10-12', 717.8641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3406, 4, DATE '2014-10-13', 128.4301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3407, 1, DATE '2015-04-29', 648.8741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3408, 1, DATE '2015-04-10', 694.4361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3409, 9, DATE '2011-06-06', 271.8585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3410, 2, DATE '2011-03-23', 973.0549);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3411, 6, DATE '2014-05-13', 819.9862);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3412, 3, DATE '2014-09-19', 233.2334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3413, 3, DATE '2011-09-21', 31.2639);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3414, 3, DATE '2013-12-18', 931.4729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3415, 6, DATE '2013-02-28', 342.7820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3416, 8, DATE '2013-11-07', 408.0914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3417, 2, DATE '2013-07-30', 859.5556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3418, 5, DATE '2012-08-07', 224.8708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3419, 3, DATE '2015-04-23', 436.3065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3420, 3, DATE '2011-06-24', 934.0428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3421, 7, DATE '2013-11-17', 465.1488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3422, 7, DATE '2015-10-11', 278.8302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3423, 5, DATE '2015-06-08', 342.3106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3424, 5, DATE '2011-01-18', 540.2008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3425, 2, DATE '2013-11-06', 996.5535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3426, 9, DATE '2014-08-26', 562.2592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3427, 5, DATE '2015-10-06', 457.8110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3428, 10, DATE '2015-07-14', 870.8905);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3429, 7, DATE '2013-09-26', 434.2938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3430, 1, DATE '2014-01-02', 195.4557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3431, 4, DATE '2014-08-18', 122.7917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3432, 10, DATE '2011-12-06', 402.5335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3433, 1, DATE '2012-07-21', 570.8180);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3434, 3, DATE '2014-11-12', 248.2503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3435, 1, DATE '2011-01-03', 966.8167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3436, 10, DATE '2014-06-30', 448.3581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3437, 10, DATE '2015-03-25', 745.8700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3438, 8, DATE '2014-08-02', 681.0869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3439, 1, DATE '2012-09-06', 670.6837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3440, 4, DATE '2015-12-07', 613.6380);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3441, 7, DATE '2015-06-06', 154.8709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3442, 7, DATE '2013-01-01', 146.6528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3443, 5, DATE '2013-06-08', 562.0971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3444, 2, DATE '2011-01-09', 824.3996);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3445, 2, DATE '2014-07-08', 275.0832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3446, 7, DATE '2014-06-05', 678.6132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3447, 4, DATE '2014-08-04', 87.7433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3448, 8, DATE '2014-08-27', 694.0698);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3449, 1, DATE '2014-08-15', 379.2348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3450, 3, DATE '2012-02-23', 160.7628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3451, 8, DATE '2014-01-06', 494.8470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3452, 6, DATE '2014-10-07', 979.7238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3453, 1, DATE '2011-07-21', 194.9294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3454, 8, DATE '2011-11-02', 554.4422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3455, 10, DATE '2015-02-23', 674.5410);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3456, 6, DATE '2015-06-21', 242.2095);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3457, 4, DATE '2012-01-17', 66.7730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3458, 2, DATE '2012-09-16', 495.4437);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3459, 3, DATE '2015-05-12', 450.1893);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3460, 5, DATE '2015-02-17', 155.6049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3461, 10, DATE '2015-01-07', 670.6192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3462, 2, DATE '2015-10-16', 777.9837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3463, 4, DATE '2012-07-15', 260.1423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3464, 9, DATE '2013-06-04', 76.4028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3465, 8, DATE '2012-08-04', 850.2632);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3466, 6, DATE '2013-06-07', 417.4526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3467, 3, DATE '2013-02-28', 662.4154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3468, 10, DATE '2012-11-08', 783.0136);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3469, 3, DATE '2013-12-16', 964.6562);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3470, 6, DATE '2014-08-31', 894.4240);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3471, 8, DATE '2014-08-16', 662.2214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3472, 5, DATE '2014-12-28', 178.4686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3473, 5, DATE '2015-12-02', 554.1871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3474, 10, DATE '2015-05-17', 822.6686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3475, 7, DATE '2012-01-18', 779.1719);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3476, 1, DATE '2011-11-16', 318.4959);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3477, 3, DATE '2013-05-04', 716.7331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3478, 3, DATE '2015-05-31', 517.9111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3479, 4, DATE '2012-07-12', 265.1175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3480, 5, DATE '2015-06-03', 317.9402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3481, 6, DATE '2011-01-22', 474.5158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3482, 7, DATE '2012-02-10', 763.7412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3483, 9, DATE '2011-11-29', 491.6556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3484, 4, DATE '2012-08-03', 273.5309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3485, 3, DATE '2015-12-27', 700.6088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3486, 9, DATE '2015-11-12', 143.0679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3487, 10, DATE '2011-05-19', 207.6041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3488, 3, DATE '2011-09-20', 16.3758);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3489, 4, DATE '2015-09-20', 573.7094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3490, 5, DATE '2011-07-15', 724.6071);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3491, 6, DATE '2013-06-13', 381.5851);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3492, 8, DATE '2013-07-08', 250.4263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3493, 5, DATE '2015-03-24', 230.8975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3494, 6, DATE '2013-07-21', 515.0787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3495, 5, DATE '2011-11-30', 943.0188);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3496, 5, DATE '2015-08-21', 376.8872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3497, 4, DATE '2011-06-20', 886.5106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3498, 6, DATE '2011-01-05', 485.6943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3499, 4, DATE '2014-06-06', 974.1365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3500, 6, DATE '2012-02-01', 857.6307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3501, 5, DATE '2012-04-07', 16.1977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3502, 4, DATE '2012-09-26', 304.7297);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3503, 6, DATE '2011-09-11', 729.4137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3504, 5, DATE '2015-12-16', 484.8109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3505, 6, DATE '2013-07-10', 498.5415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3506, 3, DATE '2015-01-10', 316.3783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3507, 2, DATE '2014-11-06', 425.5366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3508, 1, DATE '2012-03-05', 372.2609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3509, 2, DATE '2015-10-15', 775.2703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3510, 10, DATE '2014-04-09', 356.0450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3511, 4, DATE '2013-02-16', 525.4765);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3512, 2, DATE '2012-08-19', 548.8620);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3513, 9, DATE '2011-03-08', 230.3262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3514, 9, DATE '2015-12-09', 132.2491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3515, 10, DATE '2015-01-26', 681.0892);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3516, 3, DATE '2013-11-28', 906.8781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3517, 3, DATE '2014-11-17', 286.3281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3518, 10, DATE '2015-12-12', 986.6115);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3519, 6, DATE '2013-06-08', 375.7941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3520, 10, DATE '2012-09-23', 707.1952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3521, 7, DATE '2013-01-20', 209.8484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3522, 10, DATE '2012-06-10', 646.0395);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3523, 7, DATE '2013-02-18', 209.3042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3524, 8, DATE '2013-06-03', 240.0491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3525, 10, DATE '2012-03-20', 512.8388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3526, 1, DATE '2012-02-08', 411.7951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3527, 10, DATE '2015-10-07', 947.5711);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3528, 10, DATE '2013-05-14', 39.1084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3529, 6, DATE '2014-06-18', 879.6498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3530, 2, DATE '2012-05-29', 402.2846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3531, 8, DATE '2011-05-29', 431.9854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3532, 8, DATE '2013-04-30', 231.0387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3533, 9, DATE '2011-12-26', 543.7746);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3534, 8, DATE '2011-06-11', 407.4868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3535, 10, DATE '2014-02-25', 301.7424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3536, 2, DATE '2014-04-27', 169.7860);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3537, 2, DATE '2011-06-01', 34.3275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3538, 4, DATE '2011-12-15', 6.8446);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3539, 9, DATE '2015-01-25', 774.9895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3540, 1, DATE '2011-12-18', 384.2304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3541, 7, DATE '2012-01-07', 717.5314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3542, 9, DATE '2015-03-15', 835.3433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3543, 2, DATE '2011-12-06', 241.1056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3544, 4, DATE '2012-06-13', 217.6644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3545, 2, DATE '2014-05-28', 199.1305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3546, 5, DATE '2011-10-26', 832.7231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3547, 10, DATE '2013-05-03', 20.1001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3548, 7, DATE '2015-04-15', 98.6484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3549, 6, DATE '2014-06-25', 833.9896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3550, 2, DATE '2014-01-02', 36.1407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3551, 3, DATE '2011-10-04', 90.5591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3552, 4, DATE '2011-07-10', 899.8991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3553, 10, DATE '2013-07-29', 109.9002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3554, 5, DATE '2012-09-13', 266.9413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3555, 10, DATE '2015-01-12', 647.7822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3556, 6, DATE '2015-10-28', 370.1583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3557, 8, DATE '2015-08-08', 95.4255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3558, 9, DATE '2014-04-10', 489.3645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3559, 6, DATE '2014-09-28', 971.9721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3560, 5, DATE '2012-06-01', 86.7463);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3561, 4, DATE '2015-04-06', 368.8073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3562, 3, DATE '2012-06-24', 386.4282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3563, 6, DATE '2013-09-18', 492.6111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3564, 10, DATE '2014-05-19', 372.9856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3565, 3, DATE '2013-11-11', 924.0596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3566, 7, DATE '2015-10-20', 294.4377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3567, 3, DATE '2011-08-26', 5.0873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3568, 1, DATE '2015-09-28', 822.8394);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3569, 9, DATE '2012-10-13', 830.5067);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3570, 8, DATE '2011-10-02', 511.3031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3571, 2, DATE '2013-06-29', 872.5505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3572, 9, DATE '2013-12-04', 279.4834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3573, 2, DATE '2011-11-17', 211.6219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3574, 6, DATE '2012-06-22', 991.5637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3575, 3, DATE '2011-09-18', 989.6638);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3576, 8, DATE '2013-11-07', 374.5052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3577, 9, DATE '2011-07-07', 404.9339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3578, 3, DATE '2011-09-08', 991.6399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3579, 6, DATE '2015-01-07', 40.9185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3580, 5, DATE '2011-05-26', 680.1158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3581, 2, DATE '2014-10-08', 391.6949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3582, 4, DATE '2011-06-24', 848.9227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3583, 4, DATE '2014-11-19', 205.1189);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3584, 4, DATE '2011-06-16', 843.5090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3585, 10, DATE '2011-08-27', 311.7255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3586, 5, DATE '2015-11-20', 532.0863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3587, 8, DATE '2015-10-03', 121.1385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3588, 5, DATE '2015-04-14', 276.8333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3589, 9, DATE '2012-05-29', 759.7046);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3590, 5, DATE '2014-04-30', 931.5842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3591, 5, DATE '2014-09-19', 74.3605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3592, 4, DATE '2013-02-21', 544.9630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3593, 9, DATE '2013-03-19', 34.8725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3594, 4, DATE '2013-08-26', 688.2431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3595, 7, DATE '2012-09-12', 15.4231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3596, 5, DATE '2015-07-15', 331.1032);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3597, 3, DATE '2012-06-27', 342.7321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3598, 2, DATE '2013-07-20', 868.1200);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3599, 2, DATE '2014-08-02', 293.6048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3600, 6, DATE '2014-08-09', 904.6929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3601, 3, DATE '2011-03-02', 827.6358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3602, 9, DATE '2013-08-05', 197.2607);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3603, 8, DATE '2013-07-02', 268.1417);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3604, 8, DATE '2013-09-24', 322.6864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3605, 1, DATE '2011-07-07', 163.5902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3606, 4, DATE '2013-10-31', 811.0757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3607, 2, DATE '2015-08-24', 688.2772);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3608, 4, DATE '2012-02-07', 118.3366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3609, 2, DATE '2011-12-27', 277.2775);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3610, 2, DATE '2012-03-07', 273.2770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3611, 8, DATE '2015-04-24', 965.2244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3612, 5, DATE '2014-12-01', 103.7856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3613, 3, DATE '2015-04-03', 448.4459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3614, 1, DATE '2014-05-05', 291.8563);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3615, 4, DATE '2013-08-25', 695.0515);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3616, 10, DATE '2014-10-13', 519.8847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3617, 9, DATE '2013-08-06', 181.3092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3618, 3, DATE '2013-04-04', 649.1021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3619, 1, DATE '2013-09-23', 61.2600);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3620, 8, DATE '2013-12-23', 391.9732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3621, 9, DATE '2011-01-18', 173.2992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3622, 9, DATE '2012-05-14', 728.2540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3623, 3, DATE '2014-05-01', 63.1347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3624, 5, DATE '2014-06-16', 898.9225);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3625, 4, DATE '2013-01-12', 436.9426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3626, 9, DATE '2011-05-09', 327.5874);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3627, 1, DATE '2011-09-18', 244.6109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3628, 8, DATE '2014-03-24', 523.3789);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3629, 10, DATE '2015-10-10', 976.1406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3630, 9, DATE '2012-03-06', 658.5606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3631, 6, DATE '2012-05-13', 31.7731);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3632, 7, DATE '2013-12-17', 536.8139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3633, 2, DATE '2013-02-06', 698.0350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3634, 1, DATE '2011-05-31', 136.2257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3635, 3, DATE '2011-03-26', 852.4800);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3636, 3, DATE '2012-03-04', 194.4341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3637, 7, DATE '2013-12-22', 580.7809);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3638, 6, DATE '2012-02-26', 882.4326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3639, 3, DATE '2015-12-11', 679.9187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3640, 7, DATE '2013-10-26', 500.6499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3641, 3, DATE '2011-03-30', 843.8092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3642, 5, DATE '2014-08-27', 2.8019);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3643, 4, DATE '2014-04-18', 999.5559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3644, 7, DATE '2011-03-25', 486.4276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3645, 7, DATE '2015-01-07', 966.3599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3646, 10, DATE '2015-10-20', 970.5749);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3647, 1, DATE '2013-11-20', 96.5171);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3648, 9, DATE '2014-11-14', 743.0163);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3649, 1, DATE '2011-01-02', 993.1917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3650, 7, DATE '2013-11-30', 495.5385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3651, 7, DATE '2012-12-08', 149.7939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3652, 10, DATE '2015-03-25', 693.6300);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3653, 2, DATE '2015-10-28', 806.8599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3654, 4, DATE '2011-08-11', 901.6317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3655, 7, DATE '2014-07-23', 731.3936);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3656, 5, DATE '2014-10-19', 99.3818);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3657, 6, DATE '2015-04-07', 134.1260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3658, 3, DATE '2015-01-17', 369.2192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3659, 4, DATE '2011-09-12', 885.7438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3660, 3, DATE '2011-03-01', 836.0028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3661, 3, DATE '2013-02-13', 566.4648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3662, 5, DATE '2012-06-02', 164.8982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3663, 4, DATE '2012-04-29', 142.1960);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3664, 4, DATE '2015-10-23', 618.7169);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3665, 7, DATE '2015-10-25', 241.5039);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3666, 2, DATE '2012-05-08', 428.4105);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3667, 4, DATE '2012-10-25', 405.7507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3668, 3, DATE '2014-11-03', 312.2202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3669, 9, DATE '2014-02-09', 439.3764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3670, 1, DATE '2012-06-22', 500.6173);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3671, 4, DATE '2011-10-22', 939.1038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3672, 3, DATE '2012-06-10', 298.8767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3673, 10, DATE '2013-04-25', 969.1834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3674, 5, DATE '2015-11-28', 560.6102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3675, 6, DATE '2013-09-25', 548.1640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3676, 4, DATE '2012-05-24', 170.4972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3677, 5, DATE '2014-01-26', 728.6981);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3678, 7, DATE '2014-02-06', 576.7072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3679, 9, DATE '2015-06-09', 932.5627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3680, 5, DATE '2013-03-25', 466.3678);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3681, 8, DATE '2013-06-18', 231.0703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3682, 3, DATE '2012-11-03', 501.5947);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3683, 8, DATE '2014-03-22', 530.1873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3684, 3, DATE '2012-11-09', 480.6021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3685, 2, DATE '2015-03-29', 508.7667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3686, 6, DATE '2013-02-19', 338.1431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3687, 6, DATE '2014-02-20', 729.9540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3688, 9, DATE '2012-06-28', 796.4034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3689, 4, DATE '2012-11-08', 404.8321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3690, 9, DATE '2012-06-06', 753.0982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3691, 8, DATE '2012-11-28', 60.3081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3692, 4, DATE '2014-12-06', 211.5616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3693, 2, DATE '2011-06-16', 996.6889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3694, 1, DATE '2015-10-13', 843.9160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3695, 4, DATE '2011-09-13', 934.1852);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3696, 9, DATE '2014-10-27', 678.9109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3697, 1, DATE '2013-04-29', 860.6059);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3698, 1, DATE '2014-06-26', 380.8390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3699, 10, DATE '2011-05-31', 244.9236);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3700, 6, DATE '2013-08-31', 537.9493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3701, 7, DATE '2013-12-26', 564.8241);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3702, 9, DATE '2015-01-17', 784.2970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3703, 1, DATE '2011-10-06', 303.6398);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3704, 10, DATE '2014-07-13', 492.5743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3705, 3, DATE '2013-02-08', 556.4347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3706, 4, DATE '2011-06-30', 850.9172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3707, 1, DATE '2012-11-29', 724.4466);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3708, 8, DATE '2015-12-01', 246.2497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3709, 8, DATE '2013-11-15', 353.4676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3710, 4, DATE '2013-03-01', 560.8963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3711, 10, DATE '2011-09-24', 370.6837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3712, 10, DATE '2012-02-29', 557.4188);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3713, 5, DATE '2015-08-10', 436.6565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3714, 10, DATE '2014-06-20', 419.3759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3715, 5, DATE '2013-09-12', 604.9325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3716, 1, DATE '2011-04-12', 64.8701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3717, 7, DATE '2014-03-13', 634.7110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3718, 2, DATE '2015-06-20', 661.5940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3719, 2, DATE '2011-07-28', 109.9501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3720, 2, DATE '2013-09-05', 903.3609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3721, 6, DATE '2014-03-19', 698.4565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3722, 6, DATE '2011-04-29', 609.3473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3723, 9, DATE '2012-12-26', 907.3881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3724, 10, DATE '2012-09-04', 686.2782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3725, 4, DATE '2015-07-25', 440.3091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3726, 1, DATE '2012-11-16', 727.5422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3727, 1, DATE '2011-12-27', 302.1879);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3728, 9, DATE '2013-07-14', 125.2674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3729, 1, DATE '2015-03-17', 626.4251);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3730, 7, DATE '2014-11-29', 869.2531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3731, 4, DATE '2015-01-25', 309.8914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3732, 5, DATE '2015-08-02', 347.8591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3733, 8, DATE '2013-09-08', 331.7835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3734, 4, DATE '2012-10-09', 394.6134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3735, 8, DATE '2015-03-30', 901.5437);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3736, 10, DATE '2014-06-01', 446.7734);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3737, 3, DATE '2012-01-30', 197.9548);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3738, 9, DATE '2015-09-10', 37.6129);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3739, 10, DATE '2015-10-02', 924.1674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3740, 9, DATE '2014-09-29', 657.8495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3741, 5, DATE '2011-03-23', 613.6965);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3742, 9, DATE '2014-03-22', 483.7043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3743, 1, DATE '2014-08-13', 442.9357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3744, 1, DATE '2015-09-10', 843.9358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3745, 9, DATE '2011-09-14', 382.4144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3746, 8, DATE '2011-10-01', 502.8894);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3747, 10, DATE '2015-04-28', 774.9051);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3748, 3, DATE '2012-12-26', 577.3129);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3749, 6, DATE '2013-01-30', 238.9834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3750, 3, DATE '2011-06-03', 869.3150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3751, 3, DATE '2011-08-17', 44.1999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3752, 10, DATE '2013-11-10', 199.0118);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3753, 9, DATE '2013-11-30', 270.8888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3754, 8, DATE '2013-09-25', 341.5628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3755, 10, DATE '2015-06-15', 839.4929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3756, 2, DATE '2013-08-30', 955.4769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3757, 10, DATE '2013-01-22', 876.9089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3758, 1, DATE '2015-01-31', 617.3616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3759, 6, DATE '2014-12-19', 52.2651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3760, 3, DATE '2011-03-26', 828.8925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3761, 3, DATE '2015-07-05', 548.7293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3762, 2, DATE '2015-05-18', 599.1792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3763, 7, DATE '2011-09-16', 619.8246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3764, 2, DATE '2014-12-17', 484.2145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3765, 10, DATE '2014-02-05', 251.0049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3766, 5, DATE '2012-02-22', 22.8246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3767, 2, DATE '2014-06-22', 225.6353);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3768, 1, DATE '2013-11-01', 42.0431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3769, 2, DATE '2015-03-23', 517.8322);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3770, 6, DATE '2015-04-13', 158.1590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3771, 9, DATE '2015-03-14', 866.9153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3772, 9, DATE '2014-07-03', 597.0981);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3773, 2, DATE '2015-09-19', 737.4266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3774, 3, DATE '2012-10-28', 452.1007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3775, 7, DATE '2013-06-15', 289.6643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3776, 8, DATE '2015-12-28', 214.7521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3777, 6, DATE '2012-09-15', 166.4116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3778, 9, DATE '2013-04-17', 63.4522);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3779, 1, DATE '2011-12-22', 303.8637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3780, 6, DATE '2014-10-25', 937.4198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3781, 1, DATE '2013-07-22', 952.6371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3782, 9, DATE '2014-12-31', 724.8750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3783, 3, DATE '2011-06-14', 886.2840);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3784, 8, DATE '2014-10-14', 757.1101);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3785, 5, DATE '2014-04-15', 825.0532);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3786, 4, DATE '2012-03-16', 110.8795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3787, 6, DATE '2012-09-01', 76.9702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3788, 10, DATE '2015-12-15', 990.2207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3789, 4, DATE '2013-04-26', 555.1205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3790, 7, DATE '2012-07-31', 946.0669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3791, 10, DATE '2012-05-10', 569.8645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3792, 3, DATE '2012-12-30', 580.5932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3793, 4, DATE '2011-09-23', 985.3478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3794, 8, DATE '2015-07-09', 95.2748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3795, 6, DATE '2015-03-28', 109.1202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3796, 4, DATE '2011-11-05', 14.5173);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3797, 2, DATE '2013-07-07', 863.8798);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3798, 10, DATE '2015-08-28', 958.7213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3799, 1, DATE '2012-08-05', 592.9309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3800, 5, DATE '2015-07-24', 359.5898);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3801, 7, DATE '2013-04-10', 277.2540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3802, 9, DATE '2012-06-26', 732.8619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3803, 1, DATE '2013-10-06', 59.4807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3804, 1, DATE '2013-10-19', 80.8244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3805, 5, DATE '2012-03-22', 2.3997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3806, 5, DATE '2013-02-13', 447.1018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3807, 8, DATE '2014-02-22', 461.5853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3808, 7, DATE '2012-02-03', 818.7882);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3809, 1, DATE '2011-04-13', 51.8985);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3810, 2, DATE '2015-06-19', 624.7407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3811, 6, DATE '2011-12-15', 789.0653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3812, 1, DATE '2015-10-07', 813.4567);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3813, 10, DATE '2014-02-09', 313.4979);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3814, 10, DATE '2011-02-24', 114.8454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3815, 2, DATE '2013-09-03', 876.2555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3816, 4, DATE '2011-07-05', 823.8543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3817, 9, DATE '2014-12-05', 712.8952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3818, 10, DATE '2012-12-02', 862.7146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3819, 7, DATE '2011-09-04', 659.1613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3820, 7, DATE '2012-11-21', 140.1254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3821, 9, DATE '2015-06-22', 945.8545);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3822, 2, DATE '2014-07-08', 235.4146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3823, 8, DATE '2011-07-08', 486.9227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3824, 5, DATE '2013-08-22', 571.7653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3825, 6, DATE '2013-12-04', 588.2945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3826, 6, DATE '2013-03-15', 286.3221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3827, 5, DATE '2013-10-11', 611.7503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3828, 5, DATE '2011-03-13', 642.1517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3829, 7, DATE '2013-08-03', 342.9804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3830, 4, DATE '2012-08-10', 275.1470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3831, 7, DATE '2013-06-22', 350.8724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3832, 7, DATE '2013-01-19', 207.6903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3833, 9, DATE '2011-09-13', 470.5214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3834, 7, DATE '2012-05-31', 944.2740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3835, 10, DATE '2012-07-17', 660.1657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3836, 3, DATE '2012-01-26', 219.7752);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3837, 9, DATE '2012-03-27', 665.3943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3838, 3, DATE '2013-08-26', 805.4596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3839, 3, DATE '2013-07-25', 754.7104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3840, 1, DATE '2012-03-01', 377.9514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3841, 6, DATE '2014-01-23', 649.2943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3842, 10, DATE '2011-07-31', 258.1820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3843, 10, DATE '2015-09-04', 938.3222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3844, 3, DATE '2013-11-08', 930.3798);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3845, 1, DATE '2011-08-18', 157.0016);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3846, 9, DATE '2012-08-04', 756.4079);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3847, 3, DATE '2014-11-20', 267.0953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3848, 4, DATE '2011-07-30', 870.5024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3849, 6, DATE '2012-11-05', 219.0194);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3850, 3, DATE '2014-09-23', 285.2660);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3851, 5, DATE '2012-12-01', 301.6222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3852, 3, DATE '2011-08-06', 1.1652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3853, 3, DATE '2014-12-25', 299.5599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3854, 5, DATE '2015-09-14', 452.8055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3855, 7, DATE '2011-02-02', 413.7354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3856, 5, DATE '2014-10-03', 41.8394);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3857, 2, DATE '2011-12-21', 245.9392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3858, 6, DATE '2011-02-15', 487.7154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3859, 5, DATE '2015-11-16', 492.5300);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3860, 9, DATE '2015-01-08', 716.0776);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3861, 10, DATE '2015-05-06', 835.3516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3862, 4, DATE '2013-12-13', 819.4336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3863, 10, DATE '2014-07-02', 475.8077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3864, 7, DATE '2014-09-02', 776.7516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3865, 6, DATE '2012-12-27', 273.8683);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3866, 10, DATE '2014-11-26', 581.3749);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3867, 3, DATE '2015-01-24', 342.9352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3868, 4, DATE '2012-09-11', 369.2239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3869, 10, DATE '2014-08-10', 454.6797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3870, 10, DATE '2012-08-09', 656.4802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3871, 6, DATE '2015-04-10', 158.4599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3872, 7, DATE '2012-04-10', 907.4357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3873, 7, DATE '2015-05-11', 108.0041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3874, 6, DATE '2015-07-05', 281.2099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3875, 1, DATE '2014-10-30', 490.8312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3876, 9, DATE '2014-11-22', 687.6724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3877, 3, DATE '2014-11-04', 297.0925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3878, 6, DATE '2013-08-30', 556.5429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3879, 4, DATE '2013-01-04', 414.7637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3880, 8, DATE '2012-05-01', 831.8866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3881, 4, DATE '2014-04-25', 19.2268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3882, 2, DATE '2013-03-14', 741.2480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3883, 10, DATE '2014-05-08', 423.1323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3884, 5, DATE '2014-11-11', 57.7144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3885, 10, DATE '2015-09-09', 973.5248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3886, 5, DATE '2012-11-17', 349.7072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3887, 4, DATE '2014-01-26', 908.1305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3888, 4, DATE '2011-12-30', 17.7159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3889, 10, DATE '2012-04-28', 530.5386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3890, 5, DATE '2013-10-14', 618.3263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3891, 1, DATE '2011-02-06', 973.8361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3892, 3, DATE '2012-02-10', 177.6789);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3893, 8, DATE '2013-10-10', 312.9296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3894, 4, DATE '2014-07-17', 38.6327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3895, 2, DATE '2012-10-27', 542.5999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3896, 3, DATE '2011-02-10', 829.8607);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3897, 1, DATE '2013-01-28', 782.3744);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3898, 3, DATE '2012-01-02', 161.5705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3899, 7, DATE '2011-11-12', 656.5115);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3900, 2, DATE '2012-09-22', 575.6268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3901, 6, DATE '2013-07-11', 413.4726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3902, 10, DATE '2013-03-10', 897.8714);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3903, 4, DATE '2012-12-20', 415.8227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3904, 6, DATE '2011-03-29', 562.5393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3905, 7, DATE '2015-06-15', 126.8060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3906, 9, DATE '2011-08-24', 394.1866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3907, 7, DATE '2012-03-27', 893.1611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3908, 8, DATE '2015-06-22', 18.3499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3909, 4, DATE '2011-11-16', 961.9743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3910, 8, DATE '2012-03-12', 726.0630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3911, 3, DATE '2015-11-30', 744.7470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3912, 7, DATE '2014-04-22', 689.3963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3913, 2, DATE '2014-02-10', 72.9516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3914, 8, DATE '2014-07-17', 660.6434);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3915, 6, DATE '2011-09-16', 696.8508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3916, 8, DATE '2013-02-21', 94.1035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3917, 5, DATE '2015-08-07', 396.3013);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3918, 5, DATE '2015-08-22', 418.0932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3919, 8, DATE '2014-12-25', 803.2268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3920, 2, DATE '2011-02-10', 924.1611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3921, 7, DATE '2011-10-31', 673.2444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3922, 10, DATE '2014-01-26', 325.2193);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3923, 4, DATE '2011-05-16', 838.6854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3924, 5, DATE '2011-10-28', 836.3535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3925, 10, DATE '2012-07-04', 682.6442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3926, 3, DATE '2014-02-28', 980.7810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3927, 9, DATE '2014-07-02', 594.5060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3928, 3, DATE '2011-10-25', 69.3713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3929, 4, DATE '2013-09-08', 738.6101);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3930, 9, DATE '2014-09-19', 660.9705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3931, 9, DATE '2012-10-25', 905.2981);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3932, 10, DATE '2013-11-02', 135.5219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3933, 9, DATE '2012-10-19', 900.0315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3934, 3, DATE '2011-04-15', 839.1369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3935, 2, DATE '2014-10-22', 418.4139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3936, 4, DATE '2012-02-15', 121.3554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3937, 8, DATE '2011-03-26', 325.4253);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3938, 4, DATE '2014-02-09', 860.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3939, 9, DATE '2015-05-30', 930.9085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3940, 1, DATE '2015-01-17', 579.3382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3941, 9, DATE '2011-08-23', 456.5462);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3942, 6, DATE '2014-08-06', 889.7805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3943, 10, DATE '2011-02-14', 55.7416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3944, 3, DATE '2011-02-17', 804.4756);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3945, 3, DATE '2013-11-15', 873.5793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3946, 5, DATE '2012-10-16', 284.4397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3947, 1, DATE '2013-12-31', 104.7272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3948, 1, DATE '2015-03-26', 652.2862);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3949, 8, DATE '2013-11-01', 341.7820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3950, 5, DATE '2015-09-05', 448.4963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3951, 8, DATE '2011-07-06', 433.5594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3952, 7, DATE '2013-06-09', 364.2811);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3953, 5, DATE '2013-01-08', 358.3438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3954, 6, DATE '2011-10-02', 732.3504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3955, 5, DATE '2011-11-23', 902.3824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3956, 7, DATE '2015-06-16', 88.2533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3957, 7, DATE '2012-10-26', 59.1860);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3958, 9, DATE '2012-02-24', 579.4693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3959, 7, DATE '2014-09-25', 879.8951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3960, 4, DATE '2012-04-16', 146.0250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3961, 1, DATE '2013-02-21', 799.6806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3962, 4, DATE '2011-06-03', 823.7897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3963, 5, DATE '2012-10-14', 279.7399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3964, 6, DATE '2013-02-27', 301.0038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3965, 10, DATE '2015-05-19', 820.7650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3966, 3, DATE '2013-01-27', 609.2251);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3967, 9, DATE '2012-07-04', 789.3648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3968, 9, DATE '2013-10-28', 233.8148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3969, 7, DATE '2015-09-26', 242.2294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3970, 3, DATE '2015-08-01', 575.4954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3971, 10, DATE '2012-11-29', 768.6783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3972, 1, DATE '2012-06-28', 535.7083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3973, 7, DATE '2011-03-26', 487.1848);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3974, 8, DATE '2015-12-08', 223.8885);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3975, 4, DATE '2015-06-21', 467.6149);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3976, 2, DATE '2013-03-27', 783.4639);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3977, 10, DATE '2013-12-13', 269.4777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3978, 1, DATE '2011-03-29', 34.2097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3979, 3, DATE '2013-12-12', 962.7742);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3980, 5, DATE '2015-09-18', 398.2044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3981, 2, DATE '2011-03-01', 876.0538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3982, 8, DATE '2015-04-08', 942.2198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3983, 5, DATE '2013-12-24', 727.5894);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3984, 10, DATE '2014-01-03', 290.1138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3985, 1, DATE '2014-03-16', 227.4110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3986, 3, DATE '2015-05-18', 541.0169);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3987, 6, DATE '2011-10-25', 777.1781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3988, 3, DATE '2012-01-18', 167.6810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3989, 9, DATE '2015-05-23', 936.7546);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3990, 5, DATE '2015-05-09', 330.1606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3991, 7, DATE '2015-04-22', 62.1693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3992, 9, DATE '2015-01-30', 745.9561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3993, 8, DATE '2015-05-18', 980.6980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3994, 5, DATE '2014-02-12', 784.8834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3995, 10, DATE '2012-11-25', 779.6577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3996, 5, DATE '2011-03-22', 632.7565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3997, 2, DATE '2012-10-22', 610.0406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3998, 5, DATE '2013-12-17', 754.7378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (3999, 4, DATE '2011-10-02', 983.7107);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4000, 1, DATE '2011-10-19', 264.3542);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4001, 7, DATE '2011-04-15', 495.0750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4002, 2, DATE '2011-03-05', 870.9125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4003, 4, DATE '2015-06-30', 410.0568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4004, 6, DATE '2014-04-03', 766.2867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4005, 5, DATE '2013-10-07', 679.8180);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4006, 8, DATE '2015-01-08', 897.8512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4007, 1, DATE '2013-03-17', 877.0963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4008, 8, DATE '2013-01-31', 134.4552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4009, 3, DATE '2012-04-13', 264.7355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4010, 4, DATE '2014-08-29', 118.9184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4011, 8, DATE '2012-07-03', 818.7757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4012, 7, DATE '2012-07-30', 24.9763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4013, 7, DATE '2014-03-14', 616.6951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4014, 2, DATE '2015-01-07', 481.6907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4015, 2, DATE '2012-02-17', 269.9713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4016, 3, DATE '2013-11-15', 857.4608);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4017, 9, DATE '2013-06-10', 96.2003);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4018, 6, DATE '2014-10-12', 989.6261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4019, 6, DATE '2014-12-14', 73.5928);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4020, 8, DATE '2011-01-01', 279.7480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4021, 7, DATE '2012-04-04', 832.0470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4022, 6, DATE '2011-06-18', 621.6838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4023, 1, DATE '2014-06-08', 297.0602);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4024, 3, DATE '2011-05-21', 912.0688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4025, 6, DATE '2011-04-11', 513.3260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4026, 2, DATE '2013-10-30', 22.7222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4027, 3, DATE '2013-02-11', 555.0104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4028, 2, DATE '2013-02-10', 702.3014);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4029, 8, DATE '2014-01-13', 444.2309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4030, 9, DATE '2015-04-01', 834.8585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4031, 10, DATE '2011-06-05', 173.4233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4032, 5, DATE '2015-12-27', 514.7399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4033, 8, DATE '2015-06-28', 50.4991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4034, 2, DATE '2013-02-24', 698.4199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4035, 9, DATE '2015-06-06', 903.1295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4036, 10, DATE '2015-12-27', 5.1412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4037, 4, DATE '2015-10-10', 532.1630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4038, 10, DATE '2015-09-23', 961.3027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4039, 5, DATE '2011-03-30', 610.2958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4040, 4, DATE '2015-03-08', 329.5599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4041, 3, DATE '2013-03-02', 663.9207);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4042, 9, DATE '2014-09-23', 642.7229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4043, 1, DATE '2015-10-06', 902.9456);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4044, 5, DATE '2011-09-25', 817.8361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4045, 7, DATE '2013-11-05', 511.3850);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4046, 1, DATE '2013-09-23', 37.1930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4047, 3, DATE '2011-11-19', 129.2609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4048, 7, DATE '2011-05-11', 499.0073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4049, 3, DATE '2012-12-27', 514.9120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4050, 7, DATE '2015-01-10', 922.1969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4051, 6, DATE '2013-10-12', 536.5561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4052, 6, DATE '2014-01-11', 620.4145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4053, 10, DATE '2015-01-04', 681.1449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4054, 6, DATE '2011-10-01', 703.9626);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4055, 4, DATE '2015-07-16', 432.3072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4056, 1, DATE '2015-10-28', 873.3912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4057, 2, DATE '2012-09-27', 573.8522);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4058, 2, DATE '2015-02-10', 497.9881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4059, 10, DATE '2013-12-23', 252.9606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4060, 4, DATE '2015-12-08', 657.0958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4061, 5, DATE '2012-11-27', 342.8407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4062, 9, DATE '2011-02-05', 174.7948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4063, 10, DATE '2015-01-19', 690.2243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4064, 4, DATE '2013-01-12', 429.8771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4065, 4, DATE '2014-03-26', 945.4952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4066, 4, DATE '2012-07-08', 304.0357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4067, 9, DATE '2013-02-02', 974.4773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4068, 6, DATE '2012-01-19', 918.2753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4069, 3, DATE '2015-08-04', 578.5612);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4070, 2, DATE '2012-02-21', 264.8301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4071, 10, DATE '2014-02-06', 325.2978);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4072, 10, DATE '2013-09-17', 134.8977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4073, 1, DATE '2014-07-16', 379.3303);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4074, 2, DATE '2015-10-08', 744.0330);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4075, 6, DATE '2013-10-31', 615.8274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4076, 9, DATE '2013-07-12', 189.3241);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4077, 6, DATE '2011-09-13', 718.7382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4078, 7, DATE '2013-09-13', 479.2242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4079, 7, DATE '2013-07-16', 400.6837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4080, 6, DATE '2013-07-19', 476.1330);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4081, 9, DATE '2012-12-11', 893.4614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4082, 7, DATE '2012-10-03', 56.0031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4083, 9, DATE '2011-02-14', 187.3894);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4084, 1, DATE '2015-01-03', 522.0341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4085, 3, DATE '2012-06-20', 298.3023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4086, 5, DATE '2013-05-25', 553.0088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4087, 6, DATE '2011-12-24', 833.5950);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4088, 2, DATE '2014-09-27', 346.5365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4089, 8, DATE '2013-08-11', 266.1126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4090, 9, DATE '2015-08-09', 29.7382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4091, 9, DATE '2014-04-01', 431.2890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4092, 3, DATE '2011-08-30', 34.1748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4093, 10, DATE '2012-09-30', 708.3420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4094, 2, DATE '2011-04-22', 953.2000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4095, 10, DATE '2013-04-11', 986.7192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4096, 4, DATE '2013-01-26', 489.1258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4097, 10, DATE '2015-09-05', 952.4986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4098, 7, DATE '2013-09-23', 473.0685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4099, 2, DATE '2013-07-02', 872.3409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4100, 4, DATE '2012-04-29', 207.3493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4101, 2, DATE '2011-08-22', 62.7158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4102, 8, DATE '2015-11-01', 210.9856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4103, 4, DATE '2011-10-08', 920.4461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4104, 1, DATE '2011-11-07', 250.0819);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4105, 8, DATE '2011-12-04', 596.8991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4106, 7, DATE '2011-01-25', 401.6584);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4107, 6, DATE '2015-06-29', 241.0842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4108, 8, DATE '2015-03-29', 937.1120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4109, 1, DATE '2013-11-30', 88.1352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4110, 6, DATE '2013-01-03', 242.9831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4111, 5, DATE '2015-02-15', 154.6529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4112, 6, DATE '2015-01-14', 94.6279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4113, 6, DATE '2012-07-27', 97.3043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4114, 4, DATE '2011-06-07', 776.8277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4115, 5, DATE '2013-12-27', 763.6345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4116, 8, DATE '2011-02-25', 286.8376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4117, 1, DATE '2015-12-22', 987.4055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4118, 9, DATE '2011-01-17', 168.1902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4119, 1, DATE '2011-07-26', 131.5747);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4120, 10, DATE '2011-11-01', 392.4864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4121, 8, DATE '2011-07-17', 470.4407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4122, 8, DATE '2014-05-08', 627.9407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4123, 8, DATE '2014-06-09', 652.1626);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4124, 5, DATE '2015-12-26', 548.8229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4125, 4, DATE '2013-11-22', 833.5411);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4126, 7, DATE '2013-06-09', 291.1229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4127, 10, DATE '2011-12-18', 426.5557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4128, 9, DATE '2014-03-26', 426.1303);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4129, 3, DATE '2013-06-29', 757.3138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4130, 2, DATE '2011-10-06', 126.7015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4131, 10, DATE '2013-11-07', 236.8255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4132, 10, DATE '2013-12-20', 245.6697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4133, 5, DATE '2011-03-15', 606.8834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4134, 3, DATE '2012-03-19', 193.3344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4135, 4, DATE '2012-11-28', 413.4172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4136, 2, DATE '2013-02-10', 682.4757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4137, 3, DATE '2011-12-27', 135.5570);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4138, 8, DATE '2015-04-10', 937.3075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4139, 4, DATE '2014-01-30', 925.1350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4140, 7, DATE '2012-05-27', 896.6439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4141, 9, DATE '2013-11-27', 311.9246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4142, 8, DATE '2012-09-27', 896.4831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4143, 1, DATE '2011-10-29', 258.4013);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4144, 3, DATE '2011-08-09', 23.1294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4145, 4, DATE '2011-06-24', 875.0853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4146, 4, DATE '2015-03-18', 336.6611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4147, 7, DATE '2015-02-03', 936.8706);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4148, 6, DATE '2012-04-26', 931.5144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4149, 8, DATE '2013-04-25', 189.5655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4150, 2, DATE '2013-02-15', 699.8815);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4151, 4, DATE '2013-02-04', 501.7203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4152, 1, DATE '2015-08-20', 784.3084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4153, 6, DATE '2013-03-01', 341.4937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4154, 2, DATE '2012-08-31', 479.8544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4155, 6, DATE '2011-10-15', 736.9087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4156, 5, DATE '2013-04-15', 434.7751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4157, 1, DATE '2012-05-25', 558.8231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4158, 10, DATE '2011-10-13', 371.6231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4159, 8, DATE '2013-12-16', 416.5409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4160, 1, DATE '2014-06-26', 305.7761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4161, 7, DATE '2015-02-07', 975.1028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4162, 7, DATE '2012-04-04', 814.9539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4163, 6, DATE '2012-09-29', 179.7981);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4164, 9, DATE '2013-02-25', 961.4337);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4165, 7, DATE '2015-02-26', 6.1576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4166, 6, DATE '2012-02-26', 908.9833);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4167, 1, DATE '2014-11-01', 487.7446);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4168, 3, DATE '2011-05-11', 903.9700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4169, 1, DATE '2014-07-09', 363.4104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4170, 3, DATE '2011-11-17', 81.1587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4171, 6, DATE '2015-03-01', 151.2805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4172, 3, DATE '2011-09-14', 50.0980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4173, 6, DATE '2012-12-17', 243.0552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4174, 5, DATE '2015-02-28', 234.9308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4175, 1, DATE '2013-12-05', 80.5618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4176, 10, DATE '2014-10-19', 573.9577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4177, 7, DATE '2013-07-10', 369.5393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4178, 6, DATE '2013-11-01', 629.0331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4179, 2, DATE '2015-07-04', 673.7376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4180, 10, DATE '2014-09-06', 496.8800);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4181, 10, DATE '2014-05-07', 354.2523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4182, 4, DATE '2015-08-24', 495.0413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4183, 2, DATE '2011-12-01', 236.5647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4184, 1, DATE '2011-05-15', 57.4323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4185, 9, DATE '2014-08-31', 624.9813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4186, 9, DATE '2014-03-21', 452.5172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4187, 5, DATE '2011-10-22', 904.1760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4188, 3, DATE '2014-07-15', 127.0290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4189, 8, DATE '2011-06-05', 456.4258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4190, 9, DATE '2015-08-15', 978.6421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4191, 2, DATE '2011-09-19', 123.6526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4192, 4, DATE '2011-03-17', 763.9339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4193, 1, DATE '2012-04-25', 520.7665);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4194, 3, DATE '2015-08-06', 619.3589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4195, 10, DATE '2013-04-20', 921.5412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4196, 2, DATE '2012-08-24', 496.9707);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4197, 3, DATE '2015-12-29', 716.6849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4198, 2, DATE '2014-09-02', 296.9677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4199, 6, DATE '2012-06-12', 16.9718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4200, 8, DATE '2015-04-29', 966.1021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4201, 4, DATE '2011-05-18', 848.9166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4202, 5, DATE '2014-09-25', 32.9006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4203, 6, DATE '2013-10-18', 568.1039);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4204, 5, DATE '2012-06-09', 108.4067);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4205, 7, DATE '2013-12-17', 548.6009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4206, 2, DATE '2012-05-24', 451.6223);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4207, 6, DATE '2013-09-02', 541.2531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4208, 1, DATE '2014-01-01', 106.5629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4209, 1, DATE '2014-09-26', 399.2925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4210, 7, DATE '2012-12-26', 162.9510);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4211, 9, DATE '2015-10-07', 65.2358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4212, 5, DATE '2014-07-24', 929.7900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4213, 9, DATE '2012-04-11', 697.8856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4214, 8, DATE '2015-04-11', 919.6610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4215, 2, DATE '2011-02-20', 951.5238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4216, 4, DATE '2015-06-16', 480.0614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4217, 6, DATE '2011-05-06', 578.3891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4218, 5, DATE '2012-05-18', 122.3658);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4219, 1, DATE '2014-06-27', 336.4524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4220, 9, DATE '2011-12-09', 553.6404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4221, 2, DATE '2011-05-08', 4.8072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4222, 8, DATE '2011-04-19', 360.7155);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4223, 6, DATE '2015-12-06', 447.5441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4224, 2, DATE '2014-11-25', 384.7684);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4225, 2, DATE '2011-03-01', 957.5062);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4226, 2, DATE '2014-12-16', 387.3466);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4227, 3, DATE '2015-05-22', 529.3316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4228, 4, DATE '2013-05-13', 623.6964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4229, 5, DATE '2012-11-10', 313.3896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4230, 10, DATE '2012-04-13', 583.5912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4231, 7, DATE '2014-10-22', 857.2728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4232, 5, DATE '2014-11-08', 72.5716);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4233, 10, DATE '2012-05-22', 612.0613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4234, 4, DATE '2011-03-08', 707.6355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4235, 7, DATE '2014-04-22', 647.9634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4236, 6, DATE '2015-08-12', 321.3517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4237, 9, DATE '2012-11-05', 926.9375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4238, 7, DATE '2015-06-23', 128.1579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4239, 5, DATE '2013-05-28', 508.8314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4240, 8, DATE '2013-04-09', 173.3589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4241, 4, DATE '2011-07-19', 911.2641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4242, 4, DATE '2013-10-20', 797.6131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4243, 2, DATE '2015-10-20', 727.7365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4244, 1, DATE '2014-06-10', 293.4747);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4245, 1, DATE '2015-11-09', 913.4062);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4246, 7, DATE '2013-02-25', 193.8627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4247, 6, DATE '2014-12-05', 66.0483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4248, 3, DATE '2013-01-14', 601.1055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4249, 2, DATE '2015-06-17', 667.8351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4250, 7, DATE '2013-11-04', 441.4798);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4251, 7, DATE '2012-04-21', 918.5816);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4252, 9, DATE '2014-08-13', 594.3190);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4253, 2, DATE '2011-03-09', 960.5153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4254, 8, DATE '2011-07-05', 463.3314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4255, 7, DATE '2014-12-22', 961.2949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4256, 6, DATE '2011-01-29', 488.2010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4257, 10, DATE '2014-10-21', 585.3565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4258, 4, DATE '2014-11-24', 183.3354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4259, 4, DATE '2012-04-11', 150.9006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4260, 5, DATE '2015-01-02', 161.2543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4261, 9, DATE '2013-01-02', 922.2908);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4262, 3, DATE '2011-04-23', 917.5568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4263, 7, DATE '2012-02-22', 793.1733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4264, 2, DATE '2013-06-14', 815.7014);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4265, 10, DATE '2014-03-07', 305.6782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4266, 4, DATE '2011-11-29', 992.6643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4267, 6, DATE '2013-03-04', 317.7287);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4268, 5, DATE '2012-02-04', 990.2501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4269, 2, DATE '2011-12-21', 271.6975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4270, 6, DATE '2011-07-12', 630.1721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4271, 5, DATE '2013-08-11', 553.1239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4272, 9, DATE '2011-11-13', 450.2311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4273, 10, DATE '2014-12-21', 613.5345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4274, 4, DATE '2012-03-20', 163.0934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4275, 6, DATE '2011-05-23', 642.3764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4276, 9, DATE '2013-07-18', 207.1942);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4277, 6, DATE '2011-07-01', 632.9791);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4278, 5, DATE '2012-06-28', 154.0694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4279, 2, DATE '2015-01-17', 471.3622);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4280, 5, DATE '2014-01-03', 763.6435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4281, 7, DATE '2011-01-11', 321.2983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4282, 1, DATE '2013-05-08', 928.2261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4283, 3, DATE '2013-11-27', 955.8613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4284, 8, DATE '2015-01-07', 871.9099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4285, 4, DATE '2015-12-24', 665.0096);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4286, 9, DATE '2011-03-11', 262.9537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4287, 4, DATE '2014-09-01', 112.0563);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4288, 3, DATE '2011-11-18', 148.7298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4289, 8, DATE '2012-03-17', 746.3407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4290, 2, DATE '2014-03-24', 159.7624);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4291, 6, DATE '2011-10-23', 735.9952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4292, 5, DATE '2013-12-13', 743.6020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4293, 4, DATE '2014-03-14', 977.2574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4294, 1, DATE '2014-05-26', 347.5771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4295, 9, DATE '2011-04-07', 251.0682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4296, 2, DATE '2011-03-29', 993.7074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4297, 7, DATE '2012-08-29', 4.4397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4298, 1, DATE '2013-05-07', 912.0351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4299, 2, DATE '2011-04-06', 987.7966);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4300, 7, DATE '2014-12-11', 920.7420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4301, 2, DATE '2015-12-24', 876.1340);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4302, 1, DATE '2013-10-31', 75.7983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4303, 1, DATE '2012-01-25', 329.4080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4304, 6, DATE '2014-12-07', 37.6629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4305, 3, DATE '2011-03-26', 888.3559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4306, 8, DATE '2011-06-09', 468.3505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4307, 9, DATE '2015-08-24', 980.7846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4308, 8, DATE '2014-12-19', 797.4219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4309, 3, DATE '2011-02-12', 820.9551);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4310, 9, DATE '2012-06-05', 754.1007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4311, 10, DATE '2015-08-01', 855.2219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4312, 5, DATE '2013-04-24', 431.2871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4313, 3, DATE '2015-11-08', 711.9733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4314, 10, DATE '2014-04-08', 387.2572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4315, 8, DATE '2014-12-23', 839.9560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4316, 9, DATE '2015-08-28', 994.0648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4317, 10, DATE '2013-05-26', 961.6955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4318, 10, DATE '2013-02-15', 921.2634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4319, 9, DATE '2013-06-22', 150.6918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4320, 2, DATE '2013-12-27', 42.7244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4321, 1, DATE '2013-03-29', 880.6080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4322, 4, DATE '2012-04-16', 168.9989);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4323, 8, DATE '2015-11-20', 243.9093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4324, 10, DATE '2013-09-29', 111.9350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4325, 10, DATE '2015-09-19', 894.1769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4326, 1, DATE '2015-08-30', 809.5220);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4327, 6, DATE '2013-09-01', 472.9738);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4328, 10, DATE '2011-07-29', 265.9574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4329, 5, DATE '2011-12-15', 912.0252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4330, 5, DATE '2011-02-25', 648.6691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4331, 2, DATE '2011-11-20', 202.7544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4332, 6, DATE '2014-02-23', 720.9440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4333, 4, DATE '2012-03-25', 166.2728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4334, 5, DATE '2011-02-06', 550.6203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4335, 4, DATE '2014-01-11', 887.5095);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4336, 7, DATE '2013-03-12', 245.4999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4337, 10, DATE '2012-04-13', 598.8181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4338, 7, DATE '2014-12-22', 918.1983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4339, 6, DATE '2014-10-14', 983.5541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4340, 7, DATE '2015-07-17', 196.6591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4341, 10, DATE '2011-07-19', 282.1692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4342, 6, DATE '2015-09-14', 314.6344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4343, 10, DATE '2011-10-06', 327.7747);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4344, 10, DATE '2015-10-12', 992.2401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4345, 2, DATE '2014-08-24', 304.5406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4346, 1, DATE '2014-06-30', 304.7081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4347, 3, DATE '2014-02-05', 31.6287);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4348, 4, DATE '2015-12-06', 590.0002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4349, 3, DATE '2015-06-03', 507.6211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4350, 10, DATE '2011-08-10', 257.0035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4351, 2, DATE '2013-11-02', 32.0118);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4352, 8, DATE '2015-07-14', 83.1763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4353, 2, DATE '2015-11-15', 761.3433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4354, 10, DATE '2013-04-09', 945.0721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4355, 7, DATE '2012-09-13', 40.1340);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4356, 8, DATE '2014-09-08', 707.1351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4357, 4, DATE '2013-12-12', 831.8890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4358, 2, DATE '2014-04-28', 217.4729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4359, 6, DATE '2015-03-20', 143.4861);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4360, 2, DATE '2011-07-28', 78.8339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4361, 2, DATE '2013-10-08', 995.3768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4362, 10, DATE '2015-01-27', 714.8272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4363, 4, DATE '2014-01-05', 885.3967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4364, 9, DATE '2015-12-19', 172.2860);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4365, 7, DATE '2011-07-17', 551.3462);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4366, 5, DATE '2012-06-07', 134.2778);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4367, 2, DATE '2012-01-31', 265.0142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4368, 8, DATE '2015-10-02', 161.3529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4369, 6, DATE '2011-03-29', 499.7477);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4370, 2, DATE '2012-10-13', 594.4561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4371, 10, DATE '2014-05-17', 395.2467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4372, 4, DATE '2014-06-05', 43.4971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4373, 4, DATE '2014-05-05', 937.7094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4374, 3, DATE '2013-12-06', 954.0328);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4375, 3, DATE '2013-06-11', 760.5553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4376, 5, DATE '2013-07-16', 565.9735);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4377, 4, DATE '2011-07-12', 841.2242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4378, 8, DATE '2011-02-08', 251.6692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4379, 9, DATE '2015-02-05', 807.3945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4380, 9, DATE '2012-03-22', 589.4688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4381, 9, DATE '2012-07-25', 777.8932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4382, 3, DATE '2013-09-26', 882.9736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4383, 8, DATE '2012-02-25', 758.3363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4384, 5, DATE '2011-05-07', 655.0217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4385, 4, DATE '2013-04-24', 616.6572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4386, 5, DATE '2012-05-09', 119.5780);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4387, 4, DATE '2014-04-11', 959.6008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4388, 4, DATE '2014-12-17', 221.2008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4389, 9, DATE '2014-05-26', 510.4863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4390, 6, DATE '2015-05-05', 180.3743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4391, 3, DATE '2015-04-01', 413.6109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4392, 9, DATE '2013-12-17', 381.3451);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4393, 2, DATE '2015-10-05', 774.7122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4394, 4, DATE '2014-03-19', 904.7202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4395, 6, DATE '2012-10-09', 201.2823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4396, 1, DATE '2012-06-22', 567.3420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4397, 3, DATE '2012-09-09', 429.2378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4398, 2, DATE '2011-10-19', 155.4887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4399, 3, DATE '2015-03-29', 440.8939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4400, 8, DATE '2013-03-19', 170.2627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4401, 10, DATE '2013-05-31', 39.6938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4402, 5, DATE '2014-05-06', 870.2758);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4403, 8, DATE '2015-09-09', 90.2525);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4404, 2, DATE '2013-08-21', 913.1651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4405, 1, DATE '2013-03-26', 861.7569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4406, 8, DATE '2015-05-31', 988.5148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4407, 4, DATE '2012-03-11', 145.4670);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4408, 10, DATE '2012-12-09', 807.3105);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4409, 8, DATE '2015-10-30', 184.5167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4410, 2, DATE '2015-03-01', 474.1605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4411, 4, DATE '2014-02-28', 865.9110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4412, 6, DATE '2013-11-03', 580.2198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4413, 3, DATE '2015-03-23', 410.0785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4414, 7, DATE '2013-12-28', 554.0174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4415, 4, DATE '2015-01-03', 300.9407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4416, 10, DATE '2011-01-12', 112.4031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4417, 3, DATE '2013-12-03', 956.4909);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4418, 9, DATE '2013-08-31', 230.3750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4419, 6, DATE '2013-08-26', 555.6288);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4420, 3, DATE '2015-03-10', 431.7682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4421, 1, DATE '2014-02-26', 174.6770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4422, 9, DATE '2013-02-14', 43.8134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4423, 9, DATE '2012-05-09', 650.8667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4424, 1, DATE '2011-11-25', 319.3733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4425, 9, DATE '2013-07-15', 180.8451);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4426, 2, DATE '2011-06-01', 13.9015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4427, 2, DATE '2014-09-01', 268.7849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4428, 1, DATE '2011-02-16', 32.9891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4429, 8, DATE '2012-02-28', 752.7504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4430, 2, DATE '2011-12-20', 193.2132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4431, 3, DATE '2011-11-06', 136.7357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4432, 3, DATE '2015-09-24', 685.7354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4433, 6, DATE '2011-11-13', 810.7754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4434, 2, DATE '2012-11-19', 637.1317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4435, 10, DATE '2014-10-22', 549.7749);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4436, 4, DATE '2014-03-21', 907.6175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4437, 5, DATE '2014-01-17', 792.7211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4438, 6, DATE '2014-07-06', 845.1713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4439, 5, DATE '2014-02-10', 793.2648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4440, 6, DATE '2013-11-25', 628.1425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4441, 1, DATE '2011-02-28', 974.1110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4442, 4, DATE '2012-05-02', 152.2902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4443, 7, DATE '2015-02-17', 36.6840);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4444, 7, DATE '2015-03-28', 36.3257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4445, 2, DATE '2012-03-06', 314.4634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4446, 8, DATE '2012-05-28', 833.3912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4447, 6, DATE '2014-09-26', 971.2667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4448, 5, DATE '2012-10-07', 220.6948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4449, 1, DATE '2015-03-17', 603.7794);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4450, 7, DATE '2012-09-27', 88.8792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4451, 9, DATE '2014-07-21', 610.8512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4452, 5, DATE '2015-01-10', 198.8628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4453, 7, DATE '2014-02-22', 599.8599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4454, 1, DATE '2011-01-19', 9.1256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4455, 7, DATE '2015-01-21', 995.5858);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4456, 2, DATE '2011-04-17', 995.8805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4457, 6, DATE '2012-12-28', 219.4090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4458, 8, DATE '2014-10-16', 770.8792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4459, 4, DATE '2011-02-07', 732.3199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4460, 9, DATE '2012-10-26', 847.8554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4461, 6, DATE '2011-09-30', 719.7298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4462, 4, DATE '2012-01-25', 112.4778);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4463, 3, DATE '2011-10-13', 54.5601);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4464, 6, DATE '2014-11-10', 991.3035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4465, 10, DATE '2014-04-25', 337.4248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4466, 2, DATE '2014-06-06', 180.1755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4467, 1, DATE '2012-12-21', 769.4444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4468, 2, DATE '2013-05-03', 772.9468);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4469, 7, DATE '2015-03-09', 4.2424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4470, 10, DATE '2011-10-15', 393.3233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4471, 5, DATE '2012-12-25', 319.6820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4472, 7, DATE '2015-05-30', 111.3195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4473, 4, DATE '2015-07-21', 437.1102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4474, 10, DATE '2015-10-02', 927.4864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4475, 2, DATE '2015-01-11', 457.6572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4476, 8, DATE '2012-10-27', 22.3867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4477, 2, DATE '2013-12-28', 7.1293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4478, 3, DATE '2013-02-12', 614.5410);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4479, 9, DATE '2015-09-20', 4.9098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4480, 2, DATE '2012-02-17', 347.4539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4481, 7, DATE '2012-09-04', 42.6348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4482, 8, DATE '2012-11-24', 48.0901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4483, 10, DATE '2011-12-03', 429.2098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4484, 2, DATE '2015-06-02', 663.8712);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4485, 4, DATE '2013-06-01', 582.3621);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4486, 8, DATE '2012-10-27', 937.8729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4487, 6, DATE '2012-08-01', 85.8754);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4488, 6, DATE '2011-10-26', 801.6497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4489, 5, DATE '2013-10-30', 641.5460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4490, 9, DATE '2014-07-08', 553.8945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4491, 9, DATE '2012-03-24', 688.2084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4492, 7, DATE '2015-04-04', 21.8419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4493, 3, DATE '2014-05-29', 112.8513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4494, 6, DATE '2012-04-17', 945.4095);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4495, 10, DATE '2013-02-26', 908.4127);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4496, 8, DATE '2015-02-04', 861.6332);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4497, 2, DATE '2011-07-21', 97.7301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4498, 1, DATE '2011-04-09', 45.3806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4499, 7, DATE '2011-12-03', 698.9010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4500, 10, DATE '2013-10-01', 134.2878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4501, 8, DATE '2015-06-08', 63.9467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4502, 4, DATE '2012-05-25', 198.3199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4503, 9, DATE '2013-08-01', 216.4523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4504, 2, DATE '2014-06-02', 210.4561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4505, 2, DATE '2015-10-03', 769.1972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4506, 2, DATE '2015-02-21', 499.5316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4507, 1, DATE '2015-06-22', 761.7527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4508, 7, DATE '2014-05-24', 672.3736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4509, 9, DATE '2012-01-09', 551.4685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4510, 10, DATE '2013-03-26', 973.1990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4511, 10, DATE '2013-04-20', 988.7512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4512, 4, DATE '2015-11-16', 604.8681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4513, 9, DATE '2015-01-26', 765.9693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4514, 3, DATE '2014-12-22', 384.8659);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4515, 3, DATE '2011-02-21', 805.2205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4516, 9, DATE '2014-11-05', 671.6397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4517, 4, DATE '2011-02-23', 683.2681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4518, 2, DATE '2012-05-12', 390.6890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4519, 2, DATE '2012-06-11', 408.9413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4520, 2, DATE '2012-06-28', 399.5519);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4521, 7, DATE '2012-11-05', 94.3001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4522, 5, DATE '2012-02-27', 967.7947);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4523, 7, DATE '2015-07-05', 131.4008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4524, 9, DATE '2011-09-02', 450.3480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4525, 2, DATE '2015-07-24', 705.1150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4526, 8, DATE '2013-09-23', 297.8401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4527, 5, DATE '2012-01-02', 998.4682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4528, 9, DATE '2014-04-04', 491.7007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4529, 1, DATE '2013-08-05', 19.0737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4530, 4, DATE '2015-12-07', 596.0241);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4531, 6, DATE '2012-04-08', 924.6567);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4532, 2, DATE '2013-09-20', 961.7488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4533, 6, DATE '2012-03-12', 915.6401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4534, 10, DATE '2012-12-20', 870.6221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4535, 4, DATE '2012-09-11', 283.5071);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4536, 3, DATE '2011-04-13', 844.3150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4537, 9, DATE '2015-04-26', 831.6378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4538, 8, DATE '2013-07-02', 218.7536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4539, 10, DATE '2015-08-30', 894.6740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4540, 3, DATE '2014-04-10', 82.8305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4541, 8, DATE '2013-05-08', 176.1202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4542, 9, DATE '2014-03-10', 413.5019);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4543, 7, DATE '2015-10-17', 250.1812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4544, 6, DATE '2011-08-06', 668.3470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4545, 10, DATE '2012-03-19', 565.1433);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4546, 5, DATE '2012-05-09', 83.3402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4547, 9, DATE '2011-03-09', 255.8726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4548, 1, DATE '2015-06-08', 727.9855);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4549, 4, DATE '2012-02-25', 140.1890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4550, 1, DATE '2014-04-23', 236.7729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4551, 5, DATE '2014-12-13', 178.3650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4552, 10, DATE '2015-03-10', 707.0412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4553, 9, DATE '2014-10-29', 636.4393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4554, 5, DATE '2015-06-07', 299.3490);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4555, 4, DATE '2011-11-26', 39.9877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4556, 3, DATE '2014-04-11', 96.1521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4557, 7, DATE '2012-11-20', 66.9190);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4558, 10, DATE '2012-11-29', 766.1044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4559, 1, DATE '2014-11-10', 505.3412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4560, 4, DATE '2013-01-10', 471.3570);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4561, 8, DATE '2014-02-20', 501.0634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4562, 3, DATE '2012-03-19', 270.0519);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4563, 7, DATE '2011-10-19', 653.2998);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4564, 5, DATE '2012-02-02', 955.4445);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4565, 4, DATE '2011-12-18', 48.5423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4566, 9, DATE '2015-07-31', 27.0024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4567, 8, DATE '2014-09-05', 689.2281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4568, 10, DATE '2013-02-06', 895.3473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4569, 9, DATE '2013-04-11', 101.3587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4570, 10, DATE '2015-11-11', 960.9055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4571, 10, DATE '2015-07-12', 840.0020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4572, 6, DATE '2013-08-23', 464.5145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4573, 2, DATE '2012-09-13', 496.0150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4574, 10, DATE '2014-03-03', 326.1108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4575, 5, DATE '2015-02-21', 223.4317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4576, 8, DATE '2014-08-28', 680.7982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4577, 9, DATE '2012-05-12', 717.6135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4578, 2, DATE '2014-11-29', 463.0538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4579, 9, DATE '2015-06-15', 885.2047);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4580, 7, DATE '2014-03-16', 621.7747);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4581, 10, DATE '2013-07-17', 41.9675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4582, 4, DATE '2012-07-27', 270.4827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4583, 5, DATE '2013-02-08', 351.5117);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4584, 10, DATE '2015-04-14', 782.3008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4585, 10, DATE '2011-12-26', 417.6590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4586, 7, DATE '2013-01-29', 217.6154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4587, 3, DATE '2014-11-22', 325.3094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4588, 1, DATE '2012-10-06', 616.2910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4589, 6, DATE '2012-01-26', 830.6343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4590, 2, DATE '2014-06-02', 187.3550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4591, 6, DATE '2014-05-23', 777.3960);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4592, 9, DATE '2013-05-27', 65.5333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4593, 8, DATE '2014-08-22', 713.4125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4594, 7, DATE '2013-08-19', 423.3170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4595, 5, DATE '2011-02-19', 581.7671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4596, 6, DATE '2012-02-19', 906.0683);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4597, 2, DATE '2013-05-22', 760.2021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4598, 2, DATE '2014-09-14', 294.7367);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4599, 3, DATE '2015-08-20', 619.8047);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4600, 2, DATE '2012-08-20', 538.1409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4601, 7, DATE '2013-09-03', 394.1122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4602, 9, DATE '2014-01-31', 360.5253);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4603, 3, DATE '2013-02-26', 626.6267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4604, 4, DATE '2012-04-16', 179.2835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4605, 2, DATE '2014-10-13', 396.7710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4606, 9, DATE '2012-04-21', 713.8506);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4607, 8, DATE '2013-06-27', 211.0262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4608, 10, DATE '2011-08-28', 310.3284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4609, 1, DATE '2011-04-16', 75.9173);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4610, 6, DATE '2013-03-30', 359.1896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4611, 4, DATE '2012-11-29', 378.5386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4612, 6, DATE '2013-12-23', 603.8653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4613, 2, DATE '2013-06-17', 880.8998);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4614, 4, DATE '2011-08-27', 883.5666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4615, 4, DATE '2015-06-27', 429.3895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4616, 4, DATE '2012-07-26', 230.5807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4617, 8, DATE '2015-02-09', 918.5403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4618, 8, DATE '2012-07-07', 870.9991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4619, 6, DATE '2011-02-08', 537.7854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4620, 8, DATE '2014-11-18', 830.9269);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4621, 6, DATE '2011-09-08', 701.6930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4622, 7, DATE '2012-11-30', 72.9370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4623, 4, DATE '2012-01-13', 64.7130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4624, 7, DATE '2014-11-10', 914.0038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4625, 5, DATE '2012-06-21', 183.5095);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4626, 1, DATE '2013-02-14', 774.4686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4627, 9, DATE '2015-01-01', 751.1020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4628, 6, DATE '2015-01-25', 72.6980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4629, 5, DATE '2014-01-12', 744.3438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4630, 9, DATE '2014-01-02', 317.3634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4631, 6, DATE '2012-04-08', 920.5962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4632, 7, DATE '2013-08-29', 422.8767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4633, 9, DATE '2015-04-12', 843.2491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4634, 8, DATE '2013-10-26', 347.0637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4635, 10, DATE '2011-07-13', 227.6624);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4636, 2, DATE '2015-06-16', 681.4422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4637, 2, DATE '2015-06-01', 643.8561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4638, 2, DATE '2011-10-26', 172.2281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4639, 9, DATE '2011-07-03', 385.5297);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4640, 2, DATE '2015-09-05', 703.8085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4641, 9, DATE '2015-08-05', 6.5892);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4642, 3, DATE '2014-03-28', 14.9810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4643, 1, DATE '2012-06-22', 540.3737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4644, 1, DATE '2014-10-28', 471.4447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4645, 8, DATE '2012-07-03', 808.8165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4646, 10, DATE '2011-06-01', 173.5307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4647, 8, DATE '2015-12-11', 184.6336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4648, 4, DATE '2013-12-26', 829.8460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4649, 3, DATE '2014-02-23', 993.9276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4650, 1, DATE '2014-07-26', 351.1864);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4651, 9, DATE '2013-01-10', 987.5281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4652, 5, DATE '2011-11-16', 889.2030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4653, 7, DATE '2014-08-07', 756.9514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4654, 6, DATE '2011-10-02', 788.8779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4655, 6, DATE '2011-12-13', 836.4480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4656, 10, DATE '2011-10-05', 321.1751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4657, 6, DATE '2013-01-19', 295.8123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4658, 7, DATE '2014-04-18', 712.6230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4659, 10, DATE '2015-10-26', 995.7741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4660, 1, DATE '2012-08-28', 622.3025);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4661, 10, DATE '2013-04-20', 962.7486);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4662, 3, DATE '2014-06-03', 138.3281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4663, 5, DATE '2013-08-15', 565.9847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4664, 2, DATE '2013-04-14', 758.5540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4665, 10, DATE '2011-12-23', 438.5934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4666, 8, DATE '2015-04-03', 955.6620);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4667, 8, DATE '2014-09-12', 760.6162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4668, 4, DATE '2015-08-23', 533.8360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4669, 4, DATE '2011-02-15', 655.9041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4670, 3, DATE '2011-01-11', 747.9473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4671, 3, DATE '2013-02-25', 586.7246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4672, 6, DATE '2014-04-17', 746.3122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4673, 10, DATE '2012-01-05', 485.4694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4674, 4, DATE '2011-06-05', 833.9770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4675, 9, DATE '2015-04-16', 824.3376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4676, 3, DATE '2013-06-13', 686.7119);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4677, 7, DATE '2011-06-11', 532.5634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4678, 3, DATE '2013-03-17', 593.2683);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4679, 9, DATE '2013-05-09', 105.1872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4680, 5, DATE '2012-01-22', 9.9788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4681, 3, DATE '2013-03-07', 589.8349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4682, 5, DATE '2012-01-06', 921.2561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4683, 3, DATE '2011-12-02', 78.7705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4684, 4, DATE '2015-06-20', 393.1573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4685, 1, DATE '2011-12-24', 329.8354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4686, 2, DATE '2011-05-24', 31.3931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4687, 10, DATE '2015-01-22', 665.9254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4688, 4, DATE '2014-07-12', 54.3712);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4689, 3, DATE '2012-11-13', 510.6158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4690, 1, DATE '2015-10-09', 906.4873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4691, 6, DATE '2013-05-27', 385.6298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4692, 6, DATE '2012-02-13', 931.2331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4693, 3, DATE '2011-12-31', 176.4541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4694, 8, DATE '2014-11-05', 763.2272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4695, 3, DATE '2013-05-17', 741.0599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4696, 7, DATE '2012-03-03', 868.2611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4697, 8, DATE '2011-08-13', 448.9963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4698, 9, DATE '2015-03-10', 781.8197);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4699, 2, DATE '2013-11-05', 32.8512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4700, 1, DATE '2013-04-02', 853.1546);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4701, 3, DATE '2012-09-18', 412.9145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4702, 5, DATE '2011-04-21', 650.7977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4703, 10, DATE '2013-11-11', 173.9418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4704, 1, DATE '2014-02-12', 245.9802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4705, 9, DATE '2012-05-31', 764.4618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4706, 3, DATE '2014-09-25', 241.2158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4707, 6, DATE '2015-11-12', 403.7336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4708, 4, DATE '2014-03-04', 922.9744);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4709, 7, DATE '2012-06-18', 964.5403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4710, 3, DATE '2014-07-01', 149.7360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4711, 4, DATE '2011-04-26', 788.6118);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4712, 3, DATE '2015-11-05', 702.5441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4713, 8, DATE '2011-12-11', 607.4357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4714, 6, DATE '2014-10-05', 985.7952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4715, 8, DATE '2015-06-24', 32.4676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4716, 5, DATE '2012-04-15', 41.4925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4717, 10, DATE '2013-07-02', 59.5576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4718, 1, DATE '2014-02-26', 172.8274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4719, 1, DATE '2012-04-21', 428.7186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4720, 9, DATE '2011-08-02', 407.2003);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4721, 8, DATE '2011-03-12', 289.7365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4722, 4, DATE '2011-03-04', 706.2449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4723, 1, DATE '2013-10-09', 23.2202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4724, 4, DATE '2011-05-09', 749.4168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4725, 7, DATE '2013-08-17', 362.3174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4726, 8, DATE '2012-01-14', 655.4916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4727, 4, DATE '2013-04-17', 569.8581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4728, 2, DATE '2013-03-01', 722.2422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4729, 2, DATE '2014-01-19', 92.9170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4730, 3, DATE '2014-02-12', 956.0765);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4731, 5, DATE '2012-11-01', 237.7155);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4732, 8, DATE '2012-04-02', 750.7437);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4733, 2, DATE '2015-05-13', 560.4170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4734, 8, DATE '2011-02-07', 252.0327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4735, 2, DATE '2015-05-05', 597.0643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4736, 9, DATE '2012-11-16', 939.0373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4737, 6, DATE '2014-02-25', 747.3143);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4738, 3, DATE '2013-10-19', 832.7903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4739, 6, DATE '2014-01-20', 628.6955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4740, 9, DATE '2013-03-30', 88.6195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4741, 6, DATE '2011-07-12', 627.6595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4742, 7, DATE '2011-11-21', 742.9510);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4743, 8, DATE '2013-01-24', 89.8309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4744, 10, DATE '2014-05-16', 360.8797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4745, 7, DATE '2015-06-16', 117.8755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4746, 4, DATE '2013-07-23', 683.0858);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4747, 8, DATE '2011-03-05', 323.7974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4748, 8, DATE '2013-03-28', 190.6589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4749, 1, DATE '2015-05-15', 730.7596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4750, 8, DATE '2012-02-02', 699.5674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4751, 7, DATE '2014-09-02', 808.7034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4752, 8, DATE '2013-06-16', 276.1689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4753, 9, DATE '2013-11-19', 353.1011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4754, 3, DATE '2013-04-06', 625.6510);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4755, 3, DATE '2013-01-21', 563.4180);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4756, 10, DATE '2012-07-18', 706.6697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4757, 4, DATE '2013-07-13', 627.5775);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4758, 6, DATE '2013-07-06', 424.5250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4759, 4, DATE '2011-06-29', 883.6628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4760, 1, DATE '2011-05-18', 108.9702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4761, 10, DATE '2012-06-09', 671.3578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4762, 4, DATE '2013-09-12', 681.4915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4763, 3, DATE '2011-02-13', 830.0573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4764, 4, DATE '2014-05-06', 8.4637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4765, 8, DATE '2012-08-30', 912.0206);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4766, 6, DATE '2015-01-23', 37.8680);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4767, 1, DATE '2011-06-25', 142.1270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4768, 10, DATE '2011-11-04', 355.4029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4769, 4, DATE '2015-06-02', 388.7309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4770, 10, DATE '2013-08-07', 93.4304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4771, 10, DATE '2014-02-19', 294.1782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4772, 7, DATE '2015-09-13', 226.7674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4773, 5, DATE '2011-02-07', 544.1319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4774, 3, DATE '2015-01-22', 340.0991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4775, 3, DATE '2011-01-21', 779.5408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4776, 2, DATE '2015-04-21', 546.7855);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4777, 7, DATE '2014-02-07', 616.4139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4778, 1, DATE '2015-05-27', 662.3406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4779, 8, DATE '2011-11-23', 631.5413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4780, 4, DATE '2011-01-25', 679.2317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4781, 1, DATE '2011-11-12', 331.6942);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4782, 7, DATE '2011-01-21', 379.1992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4783, 2, DATE '2013-10-18', 991.4826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4784, 4, DATE '2012-12-17', 393.3497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4785, 7, DATE '2015-06-13', 147.3730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4786, 8, DATE '2015-05-18', 961.5466);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4787, 10, DATE '2014-05-15', 397.6426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4788, 10, DATE '2013-02-05', 934.7661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4789, 6, DATE '2014-01-16', 688.6148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4790, 3, DATE '2013-10-18', 890.3947);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4791, 5, DATE '2015-05-07', 311.4597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4792, 10, DATE '2011-08-22', 322.7892);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4793, 10, DATE '2013-04-22', 949.1275);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4794, 6, DATE '2013-09-04', 519.7253);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4795, 10, DATE '2011-10-21', 417.2617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4796, 2, DATE '2013-10-30', 946.1681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4797, 4, DATE '2011-10-08', 912.8937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4798, 5, DATE '2014-09-20', 81.3672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4799, 3, DATE '2012-09-15', 448.8591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4800, 1, DATE '2011-05-24', 80.0074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4801, 3, DATE '2013-01-28', 540.9587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4802, 8, DATE '2015-05-02', 968.3945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4803, 4, DATE '2013-10-26', 801.9280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4804, 1, DATE '2012-10-07', 637.3292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4805, 8, DATE '2013-12-14', 405.3891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4806, 1, DATE '2014-12-20', 581.9360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4807, 3, DATE '2013-05-10', 732.0371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4808, 6, DATE '2014-10-28', 13.0020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4809, 1, DATE '2013-03-17', 846.1103);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4810, 1, DATE '2013-10-02', 16.6324);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4811, 3, DATE '2014-06-10', 90.2557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4812, 3, DATE '2014-02-17', 965.2369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4813, 9, DATE '2012-08-13', 792.9838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4814, 10, DATE '2011-06-05', 204.4310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4815, 1, DATE '2015-07-07', 777.2761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4816, 3, DATE '2012-05-20', 292.1586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4817, 3, DATE '2015-11-26', 690.0089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4818, 9, DATE '2014-02-27', 436.7076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4819, 7, DATE '2014-11-24', 861.0907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4820, 10, DATE '2013-04-15', 950.4740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4821, 7, DATE '2011-09-11', 640.2255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4822, 2, DATE '2014-05-20', 207.3610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4823, 5, DATE '2013-10-18', 666.7882);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4824, 2, DATE '2012-08-15', 498.3363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4825, 6, DATE '2014-04-03', 781.9707);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4826, 1, DATE '2013-06-30', 971.3891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4827, 7, DATE '2013-05-24', 277.6399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4828, 10, DATE '2013-06-04', 24.4065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4829, 4, DATE '2014-04-03', 922.8374);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4830, 1, DATE '2013-03-24', 833.3727);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4831, 8, DATE '2014-07-15', 633.8919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4832, 3, DATE '2015-05-21', 535.0467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4833, 9, DATE '2013-09-10', 213.4814);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4834, 7, DATE '2011-07-03', 551.5338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4835, 1, DATE '2013-12-27', 138.2729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4836, 3, DATE '2012-07-12', 363.2997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4837, 4, DATE '2013-03-27', 577.2712);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4838, 1, DATE '2012-01-11', 354.1534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4839, 7, DATE '2015-01-04', 987.9607);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4840, 7, DATE '2011-06-24', 565.4371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4841, 6, DATE '2013-01-08', 229.5095);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4842, 5, DATE '2015-07-18', 384.6405);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4843, 9, DATE '2015-11-22', 88.6557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4844, 5, DATE '2011-04-17', 671.9823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4845, 10, DATE '2015-05-10', 800.1389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4846, 2, DATE '2012-03-19', 346.2229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4847, 1, DATE '2015-01-08', 529.8055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4848, 1, DATE '2012-11-18', 744.6965);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4849, 6, DATE '2014-03-01', 742.4493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4850, 7, DATE '2015-06-03', 125.1031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4851, 10, DATE '2013-12-04', 256.1592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4852, 6, DATE '2013-08-11', 476.1861);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4853, 8, DATE '2015-10-28', 220.2765);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4854, 3, DATE '2015-06-03', 498.3852);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4855, 5, DATE '2015-09-13', 439.7820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4856, 2, DATE '2014-09-11', 333.5977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4857, 4, DATE '2012-07-14', 301.6063);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4858, 2, DATE '2012-03-13', 303.5917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4859, 6, DATE '2014-07-07', 855.3586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4860, 8, DATE '2011-06-17', 434.0000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4861, 4, DATE '2012-07-29', 304.2961);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4862, 3, DATE '2015-12-06', 707.6305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4863, 2, DATE '2011-07-27', 90.1647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4864, 10, DATE '2015-12-25', 12.7376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4865, 4, DATE '2015-03-21', 382.7406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4866, 1, DATE '2015-01-21', 555.2090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4867, 5, DATE '2011-06-09', 751.7555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4868, 3, DATE '2012-02-12', 241.4499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4869, 10, DATE '2013-06-08', 66.1581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4870, 8, DATE '2013-12-25', 413.9763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4871, 10, DATE '2015-02-23', 714.8874);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4872, 3, DATE '2014-11-16', 335.8554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4873, 3, DATE '2015-02-24', 448.7470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4874, 1, DATE '2014-06-02', 295.6536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4875, 4, DATE '2011-04-07', 720.9645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4876, 3, DATE '2012-02-24', 255.5849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4877, 3, DATE '2014-06-28', 118.7052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4878, 1, DATE '2013-07-04', 994.8059);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4879, 3, DATE '2013-04-07', 698.1974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4880, 4, DATE '2013-01-14', 435.7478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4881, 10, DATE '2014-06-22', 441.5836);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4882, 7, DATE '2011-07-06', 532.9435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4883, 5, DATE '2015-04-06', 281.9573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4884, 8, DATE '2014-11-01', 797.7343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4885, 2, DATE '2015-04-20', 577.2134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4886, 3, DATE '2011-12-04', 157.7057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4887, 6, DATE '2015-07-24', 314.7702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4888, 6, DATE '2014-04-10', 715.0962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4889, 3, DATE '2011-10-20', 111.7517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4890, 10, DATE '2015-04-18', 804.6752);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4891, 10, DATE '2015-12-30', 61.6934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4892, 2, DATE '2012-01-15', 273.6795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4893, 6, DATE '2013-07-06', 498.7949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4894, 9, DATE '2014-07-20', 553.9606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4895, 4, DATE '2014-11-26', 261.1409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4896, 4, DATE '2013-02-02', 521.8790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4897, 3, DATE '2014-12-23', 294.4758);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4898, 9, DATE '2015-11-29', 75.9181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4899, 2, DATE '2012-01-27', 289.2417);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4900, 9, DATE '2011-04-20', 244.9299);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4901, 8, DATE '2011-10-12', 594.4674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4902, 9, DATE '2013-11-27', 288.3555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4903, 2, DATE '2015-06-13', 678.5384);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4904, 8, DATE '2011-03-08', 328.4729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4905, 7, DATE '2011-04-11', 410.2157);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4906, 7, DATE '2015-01-18', 920.3038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4907, 4, DATE '2014-06-18', 27.4391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4908, 7, DATE '2012-05-27', 924.6229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4909, 9, DATE '2015-02-26', 777.4208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4910, 3, DATE '2014-07-21', 184.1971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4911, 9, DATE '2011-03-17', 214.8925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4912, 4, DATE '2015-01-10', 306.8005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4913, 10, DATE '2014-12-07', 605.3943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4914, 2, DATE '2012-06-22', 419.6108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4915, 9, DATE '2012-12-25', 992.4165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4916, 7, DATE '2012-01-24', 771.3527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4917, 9, DATE '2011-09-02', 425.6732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4918, 5, DATE '2012-09-25', 292.4305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4919, 9, DATE '2011-09-06', 435.5242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4920, 1, DATE '2014-04-17', 225.0348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4921, 6, DATE '2015-06-30', 240.4387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4922, 9, DATE '2013-02-28', 36.6592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4923, 10, DATE '2011-04-26', 129.6982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4924, 10, DATE '2014-02-20', 261.4829);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4925, 9, DATE '2013-12-26', 352.2829);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4926, 9, DATE '2014-02-08', 441.2078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4927, 8, DATE '2012-05-13', 837.0606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4928, 4, DATE '2011-08-07', 894.7865);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4929, 8, DATE '2015-07-07', 34.5126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4930, 1, DATE '2014-03-05', 199.0854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4931, 10, DATE '2013-03-04', 961.1091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4932, 4, DATE '2014-07-30', 42.7870);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4933, 9, DATE '2012-06-07', 705.5641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4934, 4, DATE '2012-12-19', 453.2675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4935, 7, DATE '2012-04-05', 841.2804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4936, 1, DATE '2011-07-27', 153.2280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4937, 6, DATE '2012-01-24', 854.4052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4938, 7, DATE '2015-01-29', 953.4844);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4939, 1, DATE '2014-07-23', 387.5185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4940, 5, DATE '2011-04-03', 656.9097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4941, 9, DATE '2013-06-18', 130.2666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4942, 9, DATE '2014-02-27', 390.1474);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4943, 8, DATE '2015-02-13', 937.6755);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4944, 10, DATE '2013-04-01', 927.5546);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4945, 1, DATE '2015-02-02', 589.7827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4946, 7, DATE '2011-12-20', 754.8929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4947, 2, DATE '2013-02-07', 668.2853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4948, 4, DATE '2012-01-14', 79.1841);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4949, 1, DATE '2012-07-26', 561.5441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4950, 7, DATE '2013-11-03', 489.7883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4951, 5, DATE '2012-06-03', 96.2057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4952, 9, DATE '2013-03-30', 2.0453);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4953, 1, DATE '2015-03-26', 640.3940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4954, 1, DATE '2013-10-11', 64.2068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4955, 4, DATE '2011-10-21', 4.4911);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4956, 9, DATE '2014-08-13', 557.8081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4957, 9, DATE '2013-08-04', 158.6573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4958, 2, DATE '2012-04-22', 417.0554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4959, 10, DATE '2013-03-12', 976.1901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4960, 9, DATE '2013-03-02', 969.0080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4961, 10, DATE '2013-09-07', 83.2432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4962, 1, DATE '2013-11-11', 132.6527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4963, 9, DATE '2012-11-21', 890.1103);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4964, 9, DATE '2011-12-25', 578.3353);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4965, 4, DATE '2012-05-19', 223.0881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4966, 5, DATE '2012-08-17', 172.1054);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4967, 5, DATE '2013-08-05', 601.2364);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4968, 7, DATE '2012-12-19', 152.1267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4969, 6, DATE '2011-03-20', 578.3304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4970, 8, DATE '2012-05-31', 839.1884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4971, 1, DATE '2011-01-01', 916.9475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4972, 2, DATE '2012-08-03', 472.1888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4973, 4, DATE '2014-03-05', 904.9121);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4974, 4, DATE '2011-06-05', 778.6146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4975, 3, DATE '2011-10-31', 94.7682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4976, 7, DATE '2012-05-03', 850.2914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4977, 2, DATE '2014-01-15', 98.9838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4978, 1, DATE '2014-01-24', 202.1436);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4979, 10, DATE '2015-01-19', 671.7002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4980, 3, DATE '2013-01-07', 597.3900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4981, 7, DATE '2012-01-01', 772.9226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4982, 4, DATE '2011-04-30', 757.8764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4983, 3, DATE '2015-01-11', 333.2423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4984, 2, DATE '2012-09-03', 544.7243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4985, 6, DATE '2012-10-01', 102.8797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4986, 1, DATE '2015-12-05', 959.0637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4987, 4, DATE '2015-05-07', 402.3931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4988, 9, DATE '2014-08-27', 641.3573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4989, 1, DATE '2012-02-29', 448.7764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4990, 8, DATE '2013-08-23', 283.4722);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4991, 2, DATE '2013-12-23', 994.5708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4992, 5, DATE '2015-10-03', 437.3497);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4993, 8, DATE '2012-11-18', 977.2944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4994, 2, DATE '2012-05-22', 418.5105);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4995, 5, DATE '2013-07-26', 573.6664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4996, 9, DATE '2015-08-07', 997.6140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4997, 1, DATE '2012-04-07', 500.0371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4998, 9, DATE '2014-02-20', 359.3401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (4999, 7, DATE '2011-11-14', 704.4665);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5000, 6, DATE '2013-06-17', 417.6773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5001, 2, DATE '2014-05-17', 153.6565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5002, 6, DATE '2011-02-20', 516.1585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5003, 9, DATE '2011-10-27', 500.8538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5004, 4, DATE '2011-02-25', 722.3557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5005, 6, DATE '2013-11-02', 572.8408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5006, 4, DATE '2015-11-01', 624.0170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5007, 6, DATE '2015-01-25', 97.1333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5008, 7, DATE '2014-10-21', 861.7794);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5009, 9, DATE '2012-12-12', 969.4387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5010, 7, DATE '2015-06-20', 154.1997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5011, 8, DATE '2011-07-30', 458.8242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5012, 9, DATE '2015-07-11', 956.5138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5013, 2, DATE '2013-04-03', 745.3553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5014, 7, DATE '2011-03-06', 378.8000);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5015, 3, DATE '2012-03-01', 196.0853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5016, 7, DATE '2013-05-11', 325.3669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5017, 8, DATE '2014-11-01', 799.4104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5018, 8, DATE '2011-03-20', 345.3859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5019, 3, DATE '2015-03-25', 475.4556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5020, 4, DATE '2012-06-14', 264.0244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5021, 2, DATE '2013-04-13', 769.7123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5022, 7, DATE '2014-12-09', 959.8792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5023, 7, DATE '2011-10-22', 703.3504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5024, 8, DATE '2013-07-28', 294.8581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5025, 6, DATE '2014-06-09', 844.6177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5026, 7, DATE '2011-03-31', 479.5978);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5027, 4, DATE '2015-09-15', 494.8944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5028, 3, DATE '2012-10-13', 486.4015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5029, 10, DATE '2013-11-10', 204.9482);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5030, 4, DATE '2012-03-26', 97.1543);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5031, 7, DATE '2011-01-26', 350.2542);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5032, 3, DATE '2015-11-26', 739.6438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5033, 4, DATE '2013-03-12', 497.6771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5034, 4, DATE '2012-08-04', 254.0229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5035, 1, DATE '2014-08-23', 443.7335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5036, 1, DATE '2011-11-12', 256.7640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5037, 6, DATE '2015-07-04', 257.0226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5038, 10, DATE '2014-11-16', 610.8866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5039, 6, DATE '2014-11-01', 971.8835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5040, 3, DATE '2012-11-30', 478.8627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5041, 5, DATE '2011-11-11', 861.9304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5042, 7, DATE '2011-07-17', 540.6137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5043, 1, DATE '2012-09-15', 671.9187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5044, 4, DATE '2012-09-10', 294.5767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5045, 1, DATE '2013-01-25', 824.6481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5046, 4, DATE '2014-06-14', 38.0569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5047, 4, DATE '2013-07-02', 691.9944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5048, 1, DATE '2012-09-15', 598.4943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5049, 9, DATE '2011-03-24', 222.4252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5050, 9, DATE '2011-03-18', 248.2995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5051, 2, DATE '2011-10-07', 198.2035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5052, 3, DATE '2012-01-19', 154.6512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5053, 7, DATE '2014-11-28', 883.8846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5054, 4, DATE '2015-06-02', 440.4421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5055, 5, DATE '2011-03-07', 647.9650);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5056, 6, DATE '2015-06-09', 193.7773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5057, 10, DATE '2015-05-02', 812.8082);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5058, 1, DATE '2014-04-01', 205.9956);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5059, 9, DATE '2012-09-18', 877.7381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5060, 10, DATE '2013-08-04', 93.2430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5061, 10, DATE '2011-02-16', 129.1225);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5062, 4, DATE '2013-04-13', 610.7319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5063, 8, DATE '2011-12-12', 656.8312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5064, 5, DATE '2011-09-19', 872.2843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5065, 10, DATE '2015-05-25', 803.9455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5066, 6, DATE '2011-09-03', 719.1805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5067, 5, DATE '2013-04-30', 458.8367);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5068, 8, DATE '2011-08-31', 491.3324);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5069, 7, DATE '2012-07-13', 935.0666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5070, 2, DATE '2011-04-21', 939.3214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5071, 1, DATE '2013-11-07', 68.3442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5072, 8, DATE '2015-12-16', 188.5237);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5073, 2, DATE '2012-05-19', 373.5024);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5074, 10, DATE '2013-04-24', 996.5929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5075, 9, DATE '2011-08-04', 402.0940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5076, 5, DATE '2012-09-27', 229.0985);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5077, 7, DATE '2013-03-25', 287.9605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5078, 3, DATE '2015-02-10', 408.7737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5079, 8, DATE '2011-07-04', 470.2101);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5080, 2, DATE '2015-12-26', 806.5607);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5081, 4, DATE '2013-09-29', 787.6034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5082, 4, DATE '2013-12-31', 896.4002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5083, 4, DATE '2012-07-23', 263.9762);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5084, 2, DATE '2013-08-25', 956.6487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5085, 3, DATE '2011-06-21', 898.9508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5086, 5, DATE '2015-01-08', 195.6030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5087, 6, DATE '2011-12-29', 855.7592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5088, 1, DATE '2013-10-11', 57.2349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5089, 10, DATE '2012-05-30', 606.0579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5090, 5, DATE '2015-03-17', 249.9561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5091, 2, DATE '2012-07-12', 443.9559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5092, 5, DATE '2012-04-04', 51.0270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5093, 2, DATE '2013-02-28', 733.1486);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5094, 7, DATE '2012-03-29', 878.6405);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5095, 4, DATE '2012-10-15', 349.7402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5096, 2, DATE '2014-07-30', 251.1984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5097, 10, DATE '2015-08-05', 883.7825);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5098, 6, DATE '2011-12-29', 799.6344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5099, 5, DATE '2013-04-18', 490.6312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5100, 5, DATE '2012-05-24', 105.4675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5101, 9, DATE '2012-02-15', 579.2203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5102, 6, DATE '2012-11-01', 200.6620);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5103, 5, DATE '2011-03-05', 663.4278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5104, 7, DATE '2015-12-03', 283.1038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5105, 8, DATE '2013-05-11', 179.9552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5106, 4, DATE '2011-10-22', 9.6797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5107, 1, DATE '2015-09-02', 781.1489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5108, 8, DATE '2012-08-06', 887.2917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5109, 5, DATE '2014-10-29', 38.3480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5110, 10, DATE '2014-06-10', 418.8665);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5111, 10, DATE '2013-03-16', 905.8169);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5112, 7, DATE '2011-03-22', 404.0344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5113, 4, DATE '2013-09-28', 735.7855);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5114, 7, DATE '2012-09-24', 71.1773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5115, 7, DATE '2015-11-06', 305.6396);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5116, 7, DATE '2013-02-16', 232.7224);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5117, 10, DATE '2011-09-22', 346.7556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5118, 7, DATE '2014-04-19', 700.1825);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5119, 2, DATE '2011-04-01', 973.3336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5120, 6, DATE '2011-05-18', 608.3425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5121, 1, DATE '2015-09-06', 863.4213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5122, 5, DATE '2015-07-21', 401.6017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5123, 9, DATE '2015-04-03', 885.2746);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5124, 3, DATE '2013-04-29', 685.1104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5125, 1, DATE '2014-10-09', 495.3654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5126, 7, DATE '2012-08-04', 17.3172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5127, 7, DATE '2013-10-18', 455.3751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5128, 6, DATE '2011-02-20', 494.8619);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5129, 6, DATE '2011-07-11', 646.8527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5130, 7, DATE '2013-01-05', 150.8955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5131, 6, DATE '2013-02-22', 345.3160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5132, 1, DATE '2012-03-27', 488.3262);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5133, 9, DATE '2012-10-25', 918.1425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5134, 3, DATE '2015-02-10', 364.7426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5135, 4, DATE '2014-11-11', 227.3404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5136, 8, DATE '2011-11-28', 586.9414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5137, 9, DATE '2013-10-28', 232.9723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5138, 7, DATE '2012-08-20', 980.8724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5139, 4, DATE '2011-04-16', 776.6935);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5140, 10, DATE '2015-08-30', 889.2710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5141, 4, DATE '2015-05-08', 414.4541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5142, 8, DATE '2015-05-25', 968.4676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5143, 6, DATE '2014-12-13', 18.8868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5144, 1, DATE '2013-12-21', 187.1914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5145, 5, DATE '2012-12-31', 344.1393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5146, 5, DATE '2012-04-23', 39.9215);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5147, 1, DATE '2014-07-08', 315.2415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5148, 6, DATE '2011-06-06', 661.9713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5149, 10, DATE '2012-05-24', 573.0009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5150, 8, DATE '2015-08-29', 117.0177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5151, 3, DATE '2013-11-08', 904.4429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5152, 4, DATE '2012-04-18', 183.5999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5153, 5, DATE '2011-09-30', 826.3009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5154, 9, DATE '2012-12-01', 882.2888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5155, 5, DATE '2012-09-17', 242.0462);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5156, 5, DATE '2012-07-27', 177.6186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5157, 8, DATE '2013-08-01', 315.3875);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5158, 2, DATE '2013-11-06', 978.3175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5159, 7, DATE '2012-02-25', 787.7385);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5160, 2, DATE '2011-10-07', 162.6379);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5161, 7, DATE '2014-01-03', 554.3047);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5162, 6, DATE '2015-07-13', 286.2869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5163, 2, DATE '2012-01-27', 240.4389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5164, 9, DATE '2012-10-24', 887.4526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5165, 5, DATE '2012-04-17', 73.5504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5166, 10, DATE '2011-12-20', 417.4907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5167, 9, DATE '2014-05-28', 485.8919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5168, 1, DATE '2014-08-19', 371.0429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5169, 4, DATE '2013-11-13', 843.8369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5170, 9, DATE '2014-12-09', 718.6982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5171, 8, DATE '2015-04-22', 999.7502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5172, 3, DATE '2015-02-01', 365.8832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5173, 3, DATE '2014-01-03', 923.4891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5174, 2, DATE '2011-08-02', 84.0625);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5175, 3, DATE '2012-01-11', 193.8883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5176, 3, DATE '2011-04-15', 894.9537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5177, 9, DATE '2011-08-08', 382.7148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5178, 9, DATE '2012-04-12', 698.0831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5179, 8, DATE '2011-04-29', 340.9710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5180, 6, DATE '2013-06-18', 455.4439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5181, 6, DATE '2014-01-28', 702.0757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5182, 2, DATE '2013-05-14', 793.4038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5183, 6, DATE '2014-09-29', 921.8611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5184, 9, DATE '2011-11-13', 529.8350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5185, 5, DATE '2015-02-27', 246.4527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5186, 2, DATE '2011-11-07', 161.7160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5187, 6, DATE '2011-06-29', 662.0254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5188, 10, DATE '2015-11-24', 35.8537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5189, 9, DATE '2013-05-25', 122.6963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5190, 9, DATE '2013-04-16', 49.7218);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5191, 1, DATE '2014-04-29', 271.5539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5192, 8, DATE '2015-12-23', 254.6548);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5193, 1, DATE '2011-06-27', 193.1339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5194, 2, DATE '2015-07-11', 614.0555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5195, 4, DATE '2012-08-26', 334.9663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5196, 8, DATE '2015-10-26', 128.1672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5197, 7, DATE '2014-04-28', 728.0287);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5198, 8, DATE '2013-02-19', 131.4343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5199, 6, DATE '2012-09-05', 113.6409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5200, 5, DATE '2012-01-12', 926.6487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5201, 7, DATE '2013-11-26', 554.0296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5202, 1, DATE '2015-11-19', 944.1987);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5203, 3, DATE '2013-07-24', 818.1344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5204, 2, DATE '2013-06-15', 854.3027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5205, 1, DATE '2011-05-10', 117.2676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5206, 10, DATE '2014-10-07', 538.5596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5207, 1, DATE '2014-04-15', 260.1109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5208, 4, DATE '2011-02-28', 742.2383);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5209, 7, DATE '2011-11-22', 688.4005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5210, 3, DATE '2012-06-04', 347.0925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5211, 6, DATE '2011-12-21', 794.9038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5212, 10, DATE '2012-04-20', 617.3044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5213, 4, DATE '2013-07-10', 637.3465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5214, 2, DATE '2014-09-08', 332.2945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5215, 7, DATE '2013-09-09', 460.5623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5216, 5, DATE '2011-08-23', 760.9009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5217, 10, DATE '2011-10-15', 364.4258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5218, 4, DATE '2011-03-17', 710.6040);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5219, 5, DATE '2013-08-27', 640.9998);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5220, 3, DATE '2011-06-11', 911.8344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5221, 5, DATE '2011-06-24', 755.4654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5222, 10, DATE '2014-07-05', 450.0382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5223, 3, DATE '2012-03-26', 248.3465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5224, 5, DATE '2011-07-31', 794.1151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5225, 8, DATE '2011-08-13', 447.1443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5226, 10, DATE '2015-05-01', 745.0953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5227, 3, DATE '2014-08-08', 172.7493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5228, 1, DATE '2014-06-26', 309.4335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5229, 9, DATE '2014-12-06', 749.0963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5230, 5, DATE '2012-03-17', 65.7210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5231, 7, DATE '2012-12-18', 166.9250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5232, 2, DATE '2014-06-19', 251.2805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5233, 3, DATE '2015-08-08', 584.4422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5234, 4, DATE '2015-04-17', 414.3223);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5235, 10, DATE '2015-07-24', 901.4144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5236, 6, DATE '2014-03-11', 757.8771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5237, 10, DATE '2015-10-22', 975.2695);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5238, 5, DATE '2012-04-15', 67.5584);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5239, 8, DATE '2011-07-06', 412.5673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5240, 5, DATE '2011-05-24', 707.8931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5241, 2, DATE '2013-07-24', 901.6052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5242, 3, DATE '2011-05-01', 919.7871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5243, 3, DATE '2015-01-02', 347.4533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5244, 7, DATE '2011-12-22', 775.6038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5245, 3, DATE '2012-04-26', 254.8180);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5246, 2, DATE '2013-01-08', 654.2495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5247, 4, DATE '2013-06-14', 617.3084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5248, 9, DATE '2012-10-19', 860.8394);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5249, 6, DATE '2012-11-01', 153.4932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5250, 9, DATE '2012-01-05', 574.0655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5251, 9, DATE '2015-01-12', 763.7414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5252, 3, DATE '2014-02-12', 17.4247);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5253, 4, DATE '2015-06-25', 490.4345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5254, 3, DATE '2012-03-27', 201.8066);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5255, 1, DATE '2011-07-22', 171.1833);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5256, 7, DATE '2015-05-24', 103.9914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5257, 8, DATE '2014-08-26', 695.8521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5258, 8, DATE '2012-12-24', 24.0192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5259, 4, DATE '2012-11-03', 407.1583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5260, 1, DATE '2012-01-10', 372.1723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5261, 8, DATE '2011-03-02', 365.8103);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5262, 10, DATE '2015-10-21', 950.6774);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5263, 5, DATE '2012-03-25', 993.1421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5264, 3, DATE '2015-09-07', 622.6794);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5265, 7, DATE '2015-06-18', 180.1675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5266, 5, DATE '2013-07-04', 543.6233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5267, 7, DATE '2012-09-13', 32.8622);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5268, 1, DATE '2014-03-26', 223.0241);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5269, 3, DATE '2015-02-16', 430.8802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5270, 1, DATE '2015-07-01', 702.6852);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5271, 6, DATE '2011-11-01', 785.6315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5272, 6, DATE '2015-07-01', 296.8674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5273, 6, DATE '2015-09-11', 298.0366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5274, 10, DATE '2013-04-06', 933.1068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5275, 2, DATE '2013-11-18', 10.2292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5276, 3, DATE '2011-02-23', 835.6783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5277, 7, DATE '2015-07-04', 102.5849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5278, 7, DATE '2011-04-06', 472.7427);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5279, 2, DATE '2015-04-05', 539.2971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5280, 7, DATE '2014-08-04', 792.8949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5281, 7, DATE '2012-11-16', 127.7869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5282, 5, DATE '2012-10-20', 311.9099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5283, 6, DATE '2012-08-25', 155.9403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5284, 10, DATE '2013-12-02', 175.0307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5285, 6, DATE '2013-03-06', 301.9797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5286, 4, DATE '2014-11-05', 149.5003);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5287, 9, DATE '2014-12-26', 760.8460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5288, 10, DATE '2014-05-14', 382.6355);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5289, 3, DATE '2014-09-26', 243.1390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5290, 3, DATE '2011-03-02', 797.4230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5291, 8, DATE '2015-07-17', 62.0250);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5292, 2, DATE '2013-10-28', 951.2502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5293, 2, DATE '2015-06-13', 660.4001);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5294, 8, DATE '2015-06-27', 40.3949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5295, 8, DATE '2011-03-25', 342.0827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5296, 2, DATE '2013-10-03', 950.9278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5297, 8, DATE '2015-02-06', 926.6450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5298, 1, DATE '2015-04-28', 724.7739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5299, 1, DATE '2012-07-05', 595.4363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5300, 9, DATE '2014-10-24', 711.1948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5301, 6, DATE '2011-04-28', 621.3873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5302, 3, DATE '2015-03-22', 394.2842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5303, 7, DATE '2013-09-02', 429.9591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5304, 5, DATE '2013-05-04', 450.8081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5305, 3, DATE '2011-03-06', 788.4341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5306, 4, DATE '2015-07-14', 466.8739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5307, 7, DATE '2014-06-03', 719.3882);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5308, 4, DATE '2013-03-20', 557.3278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5309, 2, DATE '2014-05-09', 191.5773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5310, 9, DATE '2011-05-29', 335.5050);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5311, 10, DATE '2015-11-21', 1.4064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5312, 2, DATE '2014-05-22', 223.1093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5313, 7, DATE '2013-09-21', 484.7222);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5314, 7, DATE '2014-04-01', 614.2634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5315, 5, DATE '2015-02-23', 244.3854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5316, 3, DATE '2014-05-13', 53.9004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5317, 5, DATE '2014-02-26', 794.7371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5318, 6, DATE '2014-04-23', 818.1113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5319, 7, DATE '2013-07-03', 320.6997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5320, 3, DATE '2011-08-13', 30.6671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5321, 7, DATE '2014-07-10', 782.7774);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5322, 7, DATE '2014-05-02', 650.2267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5323, 9, DATE '2015-06-30', 979.8852);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5324, 10, DATE '2014-12-17', 633.4573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5325, 4, DATE '2015-12-15', 640.6602);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5326, 4, DATE '2014-01-03', 834.3813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5327, 4, DATE '2011-01-19', 636.4673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5328, 9, DATE '2011-03-17', 257.6416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5329, 3, DATE '2013-01-12', 591.0240);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5330, 10, DATE '2011-02-15', 59.3014);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5331, 6, DATE '2012-01-18', 909.0334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5332, 7, DATE '2011-03-09', 377.8110);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5333, 7, DATE '2014-10-02', 877.3065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5334, 4, DATE '2011-06-12', 828.1023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5335, 2, DATE '2014-04-09', 171.5076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5336, 4, DATE '2013-08-28', 733.5028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5337, 8, DATE '2015-02-17', 881.9508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5338, 1, DATE '2015-04-23', 705.1323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5339, 8, DATE '2013-09-28', 386.5967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5340, 3, DATE '2013-08-24', 835.1058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5341, 8, DATE '2011-06-05', 430.1122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5342, 6, DATE '2012-10-07', 203.5181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5343, 9, DATE '2011-01-05', 191.0581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5344, 5, DATE '2014-05-01', 907.6340);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5345, 4, DATE '2011-04-12', 796.0165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5346, 7, DATE '2012-02-26', 838.9157);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5347, 6, DATE '2011-02-07', 466.5279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5348, 5, DATE '2012-03-13', 46.1366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5349, 4, DATE '2011-05-05', 796.0096);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5350, 5, DATE '2012-11-12', 288.1823);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5351, 7, DATE '2015-08-08', 156.1907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5352, 3, DATE '2011-10-16', 108.5336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5353, 4, DATE '2012-10-25', 404.0741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5354, 8, DATE '2011-11-23', 564.7691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5355, 2, DATE '2011-04-17', 928.4175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5356, 9, DATE '2012-12-26', 971.1606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5357, 5, DATE '2015-09-22', 414.3990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5358, 7, DATE '2014-09-17', 796.5018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5359, 2, DATE '2013-05-21', 810.1479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5360, 10, DATE '2013-03-02', 954.0528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5361, 10, DATE '2015-06-25', 830.4066);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5362, 9, DATE '2014-03-20', 461.7465);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5363, 2, DATE '2011-03-08', 966.3039);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5364, 2, DATE '2014-03-25', 132.2759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5365, 4, DATE '2015-05-12', 426.4717);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5366, 3, DATE '2015-09-15', 623.5954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5367, 6, DATE '2015-08-21', 345.8029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5368, 3, DATE '2013-04-11', 656.6199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5369, 6, DATE '2015-12-24', 442.7558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5370, 1, DATE '2012-06-28', 510.8826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5371, 6, DATE '2015-03-26', 171.9496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5372, 5, DATE '2014-11-05', 89.6047);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5373, 8, DATE '2011-07-27', 431.5145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5374, 5, DATE '2015-11-10', 485.5940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5375, 5, DATE '2011-03-11', 600.5550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5376, 2, DATE '2012-10-02', 579.2592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5377, 9, DATE '2014-04-28', 459.1685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5378, 4, DATE '2012-03-01', 72.2512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5379, 7, DATE '2014-09-07', 837.4409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5380, 8, DATE '2014-10-19', 801.7445);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5381, 8, DATE '2013-11-27', 367.8534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5382, 10, DATE '2014-11-07', 590.3306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5383, 5, DATE '2015-11-13', 461.6320);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5384, 8, DATE '2011-03-03', 302.8416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5385, 4, DATE '2011-07-11', 903.1108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5386, 4, DATE '2011-04-05', 800.4997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5387, 4, DATE '2014-05-15', 973.7370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5388, 9, DATE '2013-11-09', 312.5373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5389, 2, DATE '2011-02-26', 899.6849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5390, 4, DATE '2012-04-13', 200.3470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5391, 9, DATE '2013-12-06', 319.1037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5392, 1, DATE '2011-06-02', 85.4489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5393, 9, DATE '2012-12-03', 894.9844);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5394, 8, DATE '2011-07-29', 432.5440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5395, 3, DATE '2014-03-01', 4.6991);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5396, 10, DATE '2013-03-18', 968.3657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5397, 4, DATE '2012-08-01', 237.2142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5398, 7, DATE '2012-10-13', 58.7822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5399, 2, DATE '2014-12-21', 481.1622);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5400, 1, DATE '2011-07-29', 172.4210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5401, 2, DATE '2012-07-08', 493.1128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5402, 4, DATE '2013-10-28', 809.9080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5403, 9, DATE '2012-03-20', 603.3809);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5404, 3, DATE '2014-11-07', 285.1269);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5405, 10, DATE '2013-08-19', 116.2326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5406, 3, DATE '2011-10-03', 66.5859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5407, 5, DATE '2011-03-23', 677.0191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5408, 9, DATE '2012-12-15', 918.4802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5409, 4, DATE '2011-09-15', 964.2142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5410, 1, DATE '2014-07-15', 349.1582);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5411, 10, DATE '2014-08-31', 511.9920);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5412, 1, DATE '2014-07-24', 342.1478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5413, 1, DATE '2011-01-10', 959.0610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5414, 5, DATE '2014-08-02', 8.4034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5415, 2, DATE '2015-04-06', 586.1993);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5416, 1, DATE '2011-08-18', 240.0759);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5417, 4, DATE '2014-05-07', 0.1144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5418, 4, DATE '2011-01-06', 663.4622);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5419, 9, DATE '2013-09-15', 229.1651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5420, 1, DATE '2015-02-06', 625.9721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5421, 9, DATE '2012-05-03', 649.8585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5422, 7, DATE '2012-10-12', 33.2656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5423, 1, DATE '2013-02-14', 756.9351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5424, 3, DATE '2014-09-12', 242.4088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5425, 3, DATE '2014-07-23', 191.7789);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5426, 5, DATE '2014-10-25', 86.5006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5427, 6, DATE '2012-12-02', 194.6204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5428, 10, DATE '2015-12-29', 998.9706);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5429, 2, DATE '2012-09-11', 480.8948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5430, 6, DATE '2013-12-24', 632.1893);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5431, 8, DATE '2011-03-04', 342.0449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5432, 3, DATE '2012-07-16', 400.3863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5433, 3, DATE '2013-03-11', 591.0891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5434, 6, DATE '2014-02-10', 665.0199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5435, 7, DATE '2013-04-13', 308.6316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5436, 5, DATE '2011-01-30', 557.9455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5437, 1, DATE '2013-08-20', 986.9498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5438, 3, DATE '2012-01-07', 176.5050);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5439, 9, DATE '2013-07-15', 186.6089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5440, 1, DATE '2015-10-08', 836.5249);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5441, 9, DATE '2011-01-13', 123.4805);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5442, 6, DATE '2012-05-30', 55.2567);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5443, 6, DATE '2013-02-24', 348.3231);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5444, 1, DATE '2012-08-13', 550.5267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5445, 4, DATE '2013-08-14', 688.3550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5446, 8, DATE '2015-05-16', 976.9560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5447, 1, DATE '2011-05-23', 126.3880);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5448, 5, DATE '2014-05-04', 886.5810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5449, 7, DATE '2012-04-24', 846.3448);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5450, 3, DATE '2013-07-14', 764.6232);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5451, 6, DATE '2014-11-11', 968.2512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5452, 1, DATE '2012-07-26', 573.7521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5453, 9, DATE '2015-01-29', 829.6172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5454, 1, DATE '2015-11-14', 855.1901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5455, 2, DATE '2015-03-28', 522.5625);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5456, 5, DATE '2015-09-26', 459.8472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5457, 3, DATE '2011-09-14', 52.9729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5458, 7, DATE '2013-07-09', 360.9720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5459, 1, DATE '2011-04-17', 93.3480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5460, 5, DATE '2014-10-26', 29.7320);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5461, 7, DATE '2014-11-01', 871.9656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5462, 5, DATE '2011-03-26', 678.0486);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5463, 7, DATE '2011-04-05', 437.5853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5464, 8, DATE '2013-09-22', 332.0248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5465, 4, DATE '2014-05-13', 7.1132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5466, 8, DATE '2013-02-14', 111.6057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5467, 8, DATE '2012-05-14', 751.0587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5468, 5, DATE '2012-11-30', 294.0410);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5469, 9, DATE '2012-04-20', 699.7718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5470, 7, DATE '2015-03-07', 28.2538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5471, 10, DATE '2013-12-29', 253.1261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5472, 2, DATE '2013-05-01', 823.6094);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5473, 6, DATE '2013-06-24', 476.8532);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5474, 8, DATE '2013-12-08', 392.6403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5475, 2, DATE '2015-01-24', 502.4916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5476, 4, DATE '2015-12-04', 594.6018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5477, 2, DATE '2015-08-18', 684.9425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5478, 10, DATE '2011-07-04', 206.4083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5479, 9, DATE '2012-01-30', 554.0538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5480, 5, DATE '2015-03-10', 214.8229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5481, 5, DATE '2014-06-04', 960.1126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5482, 2, DATE '2014-08-01', 308.0395);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5483, 4, DATE '2014-09-05', 152.6257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5484, 10, DATE '2015-03-01', 716.2717);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5485, 10, DATE '2015-02-12', 663.9381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5486, 7, DATE '2014-08-09', 768.2929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5487, 5, DATE '2013-06-18', 570.7691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5488, 2, DATE '2013-04-28', 735.8990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5489, 5, DATE '2014-11-16', 142.4573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5490, 2, DATE '2013-07-18', 848.7845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5491, 3, DATE '2015-05-18', 504.9725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5492, 5, DATE '2011-02-11', 625.9778);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5493, 3, DATE '2011-09-22', 83.1570);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5494, 4, DATE '2014-09-20', 156.8769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5495, 5, DATE '2011-12-08', 964.5594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5496, 5, DATE '2015-10-21', 445.4319);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5497, 9, DATE '2012-02-25', 617.6714);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5498, 8, DATE '2015-06-05', 16.2983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5499, 8, DATE '2014-04-03', 543.4135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5500, 7, DATE '2011-06-30', 576.7493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5501, 10, DATE '2014-01-01', 225.8972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5502, 6, DATE '2014-06-23', 832.3470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5503, 7, DATE '2013-01-13', 186.8091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5504, 1, DATE '2013-02-18', 818.0909);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5505, 4, DATE '2015-07-16', 511.4970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5506, 5, DATE '2012-07-13', 144.6418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5507, 6, DATE '2015-02-02', 96.8988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5508, 1, DATE '2012-02-21', 436.9768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5509, 10, DATE '2011-10-21', 352.6985);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5510, 8, DATE '2015-04-24', 927.9608);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5511, 3, DATE '2011-02-09', 774.9048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5512, 3, DATE '2011-03-14', 846.5646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5513, 8, DATE '2012-06-10', 806.9183);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5514, 6, DATE '2012-02-08', 878.5252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5515, 1, DATE '2011-05-24', 69.6194);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5516, 6, DATE '2011-04-02', 563.9260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5517, 1, DATE '2012-07-20', 525.4229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5518, 8, DATE '2012-02-05', 721.3137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5519, 8, DATE '2014-08-10', 668.0867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5520, 7, DATE '2015-10-05', 238.8203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5521, 4, DATE '2015-08-30', 540.8366);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5522, 7, DATE '2015-01-17', 15.1597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5523, 1, DATE '2014-01-15', 151.5837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5524, 7, DATE '2014-10-04', 850.9874);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5525, 4, DATE '2015-10-20', 523.2813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5526, 6, DATE '2013-11-18', 627.1484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5527, 10, DATE '2012-08-09', 740.4524);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5528, 2, DATE '2014-10-04', 319.9763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5529, 4, DATE '2013-01-01', 428.0810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5530, 7, DATE '2015-04-06', 57.0597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5531, 6, DATE '2014-10-09', 976.9304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5532, 5, DATE '2011-03-15', 668.6442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5533, 3, DATE '2013-04-02', 662.9949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5534, 3, DATE '2011-08-02', 977.3045);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5535, 5, DATE '2012-03-08', 988.9257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5536, 9, DATE '2015-12-13', 127.7656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5537, 5, DATE '2012-07-18', 121.2303);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5538, 3, DATE '2012-07-18', 334.5348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5539, 7, DATE '2015-08-16', 204.7746);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5540, 6, DATE '2013-08-02', 519.2963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5541, 2, DATE '2015-07-07', 671.3941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5542, 4, DATE '2012-04-27', 133.7923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5543, 3, DATE '2012-07-08', 383.2005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5544, 7, DATE '2015-07-25', 214.4965);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5545, 10, DATE '2013-06-08', 73.8797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5546, 1, DATE '2015-03-07', 658.4080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5547, 7, DATE '2014-09-03', 819.0595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5548, 7, DATE '2015-08-14', 204.6318);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5549, 3, DATE '2014-04-29', 87.2575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5550, 9, DATE '2011-09-07', 400.6333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5551, 4, DATE '2014-04-03', 920.0091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5552, 2, DATE '2011-01-20', 896.3577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5553, 10, DATE '2011-10-27', 348.2116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5554, 1, DATE '2014-06-29', 304.5931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5555, 3, DATE '2011-11-01', 35.9127);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5556, 4, DATE '2014-12-15', 210.7375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5557, 5, DATE '2011-06-08', 680.7633);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5558, 10, DATE '2014-04-12', 335.8217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5559, 7, DATE '2013-05-01', 294.8096);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5560, 8, DATE '2012-08-28', 884.3486);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5561, 6, DATE '2015-12-04', 404.1894);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5562, 4, DATE '2011-05-01', 776.9225);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5563, 7, DATE '2015-02-20', 8.8958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5564, 4, DATE '2012-07-17', 295.6388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5565, 3, DATE '2011-07-17', 951.0304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5566, 9, DATE '2015-11-28', 106.2605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5567, 10, DATE '2013-12-11', 183.5697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5568, 6, DATE '2011-11-09', 829.6138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5569, 1, DATE '2015-12-02', 889.5996);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5570, 3, DATE '2011-06-12', 941.8539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5571, 1, DATE '2014-09-15', 442.6956);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5572, 9, DATE '2011-01-03', 190.8880);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5573, 1, DATE '2012-06-22', 516.5391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5574, 3, DATE '2012-01-09', 148.7903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5575, 6, DATE '2011-04-01', 567.4263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5576, 10, DATE '2014-05-04', 407.0443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5577, 4, DATE '2013-07-11', 631.9592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5578, 5, DATE '2014-06-23', 937.0872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5579, 8, DATE '2012-04-27', 777.1077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5580, 4, DATE '2011-08-16', 864.8734);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5581, 9, DATE '2015-03-17', 808.0889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5582, 3, DATE '2012-12-26', 535.8205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5583, 10, DATE '2011-06-08', 232.7188);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5584, 5, DATE '2012-04-26', 27.4476);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5585, 3, DATE '2012-01-03', 137.0506);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5586, 5, DATE '2014-09-19', 80.5726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5587, 5, DATE '2015-05-20', 320.4325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5588, 2, DATE '2014-10-05', 358.4017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5589, 10, DATE '2015-10-02', 941.3918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5590, 2, DATE '2013-03-24', 778.1881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5591, 4, DATE '2015-07-07', 447.0023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5592, 6, DATE '2014-04-07', 785.4086);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5593, 7, DATE '2015-03-19', 39.7252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5594, 9, DATE '2013-12-18', 320.4260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5595, 10, DATE '2013-08-29', 115.1069);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5596, 8, DATE '2015-03-08', 894.4716);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5597, 8, DATE '2013-03-08', 124.8964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5598, 10, DATE '2015-12-23', 87.5617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5599, 4, DATE '2015-01-09', 263.4661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5600, 1, DATE '2013-07-12', 967.6192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5601, 1, DATE '2012-03-26', 474.8382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5602, 2, DATE '2013-10-25', 989.4458);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5603, 6, DATE '2015-09-12', 315.0323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5604, 1, DATE '2013-11-18', 145.4037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5605, 9, DATE '2012-12-23', 957.9377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5606, 6, DATE '2014-04-01', 729.1211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5607, 1, DATE '2014-07-31', 379.8186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5608, 8, DATE '2015-10-19', 199.4212);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5609, 6, DATE '2014-03-30', 737.1669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5610, 4, DATE '2013-06-29', 628.8684);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5611, 10, DATE '2012-06-06', 578.7783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5612, 1, DATE '2012-12-16', 743.6761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5613, 3, DATE '2012-12-16', 558.7141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5614, 3, DATE '2012-09-16', 429.9363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5615, 10, DATE '2013-06-13', 76.2597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5616, 4, DATE '2013-12-09', 868.3689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5617, 5, DATE '2015-11-24', 544.2037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5618, 2, DATE '2013-10-27', 981.4483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5619, 1, DATE '2011-07-15', 158.5881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5620, 9, DATE '2012-10-27', 870.4577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5621, 5, DATE '2011-07-12', 785.8280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5622, 9, DATE '2015-03-09', 825.1681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5623, 6, DATE '2012-02-08', 888.2220);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5624, 10, DATE '2013-09-10', 111.4114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5625, 9, DATE '2011-12-06', 494.8515);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5626, 6, DATE '2011-06-10', 657.2871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5627, 2, DATE '2011-10-17', 151.1627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5628, 3, DATE '2014-07-05', 196.1131);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5629, 4, DATE '2014-05-12', 33.6834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5630, 8, DATE '2012-01-24', 672.9547);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5631, 2, DATE '2012-02-27', 282.1479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5632, 5, DATE '2013-07-19', 544.3975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5633, 2, DATE '2015-06-15', 673.6210);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5634, 8, DATE '2014-10-16', 809.4885);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5635, 4, DATE '2015-05-22', 390.0351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5636, 8, DATE '2012-05-23', 818.6432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5637, 7, DATE '2013-04-15', 220.7882);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5638, 10, DATE '2013-07-20', 87.3150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5639, 7, DATE '2015-05-05', 69.5100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5640, 7, DATE '2013-10-04', 407.9296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5641, 4, DATE '2011-02-20', 700.7541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5642, 8, DATE '2015-08-01', 121.0113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5643, 6, DATE '2011-07-08', 621.2348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5644, 6, DATE '2013-04-04', 312.5234);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5645, 2, DATE '2011-10-19', 199.4097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5646, 4, DATE '2013-07-22', 703.3263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5647, 3, DATE '2012-04-22', 226.6945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5648, 4, DATE '2013-07-03', 609.7889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5649, 10, DATE '2011-07-08', 244.1663);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5650, 7, DATE '2015-09-21', 246.7380);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5651, 4, DATE '2015-04-14', 350.2679);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5652, 7, DATE '2015-05-12', 143.4482);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5653, 9, DATE '2015-06-10', 928.9736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5654, 5, DATE '2013-03-15', 393.0084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5655, 7, DATE '2013-01-01', 181.7911);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5656, 2, DATE '2013-01-17', 649.6702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5657, 6, DATE '2012-09-16', 101.2237);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5658, 6, DATE '2013-01-02', 203.6208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5659, 2, DATE '2012-12-14', 650.5523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5660, 4, DATE '2012-07-15', 300.6506);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5661, 5, DATE '2013-06-16', 577.9583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5662, 9, DATE '2011-01-27', 183.7055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5663, 5, DATE '2012-06-08', 165.7377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5664, 9, DATE '2013-03-07', 64.2122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5665, 2, DATE '2012-05-02', 346.7205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5666, 6, DATE '2014-11-18', 34.3808);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5667, 10, DATE '2013-07-03', 70.0550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5668, 6, DATE '2014-03-02', 749.2256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5669, 9, DATE '2013-04-27', 39.9012);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5670, 2, DATE '2012-01-22', 257.6165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5671, 7, DATE '2011-08-26', 647.5807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5672, 5, DATE '2013-05-07', 456.8886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5673, 5, DATE '2014-06-24', 911.9382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5674, 4, DATE '2013-10-11', 750.6585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5675, 6, DATE '2012-09-07', 169.7036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5676, 8, DATE '2011-12-11', 664.8167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5677, 3, DATE '2014-09-02', 203.9332);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5678, 10, DATE '2014-11-05', 575.6986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5679, 9, DATE '2012-11-22', 912.0018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5680, 6, DATE '2014-05-16', 791.5252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5681, 3, DATE '2015-02-18', 430.5925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5682, 8, DATE '2014-04-15', 541.3739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5683, 3, DATE '2013-12-29', 951.9468);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5684, 7, DATE '2014-08-22', 786.9454);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5685, 4, DATE '2012-10-11', 322.6868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5686, 6, DATE '2012-10-17', 138.6997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5687, 7, DATE '2014-02-08', 615.4239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5688, 7, DATE '2013-04-01', 280.6125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5689, 1, DATE '2012-10-15', 627.6974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5690, 2, DATE '2013-05-04', 740.3649);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5691, 2, DATE '2015-09-06', 717.4195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5692, 1, DATE '2011-04-13', 17.1673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5693, 9, DATE '2011-08-06', 436.7628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5694, 4, DATE '2013-10-20', 768.8595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5695, 3, DATE '2011-04-21', 829.9714);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5696, 6, DATE '2011-01-24', 517.0486);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5697, 4, DATE '2014-02-22', 955.2737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5698, 8, DATE '2014-05-03', 557.0226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5699, 5, DATE '2011-12-03', 965.8029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5700, 7, DATE '2012-11-30', 165.0289);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5701, 4, DATE '2011-01-19', 633.2712);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5702, 8, DATE '2014-02-20', 477.4689);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5703, 6, DATE '2011-03-08', 569.8877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5704, 8, DATE '2015-06-17', 986.5498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5705, 1, DATE '2015-01-26', 599.1574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5706, 9, DATE '2012-12-08', 893.3793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5707, 2, DATE '2011-11-19', 231.5100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5708, 5, DATE '2012-08-30', 178.3150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5709, 10, DATE '2011-07-09', 223.3048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5710, 10, DATE '2012-01-22', 516.9745);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5711, 10, DATE '2014-05-18', 445.7370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5712, 7, DATE '2013-11-11', 525.5251);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5713, 8, DATE '2011-02-10', 291.6191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5714, 6, DATE '2014-07-31', 859.0271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5715, 1, DATE '2013-05-28', 870.0581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5716, 7, DATE '2015-03-03', 36.5844);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5717, 6, DATE '2013-01-29', 231.7587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5718, 8, DATE '2013-10-18', 378.7923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5719, 5, DATE '2011-05-27', 741.5255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5720, 7, DATE '2015-07-17', 208.0208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5721, 9, DATE '2011-10-10', 418.9569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5722, 4, DATE '2011-04-03', 789.4425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5723, 5, DATE '2012-05-18', 121.5282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5724, 7, DATE '2015-12-25', 299.5363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5725, 1, DATE '2012-05-17', 540.1971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5726, 6, DATE '2011-05-15', 630.4133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5727, 7, DATE '2012-10-01', 20.1258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5728, 2, DATE '2011-09-05', 143.0787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5729, 1, DATE '2013-06-23', 920.6872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5730, 10, DATE '2012-08-14', 652.6550);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5731, 5, DATE '2013-10-18', 709.5431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5732, 5, DATE '2011-05-03', 646.9107);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5733, 6, DATE '2013-12-04', 609.8957);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5734, 3, DATE '2015-12-24', 746.9728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5735, 2, DATE '2014-04-28', 158.2539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5736, 5, DATE '2011-12-29', 953.1237);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5737, 3, DATE '2014-02-08', 971.4862);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5738, 5, DATE '2014-07-15', 965.3970);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5739, 7, DATE '2015-07-27', 187.7880);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5740, 6, DATE '2015-11-04', 429.3075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5741, 5, DATE '2011-11-30', 907.1897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5742, 2, DATE '2012-06-11', 437.1088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5743, 7, DATE '2012-09-24', 57.3077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5744, 2, DATE '2011-09-24', 110.7229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5745, 3, DATE '2014-12-18', 294.6279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5746, 6, DATE '2012-10-26', 191.8943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5747, 4, DATE '2011-03-04', 725.5482);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5748, 3, DATE '2013-01-06', 577.7358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5749, 3, DATE '2011-05-26', 898.8015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5750, 7, DATE '2012-02-18', 793.3869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5751, 10, DATE '2013-12-26', 285.2898);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5752, 6, DATE '2011-05-08', 576.4813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5753, 4, DATE '2013-12-07', 815.4971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5754, 8, DATE '2012-05-19', 757.7821);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5755, 8, DATE '2012-02-21', 746.0720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5756, 1, DATE '2015-10-18', 843.8287);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5757, 4, DATE '2012-10-04', 355.9406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5758, 9, DATE '2011-03-15', 270.3513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5759, 8, DATE '2014-01-30', 446.3527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5760, 6, DATE '2014-09-14', 968.7441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5761, 3, DATE '2011-03-09', 873.2535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5762, 10, DATE '2011-03-16', 88.4313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5763, 5, DATE '2015-03-10', 257.6279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5764, 10, DATE '2014-11-24', 570.6499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5765, 5, DATE '2014-04-05', 807.4315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5766, 5, DATE '2014-01-16', 798.8264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5767, 1, DATE '2015-12-09', 915.6294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5768, 6, DATE '2011-02-18', 544.6463);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5769, 5, DATE '2011-04-05', 700.7731);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5770, 7, DATE '2012-05-30', 916.9344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5771, 4, DATE '2012-01-24', 65.0982);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5772, 2, DATE '2014-07-18', 266.3617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5773, 2, DATE '2014-03-24', 191.0043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5774, 10, DATE '2011-07-23', 312.2179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5775, 2, DATE '2014-08-17', 300.8311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5776, 8, DATE '2015-05-01', 981.8481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5777, 7, DATE '2014-07-10', 732.1348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5778, 3, DATE '2011-08-26', 10.8053);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5779, 5, DATE '2012-01-08', 4.9084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5780, 5, DATE '2015-07-22', 348.3027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5781, 2, DATE '2011-03-14', 904.8651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5782, 5, DATE '2015-09-26', 442.3900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5783, 9, DATE '2011-04-12', 244.2773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5784, 5, DATE '2012-05-05', 127.3002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5785, 1, DATE '2014-08-20', 367.3651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5786, 9, DATE '2013-06-13', 133.0617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5787, 2, DATE '2013-05-26', 831.4136);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5788, 8, DATE '2012-07-17', 852.1137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5789, 6, DATE '2014-11-02', 0.9008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5790, 1, DATE '2014-07-11', 314.4253);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5791, 1, DATE '2015-03-27', 597.1831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5792, 5, DATE '2013-11-26', 701.1348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5793, 7, DATE '2011-06-15', 519.0442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5794, 2, DATE '2011-11-13', 219.0439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5795, 4, DATE '2015-08-28', 556.0541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5796, 5, DATE '2011-09-16', 818.7584);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5797, 8, DATE '2013-04-03', 179.4809);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5798, 7, DATE '2013-11-01', 486.6579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5799, 7, DATE '2013-06-20', 303.2914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5800, 9, DATE '2011-12-03', 495.8016);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5801, 5, DATE '2012-11-17', 276.2649);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5802, 9, DATE '2011-01-14', 180.9018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5803, 9, DATE '2012-10-04', 876.9627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5804, 7, DATE '2014-12-26', 981.8671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5805, 3, DATE '2011-01-26', 728.2887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5806, 8, DATE '2015-06-11', 18.9281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5807, 5, DATE '2013-02-13', 385.4770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5808, 5, DATE '2013-05-18', 503.2792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5809, 7, DATE '2013-10-02', 456.9510);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5810, 10, DATE '2012-10-23', 764.2239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5811, 4, DATE '2012-04-10', 111.6939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5812, 1, DATE '2012-02-09', 345.1353);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5813, 5, DATE '2015-03-08', 265.4429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5814, 4, DATE '2014-07-11', 98.0500);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5815, 4, DATE '2014-07-03', 63.8790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5816, 8, DATE '2011-06-14', 430.8634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5817, 2, DATE '2015-12-04', 844.1541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5818, 1, DATE '2013-11-05', 130.3276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5819, 10, DATE '2011-04-07', 203.2847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5820, 7, DATE '2011-10-24', 674.3697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5821, 3, DATE '2011-08-23', 967.4128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5822, 3, DATE '2014-05-25', 63.5157);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5823, 10, DATE '2012-04-18', 543.7455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5824, 4, DATE '2012-09-24', 386.3478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5825, 6, DATE '2013-03-06', 319.7513);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5826, 9, DATE '2014-02-27', 363.9634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5827, 5, DATE '2014-02-03', 747.3176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5828, 10, DATE '2013-05-12', 971.9604);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5829, 7, DATE '2011-11-26', 756.1639);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5830, 7, DATE '2013-12-01', 482.0728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5831, 1, DATE '2013-01-27', 802.3672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5832, 1, DATE '2011-09-08', 245.4769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5833, 6, DATE '2014-03-08', 707.5139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5834, 6, DATE '2011-02-06', 509.1068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5835, 10, DATE '2013-09-04', 72.0377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5836, 4, DATE '2011-02-28', 723.9632);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5837, 7, DATE '2013-12-22', 565.4274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5838, 3, DATE '2012-04-17', 262.4102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5839, 2, DATE '2012-04-09', 399.0116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5840, 4, DATE '2015-03-11', 348.4370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5841, 4, DATE '2011-04-30', 747.5848);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5842, 7, DATE '2011-01-09', 328.1343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5843, 2, DATE '2014-10-15', 395.1627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5844, 6, DATE '2013-01-09', 236.6769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5845, 7, DATE '2013-04-01', 202.7313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5846, 10, DATE '2014-02-15', 252.0477);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5847, 1, DATE '2014-09-21', 435.6919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5848, 4, DATE '2012-12-04', 420.9942);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5849, 8, DATE '2013-05-13', 155.1649);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5850, 6, DATE '2015-03-16', 125.1907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5851, 4, DATE '2011-10-13', 974.6044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5852, 8, DATE '2015-05-30', 49.1533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5853, 8, DATE '2013-07-27', 283.3731);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5854, 1, DATE '2012-08-28', 628.9218);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5855, 6, DATE '2011-04-12', 528.3888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5856, 2, DATE '2014-06-26', 212.7492);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5857, 9, DATE '2014-09-28', 637.1564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5858, 6, DATE '2011-01-10', 490.6148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5859, 1, DATE '2012-10-22', 662.1158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5860, 5, DATE '2012-11-28', 364.3252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5861, 3, DATE '2012-05-08', 271.6105);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5862, 5, DATE '2015-10-05', 413.5166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5863, 9, DATE '2012-06-22', 747.1154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5864, 10, DATE '2015-11-02', 974.8782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5865, 10, DATE '2015-09-27', 961.8568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5866, 4, DATE '2011-08-03', 866.2170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5867, 6, DATE '2013-12-04', 637.6214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5868, 9, DATE '2015-01-31', 756.3361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5869, 4, DATE '2011-11-07', 26.0122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5870, 10, DATE '2014-05-05', 339.9158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5871, 2, DATE '2013-06-22', 865.4360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5872, 9, DATE '2014-08-19', 581.7438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5873, 9, DATE '2012-07-29', 731.3160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5874, 6, DATE '2012-01-27', 854.8477);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5875, 3, DATE '2011-06-26', 926.7849);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5876, 7, DATE '2011-08-15', 639.2785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5877, 2, DATE '2015-08-10', 668.3530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5878, 5, DATE '2015-04-09', 307.0686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5879, 7, DATE '2015-06-25', 183.6164);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5880, 6, DATE '2015-01-19', 67.7035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5881, 9, DATE '2015-06-09', 928.2716);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5882, 2, DATE '2012-03-01', 326.3233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5883, 2, DATE '2015-12-31', 816.7955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5884, 1, DATE '2012-09-11', 630.9731);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5885, 4, DATE '2013-02-18', 507.4685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5886, 4, DATE '2013-08-31', 753.2138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5887, 3, DATE '2014-02-11', 962.1039);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5888, 6, DATE '2012-07-11', 78.5921);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5889, 10, DATE '2015-10-27', 980.7181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5890, 9, DATE '2015-03-11', 859.2885);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5891, 5, DATE '2012-06-02', 86.8068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5892, 2, DATE '2013-12-13', 74.8125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5893, 2, DATE '2015-06-26', 600.2945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5894, 8, DATE '2015-05-12', 34.6863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5895, 1, DATE '2013-11-03', 76.8264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5896, 9, DATE '2011-07-27', 334.0682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5897, 9, DATE '2014-07-19', 581.0190);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5898, 2, DATE '2014-12-14', 420.2845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5899, 7, DATE '2013-04-15', 274.8201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5900, 4, DATE '2012-08-30', 336.5144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5901, 5, DATE '2011-03-14', 614.4263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5902, 2, DATE '2015-08-22', 679.3558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5903, 1, DATE '2012-01-28', 394.9819);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5904, 8, DATE '2015-01-08', 815.2492);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5905, 5, DATE '2012-09-23', 259.7547);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5906, 5, DATE '2013-02-24', 392.8605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5907, 9, DATE '2013-11-01', 317.8373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5908, 2, DATE '2012-07-01', 428.5254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5909, 8, DATE '2012-03-04', 702.1369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5910, 10, DATE '2015-08-28', 889.1104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5911, 1, DATE '2014-11-17', 544.3962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5912, 5, DATE '2015-06-21', 330.0878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5913, 10, DATE '2011-07-18', 306.9984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5914, 6, DATE '2013-10-03', 594.4122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5915, 6, DATE '2013-06-22', 436.0536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5916, 2, DATE '2011-03-09', 945.2873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5917, 4, DATE '2015-10-06', 596.7211);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5918, 8, DATE '2015-10-11', 116.1422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5919, 7, DATE '2013-09-13', 467.4097);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5920, 7, DATE '2013-01-26', 208.6430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5921, 1, DATE '2013-06-21', 904.1132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5922, 1, DATE '2012-05-26', 559.0293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5923, 10, DATE '2015-04-06', 775.6181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5924, 5, DATE '2012-08-29', 166.7238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5925, 6, DATE '2012-12-03', 253.1089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5926, 1, DATE '2015-07-11', 790.6235);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5927, 7, DATE '2015-02-23', 981.4494);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5928, 2, DATE '2013-03-19', 696.6296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5929, 6, DATE '2014-03-26', 778.0213);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5930, 4, DATE '2015-11-30', 592.7167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5931, 8, DATE '2013-01-26', 58.2595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5932, 1, DATE '2011-08-27', 248.0685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5933, 8, DATE '2012-12-25', 32.2484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5934, 3, DATE '2013-10-26', 847.1020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5935, 1, DATE '2014-11-08', 453.2773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5936, 7, DATE '2015-10-19', 248.9158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5937, 2, DATE '2011-02-03', 931.3415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5938, 4, DATE '2011-12-23', 1.5463);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5939, 7, DATE '2015-12-20', 371.2184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5940, 9, DATE '2015-12-26', 114.6080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5941, 5, DATE '2015-10-31', 435.3764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5942, 2, DATE '2012-08-13', 533.5784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5943, 8, DATE '2011-05-09', 376.4552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5944, 10, DATE '2011-03-01', 91.6077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5945, 9, DATE '2011-04-25', 314.8923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5946, 1, DATE '2012-12-12', 756.7191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5947, 2, DATE '2013-05-29', 767.8142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5948, 7, DATE '2012-09-23', 5.8822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5949, 2, DATE '2012-11-19', 598.6327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5950, 10, DATE '2013-08-28', 131.5392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5951, 6, DATE '2011-10-22', 737.3471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5952, 1, DATE '2014-10-08', 464.8767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5953, 6, DATE '2012-04-02', 952.8748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5954, 1, DATE '2011-03-20', 66.1771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5955, 3, DATE '2015-03-11', 432.4013);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5956, 5, DATE '2014-10-18', 55.3969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5957, 3, DATE '2011-05-18', 903.7377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5958, 6, DATE '2015-05-31', 228.2581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5959, 3, DATE '2013-02-04', 562.1402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5960, 5, DATE '2013-03-16', 469.1313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5961, 8, DATE '2014-01-01', 411.4111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5962, 7, DATE '2011-08-15', 621.2078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5963, 7, DATE '2014-04-08', 650.5042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5964, 4, DATE '2012-04-04', 109.4201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5965, 3, DATE '2013-08-01', 830.8509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5966, 10, DATE '2014-03-23', 296.3276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5967, 7, DATE '2013-06-27', 297.8393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5968, 7, DATE '2013-09-21', 459.8964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5969, 5, DATE '2014-11-26', 141.1349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5970, 9, DATE '2013-09-04', 187.1378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5971, 1, DATE '2011-02-03', 13.9457);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5972, 10, DATE '2014-10-14', 595.1748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5973, 2, DATE '2015-10-23', 744.9238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5974, 8, DATE '2013-09-18', 352.8017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5975, 2, DATE '2013-03-29', 773.2666);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5976, 10, DATE '2011-11-09', 370.5347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5977, 3, DATE '2012-01-19', 182.5741);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5978, 10, DATE '2015-02-05', 684.0104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5979, 7, DATE '2012-05-07', 851.8316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5980, 5, DATE '2015-12-23', 496.3898);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5981, 9, DATE '2013-02-12', 22.8092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5982, 10, DATE '2013-06-02', 975.5671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5983, 1, DATE '2011-04-30', 97.9969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5984, 6, DATE '2011-07-29', 646.4820);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5985, 8, DATE '2015-02-09', 855.3697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5986, 8, DATE '2014-04-21', 593.3828);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5987, 5, DATE '2015-05-27', 295.1938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5988, 8, DATE '2012-10-07', 966.0713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5989, 1, DATE '2014-08-18', 414.7007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5990, 7, DATE '2011-01-21', 397.8803);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5991, 5, DATE '2015-06-03', 345.1781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5992, 6, DATE '2011-09-06', 703.0834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5993, 2, DATE '2014-11-18', 439.4061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5994, 3, DATE '2013-10-05', 902.0872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5995, 1, DATE '2012-12-24', 703.1969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5996, 9, DATE '2015-03-18', 814.1687);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5997, 5, DATE '2014-05-08', 883.0742);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5998, 4, DATE '2015-02-03', 267.0350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (5999, 8, DATE '2013-07-30', 260.7569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6000, 9, DATE '2013-02-01', 18.5646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6001, 4, DATE '2015-06-17', 458.8798);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6002, 6, DATE '2015-09-07', 307.9178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6003, 3, DATE '2013-10-29', 864.7474);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6004, 3, DATE '2015-03-18', 411.4949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6005, 10, DATE '2013-07-25', 117.5934);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6006, 7, DATE '2013-01-07', 142.1722);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6007, 9, DATE '2014-12-16', 719.9529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6008, 9, DATE '2014-07-15', 600.0730);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6009, 9, DATE '2013-12-21', 292.9105);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6010, 3, DATE '2014-05-02', 61.8665);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6011, 3, DATE '2013-09-30', 872.8229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6012, 3, DATE '2012-04-11', 219.7273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6013, 9, DATE '2014-01-24', 376.4266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6014, 8, DATE '2013-02-13', 65.7504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6015, 6, DATE '2011-02-02', 446.3220);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6016, 8, DATE '2011-08-01', 435.8440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6017, 6, DATE '2011-04-17', 523.2108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6018, 1, DATE '2013-09-10', 4.0221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6019, 7, DATE '2013-02-23', 254.0505);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6020, 5, DATE '2015-04-13', 237.4680);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6021, 6, DATE '2014-10-28', 1.1338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6022, 10, DATE '2011-09-20', 331.7681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6023, 6, DATE '2015-02-03', 45.1956);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6024, 8, DATE '2014-11-05', 743.2547);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6025, 5, DATE '2014-04-03', 841.9597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6026, 5, DATE '2015-05-31', 310.8624);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6027, 9, DATE '2015-11-27', 155.7686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6028, 10, DATE '2013-01-17', 842.8367);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6029, 7, DATE '2011-09-25', 649.6049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6030, 3, DATE '2014-01-11', 959.0980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6031, 6, DATE '2013-07-03', 487.4605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6032, 9, DATE '2012-12-15', 915.5391);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6033, 2, DATE '2012-07-08', 423.2534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6034, 9, DATE '2015-04-06', 833.2669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6035, 2, DATE '2011-07-08', 37.5100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6036, 3, DATE '2013-06-07', 714.8915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6037, 8, DATE '2015-08-05', 110.8197);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6038, 8, DATE '2012-02-13', 686.5020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6039, 7, DATE '2014-01-03', 528.8886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6040, 2, DATE '2013-02-02', 713.1974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6041, 9, DATE '2015-05-06', 873.4299);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6042, 7, DATE '2011-11-12', 695.1208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6043, 9, DATE '2014-10-17', 673.1607);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6044, 8, DATE '2011-04-18', 352.8341);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6045, 4, DATE '2013-04-22', 525.0574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6046, 2, DATE '2014-02-21', 125.4508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6047, 8, DATE '2013-08-12', 326.6568);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6048, 4, DATE '2012-10-04', 373.6557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6049, 7, DATE '2013-09-03', 455.7651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6050, 3, DATE '2012-05-25', 267.3529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6051, 3, DATE '2014-12-02', 290.9578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6052, 4, DATE '2011-08-29', 879.0521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6053, 8, DATE '2012-12-11', 12.9845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6054, 3, DATE '2014-04-19', 23.2888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6055, 3, DATE '2014-04-07', 17.4307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6056, 4, DATE '2014-09-27', 127.1116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6057, 10, DATE '2011-08-05', 262.7221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6058, 5, DATE '2014-12-24', 121.4927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6059, 9, DATE '2011-12-16', 569.5352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6060, 5, DATE '2014-02-25', 806.7310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6061, 9, DATE '2013-02-10', 986.4036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6062, 9, DATE '2012-11-28', 877.1163);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6063, 2, DATE '2013-10-20', 950.4682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6064, 7, DATE '2015-12-10', 333.8125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6065, 8, DATE '2011-10-31', 574.4060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6066, 4, DATE '2011-10-17', 957.2839);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6067, 2, DATE '2015-10-05', 796.4739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6068, 10, DATE '2014-10-20', 543.1597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6069, 7, DATE '2012-08-09', 28.2404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6070, 4, DATE '2013-08-28', 731.4306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6071, 1, DATE '2011-12-28', 325.0242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6072, 9, DATE '2015-03-05', 836.7088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6073, 4, DATE '2015-09-07', 475.1336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6074, 5, DATE '2011-01-22', 540.8531);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6075, 7, DATE '2015-12-08', 364.0382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6076, 9, DATE '2013-12-16', 306.0130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6077, 2, DATE '2012-12-04', 658.6074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6078, 9, DATE '2014-10-18', 692.3615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6079, 4, DATE '2012-07-15', 218.1972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6080, 4, DATE '2011-02-10', 716.5089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6081, 8, DATE '2012-10-18', 984.2057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6082, 5, DATE '2014-02-22', 782.1130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6083, 4, DATE '2015-05-17', 387.0715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6084, 4, DATE '2015-05-02', 382.2519);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6085, 10, DATE '2015-02-10', 668.1402);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6086, 2, DATE '2012-11-05', 608.4085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6087, 2, DATE '2011-01-05', 902.5545);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6088, 9, DATE '2014-03-22', 399.9646);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6089, 6, DATE '2011-12-30', 815.8362);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6090, 8, DATE '2012-10-10', 910.3984);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6091, 3, DATE '2012-11-03', 452.1693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6092, 3, DATE '2011-08-13', 989.3271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6093, 10, DATE '2011-02-28', 116.9668);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6094, 3, DATE '2015-11-09', 722.1576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6095, 3, DATE '2015-12-23', 726.7939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6096, 10, DATE '2013-06-07', 996.3136);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6097, 5, DATE '2014-01-22', 744.6527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6098, 3, DATE '2014-11-07', 339.3481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6099, 1, DATE '2015-06-19', 778.4282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6100, 1, DATE '2012-07-07', 567.7736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6101, 1, DATE '2014-05-20', 328.9769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6102, 8, DATE '2014-10-23', 783.4971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6103, 8, DATE '2011-02-26', 345.4153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6104, 3, DATE '2011-01-07', 724.3346);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6105, 3, DATE '2011-05-30', 942.3287);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6106, 5, DATE '2015-09-29', 454.2490);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6107, 10, DATE '2011-12-22', 403.9185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6108, 3, DATE '2012-11-19', 472.1315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6109, 7, DATE '2014-05-12', 659.2507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6110, 5, DATE '2011-04-23', 711.4177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6111, 3, DATE '2012-10-24', 468.5042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6112, 2, DATE '2012-10-17', 570.3606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6113, 1, DATE '2013-06-10', 903.2955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6114, 5, DATE '2011-11-05', 853.0263);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6115, 8, DATE '2012-05-09', 822.5254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6116, 4, DATE '2014-12-20', 204.2906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6117, 6, DATE '2013-07-15', 490.0448);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6118, 9, DATE '2014-06-20', 568.2162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6119, 7, DATE '2011-10-31', 665.6724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6120, 7, DATE '2014-12-26', 965.9976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6121, 3, DATE '2011-10-13', 54.7293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6122, 3, DATE '2012-07-16', 396.5093);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6123, 4, DATE '2013-10-22', 727.3235);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6124, 9, DATE '2015-10-30', 117.8420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6125, 1, DATE '2011-10-25', 279.2613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6126, 9, DATE '2011-05-18', 335.6972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6127, 9, DATE '2015-01-05', 719.7420);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6128, 2, DATE '2015-10-30', 752.9760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6129, 3, DATE '2011-01-30', 814.0593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6130, 7, DATE '2013-07-03', 367.7246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6131, 4, DATE '2015-11-24', 561.3604);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6132, 10, DATE '2014-01-27', 319.2592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6133, 9, DATE '2015-05-02', 913.9334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6134, 4, DATE '2011-01-09', 650.4237);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6135, 4, DATE '2012-09-23', 387.5320);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6136, 10, DATE '2013-12-26', 200.7085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6137, 8, DATE '2013-12-28', 436.6977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6138, 1, DATE '2015-05-10', 662.7370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6139, 2, DATE '2014-12-04', 439.9233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6140, 6, DATE '2015-05-15', 213.8911);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6141, 2, DATE '2011-11-15', 204.4900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6142, 9, DATE '2014-02-15', 430.4229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6143, 3, DATE '2015-11-10', 740.7140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6144, 2, DATE '2011-09-09', 104.4185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6145, 6, DATE '2015-12-17', 441.8942);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6146, 2, DATE '2011-01-17', 881.8087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6147, 2, DATE '2014-03-04', 86.0316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6148, 5, DATE '2015-04-25', 263.9405);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6149, 6, DATE '2014-07-02', 899.6323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6150, 9, DATE '2012-01-04', 522.5032);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6151, 5, DATE '2015-11-23', 506.2688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6152, 7, DATE '2015-08-04', 176.4364);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6153, 6, DATE '2014-01-08', 673.6758);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6154, 4, DATE '2011-06-25', 812.4306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6155, 8, DATE '2011-09-26', 513.0442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6156, 9, DATE '2012-11-04', 932.4676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6157, 4, DATE '2012-01-02', 56.1736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6158, 10, DATE '2011-04-29', 227.5732);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6159, 3, DATE '2015-03-15', 445.0733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6160, 5, DATE '2011-01-13', 606.6315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6161, 6, DATE '2011-09-24', 734.5070);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6162, 9, DATE '2012-02-22', 650.9425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6163, 1, DATE '2012-10-21', 658.0723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6164, 1, DATE '2011-11-10', 291.5260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6165, 1, DATE '2011-05-30', 150.0572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6166, 4, DATE '2014-09-28', 149.2449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6167, 4, DATE '2013-06-18', 656.4273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6168, 8, DATE '2013-06-02', 252.8717);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6169, 2, DATE '2015-02-12', 465.4943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6170, 8, DATE '2014-05-15', 621.8168);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6171, 7, DATE '2011-12-23', 767.5929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6172, 5, DATE '2014-03-08', 827.3078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6173, 7, DATE '2015-07-18', 128.2929);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6174, 2, DATE '2012-06-17', 451.7812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6175, 5, DATE '2014-02-10', 761.5076);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6176, 5, DATE '2013-08-28', 624.3064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6177, 1, DATE '2012-09-05', 655.7954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6178, 3, DATE '2013-02-12', 622.9050);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6179, 3, DATE '2015-11-14', 675.9479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6180, 10, DATE '2011-10-09', 397.4526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6181, 7, DATE '2013-03-15', 249.6655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6182, 5, DATE '2015-09-13', 455.8014);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6183, 7, DATE '2012-04-30', 853.3437);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6184, 4, DATE '2015-01-27', 291.5560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6185, 2, DATE '2013-08-10', 861.4559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6186, 8, DATE '2011-04-22', 384.9239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6187, 4, DATE '2011-01-19', 645.5835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6188, 5, DATE '2014-11-08', 101.5027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6189, 6, DATE '2015-04-15', 137.3795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6190, 5, DATE '2015-11-19', 455.0644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6191, 7, DATE '2012-12-24', 144.5349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6192, 9, DATE '2013-09-01', 209.1244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6193, 9, DATE '2011-02-25', 217.6637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6194, 8, DATE '2014-11-22', 833.2918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6195, 10, DATE '2014-08-21', 479.3842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6196, 4, DATE '2015-09-23', 553.5475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6197, 8, DATE '2012-04-27', 772.3507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6198, 2, DATE '2014-12-31', 449.1880);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6199, 2, DATE '2011-04-12', 954.3613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6200, 2, DATE '2012-03-21', 292.6492);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6201, 9, DATE '2013-08-01', 225.3814);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6202, 5, DATE '2011-10-03', 833.1600);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6203, 3, DATE '2011-03-14', 798.4463);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6204, 8, DATE '2011-02-17', 277.8155);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6205, 3, DATE '2011-01-12', 754.9104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6206, 1, DATE '2012-09-17', 678.9611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6207, 10, DATE '2011-01-18', 48.1435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6208, 5, DATE '2012-07-24', 221.8945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6209, 9, DATE '2013-05-14', 50.9230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6210, 4, DATE '2014-01-29', 888.7378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6211, 8, DATE '2011-03-01', 276.6722);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6212, 2, DATE '2014-11-19', 433.2686);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6213, 7, DATE '2011-06-16', 551.6254);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6214, 4, DATE '2014-06-07', 47.6206);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6215, 8, DATE '2013-10-30', 356.9659);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6216, 2, DATE '2012-01-12', 278.7056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6217, 2, DATE '2015-10-25', 797.5988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6218, 8, DATE '2013-09-24', 366.5163);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6219, 9, DATE '2014-04-02', 430.0701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6220, 3, DATE '2011-02-08', 765.1334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6221, 10, DATE '2014-09-09', 503.6614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6222, 9, DATE '2014-08-10', 554.9245);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6223, 2, DATE '2014-02-17', 115.4921);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6224, 7, DATE '2015-03-26', 10.4298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6225, 1, DATE '2012-05-21', 477.2818);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6226, 8, DATE '2014-04-23', 558.4685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6227, 7, DATE '2014-01-11', 609.6441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6228, 10, DATE '2011-08-27', 295.0011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6229, 2, DATE '2013-10-27', 972.3971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6230, 2, DATE '2014-05-20', 207.9600);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6231, 7, DATE '2012-05-03', 851.9558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6232, 9, DATE '2013-09-05', 206.6074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6233, 1, DATE '2012-11-03', 668.5438);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6234, 1, DATE '2014-08-25', 383.2986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6235, 2, DATE '2014-03-09', 172.0711);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6236, 2, DATE '2012-06-13', 416.5056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6237, 2, DATE '2015-07-03', 657.3552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6238, 10, DATE '2012-03-13', 575.5282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6239, 1, DATE '2015-01-15', 536.6457);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6240, 2, DATE '2011-11-23', 182.4948);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6241, 8, DATE '2011-04-05', 336.7804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6242, 10, DATE '2014-06-28', 423.6890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6243, 6, DATE '2012-06-26', 50.5797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6244, 3, DATE '2012-03-17', 248.6418);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6245, 8, DATE '2015-09-21', 178.3922);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6246, 6, DATE '2014-02-05', 711.2664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6247, 3, DATE '2013-03-18', 657.4990);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6248, 6, DATE '2012-09-20', 170.0430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6249, 10, DATE '2012-01-23', 476.3258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6250, 9, DATE '2013-08-10', 200.6785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6251, 3, DATE '2015-11-30', 755.9487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6252, 1, DATE '2014-08-03', 405.8344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6253, 3, DATE '2011-10-01', 19.1178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6254, 9, DATE '2011-03-05', 189.2279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6255, 3, DATE '2013-07-13', 788.9878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6256, 10, DATE '2014-12-22', 670.4570);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6257, 4, DATE '2013-08-15', 717.6678);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6258, 6, DATE '2011-12-19', 788.0165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6259, 7, DATE '2014-09-29', 800.5337);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6260, 5, DATE '2012-09-21', 196.4419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6261, 5, DATE '2014-09-07', 69.3170);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6262, 1, DATE '2015-05-25', 753.1424);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6263, 3, DATE '2014-09-27', 249.4974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6264, 8, DATE '2014-12-25', 842.9630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6265, 7, DATE '2012-09-28', 36.7819);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6266, 10, DATE '2013-06-25', 70.0648);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6267, 1, DATE '2013-01-16', 764.7249);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6268, 6, DATE '2012-10-21', 168.3268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6269, 3, DATE '2011-04-01', 875.5495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6270, 7, DATE '2012-05-19', 940.4604);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6271, 10, DATE '2012-07-12', 621.3504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6272, 3, DATE '2014-08-13', 222.0706);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6273, 7, DATE '2014-09-10', 829.8707);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6274, 7, DATE '2013-05-10', 247.5753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6275, 6, DATE '2015-11-05', 428.3530);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6276, 10, DATE '2011-03-14', 79.9724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6277, 4, DATE '2013-02-14', 504.3448);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6278, 10, DATE '2012-12-02', 866.8504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6279, 10, DATE '2015-07-06', 832.0377);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6280, 6, DATE '2014-04-16', 766.0155);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6281, 6, DATE '2012-02-05', 900.9695);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6282, 1, DATE '2012-04-23', 439.6010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6283, 1, DATE '2015-08-04', 818.6753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6284, 4, DATE '2011-03-20', 771.7185);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6285, 10, DATE '2014-06-20', 452.0114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6286, 7, DATE '2013-09-30', 446.1214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6287, 6, DATE '2012-12-06', 187.4895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6288, 2, DATE '2012-08-31', 479.3159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6289, 9, DATE '2012-02-13', 594.3109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6290, 2, DATE '2015-03-18', 501.6142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6291, 9, DATE '2014-10-29', 698.8378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6292, 6, DATE '2014-07-15', 869.3388);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6293, 3, DATE '2013-06-15', 774.9946);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6294, 6, DATE '2013-04-25', 340.2037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6295, 8, DATE '2013-03-18', 113.1778);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6296, 8, DATE '2011-11-11', 583.6380);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6297, 8, DATE '2015-10-02', 174.1915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6298, 8, DATE '2013-07-03', 207.6167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6299, 6, DATE '2015-06-20', 211.8598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6300, 8, DATE '2013-03-29', 108.3273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6301, 5, DATE '2012-01-20', 946.5415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6302, 7, DATE '2011-05-29', 489.1722);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6303, 3, DATE '2012-06-21', 294.4936);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6304, 4, DATE '2015-09-06', 535.8655);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6305, 9, DATE '2012-01-30', 579.3282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6306, 10, DATE '2012-04-18', 533.8781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6307, 4, DATE '2015-11-23', 575.9638);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6308, 6, DATE '2014-05-24', 771.5425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6309, 4, DATE '2011-04-30', 760.8750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6310, 3, DATE '2013-05-01', 709.0153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6311, 6, DATE '2012-11-07', 166.1122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6312, 5, DATE '2011-09-13', 850.8175);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6313, 7, DATE '2012-06-14', 955.9789);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6314, 2, DATE '2011-06-16', 34.5181);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6315, 10, DATE '2011-08-17', 295.4724);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6316, 4, DATE '2013-05-17', 629.7160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6317, 10, DATE '2015-10-21', 934.4672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6318, 10, DATE '2014-07-10', 477.7790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6319, 9, DATE '2011-07-07', 390.9516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6320, 1, DATE '2014-12-29', 590.6606);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6321, 4, DATE '2011-07-21', 882.5753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6322, 9, DATE '2011-05-19', 285.4090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6323, 8, DATE '2011-09-08', 574.0159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6324, 1, DATE '2012-01-14', 373.9352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6325, 8, DATE '2013-07-21', 241.6225);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6326, 5, DATE '2013-12-28', 752.0117);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6327, 1, DATE '2012-02-29', 447.0761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6328, 1, DATE '2012-05-17', 489.6669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6329, 10, DATE '2011-02-23', 134.3975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6330, 8, DATE '2014-12-26', 844.7150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6331, 3, DATE '2011-06-13', 905.7809);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6332, 6, DATE '2015-08-15', 296.7280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6333, 4, DATE '2013-06-15', 654.9905);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6334, 2, DATE '2013-04-08', 723.7103);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6335, 1, DATE '2013-03-27', 819.4740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6336, 9, DATE '2011-09-10', 411.7972);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6337, 8, DATE '2015-11-02', 145.1073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6338, 7, DATE '2015-11-29', 282.8098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6339, 5, DATE '2015-02-19', 192.3903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6340, 10, DATE '2013-03-04', 918.1334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6341, 3, DATE '2013-11-08', 870.1577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6342, 10, DATE '2014-07-15', 415.9471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6343, 9, DATE '2012-05-03', 718.4409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6344, 7, DATE '2014-10-15', 885.2956);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6345, 7, DATE '2013-05-11', 335.5020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6346, 5, DATE '2014-02-16', 848.0203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6347, 10, DATE '2013-01-31', 913.3600);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6348, 1, DATE '2012-12-30', 740.4764);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6349, 7, DATE '2012-09-09', 44.7312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6350, 5, DATE '2015-11-01', 483.4618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6351, 8, DATE '2012-01-22', 649.1708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6352, 8, DATE '2012-03-24', 696.4126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6353, 10, DATE '2012-12-27', 816.6651);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6354, 6, DATE '2011-06-23', 621.1992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6355, 5, DATE '2012-09-09', 225.7520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6356, 7, DATE '2011-09-04', 661.1325);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6357, 10, DATE '2015-09-20', 915.1564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6358, 3, DATE '2011-06-09', 920.5584);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6359, 6, DATE '2013-02-16', 294.2429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6360, 5, DATE '2014-02-01', 827.3165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6361, 10, DATE '2011-02-19', 86.8020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6362, 4, DATE '2014-07-09', 86.2968);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6363, 7, DATE '2014-03-31', 637.1450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6364, 7, DATE '2012-05-05', 916.1600);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6365, 10, DATE '2012-11-19', 803.2344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6366, 1, DATE '2013-03-26', 869.3842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6367, 2, DATE '2014-03-31', 195.8270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6368, 5, DATE '2015-03-08', 232.2685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6369, 1, DATE '2014-03-22', 215.0442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6370, 1, DATE '2015-12-08', 883.6753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6371, 6, DATE '2013-07-16', 484.6086);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6372, 4, DATE '2015-11-23', 651.6574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6373, 5, DATE '2015-05-22', 285.3886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6374, 9, DATE '2014-05-05', 472.8182);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6375, 8, DATE '2012-02-21', 720.5030);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6376, 4, DATE '2013-01-05', 466.6282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6377, 1, DATE '2015-01-15', 566.9681);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6378, 1, DATE '2012-11-24', 688.7203);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6379, 5, DATE '2014-09-05', 38.4332);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6380, 4, DATE '2015-06-05', 393.6023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6381, 6, DATE '2011-11-28', 838.6518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6382, 10, DATE '2015-03-01', 706.5997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6383, 5, DATE '2015-09-08', 444.9356);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6384, 5, DATE '2011-04-24', 650.9358);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6385, 10, DATE '2013-12-05', 195.5442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6386, 5, DATE '2015-03-21', 209.3683);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6387, 6, DATE '2013-08-18', 480.0629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6388, 8, DATE '2012-12-24', 33.7912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6389, 8, DATE '2011-07-31', 497.9582);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6390, 5, DATE '2012-07-23', 158.3415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6391, 9, DATE '2011-12-21', 496.6409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6392, 6, DATE '2015-05-26', 224.5490);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6393, 2, DATE '2013-10-12', 988.5669);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6394, 1, DATE '2012-01-18', 365.0739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6395, 10, DATE '2013-01-13', 831.3314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6396, 10, DATE '2015-05-03', 783.8608);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6397, 4, DATE '2011-04-17', 778.8022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6398, 2, DATE '2015-12-29', 802.2810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6399, 7, DATE '2012-11-25', 82.0611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6400, 6, DATE '2011-02-15', 466.1179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6401, 4, DATE '2015-11-18', 652.1933);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6402, 5, DATE '2013-11-25', 681.0914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6403, 10, DATE '2014-10-11', 525.4322);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6404, 6, DATE '2012-10-02', 161.0560);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6405, 10, DATE '2013-04-18', 998.8532);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6406, 5, DATE '2012-02-29', 997.5135);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6407, 4, DATE '2012-11-03', 411.0240);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6408, 2, DATE '2014-08-24', 343.8469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6409, 9, DATE '2015-05-02', 900.6963);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6410, 2, DATE '2015-09-04', 759.1239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6411, 6, DATE '2012-08-20', 94.1643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6412, 10, DATE '2013-10-26', 226.4360);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6413, 9, DATE '2012-10-03', 882.1252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6414, 2, DATE '2013-09-14', 900.6407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6415, 9, DATE '2013-03-06', 988.6647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6416, 1, DATE '2011-12-21', 380.2023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6417, 9, DATE '2014-10-31', 641.3613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6418, 2, DATE '2013-12-08', 986.2092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6419, 7, DATE '2014-06-01', 720.6158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6420, 5, DATE '2013-08-31', 593.8661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6421, 5, DATE '2015-08-08', 389.3212);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6422, 4, DATE '2012-04-07', 162.0357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6423, 8, DATE '2014-08-08', 734.3104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6424, 7, DATE '2012-08-29', 56.7026);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6425, 2, DATE '2014-12-19', 387.0343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6426, 10, DATE '2014-02-20', 260.0596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6427, 2, DATE '2013-02-10', 663.0906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6428, 5, DATE '2014-05-04', 920.3148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6429, 9, DATE '2012-04-22', 641.4869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6430, 8, DATE '2012-10-21', 936.6422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6431, 1, DATE '2012-09-21', 687.8261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6432, 9, DATE '2015-01-17', 764.6871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6433, 4, DATE '2015-12-30', 606.6591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6434, 9, DATE '2014-07-21', 572.3153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6435, 1, DATE '2015-07-18', 741.4090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6436, 1, DATE '2014-01-03', 157.5604);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6437, 10, DATE '2011-05-21', 181.1675);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6438, 9, DATE '2013-12-07', 283.8795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6439, 6, DATE '2014-01-05', 652.0826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6440, 6, DATE '2012-10-06', 198.0307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6441, 2, DATE '2013-05-18', 798.3444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6442, 5, DATE '2014-12-26', 136.2160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6443, 10, DATE '2013-08-24', 133.0949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6444, 7, DATE '2011-11-27', 738.8344);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6445, 10, DATE '2015-12-04', 64.1771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6446, 10, DATE '2014-02-24', 270.2049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6447, 8, DATE '2013-08-23', 342.4239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6448, 10, DATE '2011-01-29', 87.9261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6449, 2, DATE '2014-11-13', 376.4092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6450, 10, DATE '2012-01-25', 451.1291);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6451, 1, DATE '2011-07-03', 142.4995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6452, 2, DATE '2013-05-09', 792.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6453, 6, DATE '2012-07-30', 81.6652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6454, 3, DATE '2015-03-28', 488.1951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6455, 2, DATE '2011-07-11', 76.7967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6456, 10, DATE '2014-08-13', 490.1575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6457, 8, DATE '2015-04-19', 946.7811);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6458, 4, DATE '2013-02-12', 468.7295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6459, 4, DATE '2013-10-15', 774.0218);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6460, 10, DATE '2015-02-27', 738.7936);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6461, 3, DATE '2015-01-19', 334.4229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6462, 10, DATE '2014-07-02', 490.7092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6463, 3, DATE '2013-05-04', 702.3600);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6464, 1, DATE '2013-07-12', 964.0541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6465, 2, DATE '2013-12-14', 71.2978);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6466, 8, DATE '2013-08-03', 329.4772);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6467, 6, DATE '2013-10-28', 619.7769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6468, 10, DATE '2014-03-16', 309.8098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6469, 2, DATE '2014-02-27', 159.2317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6470, 9, DATE '2015-03-04', 831.1043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6471, 1, DATE '2011-08-02', 199.0347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6472, 1, DATE '2011-11-25', 357.4817);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6473, 7, DATE '2015-12-03', 334.1266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6474, 2, DATE '2012-08-26', 522.5850);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6475, 4, DATE '2011-04-16', 795.5218);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6476, 10, DATE '2011-08-14', 253.1051);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6477, 5, DATE '2014-08-14', 28.9407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6478, 1, DATE '2013-09-12', 995.4761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6479, 8, DATE '2012-09-25', 992.5255);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6480, 3, DATE '2011-10-25', 116.8294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6481, 3, DATE '2011-07-01', 917.6357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6482, 3, DATE '2013-01-12', 575.1644);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6483, 3, DATE '2015-06-21', 543.9055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6484, 10, DATE '2011-03-30', 190.3578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6485, 8, DATE '2012-04-20', 794.1427);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6486, 9, DATE '2015-05-15', 895.2331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6487, 4, DATE '2013-06-20', 683.0219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6488, 2, DATE '2011-10-05', 118.4640);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6489, 8, DATE '2014-01-11', 495.5186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6490, 2, DATE '2011-12-06', 251.2514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6491, 3, DATE '2014-09-17', 210.7793);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6492, 6, DATE '2014-04-08', 712.4380);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6493, 6, DATE '2011-02-22', 509.8578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6494, 7, DATE '2014-11-08', 913.2891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6495, 3, DATE '2013-09-17', 863.6079);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6496, 3, DATE '2014-11-16', 307.6351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6497, 3, DATE '2012-08-23', 433.8561);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6498, 9, DATE '2011-02-12', 169.0409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6499, 6, DATE '2013-12-13', 667.5365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6500, 2, DATE '2013-05-03', 734.6999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6501, 5, DATE '2011-04-30', 650.4280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6502, 8, DATE '2015-06-09', 32.6141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6503, 9, DATE '2012-12-02', 928.6945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6504, 4, DATE '2015-09-12', 545.3049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6505, 10, DATE '2011-06-25', 252.0943);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6506, 1, DATE '2015-08-08', 785.0179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6507, 6, DATE '2013-06-06', 458.4664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6508, 5, DATE '2015-12-04', 559.0802);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6509, 9, DATE '2014-12-12', 692.6733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6510, 2, DATE '2015-11-28', 823.6916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6511, 6, DATE '2015-12-30', 461.2167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6512, 7, DATE '2012-08-06', 951.3051);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6513, 7, DATE '2011-05-20', 476.2041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6514, 2, DATE '2012-12-21', 657.1923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6515, 7, DATE '2014-08-30', 821.1579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6516, 1, DATE '2013-01-06', 759.2585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6517, 7, DATE '2015-01-11', 946.8037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6518, 4, DATE '2013-02-05', 512.0021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6519, 4, DATE '2012-03-24', 169.9114);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6520, 3, DATE '2014-08-02', 176.0647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6521, 5, DATE '2011-02-13', 646.4554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6522, 4, DATE '2013-01-23', 501.3128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6523, 3, DATE '2011-03-06', 814.2912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6524, 10, DATE '2013-03-25', 907.9803);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6525, 6, DATE '2011-06-18', 620.3249);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6526, 5, DATE '2013-04-26', 486.5968);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6527, 5, DATE '2011-10-03', 847.6239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6528, 1, DATE '2012-01-26', 420.8375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6529, 10, DATE '2014-12-09', 658.9772);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6530, 1, DATE '2012-05-30', 487.8867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6531, 8, DATE '2014-12-21', 819.2491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6532, 6, DATE '2014-07-03', 859.8999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6533, 6, DATE '2015-10-01', 327.9395);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6534, 6, DATE '2015-05-26', 257.8256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6535, 8, DATE '2011-06-27', 466.4015);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6536, 6, DATE '2012-01-22', 885.0216);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6537, 4, DATE '2011-02-11', 646.4700);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6538, 10, DATE '2015-10-10', 998.6006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6539, 10, DATE '2015-10-05', 938.2636);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6540, 7, DATE '2012-09-13', 9.1248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6541, 4, DATE '2012-12-08', 436.7667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6542, 9, DATE '2013-07-17', 123.9416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6543, 3, DATE '2012-10-24', 425.7908);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6544, 6, DATE '2014-02-14', 671.8271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6545, 6, DATE '2011-12-07', 790.0347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6546, 6, DATE '2013-02-10', 259.4743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6547, 10, DATE '2013-11-20', 236.2339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6548, 5, DATE '2014-03-04', 852.6656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6549, 10, DATE '2011-03-12', 92.1312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6550, 2, DATE '2011-09-12', 104.3493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6551, 6, DATE '2015-11-06', 360.8314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6552, 9, DATE '2015-07-19', 921.8540);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6553, 6, DATE '2014-11-21', 999.1296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6554, 3, DATE '2015-05-14', 491.4718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6555, 8, DATE '2013-03-20', 88.2445);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6556, 2, DATE '2014-04-07', 149.1151);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6557, 5, DATE '2015-04-06', 218.3229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6558, 9, DATE '2015-09-10', 20.7142);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6559, 8, DATE '2015-03-28', 924.9801);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6560, 5, DATE '2014-02-28', 765.4975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6561, 7, DATE '2014-11-06', 937.3940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6562, 6, DATE '2012-05-12', 37.6288);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6563, 5, DATE '2011-12-27', 900.1031);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6564, 9, DATE '2013-07-14', 204.7866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6565, 4, DATE '2011-12-08', 4.4425);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6566, 10, DATE '2012-06-29', 601.3169);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6567, 2, DATE '2012-11-05', 623.3656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6568, 2, DATE '2011-12-25', 218.3784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6569, 5, DATE '2012-06-27', 190.7908);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6570, 2, DATE '2013-08-09', 936.1363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6571, 7, DATE '2012-11-26', 112.7885);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6572, 8, DATE '2015-04-04', 948.2032);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6573, 4, DATE '2013-05-03', 573.7386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6574, 7, DATE '2015-07-12', 160.7865);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6575, 10, DATE '2012-08-24', 739.2980);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6576, 6, DATE '2013-07-30', 522.5137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6577, 1, DATE '2011-04-02', 75.5220);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6578, 7, DATE '2013-01-19', 142.4641);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6579, 5, DATE '2012-04-18', 117.9455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6580, 10, DATE '2014-05-07', 360.8506);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6581, 6, DATE '2015-06-07', 250.3628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6582, 1, DATE '2013-08-01', 994.9584);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6583, 1, DATE '2011-11-17', 328.7063);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6584, 8, DATE '2014-03-30', 554.6278);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6585, 5, DATE '2012-07-25', 127.0552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6586, 9, DATE '2015-06-05', 897.3951);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6587, 10, DATE '2015-08-13', 860.7704);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6588, 4, DATE '2011-05-21', 836.4677);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6589, 8, DATE '2013-03-08', 169.5810);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6590, 6, DATE '2013-03-22', 317.2863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6591, 1, DATE '2012-10-17', 666.6987);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6592, 6, DATE '2011-06-04', 625.7558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6593, 2, DATE '2011-07-16', 73.6205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6594, 5, DATE '2012-08-06', 172.7660);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6595, 1, DATE '2013-11-08', 71.7308);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6596, 9, DATE '2011-07-30', 399.1379);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6597, 4, DATE '2012-07-22', 223.8386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6598, 5, DATE '2015-04-12', 221.0041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6599, 3, DATE '2013-03-09', 667.3845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6600, 6, DATE '2015-06-10', 188.7178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6601, 5, DATE '2011-04-08', 636.1088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6602, 8, DATE '2012-11-26', 17.8554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6603, 1, DATE '2012-09-06', 661.8748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6604, 9, DATE '2013-08-02', 155.9949);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6605, 6, DATE '2014-10-16', 991.5609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6606, 9, DATE '2011-08-04', 412.6283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6607, 6, DATE '2013-03-17', 348.1154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6608, 10, DATE '2015-05-13', 838.3430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6609, 4, DATE '2013-09-19', 752.1739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6610, 3, DATE '2015-08-21', 565.7309);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6611, 2, DATE '2014-01-06', 73.5930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6612, 9, DATE '2013-03-17', 75.8587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6613, 5, DATE '2014-05-24', 902.7687);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6614, 8, DATE '2011-11-21', 564.1294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6615, 10, DATE '2014-09-24', 515.1347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6616, 6, DATE '2012-04-06', 942.4357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6617, 5, DATE '2011-06-27', 708.9226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6618, 8, DATE '2013-09-29', 345.4752);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6619, 4, DATE '2011-12-21', 77.7313);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6620, 5, DATE '2012-07-04', 107.0474);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6621, 1, DATE '2012-11-17', 740.5466);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6622, 8, DATE '2012-06-18', 786.8979);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6623, 5, DATE '2014-10-18', 48.7974);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6624, 9, DATE '2015-04-08', 873.5045);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6625, 1, DATE '2011-10-24', 269.4375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6626, 2, DATE '2012-06-25', 487.0328);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6627, 7, DATE '2014-09-20', 874.5826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6628, 9, DATE '2011-09-27', 400.9725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6629, 6, DATE '2012-09-02', 89.0556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6630, 1, DATE '2012-01-26', 340.1601);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6631, 2, DATE '2012-01-09', 298.6750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6632, 6, DATE '2011-12-22', 854.5179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6633, 5, DATE '2015-11-13', 475.0796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6634, 9, DATE '2012-11-09', 929.2277);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6635, 6, DATE '2014-01-30', 724.7419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6636, 8, DATE '2013-07-11', 232.5074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6637, 1, DATE '2011-11-25', 333.0836);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6638, 2, DATE '2014-04-16', 172.7113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6639, 3, DATE '2015-06-15', 563.0670);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6640, 7, DATE '2011-12-23', 714.4270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6641, 4, DATE '2013-03-21', 549.2796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6642, 1, DATE '2011-04-02', 22.4273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6643, 10, DATE '2013-08-31', 84.2938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6644, 5, DATE '2013-07-18', 603.8502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6645, 5, DATE '2015-03-16', 243.6932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6646, 3, DATE '2015-08-02', 590.8400);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6647, 1, DATE '2013-01-10', 722.9871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6648, 4, DATE '2015-08-25', 509.4912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6649, 5, DATE '2013-11-13', 657.6314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6650, 6, DATE '2012-08-03', 129.2952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6651, 4, DATE '2011-02-03', 690.2154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6652, 7, DATE '2014-10-24', 878.3635);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6653, 2, DATE '2014-04-22', 143.2728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6654, 8, DATE '2011-09-05', 560.3370);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6655, 6, DATE '2013-07-24', 448.1713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6656, 7, DATE '2014-10-20', 849.2109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6657, 3, DATE '2014-02-08', 969.0581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6658, 2, DATE '2013-06-01', 788.3703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6659, 9, DATE '2012-10-10', 886.5574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6660, 5, DATE '2013-04-22', 504.5280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6661, 3, DATE '2012-11-14', 538.0458);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6662, 7, DATE '2012-06-20', 947.1429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6663, 4, DATE '2013-09-09', 749.2873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6664, 3, DATE '2012-08-24', 412.0137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6665, 2, DATE '2014-08-13', 267.0558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6666, 6, DATE '2013-01-16', 219.0751);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6667, 4, DATE '2013-05-05', 600.7791);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6668, 7, DATE '2012-07-14', 973.5410);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6669, 3, DATE '2013-10-22', 839.3875);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6670, 2, DATE '2012-03-16', 282.6273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6671, 6, DATE '2011-05-13', 609.3521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6672, 4, DATE '2013-03-12', 536.2112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6673, 6, DATE '2014-04-16', 782.4082);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6674, 7, DATE '2015-12-30', 363.3044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6675, 2, DATE '2015-04-16', 557.7678);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6676, 10, DATE '2012-08-17', 718.1192);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6677, 9, DATE '2014-10-18', 702.6040);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6678, 1, DATE '2012-04-01', 444.9472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6679, 4, DATE '2011-01-23', 629.8112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6680, 9, DATE '2012-03-24', 678.5976);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6681, 1, DATE '2015-06-15', 764.0457);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6682, 3, DATE '2015-01-26', 365.0914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6683, 5, DATE '2013-11-14', 743.3412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6684, 1, DATE '2011-01-31', 959.7605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6685, 8, DATE '2011-12-24', 649.9447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6686, 5, DATE '2013-03-17', 420.3116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6687, 4, DATE '2013-08-31', 711.2451);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6688, 8, DATE '2015-03-10', 914.7426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6689, 3, DATE '2015-04-19', 481.0564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6690, 9, DATE '2015-04-12', 875.5311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6691, 6, DATE '2015-06-02', 263.4493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6692, 9, DATE '2014-06-25', 544.7133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6693, 4, DATE '2012-07-07', 286.1539);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6694, 8, DATE '2013-02-22', 58.5390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6695, 5, DATE '2015-02-07', 176.3812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6696, 7, DATE '2011-10-01', 602.1368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6697, 8, DATE '2013-07-24', 273.1401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6698, 8, DATE '2012-01-07', 672.2801);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6699, 3, DATE '2014-12-06', 336.7944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6700, 9, DATE '2013-02-28', 24.6180);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6701, 10, DATE '2013-03-29', 990.0609);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6702, 5, DATE '2011-06-30', 749.4461);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6703, 1, DATE '2012-11-02', 670.1037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6704, 3, DATE '2012-08-29', 375.0041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6705, 10, DATE '2012-03-23', 519.9432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6706, 1, DATE '2013-11-23', 154.0041);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6707, 2, DATE '2011-07-10', 95.9552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6708, 6, DATE '2014-04-24', 779.9684);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6709, 6, DATE '2012-05-22', 2.5692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6710, 7, DATE '2011-12-07', 730.0522);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6711, 9, DATE '2011-01-03', 146.6068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6712, 3, DATE '2012-11-09', 524.1108);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6713, 8, DATE '2013-05-10', 158.5590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6714, 1, DATE '2011-07-20', 207.9598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6715, 5, DATE '2013-11-07', 740.4824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6716, 10, DATE '2013-10-19', 172.9544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6717, 3, DATE '2014-08-06', 203.8017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6718, 3, DATE '2013-08-09', 789.5269);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6719, 6, DATE '2011-09-01', 762.0691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6720, 8, DATE '2012-05-28', 846.7443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6721, 3, DATE '2015-05-19', 507.8301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6722, 6, DATE '2014-02-26', 686.0365);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6723, 5, DATE '2013-03-28', 492.4846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6724, 5, DATE '2014-07-13', 963.8565);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6725, 7, DATE '2012-10-14', 19.1779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6726, 7, DATE '2012-11-18', 64.6387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6727, 1, DATE '2011-09-06', 250.0572);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6728, 8, DATE '2012-02-23', 723.8692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6729, 2, DATE '2011-11-22', 186.9232);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6730, 5, DATE '2014-07-16', 955.6311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6731, 2, DATE '2015-01-24', 444.9790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6732, 1, DATE '2013-10-12', 30.3238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6733, 9, DATE '2013-04-27', 108.1528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6734, 6, DATE '2013-11-24', 605.1931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6735, 10, DATE '2014-12-26', 688.5368);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6736, 6, DATE '2014-12-17', 14.5996);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6737, 2, DATE '2013-03-25', 694.9877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6738, 2, DATE '2012-03-18', 368.3371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6739, 2, DATE '2014-11-09', 439.8172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6740, 8, DATE '2014-01-31', 495.9406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6741, 4, DATE '2012-09-08', 324.3563);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6742, 9, DATE '2015-05-09', 931.2767);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6743, 3, DATE '2013-10-19', 912.1734);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6744, 6, DATE '2014-05-13', 751.0043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6745, 10, DATE '2015-04-09', 728.9242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6746, 3, DATE '2013-07-24', 739.3386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6747, 1, DATE '2012-02-15', 386.1542);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6748, 4, DATE '2011-12-20', 78.1941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6749, 4, DATE '2015-04-17', 318.0566);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6750, 6, DATE '2012-04-21', 3.4268);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6751, 5, DATE '2013-02-25', 398.3350);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6752, 5, DATE '2015-12-15', 483.6133);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6753, 3, DATE '2011-05-08', 910.2111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6754, 6, DATE '2013-07-10', 490.0502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6755, 6, DATE '2013-10-13', 516.7880);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6756, 4, DATE '2015-02-01', 304.0243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6757, 1, DATE '2014-04-04', 256.9615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6758, 7, DATE '2014-04-23', 706.2472);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6759, 6, DATE '2015-11-16', 355.8261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6760, 3, DATE '2015-05-06', 455.3045);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6761, 10, DATE '2013-03-20', 903.9469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6762, 4, DATE '2015-05-17', 372.0861);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6763, 4, DATE '2013-06-03', 593.0452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6764, 1, DATE '2013-11-06', 46.9381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6765, 5, DATE '2012-11-13', 285.0731);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6766, 8, DATE '2013-03-24', 116.2829);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6767, 4, DATE '2015-07-15', 415.9579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6768, 3, DATE '2015-06-17', 553.3660);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6769, 2, DATE '2012-07-24', 519.4230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6770, 9, DATE '2014-11-22', 725.8827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6771, 8, DATE '2011-07-27', 477.9667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6772, 2, DATE '2013-05-21', 835.4647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6773, 2, DATE '2014-10-01', 349.7096);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6774, 8, DATE '2013-08-01', 266.1284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6775, 4, DATE '2015-09-20', 522.3879);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6776, 5, DATE '2011-01-10', 576.5534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6777, 4, DATE '2011-05-10', 773.8631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6778, 9, DATE '2014-11-16', 741.4803);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6779, 5, DATE '2015-04-05', 234.9323);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6780, 5, DATE '2015-03-23', 279.8394);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6781, 7, DATE '2011-10-04', 678.4845);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6782, 8, DATE '2015-09-17', 171.8631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6783, 4, DATE '2012-11-07', 405.8125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6784, 7, DATE '2015-08-03', 183.4964);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6785, 10, DATE '2012-05-20', 557.2961);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6786, 7, DATE '2015-02-10', 961.3658);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6787, 9, DATE '2013-06-06', 120.1128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6788, 4, DATE '2015-10-19', 618.1027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6789, 10, DATE '2011-02-11', 88.4051);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6790, 6, DATE '2015-11-25', 384.5124);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6791, 6, DATE '2011-09-15', 757.6381);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6792, 6, DATE '2014-12-03', 988.7406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6793, 6, DATE '2012-05-02', 12.5109);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6794, 9, DATE '2015-07-07', 984.5128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6795, 8, DATE '2011-11-14', 591.9937);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6796, 10, DATE '2013-04-24', 952.2703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6797, 5, DATE '2012-12-06', 338.2315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6798, 2, DATE '2015-12-13', 865.2353);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6799, 2, DATE '2012-06-30', 465.9312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6800, 3, DATE '2013-01-16', 612.6412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6801, 9, DATE '2014-01-09', 323.3806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6802, 9, DATE '2012-08-31', 832.7883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6803, 3, DATE '2015-05-29', 558.7711);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6804, 6, DATE '2011-05-27', 592.1739);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6805, 8, DATE '2011-09-26', 525.4601);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6806, 4, DATE '2015-10-08', 562.8704);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6807, 4, DATE '2012-03-16', 133.9036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6808, 5, DATE '2013-10-07', 644.0826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6809, 2, DATE '2013-10-21', 967.6623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6810, 2, DATE '2013-10-04', 940.2347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6811, 10, DATE '2014-09-24', 530.1612);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6812, 3, DATE '2015-05-20', 515.4812);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6813, 2, DATE '2015-01-18', 471.3148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6814, 2, DATE '2011-08-26', 75.9867);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6815, 7, DATE '2014-08-02', 776.8201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6816, 3, DATE '2013-07-03', 732.0838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6817, 1, DATE '2013-07-10', 966.2736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6818, 8, DATE '2013-10-31', 409.5488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6819, 1, DATE '2012-06-18', 489.6421);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6820, 8, DATE '2013-10-03', 323.7073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6821, 10, DATE '2015-10-18', 996.1702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6822, 1, DATE '2015-09-27', 797.8553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6823, 3, DATE '2015-05-06', 464.9608);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6824, 6, DATE '2012-08-30', 134.9106);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6825, 4, DATE '2014-03-09', 968.2447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6826, 2, DATE '2012-08-24', 489.2261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6827, 6, DATE '2012-01-19', 822.9538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6828, 4, DATE '2015-03-27', 365.1969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6829, 1, DATE '2012-09-17', 674.1348);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6830, 4, DATE '2013-05-28', 570.1176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6831, 10, DATE '2014-02-04', 238.3219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6832, 3, DATE '2011-05-28', 908.6279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6833, 7, DATE '2013-05-18', 275.5491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6834, 3, DATE '2013-03-19', 622.2912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6835, 6, DATE '2012-03-14', 956.4588);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6836, 8, DATE '2015-02-02', 845.6962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6837, 6, DATE '2011-04-22', 613.0920);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6838, 8, DATE '2012-06-13', 813.6386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6839, 9, DATE '2014-11-07', 658.0363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6840, 7, DATE '2012-08-13', 994.4257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6841, 4, DATE '2013-11-27', 827.4621);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6842, 4, DATE '2015-08-30', 476.0302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6843, 2, DATE '2012-12-29', 650.4404);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6844, 8, DATE '2013-05-10', 148.1705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6845, 7, DATE '2012-03-02', 854.3512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6846, 3, DATE '2012-04-28', 242.1569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6847, 5, DATE '2015-11-15', 517.4257);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6848, 4, DATE '2011-09-08', 936.5242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6849, 2, DATE '2011-12-05', 207.6927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6850, 5, DATE '2014-05-14', 859.9100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6851, 10, DATE '2015-10-16', 985.9967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6852, 8, DATE '2015-02-05', 928.6827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6853, 1, DATE '2014-06-27', 375.5932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6854, 4, DATE '2014-09-27', 142.2238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6855, 3, DATE '2013-03-31', 616.4710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6856, 8, DATE '2014-04-15', 525.5253);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6857, 6, DATE '2013-04-27', 367.8274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6858, 7, DATE '2013-09-28', 423.8605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6859, 3, DATE '2013-03-19', 623.9293);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6860, 6, DATE '2015-02-02', 36.2339);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6861, 8, DATE '2014-09-19', 739.9166);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6862, 1, DATE '2012-12-20', 768.7068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6863, 5, DATE '2012-01-20', 969.9479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6864, 8, DATE '2011-05-26', 397.5447);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6865, 2, DATE '2015-08-30', 701.9127);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6866, 8, DATE '2014-04-29', 621.5334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6867, 6, DATE '2013-01-01', 239.9321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6868, 9, DATE '2012-11-01', 849.0237);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6869, 7, DATE '2015-06-14', 119.5279);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6870, 9, DATE '2015-06-30', 931.1239);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6871, 8, DATE '2013-03-13', 118.9917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6872, 3, DATE '2012-01-27', 152.6349);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6873, 9, DATE '2014-12-25', 751.5125);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6874, 5, DATE '2015-11-05', 495.2164);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6875, 5, DATE '2015-11-07', 496.2452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6876, 6, DATE '2011-02-19', 520.1399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6877, 10, DATE '2013-09-29', 147.4148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6878, 5, DATE '2012-12-26', 316.7903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6879, 10, DATE '2011-07-01', 280.5594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6880, 1, DATE '2012-11-11', 726.0877);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6881, 8, DATE '2012-10-09', 971.8005);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6882, 3, DATE '2011-05-14', 886.4296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6883, 2, DATE '2014-04-23', 157.5042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6884, 6, DATE '2014-05-07', 814.2248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6885, 5, DATE '2013-08-13', 584.1209);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6886, 3, DATE '2014-12-30', 309.6392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6887, 3, DATE '2012-12-01', 533.0347);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6888, 4, DATE '2014-08-22', 133.3252);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6889, 10, DATE '2015-12-20', 5.8201);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6890, 8, DATE '2013-11-29', 430.9334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6891, 3, DATE '2012-10-08', 477.8687);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6892, 9, DATE '2013-07-25', 189.2315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6893, 6, DATE '2015-03-27', 189.7092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6894, 3, DATE '2015-10-06', 621.8023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6895, 10, DATE '2013-11-24', 254.5091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6896, 4, DATE '2011-12-08', 58.7553);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6897, 10, DATE '2014-08-11', 506.0824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6898, 4, DATE '2012-08-05', 252.8957);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6899, 7, DATE '2013-09-10', 446.2578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6900, 10, DATE '2013-11-03', 232.8178);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6901, 8, DATE '2015-04-28', 2.2248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6902, 6, DATE '2014-01-14', 668.4021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6903, 7, DATE '2012-03-26', 816.9962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6904, 3, DATE '2012-06-06', 276.5688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6905, 8, DATE '2012-03-02', 740.9183);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6906, 7, DATE '2014-09-19', 833.3618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6907, 9, DATE '2011-02-12', 177.1701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6908, 6, DATE '2014-08-22', 880.3768);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6909, 10, DATE '2014-11-21', 645.9786);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6910, 8, DATE '2013-02-10', 96.3310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6911, 9, DATE '2011-07-18', 378.1105);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6912, 1, DATE '2011-05-02', 51.0371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6913, 8, DATE '2013-03-31', 143.3011);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6914, 3, DATE '2011-05-09', 897.8416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6915, 9, DATE '2013-04-25', 64.4335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6916, 5, DATE '2014-05-09', 853.4870);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6917, 9, DATE '2014-08-30', 611.2026);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6918, 10, DATE '2013-09-15', 155.7230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6919, 3, DATE '2013-10-13', 813.4238);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6920, 9, DATE '2011-09-01', 392.2735);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6921, 5, DATE '2012-05-29', 88.4986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6922, 3, DATE '2014-05-13', 106.6068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6923, 10, DATE '2012-11-12', 843.2035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6924, 10, DATE '2012-07-15', 688.5945);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6925, 7, DATE '2013-09-22', 453.2551);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6926, 10, DATE '2015-08-20', 929.7602);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6927, 8, DATE '2012-11-01', 962.9258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6928, 6, DATE '2015-03-21', 129.7102);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6929, 6, DATE '2012-12-11', 240.7073);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6930, 2, DATE '2014-12-01', 437.4898);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6931, 6, DATE '2012-07-10', 14.0575);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6932, 6, DATE '2012-02-24', 894.5191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6933, 9, DATE '2015-04-18', 870.5326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6934, 1, DATE '2013-08-27', 47.7415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6935, 3, DATE '2013-07-17', 723.8629);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6936, 2, DATE '2014-09-26', 303.3983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6937, 6, DATE '2015-02-17', 69.4334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6938, 9, DATE '2012-11-16', 880.9354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6939, 8, DATE '2013-03-06', 73.3065);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6940, 9, DATE '2014-11-24', 750.7592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6941, 5, DATE '2014-11-17', 132.4690);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6942, 7, DATE '2014-04-12', 652.6579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6943, 5, DATE '2015-10-02', 487.3466);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6944, 3, DATE '2013-11-08', 909.4891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6945, 9, DATE '2013-05-15', 52.8229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6946, 2, DATE '2012-06-08', 426.8316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6947, 1, DATE '2011-04-26', 45.9304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6948, 3, DATE '2014-11-19', 291.8676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6949, 5, DATE '2013-06-13', 557.3687);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6950, 5, DATE '2015-07-19', 401.0221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6951, 5, DATE '2013-04-09', 447.5528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6952, 1, DATE '2011-11-26', 350.3593);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6953, 1, DATE '2014-10-24', 439.4720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6954, 8, DATE '2013-01-10', 53.9843);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6955, 5, DATE '2012-06-07', 144.3191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6956, 5, DATE '2011-12-17', 895.6180);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6957, 7, DATE '2012-03-03', 825.1986);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6958, 8, DATE '2015-09-11', 128.4016);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6959, 7, DATE '2014-09-14', 823.3137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6960, 9, DATE '2012-07-14', 811.1581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6961, 9, DATE '2012-11-18', 870.4361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6962, 4, DATE '2011-11-24', 47.4599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6963, 1, DATE '2012-09-10', 639.6695);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6964, 8, DATE '2015-12-22', 208.4887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6965, 2, DATE '2011-08-03', 82.2735);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6966, 3, DATE '2015-05-24', 483.5914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6967, 3, DATE '2012-01-15', 180.5045);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6968, 8, DATE '2015-08-05', 95.5595);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6969, 10, DATE '2013-10-23', 173.9787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6970, 7, DATE '2014-07-30', 761.0352);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6971, 10, DATE '2015-03-22', 784.0536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6972, 10, DATE '2012-10-14', 730.2672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6973, 2, DATE '2011-07-12', 82.4164);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6974, 5, DATE '2014-11-20', 62.6645);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6975, 5, DATE '2012-10-14', 259.8044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6976, 9, DATE '2014-02-16', 435.8407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6977, 9, DATE '2014-08-11', 619.2602);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6978, 7, DATE '2015-01-05', 933.7144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6979, 1, DATE '2015-03-03', 635.7716);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6980, 5, DATE '2012-04-16', 26.4235);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6981, 9, DATE '2015-04-27', 883.8298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6982, 6, DATE '2013-12-14', 671.0581);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6983, 2, DATE '2012-10-08', 572.3415);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6984, 2, DATE '2013-05-26', 839.6853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6985, 7, DATE '2012-08-23', 989.9371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6986, 6, DATE '2011-08-16', 663.6983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6987, 5, DATE '2013-05-03', 455.0471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6988, 1, DATE '2013-04-07', 816.5482);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6989, 6, DATE '2012-03-22', 903.4224);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6990, 9, DATE '2012-07-31', 828.2450);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6991, 6, DATE '2013-07-26', 478.1998);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6992, 9, DATE '2015-06-08', 941.0318);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6993, 3, DATE '2014-03-04', 57.6216);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6994, 10, DATE '2011-08-24', 262.1485);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6995, 10, DATE '2013-01-06', 880.3232);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6996, 2, DATE '2013-12-24', 85.0091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6997, 7, DATE '2012-08-02', 12.9884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6998, 7, DATE '2015-10-12', 278.8579);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (6999, 1, DATE '2013-04-08', 827.2156);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7000, 7, DATE '2013-12-22', 569.2315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7001, 10, DATE '2011-05-25', 246.3270);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7002, 4, DATE '2011-09-22', 950.3709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7003, 4, DATE '2012-01-27', 117.8889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7004, 8, DATE '2014-11-14', 796.3335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7005, 6, DATE '2011-04-29', 616.9685);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7006, 5, DATE '2011-06-27', 717.2857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7007, 9, DATE '2011-05-18', 267.9428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7008, 6, DATE '2015-12-05', 376.8074);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7009, 4, DATE '2011-03-29', 794.1799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7010, 7, DATE '2014-04-21', 708.4784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7011, 7, DATE '2013-05-07', 276.3578);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7012, 10, DATE '2013-02-27', 891.4842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7013, 8, DATE '2011-07-12', 492.6301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7014, 2, DATE '2013-05-31', 796.8902);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7015, 10, DATE '2013-03-20', 927.3283);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7016, 4, DATE '2014-12-05', 199.3780);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7017, 2, DATE '2015-02-16', 475.1184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7018, 10, DATE '2015-04-17', 799.9842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7019, 2, DATE '2014-04-30', 218.5517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7020, 6, DATE '2015-12-19', 418.5753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7021, 8, DATE '2013-01-21', 28.5443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7022, 2, DATE '2014-10-09', 363.9564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7023, 2, DATE '2014-05-15', 192.1371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7024, 2, DATE '2012-03-24', 345.7338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7025, 2, DATE '2012-01-05', 282.8354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7026, 1, DATE '2015-10-14', 843.0219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7027, 8, DATE '2014-08-12', 672.6455);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7028, 2, DATE '2015-11-18', 820.2680);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7029, 6, DATE '2012-11-13', 182.3414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7030, 4, DATE '2014-10-21', 174.7953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7031, 2, DATE '2012-07-17', 422.8523);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7032, 2, DATE '2014-10-31', 340.4023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7033, 6, DATE '2012-09-29', 106.4988);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7034, 5, DATE '2012-03-11', 66.5400);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7035, 6, DATE '2011-11-24', 780.0966);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7036, 6, DATE '2014-08-05', 933.4589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7037, 2, DATE '2012-11-17', 553.1691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7038, 4, DATE '2013-11-24', 776.0080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7039, 7, DATE '2013-01-27', 222.7167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7040, 2, DATE '2012-02-27', 272.6514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7041, 8, DATE '2011-03-31', 395.7554);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7042, 9, DATE '2013-05-29', 78.2396);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7043, 8, DATE '2013-01-10', 22.3682);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7044, 10, DATE '2013-12-01', 194.9439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7045, 2, DATE '2015-03-27', 551.8871);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7046, 6, DATE '2011-05-29', 586.7156);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7047, 2, DATE '2014-11-28', 448.4016);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7048, 1, DATE '2011-10-05', 260.7315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7049, 1, DATE '2014-06-06', 334.8202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7050, 6, DATE '2014-02-01', 680.9452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7051, 10, DATE '2014-11-08', 609.8907);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7052, 8, DATE '2013-04-17', 213.0043);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7053, 6, DATE '2012-06-13', 60.3061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7054, 6, DATE '2013-04-20', 408.6403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7055, 9, DATE '2011-12-02', 540.6872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7056, 8, DATE '2012-08-15', 882.3707);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7057, 2, DATE '2013-05-09', 758.2338);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7058, 2, DATE '2015-11-04', 772.1552);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7059, 7, DATE '2013-11-10', 513.4981);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7060, 5, DATE '2011-07-17', 773.9467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7061, 8, DATE '2012-11-15', 44.6401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7062, 8, DATE '2011-06-30', 447.6748);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7063, 1, DATE '2014-01-21', 194.4660);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7064, 10, DATE '2012-06-07', 619.3846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7065, 5, DATE '2012-10-05', 285.6261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7066, 5, DATE '2014-07-07', 935.9555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7067, 4, DATE '2011-06-01', 784.9854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7068, 4, DATE '2015-05-02', 426.0901);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7069, 6, DATE '2012-07-08', 16.7935);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7070, 5, DATE '2014-08-15', 993.8694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7071, 2, DATE '2013-01-17', 646.2089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7072, 8, DATE '2012-03-24', 699.1104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7073, 4, DATE '2013-03-21', 577.2674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7074, 10, DATE '2013-03-04', 945.9004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7075, 9, DATE '2015-09-20', 22.8198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7076, 10, DATE '2015-08-25', 950.3047);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7077, 4, DATE '2012-09-29', 341.5881);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7078, 2, DATE '2011-06-15', 997.1932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7079, 1, DATE '2012-12-28', 793.8467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7080, 6, DATE '2011-08-09', 696.1199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7081, 10, DATE '2011-11-17', 394.6202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7082, 8, DATE '2013-11-08', 411.9140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7083, 1, DATE '2012-06-14', 485.4478);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7084, 1, DATE '2014-10-12', 501.3962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7085, 5, DATE '2015-12-14', 564.9046);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7086, 5, DATE '2015-04-02', 209.8479);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7087, 7, DATE '2013-05-20', 280.0961);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7088, 1, DATE '2015-06-11', 697.8585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7089, 6, DATE '2011-04-11', 525.8528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7090, 9, DATE '2015-04-10', 897.7260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7091, 4, DATE '2012-03-29', 175.2251);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7092, 1, DATE '2013-01-14', 781.0139);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7093, 8, DATE '2011-01-15', 262.5099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7094, 2, DATE '2012-07-14', 448.7701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7095, 5, DATE '2015-04-14', 228.0113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7096, 10, DATE '2015-10-02', 948.0806);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7097, 9, DATE '2015-05-09', 883.7737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7098, 9, DATE '2011-08-05', 402.9837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7099, 6, DATE '2012-02-27', 909.3179);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7100, 7, DATE '2011-09-21', 615.9316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7101, 2, DATE '2015-12-29', 801.7302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7102, 9, DATE '2015-07-29', 22.3115);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7103, 5, DATE '2015-03-30', 243.9379);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7104, 6, DATE '2015-10-22', 340.9508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7105, 4, DATE '2012-01-16', 34.7362);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7106, 2, DATE '2013-08-17', 910.7804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7107, 4, DATE '2011-01-27', 635.7369);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7108, 6, DATE '2015-04-11', 114.4057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7109, 7, DATE '2013-07-31', 385.8204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7110, 10, DATE '2012-04-08', 590.3826);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7111, 5, DATE '2015-11-17', 540.7825);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7112, 10, DATE '2012-11-25', 761.0406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7113, 2, DATE '2013-11-06', 978.3086);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7114, 1, DATE '2013-04-03', 817.3783);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7115, 5, DATE '2015-08-30', 379.3264);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7116, 10, DATE '2015-01-07', 632.7261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7117, 7, DATE '2015-01-15', 962.2271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7118, 1, DATE '2015-04-11', 693.0698);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7119, 6, DATE '2012-06-25', 54.4799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7120, 10, DATE '2013-07-06', 75.7781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7121, 8, DATE '2012-02-17', 655.8594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7122, 4, DATE '2011-12-21', 87.1269);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7123, 8, DATE '2015-01-22', 900.2374);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7124, 8, DATE '2013-03-30', 119.0676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7125, 2, DATE '2013-05-19', 818.6442);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7126, 2, DATE '2011-01-04', 865.1950);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7127, 1, DATE '2012-03-09', 436.6004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7128, 2, DATE '2011-09-08', 128.4973);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7129, 5, DATE '2013-11-21', 717.8891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7130, 10, DATE '2015-12-20', 74.7393);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7131, 1, DATE '2011-04-19', 66.5310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7132, 6, DATE '2012-02-25', 938.6044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7133, 7, DATE '2015-04-19', 87.8753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7134, 4, DATE '2012-04-09', 177.9150);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7135, 4, DATE '2011-08-12', 894.3897);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7136, 2, DATE '2012-04-20', 372.3087);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7137, 3, DATE '2014-08-12', 167.9760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7138, 6, DATE '2012-08-23', 144.4969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7139, 7, DATE '2013-09-27', 466.6599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7140, 3, DATE '2013-04-29', 654.1243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7141, 1, DATE '2015-03-06', 574.1111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7142, 1, DATE '2014-02-08', 165.6903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7143, 5, DATE '2012-11-10', 312.0380);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7144, 7, DATE '2015-01-02', 935.4703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7145, 5, DATE '2015-05-25', 356.9434);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7146, 4, DATE '2015-05-04', 414.1846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7147, 9, DATE '2015-03-10', 802.7054);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7148, 7, DATE '2013-10-14', 445.1317);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7149, 7, DATE '2012-11-14', 69.4437);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7150, 6, DATE '2011-04-07', 595.2852);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7151, 3, DATE '2011-09-17', 985.8535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7152, 9, DATE '2011-01-28', 190.7038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7153, 3, DATE '2015-02-10', 348.5037);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7154, 7, DATE '2014-08-23', 833.5397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7155, 9, DATE '2015-08-04', 960.0723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7156, 9, DATE '2015-01-08', 714.6033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7157, 1, DATE '2011-07-08', 122.0742);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7158, 7, DATE '2012-12-30', 124.8703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7159, 5, DATE '2013-06-05', 522.3066);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7160, 3, DATE '2012-01-12', 169.5412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7161, 2, DATE '2012-06-09', 474.1799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7162, 3, DATE '2015-05-22', 507.2396);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7163, 2, DATE '2012-05-21', 396.5167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7164, 8, DATE '2013-08-11', 311.0811);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7165, 9, DATE '2011-12-22', 523.8515);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7166, 9, DATE '2014-09-23', 602.1782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7167, 4, DATE '2013-08-09', 673.1652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7168, 9, DATE '2012-07-30', 800.3935);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7169, 8, DATE '2012-08-23', 922.9886);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7170, 4, DATE '2014-05-12', 7.0176);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7171, 7, DATE '2011-05-29', 464.7501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7172, 2, DATE '2013-05-25', 817.7302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7173, 4, DATE '2012-07-14', 226.4099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7174, 3, DATE '2015-02-27', 400.3557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7175, 9, DATE '2014-05-02', 501.6671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7176, 8, DATE '2014-01-08', 490.1690);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7177, 9, DATE '2015-02-09', 775.0889);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7178, 1, DATE '2011-01-20', 964.7671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7179, 4, DATE '2013-11-06', 762.1243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7180, 9, DATE '2014-01-15', 404.4596);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7181, 3, DATE '2011-10-28', 62.4896);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7182, 4, DATE '2014-05-27', 991.4687);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7183, 5, DATE '2014-10-25', 59.0536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7184, 10, DATE '2013-08-16', 122.6038);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7185, 7, DATE '2015-04-05', 88.8858);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7186, 3, DATE '2011-03-22', 875.8273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7187, 3, DATE '2013-01-14', 590.1007);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7188, 1, DATE '2011-08-27', 254.3357);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7189, 5, DATE '2012-09-05', 217.8428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7190, 5, DATE '2012-08-03', 179.7863);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7191, 1, DATE '2011-10-14', 250.2345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7192, 7, DATE '2012-08-12', 43.1057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7193, 1, DATE '2015-03-21', 622.1903);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7194, 4, DATE '2012-09-15', 297.1186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7195, 2, DATE '2011-11-20', 179.9444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7196, 9, DATE '2015-10-16', 66.8715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7197, 10, DATE '2012-09-20', 769.1737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7198, 7, DATE '2015-04-02', 0.9569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7199, 9, DATE '2014-01-12', 411.6187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7200, 6, DATE '2011-09-01', 754.7653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7201, 10, DATE '2012-09-25', 741.0195);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7202, 1, DATE '2013-08-10', 2.3119);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7203, 10, DATE '2012-02-22', 522.1431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7204, 4, DATE '2014-07-05', 62.4260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7205, 9, DATE '2015-11-10', 130.5351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7206, 2, DATE '2014-04-24', 168.1233);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7207, 5, DATE '2014-07-16', 964.2940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7208, 1, DATE '2015-12-15', 948.1480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7209, 8, DATE '2011-04-23', 331.8726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7210, 2, DATE '2012-07-26', 469.9033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7211, 1, DATE '2015-11-29', 939.5145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7212, 1, DATE '2011-06-19', 157.3071);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7213, 3, DATE '2015-02-24', 362.7460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7214, 7, DATE '2015-05-21', 117.8470);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7215, 10, DATE '2011-03-18', 107.0516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7216, 8, DATE '2014-01-14', 482.7112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7217, 8, DATE '2011-07-29', 448.1859);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7218, 3, DATE '2014-10-06', 273.9128);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7219, 2, DATE '2014-05-08', 222.1952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7220, 7, DATE '2011-10-02', 648.0243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7221, 7, DATE '2012-09-08', 12.0774);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7222, 4, DATE '2012-12-13', 418.8295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7223, 4, DATE '2015-11-24', 582.5507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7224, 3, DATE '2011-01-20', 743.2023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7225, 3, DATE '2013-07-29', 756.7832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7226, 1, DATE '2014-10-16', 421.6443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7227, 1, DATE '2014-03-06', 195.5398);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7228, 1, DATE '2015-10-29', 929.2913);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7229, 1, DATE '2014-04-09', 220.4113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7230, 10, DATE '2014-07-18', 434.7955);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7231, 8, DATE '2012-04-20', 720.9953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7232, 2, DATE '2015-11-10', 774.1320);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7233, 3, DATE '2013-01-08', 553.1484);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7234, 9, DATE '2013-03-07', 7.3590);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7235, 9, DATE '2012-04-22', 663.4401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7236, 3, DATE '2014-03-19', 60.1776);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7237, 5, DATE '2013-04-04', 469.3256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7238, 2, DATE '2011-04-22', 996.6276);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7239, 2, DATE '2013-10-07', 992.0688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7240, 5, DATE '2011-12-13', 920.7626);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7241, 8, DATE '2012-09-05', 911.5333);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7242, 2, DATE '2013-01-31', 641.9527);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7243, 3, DATE '2011-05-06', 922.4631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7244, 3, DATE '2011-02-10', 747.9395);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7245, 5, DATE '2012-09-04', 240.2718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7246, 1, DATE '2011-04-28', 92.9274);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7247, 4, DATE '2013-06-19', 680.3597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7248, 5, DATE '2015-11-01', 504.3432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7249, 5, DATE '2012-07-01', 190.0670);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7250, 5, DATE '2013-11-05', 697.2332);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7251, 1, DATE '2015-03-20', 618.6856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7252, 7, DATE '2013-12-16', 495.2608);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7253, 6, DATE '2011-11-25', 778.7617);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7254, 2, DATE '2013-04-12', 763.5944);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7255, 9, DATE '2014-12-24', 742.6878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7256, 6, DATE '2015-10-13', 322.1900);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7257, 7, DATE '2013-09-16', 419.7613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7258, 7, DATE '2012-02-02', 778.9409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7259, 1, DATE '2011-12-07', 305.6428);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7260, 8, DATE '2012-01-25', 708.8908);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7261, 1, DATE '2011-02-19', 972.5835);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7262, 5, DATE '2014-09-17', 35.0027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7263, 10, DATE '2012-09-06', 727.7367);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7264, 9, DATE '2012-10-05', 897.0771);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7265, 4, DATE '2011-04-08', 748.9080);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7266, 9, DATE '2011-01-19', 165.3824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7267, 8, DATE '2014-06-10', 604.1587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7268, 5, DATE '2012-12-19', 355.3870);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7269, 8, DATE '2014-01-28', 454.4069);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7270, 8, DATE '2012-12-29', 46.8740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7271, 3, DATE '2011-10-12', 13.3856);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7272, 7, DATE '2011-04-08', 451.5583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7273, 2, DATE '2011-12-31', 281.8440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7274, 7, DATE '2013-05-27', 301.4327);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7275, 9, DATE '2015-01-27', 736.4910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7276, 5, DATE '2015-08-09', 370.1248);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7277, 2, DATE '2012-08-09', 496.3664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7278, 1, DATE '2015-10-14', 834.6112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7279, 9, DATE '2014-05-18', 502.9304);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7280, 3, DATE '2013-04-03', 663.8557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7281, 8, DATE '2012-04-28', 741.2847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7282, 7, DATE '2014-05-06', 691.1966);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7283, 6, DATE '2014-04-30', 739.2242);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7284, 7, DATE '2011-06-04', 523.1781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7285, 10, DATE '2015-04-30', 816.1099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7286, 2, DATE '2014-05-06', 225.7345);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7287, 6, DATE '2014-12-17', 995.3704);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7288, 2, DATE '2015-09-29', 789.5541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7289, 1, DATE '2014-03-15', 264.6712);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7290, 3, DATE '2012-07-10', 341.2501);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7291, 6, DATE '2011-07-03', 640.4164);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7292, 8, DATE '2012-03-03', 690.3847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7293, 1, DATE '2015-05-16', 690.9848);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7294, 4, DATE '2012-09-12', 283.1780);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7295, 4, DATE '2011-10-24', 948.1791);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7296, 4, DATE '2013-12-20', 876.5306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7297, 3, DATE '2011-05-27', 914.2160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7298, 5, DATE '2014-07-31', 25.3860);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7299, 10, DATE '2015-11-05', 999.0316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7300, 6, DATE '2012-08-16', 74.8893);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7301, 3, DATE '2012-11-17', 488.7688);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7302, 9, DATE '2011-07-02', 324.9726);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7303, 7, DATE '2012-10-03', 49.9363);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7304, 7, DATE '2015-07-03', 143.1930);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7305, 2, DATE '2013-01-25', 683.8476);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7306, 5, DATE '2014-12-13', 167.1272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7307, 6, DATE '2012-12-17', 213.4167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7308, 10, DATE '2014-06-30', 477.3290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7309, 3, DATE '2014-03-17', 27.1033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7310, 4, DATE '2015-05-18', 372.5630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7311, 5, DATE '2014-03-05', 825.8236);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7312, 6, DATE '2013-12-04', 585.1502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7313, 9, DATE '2013-09-17', 276.0104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7314, 9, DATE '2014-09-05', 641.7872);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7315, 10, DATE '2015-09-29', 967.6061);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7316, 5, DATE '2012-10-15', 281.3868);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7317, 9, DATE '2011-05-21', 295.7785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7318, 3, DATE '2012-04-04', 204.5586);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7319, 9, DATE '2013-06-07', 80.9672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7320, 3, DATE '2012-12-02', 523.1735);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7321, 3, DATE '2012-02-03', 170.0121);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7322, 7, DATE '2014-09-12', 814.6046);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7323, 5, DATE '2014-10-07', 90.7157);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7324, 6, DATE '2012-07-21', 113.1567);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7325, 2, DATE '2012-06-29', 406.4576);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7326, 6, DATE '2015-08-11', 323.0009);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7327, 6, DATE '2011-11-24', 760.5736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7328, 8, DATE '2015-04-19', 998.6661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7329, 3, DATE '2012-08-03', 353.2536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7330, 6, DATE '2012-02-08', 859.9605);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7331, 3, DATE '2015-03-15', 455.9088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7332, 8, DATE '2014-01-09', 470.9804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7333, 2, DATE '2015-12-10', 835.5797);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7334, 3, DATE '2012-10-01', 428.0410);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7335, 10, DATE '2011-05-17', 175.0869);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7336, 10, DATE '2011-10-29', 416.3120);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7337, 10, DATE '2012-08-03', 641.2603);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7338, 10, DATE '2014-10-28', 596.0312);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7339, 6, DATE '2014-05-10', 839.3305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7340, 6, DATE '2011-05-19', 648.9827);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7341, 6, DATE '2012-05-20', 12.3177);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7342, 7, DATE '2011-06-20', 518.0414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7343, 9, DATE '2012-07-15', 762.4508);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7344, 7, DATE '2014-10-28', 892.1083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7345, 9, DATE '2014-05-07', 515.4266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7346, 10, DATE '2013-07-30', 55.2662);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7347, 10, DATE '2014-06-17', 414.3743);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7348, 3, DATE '2011-09-11', 49.1975);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7349, 5, DATE '2012-12-14', 315.5719);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7350, 10, DATE '2015-01-09', 666.7923);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7351, 5, DATE '2013-08-01', 580.7521);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7352, 10, DATE '2015-02-22', 709.6573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7353, 6, DATE '2012-02-24', 944.4188);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7354, 7, DATE '2013-12-03', 475.8580);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7355, 4, DATE '2011-07-15', 904.8773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7356, 6, DATE '2014-03-08', 674.1642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7357, 5, DATE '2012-09-24', 234.2569);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7358, 2, DATE '2011-03-15', 936.7796);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7359, 5, DATE '2014-01-04', 736.7354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7360, 7, DATE '2013-06-17', 360.8467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7361, 9, DATE '2014-01-20', 406.5536);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7362, 9, DATE '2013-08-30', 214.7507);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7363, 7, DATE '2012-11-26', 124.0753);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7364, 7, DATE '2013-02-07', 167.1429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7365, 2, DATE '2011-03-05', 916.6542);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7366, 8, DATE '2011-02-25', 354.8432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7367, 5, DATE '2013-12-26', 749.5705);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7368, 6, DATE '2011-12-18', 847.9694);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7369, 9, DATE '2014-04-21', 466.7002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7370, 1, DATE '2014-12-01', 551.2941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7371, 5, DATE '2011-03-15', 640.1266);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7372, 10, DATE '2012-07-23', 699.7473);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7373, 8, DATE '2013-11-25', 365.2282);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7374, 4, DATE '2013-01-20', 431.9846);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7375, 8, DATE '2011-07-16', 510.8558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7376, 6, DATE '2011-08-17', 651.9708);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7377, 9, DATE '2013-02-28', 52.1538);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7378, 8, DATE '2015-12-10', 198.6075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7379, 7, DATE '2014-03-16', 597.7302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7380, 3, DATE '2014-11-30', 351.1914);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7381, 6, DATE '2012-02-24', 908.6267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7382, 4, DATE '2011-03-15', 711.3761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7383, 3, DATE '2013-05-06', 683.0941);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7384, 4, DATE '2013-07-26', 686.4614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7385, 2, DATE '2014-07-09', 279.2083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7386, 3, DATE '2011-01-21', 746.2515);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7387, 3, DATE '2012-11-16', 526.5616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7388, 5, DATE '2013-01-06', 359.7216);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7389, 10, DATE '2012-03-19', 523.1638);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7390, 4, DATE '2013-03-11', 500.9227);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7391, 5, DATE '2015-02-03', 182.0551);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7392, 9, DATE '2012-05-21', 704.4808);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7393, 5, DATE '2011-10-25', 859.2959);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7394, 9, DATE '2011-11-24', 478.4838);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7395, 7, DATE '2013-04-29', 242.4290);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7396, 7, DATE '2014-09-21', 797.5670);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7397, 1, DATE '2014-07-24', 393.9660);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7398, 2, DATE '2015-06-07', 595.3078);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7399, 5, DATE '2014-08-25', 975.4541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7400, 2, DATE '2014-03-13', 160.5833);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7401, 6, DATE '2015-08-05', 305.6957);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7402, 5, DATE '2013-06-30', 566.4049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7403, 4, DATE '2013-05-22', 582.4973);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7404, 5, DATE '2014-01-14', 764.2779);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7405, 6, DATE '2014-10-27', 26.6656);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7406, 6, DATE '2012-01-10', 881.0048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7407, 2, DATE '2012-03-29', 344.4291);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7408, 2, DATE '2015-02-03', 512.4342);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7409, 10, DATE '2013-05-21', 965.0023);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7410, 8, DATE '2015-11-29', 252.9064);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7411, 8, DATE '2012-01-08', 622.0104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7412, 7, DATE '2012-10-16', 35.6493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7413, 5, DATE '2012-12-29', 339.0493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7414, 3, DATE '2015-02-05', 385.5440);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7415, 1, DATE '2012-04-23', 452.2200);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7416, 5, DATE '2013-11-07', 695.1776);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7417, 6, DATE '2011-04-27', 531.6566);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7418, 3, DATE '2015-05-03', 437.6140);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7419, 6, DATE '2014-08-01', 887.9346);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7420, 9, DATE '2011-02-13', 170.4027);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7421, 5, DATE '2014-04-10', 828.2817);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7422, 10, DATE '2011-12-20', 389.8489);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7423, 6, DATE '2015-09-30', 324.8055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7424, 5, DATE '2012-02-10', 965.7776);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7425, 6, DATE '2015-10-28', 369.2389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7426, 6, DATE '2014-10-24', 935.6459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7427, 5, DATE '2011-09-30', 840.4515);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7428, 10, DATE '2013-01-01', 886.7445);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7429, 8, DATE '2015-09-24', 189.5555);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7430, 1, DATE '2012-10-25', 713.2888);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7431, 6, DATE '2013-01-23', 258.0048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7432, 7, DATE '2013-09-23', 456.8460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7433, 3, DATE '2012-04-16', 223.1534);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7434, 6, DATE '2011-01-04', 437.1469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7435, 7, DATE '2015-04-27', 45.4956);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7436, 2, DATE '2014-08-27', 342.2217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7437, 10, DATE '2013-10-23', 128.8787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7438, 9, DATE '2015-04-22', 918.8163);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7439, 9, DATE '2014-09-30', 659.7957);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7440, 6, DATE '2013-06-29', 398.2036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7441, 2, DATE '2014-10-24', 401.8224);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7442, 2, DATE '2013-10-14', 14.1273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7443, 5, DATE '2015-08-19', 394.7194);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7444, 3, DATE '2012-04-21', 270.2573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7445, 6, DATE '2012-03-03', 878.9124);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7446, 8, DATE '2013-04-20', 146.4057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7447, 4, DATE '2015-05-23', 365.4314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7448, 3, DATE '2012-09-19', 473.7519);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7449, 9, DATE '2015-08-03', 26.2637);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7450, 3, DATE '2015-06-22', 547.2514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7451, 1, DATE '2014-05-27', 265.9104);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7452, 8, DATE '2015-03-23', 956.3520);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7453, 7, DATE '2011-11-07', 707.3733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7454, 7, DATE '2014-07-13', 805.0514);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7455, 7, DATE '2015-12-04', 332.3017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7456, 6, DATE '2014-08-16', 915.8469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7457, 9, DATE '2013-10-01', 241.5994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7458, 9, DATE '2012-04-12', 616.7198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7459, 9, DATE '2014-03-19', 395.0390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7460, 10, DATE '2011-01-03', 91.0198);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7461, 1, DATE '2011-04-13', 40.5533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7462, 3, DATE '2015-03-28', 457.6847);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7463, 5, DATE '2015-05-13', 322.8787);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7464, 10, DATE '2011-07-27', 251.7134);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7465, 2, DATE '2013-11-05', 994.9017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7466, 2, DATE '2014-04-17', 165.1643);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7467, 4, DATE '2011-07-02', 812.4960);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7468, 9, DATE '2012-12-26', 901.9025);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7469, 6, DATE '2015-10-11', 340.0483);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7470, 10, DATE '2013-08-28', 109.9983);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7471, 5, DATE '2011-01-16', 566.2989);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7472, 8, DATE '2012-01-05', 612.8403);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7473, 5, DATE '2011-08-04', 777.8184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7474, 10, DATE '2012-02-02', 489.7310);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7475, 8, DATE '2012-04-21', 768.5803);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7476, 4, DATE '2011-06-27', 814.1544);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7477, 6, DATE '2012-05-03', 995.1295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7478, 4, DATE '2014-06-11', 54.5481);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7479, 9, DATE '2015-12-09', 86.8652);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7480, 8, DATE '2013-07-10', 222.8331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7481, 2, DATE '2015-06-04', 570.2144);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7482, 3, DATE '2015-01-11', 366.6996);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7483, 2, DATE '2013-06-01', 860.4807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7484, 5, DATE '2011-04-04', 642.3042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7485, 10, DATE '2014-05-31', 447.3784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7486, 9, DATE '2013-11-02', 301.6529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7487, 1, DATE '2012-11-17', 749.4728);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7488, 7, DATE '2013-10-04', 418.1021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7489, 10, DATE '2011-01-31', 104.8452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7490, 2, DATE '2011-09-11', 129.6488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7491, 3, DATE '2011-11-26', 100.6223);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7492, 2, DATE '2012-07-13', 512.1589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7493, 10, DATE '2012-02-04', 523.7773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7494, 10, DATE '2014-09-27', 568.7758);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7495, 6, DATE '2013-03-19', 357.6503);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7496, 9, DATE '2015-07-29', 944.1378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7497, 7, DATE '2014-06-03', 691.2487);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7498, 5, DATE '2015-01-23', 143.0059);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7499, 2, DATE '2014-06-16', 275.3557);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7500, 5, DATE '2013-11-17', 713.7480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7501, 4, DATE '2012-10-19', 333.9098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7502, 5, DATE '2013-05-27', 463.5289);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7503, 7, DATE '2012-12-09', 133.7036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7504, 9, DATE '2012-12-06', 916.2654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7505, 8, DATE '2015-06-07', 980.9526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7506, 4, DATE '2013-05-23', 653.0701);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7507, 3, DATE '2014-08-20', 178.5335);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7508, 7, DATE '2015-10-05', 217.6422);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7509, 9, DATE '2013-03-24', 36.4710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7510, 3, DATE '2015-06-09', 518.1474);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7511, 10, DATE '2013-04-15', 920.7174);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7512, 6, DATE '2015-04-22', 187.0512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7513, 1, DATE '2012-05-04', 529.8546);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7514, 2, DATE '2011-09-09', 172.2058);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7515, 8, DATE '2011-08-02', 520.8054);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7516, 9, DATE '2012-04-02', 673.8537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7517, 2, DATE '2012-10-27', 597.2040);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7518, 10, DATE '2015-02-08', 680.5746);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7519, 1, DATE '2013-02-26', 804.3351);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7520, 4, DATE '2011-01-03', 693.2488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7521, 2, DATE '2012-05-31', 415.6915);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7522, 8, DATE '2013-09-27', 394.3938);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7523, 10, DATE '2012-11-25', 797.0573);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7524, 5, DATE '2015-01-30', 210.3994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7525, 7, DATE '2012-10-02', 9.3760);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7526, 4, DATE '2014-07-05', 54.1399);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7527, 9, DATE '2015-12-01', 89.0630);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7528, 6, DATE '2012-11-06', 209.0426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7529, 5, DATE '2014-11-16', 132.0807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7530, 9, DATE '2012-09-23', 824.4426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7531, 8, DATE '2013-01-24', 122.9057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7532, 1, DATE '2013-04-11', 852.1235);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7533, 3, DATE '2015-12-26', 779.1925);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7534, 5, DATE '2013-01-22', 373.1172);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7535, 4, DATE '2011-09-21', 888.9234);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7536, 8, DATE '2013-01-07', 106.6855);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7537, 7, DATE '2013-02-01', 232.9960);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7538, 3, DATE '2011-06-26', 944.2154);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7539, 7, DATE '2011-10-29', 661.3517);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7540, 7, DATE '2012-01-08', 794.3083);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7541, 6, DATE '2015-03-16', 123.1193);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7542, 4, DATE '2013-02-13', 531.8306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7543, 9, DATE '2011-07-14', 381.6311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7544, 7, DATE '2011-08-25', 586.6978);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7545, 2, DATE '2014-05-29', 208.9314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7546, 8, DATE '2012-08-05', 913.5711);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7547, 1, DATE '2011-03-12', 982.3044);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7548, 9, DATE '2011-05-28', 351.5715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7549, 3, DATE '2014-02-25', 47.9703);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7550, 8, DATE '2011-12-18', 683.7966);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7551, 8, DATE '2013-10-02', 346.9337);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7552, 8, DATE '2015-04-26', 10.6740);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7553, 5, DATE '2012-11-26', 338.6709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7554, 8, DATE '2014-06-14', 582.1070);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7555, 3, DATE '2012-06-19', 298.0564);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7556, 7, DATE '2015-01-23', 939.5160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7557, 6, DATE '2011-07-03', 666.4717);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7558, 3, DATE '2013-11-10', 923.3042);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7559, 2, DATE '2011-03-07', 906.8893);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7560, 5, DATE '2011-12-03', 926.8126);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7561, 5, DATE '2013-06-22', 564.0071);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7562, 8, DATE '2012-10-13', 969.4910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7563, 3, DATE '2011-11-20', 85.5614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7564, 10, DATE '2011-07-01', 212.0284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7565, 6, DATE '2013-05-16', 395.2416);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7566, 10, DATE '2011-01-04', 68.5939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7567, 4, DATE '2015-04-28', 407.8587);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7568, 6, DATE '2015-04-13', 156.7373);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7569, 8, DATE '2015-12-20', 283.2824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7570, 1, DATE '2014-07-26', 414.1199);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7571, 3, DATE '2015-03-01', 440.8577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7572, 9, DATE '2012-05-03', 652.9887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7573, 3, DATE '2014-04-13', 19.2229);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7574, 5, DATE '2012-02-19', 10.0267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7575, 8, DATE '2011-10-21', 570.1294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7576, 9, DATE '2015-04-18', 883.8610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7577, 9, DATE '2013-03-16', 12.7627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7578, 3, DATE '2012-04-03', 210.3594);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7579, 3, DATE '2011-09-03', 1.4680);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7580, 10, DATE '2011-02-27', 95.8049);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7581, 3, DATE '2014-04-26', 71.8356);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7582, 1, DATE '2015-07-07', 737.4916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7583, 4, DATE '2014-09-12', 161.0723);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7584, 8, DATE '2013-11-29', 448.2842);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7585, 2, DATE '2014-12-23', 477.5088);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7586, 10, DATE '2013-10-01', 112.2316);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7587, 7, DATE '2011-05-16', 513.4526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7588, 5, DATE '2012-07-14', 197.0854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7589, 2, DATE '2011-08-05', 75.0607);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7590, 8, DATE '2012-08-29', 949.4075);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7591, 2, DATE '2012-07-08', 440.2138);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7592, 4, DATE '2015-03-24', 309.6919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7593, 1, DATE '2011-04-22', 37.3260);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7594, 3, DATE '2015-11-26', 734.5392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7595, 2, DATE '2014-07-18', 230.3012);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7596, 9, DATE '2013-06-02', 153.6284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7597, 1, DATE '2012-03-26', 446.2691);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7598, 9, DATE '2011-01-14', 169.6026);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7599, 2, DATE '2014-04-10', 191.4562);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7600, 3, DATE '2014-05-25', 140.3375);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7601, 5, DATE '2013-04-10', 505.7123);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7602, 6, DATE '2011-11-30', 825.5670);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7603, 2, DATE '2011-06-09', 68.2890);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7604, 3, DATE '2015-08-03', 633.8504);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7605, 5, DATE '2012-10-18', 242.9389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7606, 9, DATE '2012-05-31', 693.9451);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7607, 5, DATE '2012-01-13', 991.4512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7608, 10, DATE '2011-10-09', 328.6441);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7609, 1, DATE '2013-08-25', 11.9775);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7610, 5, DATE '2013-03-04', 414.1954);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7611, 9, DATE '2012-11-08', 926.7533);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7612, 3, DATE '2015-03-31', 456.1122);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7613, 10, DATE '2013-03-09', 921.8361);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7614, 2, DATE '2011-01-08', 811.0844);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7615, 2, DATE '2013-08-09', 854.9769);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7616, 4, DATE '2013-12-17', 826.5155);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7617, 5, DATE '2014-02-01', 808.4187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7618, 6, DATE '2013-12-21', 637.2773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7619, 9, DATE '2012-07-09', 734.5196);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7620, 6, DATE '2015-08-16', 283.0100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7621, 4, DATE '2015-08-22', 555.1413);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7622, 10, DATE '2013-10-14', 210.7733);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7623, 4, DATE '2014-09-08', 81.6766);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7624, 10, DATE '2014-04-23', 333.8750);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7625, 9, DATE '2013-01-17', 973.9062);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7626, 9, DATE '2015-12-08', 131.1657);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7627, 8, DATE '2012-01-13', 615.6626);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7628, 1, DATE '2014-05-19', 284.6837);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7629, 3, DATE '2013-08-03', 779.7256);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7630, 10, DATE '2014-05-20', 416.5010);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7631, 8, DATE '2014-01-22', 437.5919);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7632, 1, DATE '2013-03-03', 843.1601);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7633, 2, DATE '2013-12-24', 18.9032);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7634, 1, DATE '2013-04-11', 861.1306);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7635, 6, DATE '2013-11-19', 590.0926);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7636, 8, DATE '2013-05-28', 246.2687);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7637, 10, DATE '2015-01-28', 669.2025);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7638, 2, DATE '2015-02-09', 527.2219);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7639, 3, DATE '2012-02-11', 205.3452);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7640, 3, DATE '2013-07-24', 783.5638);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7641, 6, DATE '2012-09-18', 120.7804);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7642, 7, DATE '2015-08-08', 184.8084);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7643, 4, DATE '2014-11-20', 185.1079);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7644, 8, DATE '2014-06-03', 660.8653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7645, 9, DATE '2015-10-22', 22.6541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7646, 10, DATE '2013-04-09', 984.1017);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7647, 5, DATE '2013-01-15', 387.8558);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7648, 9, DATE '2011-04-14', 226.2417);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7649, 1, DATE '2013-04-18', 879.5623);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7650, 9, DATE '2011-08-02', 403.7857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7651, 4, DATE '2015-05-02', 345.2098);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7652, 5, DATE '2014-04-06', 808.9918);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7653, 10, DATE '2014-07-07', 435.0831);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7654, 6, DATE '2014-08-26', 908.4462);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7655, 10, DATE '2014-10-04', 585.1962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7656, 5, DATE '2015-06-27', 294.9390);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7657, 2, DATE '2013-03-23', 743.8904);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7658, 2, DATE '2013-02-16', 734.4141);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7659, 4, DATE '2013-07-17', 659.9443);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7660, 7, DATE '2012-11-10', 111.7731);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7661, 1, DATE '2011-05-20', 78.2824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7662, 4, DATE '2013-08-27', 706.7674);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7663, 8, DATE '2014-03-07', 548.9186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7664, 2, DATE '2015-04-07', 595.4765);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7665, 7, DATE '2015-02-11', 976.6036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7666, 8, DATE '2015-09-07', 83.5931);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7667, 1, DATE '2012-04-07', 437.2089);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7668, 10, DATE '2015-11-29', 60.7055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7669, 7, DATE '2013-02-19', 220.9917);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7670, 5, DATE '2011-03-14', 608.7081);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7671, 4, DATE '2014-11-19', 157.3130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7672, 4, DATE '2014-12-24', 281.1967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7673, 4, DATE '2012-11-09', 431.9321);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7674, 7, DATE '2014-12-16', 950.9559);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7675, 1, DATE '2013-11-27', 162.2296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7676, 7, DATE '2011-01-15', 370.3329);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7677, 6, DATE '2014-11-25', 25.6653);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7678, 7, DATE '2011-04-08', 420.8113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7679, 1, DATE '2014-07-03', 311.2208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7680, 10, DATE '2015-10-10', 989.8045);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7681, 5, DATE '2013-11-23', 743.3100);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7682, 10, DATE '2011-10-01', 389.4209);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7683, 1, DATE '2012-01-31', 405.1215);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7684, 5, DATE '2013-01-02', 375.9398);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7685, 6, DATE '2015-01-18', 71.2912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7686, 3, DATE '2015-10-18', 628.6002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7687, 1, DATE '2014-08-28', 408.0770);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7688, 7, DATE '2015-05-01', 110.4571);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7689, 2, DATE '2014-07-09', 275.9343);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7690, 1, DATE '2014-05-25', 295.1535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7691, 6, DATE '2011-03-07', 502.3784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7692, 9, DATE '2012-12-12', 934.7885);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7693, 8, DATE '2012-07-26', 867.2777);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7694, 7, DATE '2015-04-02', 93.5721);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7695, 2, DATE '2013-03-07', 705.2813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7696, 3, DATE '2015-01-23', 414.0130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7697, 10, DATE '2012-06-02', 635.8899);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7698, 3, DATE '2015-08-15', 589.6314);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7699, 1, DATE '2015-04-22', 684.2618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7700, 2, DATE '2011-02-14', 939.0611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7701, 9, DATE '2012-01-03', 546.8927);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7702, 6, DATE '2013-02-16', 327.1502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7703, 3, DATE '2014-02-23', 5.2499);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7704, 6, DATE '2013-02-04', 270.8541);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7705, 5, DATE '2012-09-12', 246.4727);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7706, 1, DATE '2011-05-10', 64.0130);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7707, 2, DATE '2012-05-27', 377.0597);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7708, 4, DATE '2015-07-23', 484.1272);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7709, 6, DATE '2011-09-29', 746.2165);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7710, 3, DATE '2014-09-20', 214.8632);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7711, 10, DATE '2011-08-03', 269.2737);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7712, 5, DATE '2012-12-16', 323.0791);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7713, 1, DATE '2014-08-17', 423.1932);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7714, 5, DATE '2013-10-07', 670.1398);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7715, 3, DATE '2014-12-18', 368.4631);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7716, 2, DATE '2015-08-19', 688.8616);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7717, 4, DATE '2012-07-27', 301.6459);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7718, 3, DATE '2012-03-05', 172.9788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7719, 6, DATE '2011-03-21', 524.1853);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7720, 4, DATE '2015-04-26', 348.0033);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7721, 8, DATE '2012-01-11', 675.5162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7722, 5, DATE '2012-12-08', 326.7518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7723, 8, DATE '2012-05-23', 784.7713);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7724, 6, DATE '2014-09-27', 925.8382);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7725, 10, DATE '2011-01-08', 106.3297);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7726, 6, DATE '2012-12-08', 222.5246);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7727, 6, DATE '2013-05-31', 413.9191);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7728, 8, DATE '2013-08-09', 338.3599);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7729, 5, DATE '2012-10-10', 245.6746);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7730, 8, DATE '2014-11-05', 748.2167);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7731, 8, DATE '2014-08-14', 734.4431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7732, 3, DATE '2015-04-12', 436.0340);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7733, 7, DATE '2011-12-17', 736.5495);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7734, 10, DATE '2014-05-19', 372.1598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7735, 1, DATE '2014-10-08', 442.9118);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7736, 9, DATE '2011-10-08', 416.1598);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7737, 7, DATE '2013-08-08', 384.1709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7738, 5, DATE '2014-12-26', 134.2673);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7739, 10, DATE '2011-04-23', 129.4671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7740, 5, DATE '2014-09-11', 7.2781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7741, 2, DATE '2014-05-24', 251.5405);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7742, 8, DATE '2015-02-05', 923.9498);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7743, 1, DATE '2014-08-02', 364.2406);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7744, 9, DATE '2015-10-19', 61.0710);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7745, 1, DATE '2013-10-23', 25.8798);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7746, 2, DATE '2014-03-22', 179.2992);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7747, 9, DATE '2014-04-28', 511.5952);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7748, 4, DATE '2014-10-19', 197.1378);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7749, 4, DATE '2011-04-15', 725.1090);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7750, 1, DATE '2013-07-19', 16.4197);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7751, 9, DATE '2013-06-28', 112.3670);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7752, 7, DATE '2011-03-31', 462.9111);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7753, 7, DATE '2015-05-28', 65.4460);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7754, 7, DATE '2015-12-27', 336.2585);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7755, 4, DATE '2015-02-04', 263.5449);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7756, 5, DATE '2015-01-26', 220.1408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7757, 8, DATE '2011-09-27', 542.3790);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7758, 7, DATE '2015-05-29', 79.4118);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7759, 7, DATE '2013-01-28', 164.5243);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7760, 9, DATE '2015-10-05', 23.9480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7761, 6, DATE '2013-12-09', 650.0940);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7762, 5, DATE '2014-10-18', 38.6997);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7763, 9, DATE '2013-10-12', 238.4526);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7764, 8, DATE '2012-11-24', 997.9999);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7765, 6, DATE '2011-02-06', 480.4202);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7766, 7, DATE '2012-04-22', 833.2398);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7767, 9, DATE '2011-12-31', 586.5296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7768, 1, DATE '2011-03-31', 51.0334);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7769, 4, DATE '2014-12-30', 227.2280);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7770, 4, DATE '2014-03-13', 952.3034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7771, 6, DATE '2013-01-11', 304.6906);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7772, 9, DATE '2013-08-02', 167.3786);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7773, 4, DATE '2011-11-13', 43.5116);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7774, 1, DATE '2012-07-09', 516.9072);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7775, 3, DATE '2011-12-04', 96.4628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7776, 1, DATE '2012-12-05', 751.5664);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7777, 4, DATE '2014-05-08', 962.5113);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7778, 10, DATE '2012-08-04', 723.7002);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7779, 5, DATE '2011-12-06', 899.9583);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7780, 8, DATE '2012-10-18', 927.0305);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7781, 8, DATE '2014-08-12', 710.9294);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7782, 3, DATE '2014-08-12', 216.7813);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7783, 4, DATE '2013-04-26', 613.2509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7784, 5, DATE '2015-03-25', 229.2549);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7785, 10, DATE '2012-05-09', 635.8496);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7786, 1, DATE '2014-05-16', 271.5320);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7787, 6, DATE '2015-11-16', 370.5879);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7788, 10, DATE '2011-12-22', 400.2910);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7789, 7, DATE '2015-04-14', 108.6148);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7790, 7, DATE '2015-09-12', 222.7709);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7791, 2, DATE '2011-01-11', 873.7809);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7792, 10, DATE '2014-03-12', 304.7591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7793, 8, DATE '2012-11-27', 969.7430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7794, 2, DATE '2011-07-19', 105.5190);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7795, 10, DATE '2011-10-03', 357.1841);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7796, 7, DATE '2015-08-06', 212.8407);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7797, 9, DATE '2012-04-26', 685.4971);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7798, 4, DATE '2012-09-07', 366.2408);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7799, 3, DATE '2015-09-12', 580.6509);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7800, 5, DATE '2012-07-03', 192.6401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7801, 3, DATE '2013-03-23', 592.7697);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7802, 8, DATE '2014-01-29', 460.5618);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7803, 10, DATE '2015-10-20', 969.9099);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7804, 1, DATE '2013-02-02', 772.8057);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7805, 5, DATE '2011-07-09', 711.7291);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7806, 1, DATE '2015-11-27', 944.9885);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7807, 4, DATE '2015-05-18', 419.3994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7808, 7, DATE '2013-11-18', 548.5389);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7809, 4, DATE '2015-01-24', 239.7957);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7810, 4, DATE '2013-03-02', 511.9785);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7811, 1, DATE '2011-09-21', 257.6296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7812, 9, DATE '2015-02-22', 818.6788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7813, 3, DATE '2014-06-24', 179.4535);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7814, 9, DATE '2011-04-13', 237.4939);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7815, 2, DATE '2012-02-24', 313.0187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7816, 3, DATE '2015-04-30', 433.3127);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7817, 2, DATE '2012-06-23', 425.4488);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7818, 5, DATE '2014-07-21', 9.1977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7819, 9, DATE '2011-07-19', 362.1502);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7820, 5, DATE '2012-09-23', 208.8882);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7821, 2, DATE '2012-06-06', 462.6518);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7822, 9, DATE '2011-01-10', 186.2386);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7823, 5, DATE '2011-12-17', 942.4186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7824, 8, DATE '2015-04-20', 4.4570);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7825, 2, DATE '2014-03-03', 78.5225);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7826, 6, DATE '2014-11-02', 999.9315);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7827, 1, DATE '2011-09-05', 197.6356);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7828, 2, DATE '2011-04-28', 937.9926);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7829, 2, DATE '2011-10-07', 159.7230);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7830, 7, DATE '2012-04-29', 883.6221);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7831, 2, DATE '2011-08-11', 66.0692);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7832, 1, DATE '2012-08-30', 596.2704);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7833, 7, DATE '2012-11-22', 143.0492);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7834, 1, DATE '2015-06-04', 707.3182);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7835, 5, DATE '2015-07-28', 334.2608);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7836, 10, DATE '2011-07-15', 250.3676);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7837, 3, DATE '2014-10-23', 246.8714);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7838, 3, DATE '2011-03-25', 840.4453);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7839, 10, DATE '2014-09-16', 517.5258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7840, 9, DATE '2012-06-12', 690.8612);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7841, 8, DATE '2014-12-29', 852.1326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7842, 10, DATE '2012-12-28', 822.0491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7843, 7, DATE '2012-11-27', 160.4953);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7844, 3, DATE '2013-02-12', 596.6364);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7845, 7, DATE '2014-12-23', 965.1414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7846, 3, DATE '2011-11-20', 55.1020);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7847, 8, DATE '2015-09-18', 125.3056);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7848, 10, DATE '2012-08-17', 732.2491);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7849, 10, DATE '2015-05-26', 792.5004);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7850, 7, DATE '2012-06-05', 923.8715);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7851, 5, DATE '2014-02-13', 787.3920);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7852, 5, DATE '2013-10-07', 676.2994);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7853, 5, DATE '2012-02-21', 4.0905);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7854, 9, DATE '2013-12-20', 371.7627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7855, 3, DATE '2011-01-28', 729.9883);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7856, 5, DATE '2013-03-14', 406.5311);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7857, 4, DATE '2013-02-12', 518.1432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7858, 3, DATE '2011-07-03', 965.4528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7859, 9, DATE '2014-12-03', 694.2832);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7860, 10, DATE '2012-09-05', 711.7977);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7861, 10, DATE '2015-03-24', 747.3528);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7862, 2, DATE '2015-01-21', 481.4068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7863, 5, DATE '2013-02-12', 388.8158);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7864, 8, DATE '2013-09-27', 356.1736);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7865, 2, DATE '2012-07-22', 445.9092);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7866, 10, DATE '2015-01-21', 661.3592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7867, 3, DATE '2013-04-02', 675.6296);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7868, 2, DATE '2015-01-21', 472.1354);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7869, 4, DATE '2011-09-17', 903.2331);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7870, 2, DATE '2011-08-12', 62.6511);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7871, 1, DATE '2011-07-08', 186.4412);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7872, 10, DATE '2012-03-31', 585.0035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7873, 5, DATE '2015-11-04', 491.6720);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7874, 10, DATE '2015-02-05', 671.2891);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7875, 8, DATE '2013-09-25', 356.7556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7876, 2, DATE '2015-06-09', 640.6028);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7877, 3, DATE '2014-02-12', 25.7432);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7878, 2, DATE '2014-11-04', 345.7822);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7879, 1, DATE '2011-04-28', 39.3157);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7880, 9, DATE '2013-04-13', 23.4204);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7881, 8, DATE '2015-02-14', 874.6259);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7882, 2, DATE '2015-01-19', 465.3866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7883, 3, DATE '2011-12-04', 145.4922);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7884, 5, DATE '2015-05-03', 235.8516);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7885, 2, DATE '2014-03-16', 96.2301);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7886, 8, DATE '2013-11-04', 389.7699);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7887, 7, DATE '2011-07-10', 592.1799);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7888, 8, DATE '2014-12-04', 771.2866);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7889, 8, DATE '2015-05-08', 977.3299);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7890, 1, DATE '2013-05-15', 927.7298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7891, 7, DATE '2014-06-02', 732.2244);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7892, 1, DATE '2014-04-23', 281.4187);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7893, 4, DATE '2012-04-22', 146.1621);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7894, 1, DATE '2013-01-11', 805.7281);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7895, 10, DATE '2013-03-21', 943.5085);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7896, 7, DATE '2015-12-09', 370.7258);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7897, 6, DATE '2015-11-15', 433.2332);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7898, 9, DATE '2015-03-02', 804.3217);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7899, 1, DATE '2011-07-24', 150.7271);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7900, 7, DATE '2015-12-03', 303.7821);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7901, 1, DATE '2014-08-20', 379.4725);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7902, 7, DATE '2011-08-29', 653.1702);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7903, 6, DATE '2011-12-01', 829.0160);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7904, 8, DATE '2014-10-14', 729.8493);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7905, 7, DATE '2011-11-30', 737.4302);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7906, 6, DATE '2012-11-14', 202.3884);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7907, 10, DATE '2013-12-04', 184.6273);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7908, 5, DATE '2013-01-16', 332.8014);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7909, 1, DATE '2011-03-27', 15.0070);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7910, 2, DATE '2011-08-21', 89.3854);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7911, 3, DATE '2015-01-30', 380.7878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7912, 2, DATE '2014-04-10', 172.3610);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7913, 2, DATE '2011-03-07', 926.1371);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7914, 10, DATE '2012-08-21', 670.8627);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7915, 2, DATE '2013-07-23', 837.1718);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7916, 8, DATE '2011-03-06', 281.9661);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7917, 10, DATE '2014-02-17', 335.9145);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7918, 10, DATE '2013-10-12', 152.9642);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7919, 6, DATE '2015-07-14', 259.9435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7920, 5, DATE '2014-09-18', 56.1392);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7921, 4, DATE '2014-07-14', 69.1792);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7922, 5, DATE '2014-04-29', 904.3430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7923, 4, DATE '2015-09-15', 494.8055);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7924, 4, DATE '2014-05-04', 975.5034);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7925, 6, DATE '2013-03-12', 330.4267);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7926, 10, DATE '2013-03-17', 905.0226);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7927, 6, DATE '2015-12-09', 438.8414);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7928, 5, DATE '2013-10-24', 685.9439);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7929, 1, DATE '2012-11-16', 727.7807);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7930, 2, DATE '2013-10-18', 986.0298);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7931, 7, DATE '2015-07-25', 207.3696);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7932, 4, DATE '2014-12-13', 221.4216);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7933, 2, DATE '2014-04-13', 195.0551);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7934, 5, DATE '2011-05-27', 735.5336);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7935, 9, DATE '2014-08-25', 643.9480);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7936, 2, DATE '2014-06-19', 221.4556);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7937, 7, DATE '2014-02-18', 636.3706);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7938, 5, DATE '2013-02-20', 415.6430);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7939, 9, DATE '2014-06-04', 498.4214);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7940, 7, DATE '2012-05-02', 893.8417);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7941, 8, DATE '2015-12-01', 205.1426);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7942, 2, DATE '2014-06-24', 259.3784);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7943, 8, DATE '2014-09-09', 756.2795);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7944, 6, DATE '2014-09-18', 887.9444);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7945, 8, DATE '2014-04-15', 546.9419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7946, 5, DATE '2011-02-22', 559.8634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7947, 9, DATE '2014-02-16', 355.2816);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7948, 4, DATE '2015-09-02', 475.2995);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7949, 9, DATE '2015-06-22', 968.5563);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7950, 2, DATE '2013-01-16', 661.5423);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7951, 7, DATE '2012-10-21', 34.8112);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7952, 6, DATE '2013-02-03', 280.2690);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7953, 4, DATE '2015-08-20', 544.3782);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7954, 7, DATE '2012-11-05', 94.5878);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7955, 4, DATE '2012-05-21', 234.6029);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7956, 7, DATE '2011-04-23', 475.1295);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7957, 3, DATE '2011-12-14', 158.3647);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7958, 2, DATE '2013-07-30', 853.5127);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7959, 3, DATE '2012-08-04', 399.4225);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7960, 7, DATE '2014-09-14', 832.4077);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7961, 1, DATE '2012-12-07', 763.5471);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7962, 6, DATE '2011-02-11', 498.6834);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7963, 5, DATE '2011-03-02', 605.0208);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7964, 10, DATE '2013-06-08', 28.9773);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7965, 6, DATE '2012-01-27', 882.0159);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7966, 9, DATE '2011-02-18', 159.3662);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7967, 1, DATE '2015-12-29', 977.3060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7968, 8, DATE '2015-10-12', 190.6035);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7969, 2, DATE '2013-12-27', 26.9146);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7970, 1, DATE '2015-02-03', 615.7162);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7971, 2, DATE '2013-01-15', 645.5956);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7972, 5, DATE '2011-12-29', 920.2716);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7973, 1, DATE '2015-05-11', 654.5429);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7974, 10, DATE '2014-03-14', 366.1018);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7975, 7, DATE '2014-10-18', 850.9967);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7976, 3, DATE '2011-01-21', 809.8008);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7977, 8, DATE '2015-08-21', 148.0634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7978, 8, DATE '2011-12-29', 606.8611);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7979, 6, DATE '2011-01-19', 428.5615);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7980, 1, DATE '2013-01-18', 770.5634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7981, 1, DATE '2015-01-30', 549.7409);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7982, 2, DATE '2011-04-08', 963.5419);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7983, 7, DATE '2014-05-04', 717.3876);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7984, 9, DATE '2015-11-01', 66.2384);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7985, 5, DATE '2011-12-29', 951.2186);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7986, 1, DATE '2013-06-21', 927.1006);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7987, 1, DATE '2015-04-26', 677.0435);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7988, 5, DATE '2012-06-08', 100.4672);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7989, 2, DATE '2015-01-06', 500.9307);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7990, 2, DATE '2014-05-05', 168.8184);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7991, 10, DATE '2013-07-06', 63.0909);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7992, 5, DATE '2011-07-22', 782.8580);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7993, 3, DATE '2011-07-20', 16.2205);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7994, 3, DATE '2015-09-20', 666.0137);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7995, 7, DATE '2015-05-26', 130.2946);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7996, 3, DATE '2015-10-21', 706.4592);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7997, 7, DATE '2014-04-24', 654.3577);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7998, 8, DATE '2012-04-02', 727.3022);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (7999, 1, DATE '2013-08-22', 5.9284);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8000, 9, DATE '2014-02-26', 387.5757);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8001, 5, DATE '2011-02-24', 582.5574);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8002, 2, DATE '2014-05-08', 164.6781);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8003, 3, DATE '2012-09-06', 448.3848);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8004, 8, DATE '2011-05-19', 352.8401);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8005, 10, DATE '2011-01-01', 15.9467);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8006, 3, DATE '2011-10-24', 114.5397);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8007, 5, DATE '2013-09-25', 625.7261);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8008, 4, DATE '2012-06-07', 178.2763);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8009, 10, DATE '2014-01-18', 243.5912);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8010, 2, DATE '2012-04-30', 424.8021);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8011, 10, DATE '2011-09-02', 327.0660);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8012, 5, DATE '2015-12-16', 551.5036);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8013, 6, DATE '2013-07-12', 424.9512);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8014, 2, DATE '2015-07-17', 628.8591);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8015, 6, DATE '2015-08-16', 282.6667);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8016, 9, DATE '2012-08-31', 800.0052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8017, 10, DATE '2012-10-09', 781.2958);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8018, 6, DATE '2011-05-02', 538.7824);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8019, 5, DATE '2012-06-10', 77.7588);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8020, 5, DATE '2014-08-07', 954.9153);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8021, 9, DATE '2011-10-25', 482.3228);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8022, 6, DATE '2014-07-23', 876.8387);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8023, 7, DATE '2011-10-06', 689.6729);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8024, 1, DATE '2015-08-25', 858.0962);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8025, 1, DATE '2012-07-31', 552.6253);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8026, 8, DATE '2012-06-26', 862.7376);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8027, 3, DATE '2011-06-12', 904.0511);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8028, 9, DATE '2015-08-21', 988.5292);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8029, 3, DATE '2014-10-19', 235.8071);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8030, 5, DATE '2014-12-29', 144.5374);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8031, 6, DATE '2012-09-29', 155.4431);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8032, 10, DATE '2014-05-20', 420.7613);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8033, 8, DATE '2014-05-08', 600.9326);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8034, 8, DATE '2012-11-22', 40.9857);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8035, 6, DATE '2012-11-25', 188.0060);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8036, 10, DATE '2011-09-24', 385.0628);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8037, 10, DATE '2014-08-02', 515.1570);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8038, 9, DATE '2013-12-17', 364.5475);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8039, 9, DATE '2015-10-31', 50.2916);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8040, 3, DATE '2011-03-08', 836.6788);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8041, 6, DATE '2015-09-27', 301.3745);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8042, 7, DATE '2013-11-18', 498.7671);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8043, 5, DATE '2014-05-21', 856.8761);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8044, 10, DATE '2013-09-07', 76.1286);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8045, 3, DATE '2013-09-02', 841.7525);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8046, 6, DATE '2013-07-21', 511.5873);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8047, 9, DATE '2014-01-10', 357.9068);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8048, 1, DATE '2012-01-03', 387.3614);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8049, 7, DATE '2011-02-05', 383.3469);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8050, 8, DATE '2013-09-25', 330.2895);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8051, 3, DATE '2014-01-12', 925.1634);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8052, 1, DATE '2013-12-23', 115.5752);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8053, 3, DATE '2015-10-24', 649.5434);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8054, 6, DATE '2015-01-16', 51.0132);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8055, 1, DATE '2013-05-05', 905.2529);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8056, 10, DATE '2012-08-04', 705.7188);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8057, 6, DATE '2013-08-02', 475.0052);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8058, 3, DATE '2013-01-12', 590.2887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8059, 8, DATE '2014-10-18', 800.2149);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8060, 3, DATE '2014-07-08', 153.2091);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8061, 10, DATE '2011-05-15', 210.4887);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8062, 7, DATE '2014-02-05', 637.1969);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8063, 2, DATE '2013-08-20', 942.4693);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8064, 6, DATE '2015-01-21', 99.0537);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8065, 6, DATE '2015-08-02', 269.3589);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8066, 1, DATE '2013-04-15', 906.3048);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8067, 7, DATE '2012-08-10', 950.5711);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8068, 9, DATE '2011-08-20', 383.9654);
INSERT INTO Purchases (PurchaseID, CustomerID, PurchaseDate, PurchaseAmount) VALUES (8069, 7, DATE '2013-0